/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.webservice.axis;

import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceData;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceFinder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class WebServiceAxisFinder
extends AbstractServiceFinder {
    private static String AXIS_STUB = "org.apache.axis.client.Stub";
    WebServiceFinder fParentFinder;

    WebServiceAxisFinder(WebServiceFinder finder, IServiceInvocationGenerator generator) {
        super(generator);
        this.fParentFinder = finder;
    }

    private void addAxisProxies(IJavaProject javaProject, IType axisStub, List<ServiceData> list, IProgressMonitor monitor) {
        try {
            ITypeHierarchy axisStubHierarchy = axisStub.newTypeHierarchy(javaProject, monitor);
            IType[] stubs = axisStubHierarchy.getSubtypes(axisStub);
            int s = 0;
            while (s < stubs.length) {
                IType[] seis = axisStubHierarchy.getSuperInterfaces(stubs[s]);
                int i = 0;
                while (i < seis.length) {
                    try {
                        ITypeHierarchy seiHierarchy = seis[i].newTypeHierarchy(javaProject, monitor);
                        IType[] proxies = seiHierarchy.getSubtypes(seis[i]);
                        int p = 0;
                        while (p < proxies.length) {
                            WebServiceData service;
                            if (!proxies[p].getFullyQualifiedName().equals(stubs[s].getFullyQualifiedName()) && (service = this.createWebServiceData(javaProject, proxies[p], seis[i])) != null) {
                                list.add(service);
                            }
                            ++p;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                ++s;
            }
        }
        catch (Exception exception) {}
    }

    private WebServiceData createWebServiceData(IJavaProject project, IType axisProxy, IType iface) {
        WebServiceData service = null;
        try {
            IResource resource = axisProxy.getUnderlyingResource();
            if (resource != null) {
                service = new WebServiceData(project, axisProxy, iface, this.getServiceGenerator());
                this.initMethods(service);
            }
        }
        catch (Exception exception) {}
        return service;
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        return this.getServices(project, null, monitor);
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, IProgressMonitor monitor) {
        ArrayList<ServiceData> list = new ArrayList<ServiceData>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)root);
        try {
            try {
                IType axisStub;
                javaModel.open(monitor);
                IJavaProject javaProject = javaModel.getJavaProject(project.getName());
                if (javaProject != null && (axisStub = javaProject.findType(AXIS_STUB)) != null) {
                    this.addAxisProxies(javaProject, axisStub, list, monitor);
                }
            }
            catch (Exception exception) {
                try {
                    javaModel.close();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                javaModel.close();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private void initMethods(WebServiceData service) throws Exception {
        IMethod[] interfaceMethods = service.getServiceInterface().getMethods();
        if (interfaceMethods != null) {
            int i = 0;
            while (i < interfaceMethods.length) {
                IMethod method = interfaceMethods[i];
                IMethod classMethod = service.getServiceClass().getMethod(method.getElementName(), method.getParameterTypes());
                if (classMethod != null) {
                    service.addMethod(classMethod, false);
                }
                ++i;
            }
        }
    }

    @Override
    public void removeListener(IServiceListener listener, IProject project) {
    }
}

