/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.util;

import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.services.internal.TypeData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public class JavaGenericsUtil {
    public static TypeData buildInitializedModel(String fullString, IJavaProject jp) {
        TypeData typeData = JavaGenericsUtil.buildTypeDataModel(fullString);
        if (typeData != null) {
            HashMap<String, IType> typeMap = new HashMap<String, IType>();
            JavaGenericsUtil.init(typeData, jp, typeMap);
        }
        return typeData;
    }

    private static TypeData buildTypeDataModel(String fullString) {
        TypeData typeData = null;
        if (fullString != null) {
            String sansArrays;
            fullString = fullString.trim();
            String[] holder = new String[]{fullString};
            String genericString = "";
            int dimensions = JavaGenericsUtil.stripArrays(holder);
            String qualifiedString = sansArrays = holder[0];
            int genericStart = sansArrays.indexOf(60);
            if (genericStart >= 0) {
                qualifiedString = sansArrays.substring(0, genericStart);
                genericString = sansArrays;
            }
            int lastFragmentIndex = qualifiedString.lastIndexOf(46);
            String simpleName = qualifiedString;
            if (lastFragmentIndex > -1) {
                simpleName = !qualifiedString.endsWith(".") ? qualifiedString.substring(lastFragmentIndex + 1) : "";
            }
            typeData = new TypeData(fullString, genericString, qualifiedString, simpleName, dimensions);
            if (genericStart >= 0 && genericString.endsWith(">")) {
                String genericParamList = genericString.substring(genericStart + 1, genericString.length() - 1);
                JavaGenericsUtil.tokenizeParameters(typeData, genericParamList);
            }
        }
        return typeData;
    }

    private static IStatus doQuickValidation(String target, IJavaProject jp) {
        boolean invalid = false;
        if (target != null && target.length() > 0) {
            int index = target.indexOf(60);
            if (index > -1) {
                boolean bl = invalid = index == 0 || index > 0 && !target.endsWith(">") || JavaGenericsUtil.getCharCount(target, '<') != JavaGenericsUtil.getCharCount(target, '>');
            }
            if (!invalid) {
                int openCount = 0;
                int closeCount = 0;
                char open = '[';
                char close = ']';
                char[] chars = target.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    if (chars[i] == open) {
                        ++openCount;
                        if (i + 1 == chars.length || chars[i + 1] != ']') {
                            invalid = true;
                            break;
                        }
                    } else if (chars[i] == close) {
                        ++closeCount;
                    }
                    ++i;
                }
                invalid = invalid || openCount != closeCount;
            }
        }
        return invalid ? JavaGenericsUtil.getNotValidNameStatus(target) : null;
    }

    public static IStatus doValidation(TypeData typeData, IJavaProject jp) throws JavaModelException {
        HashMap<String, IType> typeMap = new HashMap<String, IType>();
        return JavaGenericsUtil.doValidation(typeData, jp, typeMap);
    }

    private static IStatus doValidation(TypeData typeData, IJavaProject jp, Map<String, IType> typeMap) throws JavaModelException {
        IType type;
        IStatus status = null;
        typeData.setJavaProject(jp);
        String qName = typeData.getQualifiedName(false);
        if (typeData.getType() == null) {
            type = typeMap.get(qName);
            if (type == null && (type = jp.findType(qName)) != null) {
                typeMap.put(qName, type);
            }
            typeData.setType(type);
            if (type == null) {
                status = JavaGenericsUtil.getNotValidNameStatus(qName);
            }
        }
        if (status == null) {
            type = typeData.getType();
            ITypeParameter[] parameters = type.getTypeParameters();
            List<TypeData> paramTypeDataList = typeData.getParameters();
            int paramTypeDataCount = paramTypeDataList == null ? 0 : paramTypeDataList.size();
            int parameterCount = parameters == null ? 0 : parameters.length;
            boolean isGeneric = typeData.isGeneric();
            boolean isValid = true;
            if (isGeneric) {
                boolean bl = isValid = paramTypeDataCount == parameterCount && paramTypeDataCount > 0;
                if (isValid) {
                    for (TypeData parameter : paramTypeDataList) {
                        status = JavaGenericsUtil.doValidation(parameter, jp, typeMap);
                        if (status == null) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                boolean bl = isValid = paramTypeDataCount == 0;
            }
            if (!isValid) {
                status = JavaGenericsUtil.getNotValidNameStatus(qName);
            }
        }
        return status;
    }

    private static int getCharCount(String target, char c) {
        int count = 0;
        if (target != null) {
            char[] chars = target.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == c) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    public static String getClassName(String target) {
        String qualified = target;
        if (qualified != null) {
            int index = qualified.indexOf(60);
            if (index >= 0) {
                qualified = qualified.substring(0, index);
            }
            if ((index = qualified.indexOf(91)) >= 0) {
                qualified = qualified.substring(0, index);
            }
            qualified = qualified.trim();
        }
        return qualified;
    }

    private static IStatus getNotValidNameStatus(String target) {
        String message = NLS.bind((String)Messages.JSFJavaBeanBasicPage_16, (Object)(target != null ? target : "\"\""));
        return new Status(1, PageDataModel.class.getName(), 0, message, null);
    }

    private static void init(TypeData typeData, IJavaProject jp, Map<String, IType> typeMap) {
        List<TypeData> parameters;
        typeData.setJavaProject(jp);
        IType type = typeMap.get(typeData.getQualifiedName(false));
        if (type == null) {
            try {
                type = jp.findType(typeData.getQualifiedName(false));
                if (type != null) {
                    typeMap.put(typeData.getQualifiedName(false), type);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        typeData.setType(type);
        if (typeData.isGeneric() && (parameters = typeData.getParameters()) != null && parameters.size() > 0) {
            for (TypeData paramData : parameters) {
                JavaGenericsUtil.init(paramData, jp, typeMap);
            }
        }
    }

    private static int stripArrays(String[] holder) {
        String target = holder[0];
        int endGenerics = target.lastIndexOf(62);
        if (endGenerics >= 0) {
            holder[0] = target.substring(0, endGenerics + 1);
            target = target.substring(endGenerics + 1);
        } else {
            int startArrays = target.indexOf(91);
            if (startArrays >= 0) {
                holder[0] = target.substring(0, startArrays).trim();
            }
        }
        int dimensions = JavaGenericsUtil.getCharCount(target, ']');
        return dimensions;
    }

    private static void tokenizeParameters(TypeData parent, String str) {
        if (str != null && (str = str.trim()).length() > 0) {
            int firstGenericStart = str.indexOf(60);
            int firstseparator = str.indexOf(44);
            if (firstseparator < 0) {
                TypeData param = JavaGenericsUtil.buildTypeDataModel(str);
                parent.addParameter(param);
            } else if (firstseparator < firstGenericStart || firstGenericStart < 0) {
                String paramString = str.substring(0, firstseparator);
                TypeData param = JavaGenericsUtil.buildTypeDataModel(paramString);
                parent.addParameter(param);
                str = str.substring(firstseparator + 1);
                JavaGenericsUtil.tokenizeParameters(parent, str);
            } else if (firstGenericStart < firstseparator) {
                int genericOpenCount = 1;
                String remainder = "";
                int i = firstGenericStart + 1;
                while (i < str.length()) {
                    char c = str.charAt(i);
                    if ('>' == c) {
                        if (--genericOpenCount == 0) {
                            int nextSeparator = str.indexOf(44, i + 1);
                            String paramString = str.substring(0, nextSeparator < 0 ? i + 1 : nextSeparator);
                            TypeData param = JavaGenericsUtil.buildTypeDataModel(paramString);
                            parent.addParameter(param);
                            if (nextSeparator <= -1 || nextSeparator + 1 >= str.length()) break;
                            remainder = str.substring(nextSeparator + 1).trim();
                            break;
                        }
                    } else if ('<' == c) {
                        ++genericOpenCount;
                    }
                    ++i;
                }
                if (remainder.length() > 0) {
                    JavaGenericsUtil.tokenizeParameters(parent, remainder);
                }
            }
        }
    }

    public static IStatus validate(String target, IJavaProject jp) {
        IStatus status = JavaGenericsUtil.doQuickValidation(target, jp);
        if (status == null) {
            TypeData model = JavaGenericsUtil.buildTypeDataModel(target);
            try {
                status = JavaGenericsUtil.doValidation(model, jp);
            }
            catch (JavaModelException javaModelException) {
                status = JavaGenericsUtil.getNotValidNameStatus(target);
            }
        }
        return status;
    }
}

