/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyManifestUtil;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JEEUtilities {
    public static List<IProject> getAccessibleProjects(IProject rootProject, boolean includeWebLibraryProjects) {
        ArrayList<IProject> accessibleProjects = new ArrayList<IProject>(3);
        if (rootProject != null) {
            IVirtualComponent[] referencingComponents;
            if (includeWebLibraryProjects) {
                IVirtualReference[] libModules = WebUtilities.getLibModules((IProject)rootProject);
                int i = 0;
                while (i < libModules.length) {
                    IVirtualComponent referencedComponent = libModules[i].getReferencedComponent();
                    IProject dependentProject = referencedComponent.getProject();
                    if (dependentProject != null) {
                        accessibleProjects.add(dependentProject);
                    }
                    ++i;
                }
            }
            IVirtualComponent[] iVirtualComponentArray = referencingComponents = JEEUtilities.getEarComponentsReferencingProject(rootProject);
            int n = referencingComponents.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualComponent referencingComponent = iVirtualComponentArray[n2];
                IVirtualReference[] utilityModuleReferences = EarUtilities.getUtilityModuleReferences((IVirtualComponent)referencingComponent);
                int i = 0;
                while (i < utilityModuleReferences.length) {
                    IVirtualComponent referencedComponent = utilityModuleReferences[i].getReferencedComponent();
                    IProject dependentProject = referencedComponent.getProject();
                    if (dependentProject != null) {
                        accessibleProjects.add(dependentProject);
                    }
                    ++i;
                }
                ++n2;
            }
        }
        return accessibleProjects;
    }

    private static List getComponentReferences(IVirtualComponent earComponent, String typeId, List<IVirtualComponent> componentList) {
        ArrayList<IVirtualComponent> components;
        ArrayList<IVirtualComponent> arrayList = components = componentList == null ? new ArrayList<IVirtualComponent>() : componentList;
        if (earComponent != null) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null && (typeId == null || typeId.equals(JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)module)))) {
                    components.add(module);
                }
                ++i;
            }
        }
        return components;
    }

    public static List<IVirtualComponent> getComponentsInSameEar(IProject rootProject, String typeId) {
        ArrayList<IVirtualComponent> accessibleComponents = new ArrayList<IVirtualComponent>(3);
        if (rootProject != null) {
            IVirtualComponent[] referencingEARs;
            IVirtualComponent[] iVirtualComponentArray = referencingEARs = JEEUtilities.getEarComponentsReferencingProject(rootProject);
            int n = referencingEARs.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualComponent ear = iVirtualComponentArray[n2];
                JEEUtilities.getComponentReferences(ear, typeId, accessibleComponents);
                ++n2;
            }
        }
        return accessibleComponents;
    }

    public static IVirtualComponent[] getEarComponentsReferencingProject(IProject project) {
        IVirtualComponent component;
        IVirtualComponent[] ears = null;
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null) {
            if (JavaEEProjectUtilities.isEARProject((IProject)project)) {
                ears = new IVirtualComponent[]{component};
            } else {
                ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
                IVirtualComponent[] refComponents = component.getReferencingComponents();
                int i = 0;
                while (i < refComponents.length) {
                    if (JavaEEProjectUtilities.isEARProject((IProject)refComponents[i].getProject())) {
                        result.add(refComponents[i]);
                    }
                    ++i;
                }
                ears = result.toArray(new IVirtualComponent[result.size()]);
            }
        }
        return ears == null ? new IVirtualComponent[]{} : ears;
    }

    public static List<IVirtualComponent> getEjbComponentsInSameEar(IProject rootProject) {
        return JEEUtilities.getComponentsInSameEar(rootProject, "jst.ejb");
    }

    public static void updateManifest(IProject project, final List<String> updates) throws InvocationTargetException, InterruptedException, IOException {
        final IFile manifestFile = ComponentCore.createComponent((IProject)project).getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF")).getUnderlyingFile();
        final IOException[] exceptionHolder = new IOException[1];
        try {
            IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        ClasspathDependencyManifestUtil.updateManifestClasspath((IFile)manifestFile, (List)updates, (OutputStream)os);
                        manifestFile.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), true, true, pm);
                    }
                    catch (IOException e) {
                        exceptionHolder[0] = e;
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)manifestFile, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        if (exceptionHolder[0] != null) {
            throw exceptionHolder[0];
        }
    }

    public static void updateManifest(IProject project, String update) throws InvocationTargetException, InterruptedException, IOException {
        ArrayList<String> updates = new ArrayList<String>(1);
        updates.add(update);
        JEEUtilities.updateManifest(project, updates);
    }
}

