/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.sessionbean;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.ejb.ui.insertions.AddServiceLocatorManagerJAROperation;
import com.ibm.etools.ejb.ui.insertions.SessionServiceSnippetFactory;
import com.ibm.etools.ejb.ui.insertions.wizards.EJBReferenceSelectionModel;
import com.ibm.etools.j2ee.reference.snippets.J2EEReferenceSnippetDataModel;
import com.ibm.etools.webtools.services.api.ServicesAPI;
import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceMethodData;
import com.ibm.etools.webtools.services.internal.AbstractServiceInvocationGenerator;
import com.ibm.etools.webtools.services.internal.ServiceBuilder;
import com.ibm.etools.webtools.services.internal.TypeBuilder;
import com.ibm.etools.webtools.services.internal.TypeData;
import com.ibm.etools.webtools.services.internal.sessionbean.SessionBeanServiceData;
import com.ibm.etools.webtools.services.internal.util.JEEUtilities;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.ui.RunnableWithProgressWrapper;

public class SessionBeanInvocationGenerator
extends AbstractServiceInvocationGenerator {
    SessionBeanInvocationGenerator() {
    }

    private void addEjbProjectToClassPathIfNecessary(SessionBeanServiceData serviceData) {
        IVirtualComponent ejbComponent;
        if (!serviceData.getEjbRefWrapper().isEjbProjectReferenced() && (ejbComponent = serviceData.getEjbRefWrapper().getEjbComponent()) != null && ejbComponent.getProject() != null) {
            String ejbClassPathEntry = String.valueOf(ejbComponent.getProject().getName()) + ".jar";
            try {
                JEEUtilities.updateManifest(serviceData.getProject().getProject(), ejbClassPathEntry);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addLocatorJarIfNecessary(IRunnableContext context, SessionBeanServiceData serviceData) {
        String home = serviceData.getEjbRefWrapper().getHome().trim();
        if (home.length() > 0) {
            J2EEModel j2eeModel = new J2EEModel();
            j2eeModel.setProperty("J2EEReferenceSnippetDataModel.project", serviceData.getProject());
            AddServiceLocatorManagerJAROperation addJar = new AddServiceLocatorManagerJAROperation(serviceData.getProject().getProject());
            addJar.setOperationDataModel((WTPOperationDataModel)j2eeModel);
            try {
                if (context != null) {
                    context.run(false, false, (IRunnableWithProgress)new RunnableWithProgressWrapper((IHeadlessRunnableWithProgress)addJar));
                } else {
                    addJar.run(null);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                System.out.println(e.toString());
            }
        }
    }

    @Override
    protected void buildServiceGetterMethodContents(IServiceInvocationGenerator.GenerationData genData, IDOMCompilationUnit domcu, IDOMNode typeNode, ServiceBuilder builder) {
        IDOMMethod serviceMethodNode = (IDOMMethod)typeNode.getChild("getService");
        if (serviceMethodNode != null) {
            SessionBeanServiceData.EjbRefWrapper wrapper = ((SessionBeanServiceData)genData.getServiceMethod().getService()).getEjbRefWrapper();
            String body = this.getServiceMethodBody(wrapper);
            serviceMethodNode.setBody(body);
        }
    }

    private void create21CreateMethod(ServiceBuilder builder, String simpleHome, SessionBeanServiceData.EjbRefWrapper wrapper, String staticRefFieldName, String staticClassFieldName) {
        TypeBuilder.MethodData method = this.createCreateMethodStub(builder, wrapper);
        StringBuilder body = new StringBuilder(256);
        body.append(" \n\t");
        body.append(simpleHome);
        body.append(" home = (");
        body.append(simpleHome);
        if (wrapper.isLocal()) {
            body.append(") ServiceLocatorManager.getLocalHome(\n\t\t");
        } else {
            body.append(") ServiceLocatorManager.getRemoteHome(\n\t\t");
        }
        body.append(staticRefFieldName);
        body.append(", ");
        body.append(staticClassFieldName);
        body.append(");\n");
        body.append("\ttry {\n\t\tif (home != null)\n\t\t\treturn home.create();\n\t} ");
        body.append("catch (CreateException ce) {\n");
        body.append("\t\tce.printStackTrace();\n\t} ");
        if (!wrapper.isLocal()) {
            body.append("catch (RemoteException re) {\n");
            body.append("\t\tre.printStackTrace();\n\t}");
        }
        body.append("\n\treturn null;\n");
        method.setBody(body.toString());
        builder.addMethod(method);
    }

    private void create30CreateMethod(ServiceBuilder builder, SessionBeanServiceData.EjbRefWrapper wrapper) {
        TypeData context = builder.getTypeDataObject("javax.naming.Context");
        TypeData initialContext = builder.getTypeDataObject("javax.naming.InitialContext");
        TypeData namingException = builder.getTypeDataObject("javax.naming.NamingException");
        TypeBuilder.MethodData method = this.createCreateMethodStub(builder, wrapper);
        StringBuilder body = new StringBuilder(256);
        body.append(" \n\ttry{\n\t\t");
        body.append(context.getReferenceName(false));
        body.append(" ctx = new ").append(initialContext.getReferenceName(false)).append("();\n\t\t");
        body.append("service = (").append(builder.getServiceField().getTypeData().getReferenceName(false)).append(") ");
        body.append("ctx.lookup(\"java:comp/env/").append(wrapper.getName()).append("\");\n\t");
        body.append("} catch (").append(namingException.getReferenceName(false)).append(" e) {\n\t\t");
        body.append("e.printStackTrace();\n\t}\n\t");
        body.append("return service;\n");
        method.setBody(body.toString());
        builder.addMethod(method);
    }

    @Override
    public ServiceBuilder createBuilder(IServiceInvocationGenerator.GenerationData genData) throws JavaModelException {
        ServiceBuilder builder = super.createBuilder(genData);
        SessionBeanServiceData service = (SessionBeanServiceData)genData.getServiceMethod().getService();
        SessionBeanServiceData.EjbRefWrapper wrapper = service.getEjbRefWrapper();
        String home = wrapper.getHome();
        int index = home.lastIndexOf(".");
        String simpleHome = (index >= 0 ? home.substring(index + 1) : home).trim();
        if (simpleHome.length() == 0) {
            this.create30CreateMethod(builder, wrapper);
        } else {
            builder.getTypeDataObject("com.ibm.etools.service.locator.ServiceLocatorManager");
            builder.getTypeDataObject("javax.ejb.CreateException");
            builder.getTypeDataObject(home);
            if (!wrapper.isLocal()) {
                builder.getTypeDataObject("java.rmi.RemoteException");
            }
            String staticRefFieldName = "STATIC_" + simpleHome + "_REF_NAME";
            builder.addField("java.lang.String", staticRefFieldName, true, true, "private", "\"" + wrapper.getName() + "\"", false, false);
            String staticClassFieldName = "STATIC_" + simpleHome + "_CLASS";
            builder.addField("Class", staticClassFieldName, true, true, "private", String.valueOf(simpleHome) + ".class", false, false);
            this.create21CreateMethod(builder, simpleHome, wrapper, staticRefFieldName, staticClassFieldName);
        }
        return builder;
    }

    private TypeBuilder.MethodData createCreateMethodStub(ServiceBuilder builder, SessionBeanServiceData.EjbRefWrapper wrapper) {
        String type = wrapper.getTypeName();
        int index = type.lastIndexOf(".");
        String simpleType = index >= 0 ? type.substring(index + 1) : type;
        String methodName = "create" + simpleType;
        TypeBuilder.MethodData method = new TypeBuilder.MethodData();
        method.setName(methodName);
        method.setVisibility(TypeBuilder.getVisibilityKey("private"));
        method.setReturnType(builder.getTypeDataObject(wrapper.getTypeName()));
        return method;
    }

    @Override
    public boolean generate(IServiceInvocationGenerator.GenerationData data) {
        ServiceMethodData serviceMethod = data.getServiceMethod();
        if (serviceMethod == null) {
            return false;
        }
        SessionBeanServiceData serviceData = (SessionBeanServiceData)serviceMethod.getService();
        this.addEjbProjectToClassPathIfNecessary(serviceData);
        this.addLocatorJarIfNecessary(data.getContext(), serviceData);
        return super.generate(data);
    }

    @Override
    public Object getId() {
        return null;
    }

    @Override
    public Object getServiceCategory() {
        return ServicesAPI.SERVICE_CATEGORY_SESSION_BEAN;
    }

    protected String getServiceMethodBody(SessionBeanServiceData.EjbRefWrapper wrapper) {
        String body = "";
        String type = wrapper.getTypeName();
        int index = type.lastIndexOf(".");
        String simpleType = index >= 0 ? type.substring(index + 1) : type;
        String createMethodName = "create" + simpleType;
        body = " {\n\t\t\tif (service == null) {\n\t\t\t\tservice = " + createMethodName + "();\n\t\t\t}\n\t\t\treturn service;\n\t\t}\n\n";
        return body;
    }

    @Override
    protected boolean needsCustomCodeGen(IServiceInvocationGenerator.GenerationData genData) {
        return true;
    }

    public static class J2EEModel
    extends EJBReferenceSelectionModel {
        private SessionBeanJSFFactory fFactory;

        public J2EEModel() {
            this.setProperty("EJBReferenceSelectionModel.useHome", Boolean.FALSE);
        }

        public SessionBeanJSFFactory getFactory() {
            return this.fFactory == null ? (this.fFactory = new SessionBeanJSFFactory()) : this.fFactory;
        }
    }

    public static class SessionBeanJSFFactory
    extends SessionServiceSnippetFactory {
        public J2EEReferenceSnippetDataModel createModel() {
            return new J2EEModel();
        }
    }
}

