/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.sessionbean;

import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import com.ibm.etools.webtools.services.internal.sessionbean.SessionBeanServiceData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRefType;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.EjbRef;
import org.eclipse.jst.javaee.web.WebApp;

public class SessionBeanFinder
extends AbstractServiceFinder {
    SessionBeanFinder(IServiceInvocationGenerator generator) {
        super(generator);
    }

    private void collectJ2EESessionBeanRefs(org.eclipse.jst.j2ee.webapplication.WebApp webApp, IJavaProject jProject, List<ServiceData> services) {
        SessionBeanServiceData.EjbRefWrapper refWrapper;
        for (org.eclipse.jst.j2ee.common.EjbRef ref : webApp.getEjbRefs()) {
            if (ref.getType() != EjbRefType.SESSION_LITERAL || !this.isOkay(refWrapper = new SessionBeanServiceData.EjbRefWrapper(ref, jProject))) continue;
            services.add(new SessionBeanServiceData(refWrapper, this.getServiceGenerator()));
        }
        for (org.eclipse.jst.j2ee.common.EjbRef ref : webApp.getEjbLocalRefs()) {
            if (ref.getType() != EjbRefType.SESSION_LITERAL || !this.isOkay(refWrapper = new SessionBeanServiceData.EjbRefWrapper((EJBLocalRef)ref, jProject))) continue;
            services.add(new SessionBeanServiceData(refWrapper, this.getServiceGenerator()));
        }
    }

    private void collectJEESessionBeanRefs(WebApp webApp, IJavaProject jProject, List<ServiceData> services) {
        for (EjbRef ref : webApp.getEjbRefs()) {
            SessionBeanServiceData.EjbRefWrapper refWrapper;
            if (ref.getEjbRefType() != org.eclipse.jst.javaee.core.EjbRefType.SESSION_LITERAL || !this.isOkay(refWrapper = new SessionBeanServiceData.EjbRefWrapper(ref, jProject))) continue;
            services.add(new SessionBeanServiceData(refWrapper, this.getServiceGenerator()));
        }
        for (EjbLocalRef refLocal : webApp.getEjbLocalRefs()) {
            SessionBeanServiceData.EjbRefWrapper refWrapper;
            if (refLocal.getEjbRefType() != org.eclipse.jst.javaee.core.EjbRefType.SESSION_LITERAL || !this.isOkay(refWrapper = new SessionBeanServiceData.EjbRefWrapper(refLocal, jProject))) continue;
            services.add(new SessionBeanServiceData(refWrapper, this.getServiceGenerator()));
        }
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        return this.getServices(project, null, monitor);
    }

    @Override
    public List<ServiceData> getServices(IProject project, IServiceListener listener, IProgressMonitor monitor) {
        Object webAppObj;
        IJavaProject jProject = JavaCore.create((IProject)project);
        ArrayList<ServiceData> services = new ArrayList<ServiceData>();
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)jProject.getProject());
        if (provider != null && (webAppObj = provider.getModelObject()) != null) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                this.collectJ2EESessionBeanRefs(webApp, jProject, services);
            } else if (webAppObj instanceof WebApp) {
                WebApp webApp = (WebApp)webAppObj;
                this.collectJEESessionBeanRefs(webApp, jProject, services);
            }
        }
        return services;
    }

    private boolean isOkay(SessionBeanServiceData.EjbRefWrapper wrap) {
        return true;
    }

    @Override
    public void removeListener(IServiceListener listener, IProject project) {
    }
}

