/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal.servicebean;

import com.ibm.etools.webtools.services.api.ServicesAPI;
import com.ibm.etools.webtools.services.api.objects.IServiceManager;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.api.servicebean.ServiceInvocationBeanData;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaCore;

public class ServiceInvocationBeanServiceFinder
extends AbstractServiceFinder
implements ITypeHierarchyChangedListener {
    private Map<IProject, List<ServiceData>> fServicesMap = new HashMap<IProject, List<ServiceData>>();
    private Set<IProject> fInterestedProjects;
    private Map<IProject, Set<IServiceListener>> fListenerMap;
    private static ServiceInvocationBeanServiceFinder INSTANCE;

    ServiceInvocationBeanServiceFinder(IServiceManager manager) {
        super(manager.getServiceInvocationGenerator());
    }

    static ServiceInvocationBeanServiceFinder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServiceInvocationBeanServiceFinder(ServicesAPI.getServiceManager(ServicesAPI.SERVICE_CATEGORY_SERVICE_INVOCATION_BEAN));
        }
        return INSTANCE;
    }

    public static void handleAbstractServiceBeanAdded(IProject project) {
        ServiceInvocationBeanServiceFinder.getInstance().updateListeners(project);
    }

    synchronized void addListener(IProject project, IServiceListener listener) {
        this.getInterestedProjects().add(project);
        this.getListeners(project).add(listener);
    }

    private synchronized void collect(IProject project, List<ServiceData> servicesList, boolean listen) {
        if (servicesList == null) {
            servicesList = new ArrayList<ServiceData>();
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IType[] serviceTypes = null;
        try {
            IType abstractBean = javaProject.findType("services.AbstractServiceBean");
            if (abstractBean != null) {
                ITypeHierarchy hierarchy = abstractBean.newTypeHierarchy(null);
                if (listen) {
                    hierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                }
                if ((serviceTypes = hierarchy.getAllSubtypes(abstractBean)) != null) {
                    int i = 0;
                    while (i < serviceTypes.length) {
                        IMethod method;
                        IType type = serviceTypes[i];
                        int flags = type.getFlags();
                        if (!Flags.isAbstract((int)flags) && Flags.isPublic((int)flags) && (method = type.getMethod("doAction", null)).exists() && ServiceData.isServiceMethod(method, true)) {
                            servicesList.add(this.createServiceData(javaProject, type, method));
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ServiceData createServiceData(IJavaProject javaProject, IType serviceBean, IMethod method) {
        ServiceInvocationBeanData service = new ServiceInvocationBeanData(javaProject, serviceBean, this.getServiceGenerator());
        service.addMethod(method, false);
        return service;
    }

    private Set<IProject> getInterestedProjects() {
        if (this.fInterestedProjects == null) {
            this.fInterestedProjects = new HashSet<IProject>();
        }
        return this.fInterestedProjects;
    }

    private Set<IServiceListener> getListeners(IProject project) {
        Set<IServiceListener> listeners;
        if (this.fListenerMap == null) {
            this.fListenerMap = new HashMap<IProject, Set<IServiceListener>>();
        }
        if ((listeners = this.fListenerMap.get(project)) == null) {
            listeners = new HashSet<IServiceListener>();
            this.fListenerMap.put(project, listeners);
        }
        return listeners;
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        return this.getServices(project, null, monitor);
    }

    @Override
    public synchronized List<ServiceData> getServices(IProject project, IServiceListener listener, IProgressMonitor monitor) {
        ArrayList<ServiceData> servicesList;
        if (listener != null) {
            this.addListener(project, listener);
        }
        if ((servicesList = this.fServicesMap.get(project)) == null) {
            servicesList = new ArrayList<ServiceData>();
            if (listener != null) {
                this.fServicesMap.put(project, servicesList);
            }
            this.collect(project, servicesList, listener != null);
        }
        return listener == null ? servicesList : new ArrayList<ServiceData>(servicesList);
    }

    @Override
    public synchronized void removeListener(IServiceListener listener, IProject project) {
        Set<IServiceListener> listeners = this.getListeners(project);
        listeners.remove(listener);
        if (listeners.size() == 0) {
            this.getInterestedProjects().remove(project);
            this.fServicesMap.remove(project);
        }
    }

    public synchronized void typeHierarchyChanged(ITypeHierarchy hierarchy) {
        try {
            hierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            IJavaProject jp = hierarchy.getType().getJavaProject();
            IProject project = jp.getProject();
            this.updateListeners(project);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void updateListeners(IProject project) {
        if (this.getInterestedProjects().contains(project)) {
            Set<IServiceListener> listeners;
            List<ServiceData> services = this.fServicesMap.get(project);
            if (services != null) {
                services.clear();
            }
            if ((listeners = this.getListeners(project)) != null && listeners.size() > 0) {
                this.collect(project, services, true);
                this.fServicesMap.put(project, services);
                for (IServiceListener listener : listeners) {
                    listener.servicesChanged(project, new ArrayList<ServiceData>(services));
                }
            } else {
                this.getInterestedProjects().remove(project);
            }
        }
    }
}

