/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal;

import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import com.ibm.etools.webtools.services.internal.util.JavaGenericsUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeData {
    private IJavaProject fJavaProject;
    private IType fType;
    int fArrayDimensions = 0;
    private List<TypeData> fParameters;
    private boolean fUseSimpleName = true;
    private boolean fNeedsInstantiationValidation = true;
    private String fFullString;
    private String fQualifiedGenericString;
    private String fQualifiedClassName;
    private String fSimpleName;

    public TypeData(String fullString, String genericString, String qualifiedClassName, String simpleName, int arrayDimensions) {
        this.fFullString = fullString;
        this.fQualifiedGenericString = genericString;
        this.fQualifiedClassName = qualifiedClassName;
        this.fSimpleName = simpleName;
        this.fArrayDimensions = arrayDimensions;
    }

    private static void buildSimpleSignature(StringBuilder builder, TypeData typeData) {
        List<TypeData> params;
        builder.append(typeData.getSimpleName(false));
        if (typeData.isGeneric() && (params = typeData.getParameters()) != null && params.size() > 0) {
            builder.append('<');
            Iterator<TypeData> iterator = params.iterator();
            while (iterator.hasNext()) {
                TypeData param = iterator.next();
                TypeData.buildSimpleSignature(builder, param);
                if (!iterator.hasNext()) continue;
                builder.append(',');
            }
            builder.append('>');
        }
        if (typeData.isArray()) {
            int i = 0;
            while (i < typeData.getDimensions()) {
                builder.append("[]");
                ++i;
            }
        }
    }

    public static TypeData buildTypeData(String fullString, IJavaProject jp) {
        return JavaGenericsUtil.buildInitializedModel(fullString, jp);
    }

    public void addParameter(TypeData param) {
        if (this.fParameters == null) {
            this.fParameters = new ArrayList<TypeData>();
        }
        this.fParameters.add(param);
    }

    private void appendProperty(StringBuilder builder, String label, String property) {
        builder.append('{');
        builder.append(label);
        builder.append(":  ");
        builder.append(property);
        builder.append('}');
        builder.append("    ");
    }

    protected void appendTabs(StringBuilder builder, int indent) {
        if (indent > 0) {
            int i = 0;
            while (i < indent) {
                builder.append("\t");
                ++i;
            }
        }
    }

    public int getDimensions() {
        return this.fArrayDimensions;
    }

    public String getFullString() {
        return this.fFullString;
    }

    public String getGenericSegment() {
        String gen = this.isGeneric() ? this.fFullString.substring(this.fFullString.indexOf(60), this.fFullString.lastIndexOf(62) + 1) : "";
        return gen;
    }

    public String getGenericString() {
        return this.fQualifiedGenericString;
    }

    public String getInstantiationString() {
        return this.getReferenceName(!this.isArray(), true);
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public List<TypeData> getParameters() {
        return this.fParameters;
    }

    public String getQualifiedName(boolean includeGenericSegment) {
        if (includeGenericSegment && this.isGeneric()) {
            return this.getGenericString();
        }
        return this.fQualifiedClassName;
    }

    public String getReferenceName(boolean includeGenericSegment) {
        return this.getReferenceName(includeGenericSegment, false);
    }

    private String getReferenceName(boolean includeGenericSegment, boolean initArrays) {
        String ref = null;
        ref = this.fUseSimpleName ? this.getSimpleName(includeGenericSegment) : this.getQualifiedName(includeGenericSegment);
        if (this.isArray()) {
            int dimension = this.getDimensions();
            String ray = initArrays ? "[5]" : "[]";
            int i = 0;
            while (i < dimension) {
                ref = String.valueOf(ref) + ray;
                ++i;
            }
        }
        return ref;
    }

    public String getSimpleName(boolean includeGenericSegment) {
        if (includeGenericSegment) {
            return String.valueOf(this.fSimpleName) + this.getGenericSegment();
        }
        return this.fSimpleName;
    }

    public String getSimpleSignature() {
        StringBuilder builder = new StringBuilder();
        TypeData.buildSimpleSignature(builder, this);
        return builder.toString();
    }

    public IType getType() {
        return this.fType;
    }

    public boolean isArray() {
        return this.fArrayDimensions > 0;
    }

    public boolean isGeneric() {
        return this.fQualifiedGenericString != null && this.fQualifiedGenericString.length() > 0;
    }

    public boolean isInstantiatable() {
        boolean instantiable = true;
        try {
            if (this.getType() == null && this.getJavaProject() != null) {
                this.fType = this.getJavaProject().findType(this.getQualifiedName(false));
            }
            boolean bl = instantiable = this.fType != null && this.fType.isClass();
            if (instantiable) {
                IMethod[] methods;
                int flags = this.fType.getFlags();
                boolean bl2 = instantiable = !Flags.isAbstract((int)flags) && Flags.isPublic((int)flags);
                if (instantiable && (methods = this.fType.getMethods()) != null && methods.length > 0) {
                    boolean hasConstructor = false;
                    boolean hasPublicNoArgConstructor = false;
                    int i = 0;
                    while (i < methods.length) {
                        IMethod m = methods[i];
                        if (m != null && m.isConstructor()) {
                            String[] params;
                            hasConstructor = true;
                            int mFlags = m.getFlags();
                            if (Flags.isPublic((int)mFlags) && ((params = m.getParameterTypes()) == null || params.length == 0)) {
                                hasPublicNoArgConstructor = true;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (!hasPublicNoArgConstructor && hasConstructor) {
                        instantiable = false;
                    }
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return instantiable;
    }

    public boolean isPrimitive() {
        return JavaTypeUtil.isPrimitive((String)this.getQualifiedName(false));
    }

    public boolean isUseSimpleName() {
        return this.fUseSimpleName;
    }

    public boolean isVoid() {
        return "void".equals(this.getQualifiedName(false));
    }

    public boolean needsInstantiationValidation() {
        return this.fNeedsInstantiationValidation;
    }

    public void setJavaProject(IJavaProject jp) {
        this.fJavaProject = jp;
    }

    public void setNeedsInstantiationValidation(boolean needsValidation) {
        this.fNeedsInstantiationValidation = needsValidation;
    }

    public void setType(IType type) {
        this.fType = type;
    }

    public void setUseSimpleName(boolean useSimpleName) {
        this.fUseSimpleName = useSimpleName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(100);
        this.toString(builder, 0);
        return builder.toString();
    }

    protected void toString(StringBuilder builder, int indent) {
        this.appendTabs(builder, indent);
        this.appendProperty(builder, "full", this.getFullString());
        this.appendProperty(builder, "generic", this.getGenericString());
        this.appendProperty(builder, "qualified", this.getQualifiedName(false));
        this.appendProperty(builder, "simple", this.getSimpleName(false));
        this.appendProperty(builder, "simple generic", this.getSimpleName(true));
        this.appendProperty(builder, "reference", this.getReferenceName(false));
        this.appendProperty(builder, "reference generic", this.getReferenceName(true));
        this.appendProperty(builder, "array dimensions", Integer.toString(this.getDimensions()));
        List<TypeData> params = this.getParameters();
        if (params != null && params.size() > 0) {
            ++indent;
            Iterator<TypeData> iterator = params.iterator();
            while (iterator.hasNext()) {
                builder.append("\n");
                this.appendTabs(builder, indent);
                TypeData param = iterator.next();
                param.toString(builder, indent);
            }
        }
    }
}

