/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal;

import com.ibm.etools.webtools.javamodel.api.IJavaCommand;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.services.internal.TypeData;
import com.ibm.etools.webtools.services.internal.util.JavaGenericsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;

public class TypeBuilder {
    public static final byte VISIBILITY_PUBLIC = 1;
    public static final byte VISIBILITY_PROTECTED = 2;
    public static final byte VISIBILITY_PACKAGE = 3;
    public static final byte VISIBILITY_PRIVATE = 4;
    private Map<String, TypeData> fTypeDataObjects;
    private String[] fImports;
    private String fVisibility;
    private TypeData fSuperclass;
    private TypeData fNewTypeInfo;
    private List<TypeData> fImplementedInterfaces;
    private boolean fFormat = true;
    private boolean fIsStatic;
    private boolean fIsAbstract;
    private String fContents;
    private String fAnnotation;
    private List<FieldData> fFields;
    private List<MethodData> fMethods;
    private IJavaProject fJavaProject;
    private List<TypeBuilder> fInnerClasses;
    private TypeBuilder fParent;
    private boolean fHasBeenExecuted = false;

    public TypeBuilder(IJavaProject jp) {
        this.fJavaProject = jp;
    }

    public TypeBuilder(IJavaProject jp, String qName, String superClass) {
        this.fJavaProject = jp;
        this.setTypeInfo(qName);
        this.setSuperclass(superClass);
    }

    public static String getMethodNameSuffix(String propertyName) {
        String ret = null;
        IStatus status = JavaConventions.validateIdentifier((String)propertyName);
        if (status.isOK()) {
            ret = String.valueOf(Character.toUpperCase(propertyName.charAt(0)));
            if (propertyName.length() >= 2) {
                ret = Character.isUpperCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1)) ? propertyName : String.valueOf(Character.toUpperCase(propertyName.charAt(0))) + propertyName.substring(1);
            }
        }
        return ret;
    }

    public static byte getVisibilityKey(String visibility) {
        int key = 0;
        if (visibility != null) {
            if (visibility.equals("public")) {
                key = 1;
            } else if (visibility.equals("protected")) {
                key = 2;
            } else if (visibility.equals("")) {
                key = 3;
            } else if (visibility.equals("private")) {
                key = 4;
            }
        }
        return (byte)key;
    }

    public static String getVisibilityString(byte visibilityKey) {
        String visString = "";
        switch (visibilityKey) {
            case 1: {
                visString = "public";
                break;
            }
            case 2: {
                visString = "protected";
                break;
            }
            case 3: {
                visString = "";
                break;
            }
            case 4: {
                visString = "private";
            }
        }
        return visString;
    }

    private static boolean hasValidDefaultConstructor(IType type) {
        boolean hasValidConstructor;
        block5: {
            hasValidConstructor = true;
            try {
                IMethod[] methods = type.getMethods();
                if (methods == null || methods.length <= 0) break block5;
                int i = 0;
                while (i < methods.length) {
                    IMethod method = methods[i];
                    if (method.isConstructor()) {
                        boolean bl = hasValidConstructor = method.getNumberOfParameters() == 0 && Flags.isPublic((int)method.getFlags());
                        if (hasValidConstructor) break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return hasValidConstructor;
    }

    public static boolean hasValidDefaultConstructor(String fieldType, IJavaProject jp) {
        boolean valid;
        int index = fieldType.indexOf("[");
        if (index > 0) {
            fieldType = fieldType.substring(0, index);
        }
        if (!(valid = JavaCodeUtil.isPrimitive((String)fieldType))) {
            try {
                IType type = JavaModelUtil.findType((IJavaProject)jp, (String)fieldType);
                if (type != null) {
                    int flags = type.getFlags();
                    if (type.isClass() && !Flags.isAbstract((int)flags)) {
                        valid = TypeBuilder.hasValidDefaultConstructor(type);
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return valid;
    }

    private static boolean isOk(List list) {
        return list != null && list.size() > 0;
    }

    private static void processMethods(StringBuilder buf, List<MethodData> methods, IJavaProject jp) {
        if (methods != null) {
            StringBuilder methodsBuffer = new StringBuilder(256);
            for (MethodData method : methods) {
                method.buildContents(methodsBuffer);
            }
            methodsBuffer.append(IJavaCommand.LINE_SEP);
            buf.append((CharSequence)methodsBuffer);
        }
    }

    public void addField(FieldData field) {
        if (this.fFields == null) {
            this.fFields = new ArrayList<FieldData>();
        }
        this.fFields.add(field);
    }

    public FieldData addField(String type, String name) {
        TypeData typeData = this.getTypeDataObject(type);
        FieldData field = new FieldData(typeData, name);
        this.addField(field);
        return field;
    }

    public FieldData addField(String type, String name, boolean isStatic, boolean isFinal, String visibility, String initialValue, boolean needsGetter, boolean needsSetter) {
        TypeData typeData = this.getTypeDataObject(type);
        FieldData field = new FieldData(typeData, name);
        field.setStatic(isStatic);
        field.setFinal(isFinal);
        field.setVisibility(TypeBuilder.getVisibilityKey(visibility));
        field.setInitialValue(initialValue);
        field.setNeedsGetter(needsGetter);
        field.setNeedsSetter(needsSetter);
        this.addField(field);
        return field;
    }

    public FieldData addField(TypeData typeData, String name) {
        FieldData field = new FieldData(typeData, name);
        this.addField(field);
        return field;
    }

    void addIfAppropriate(List<TypeData> data, List<TypeData> allData) {
        if (data != null && data.size() > 0 && allData != null) {
            allData.addAll(data);
        }
    }

    public void addImplementedInterface(TypeData iface) {
        if (this.fImplementedInterfaces == null) {
            this.fImplementedInterfaces = new ArrayList<TypeData>();
        }
        this.fImplementedInterfaces.add(iface);
    }

    public void addInnerClass(TypeBuilder builder) {
        if (this.fInnerClasses == null && builder != null) {
            this.fInnerClasses = new ArrayList<TypeBuilder>();
        }
        builder.setParent(this);
        this.fInnerClasses.add(builder);
    }

    public void addMethod(MethodData method) {
        if (this.fMethods == null) {
            this.fMethods = new ArrayList<MethodData>();
        }
        this.fMethods.add(method);
    }

    void addVariablesIfAppropriate(List data, List<TypeData> allData) {
        if (data != null && data.size() > 0 && allData != null) {
            for (VariableData var : data) {
                allData.add(var.getTypeData());
            }
        }
    }

    private void appendGetterAndSetter(FieldData field, StringBuilder methodsBuilder, IJavaProject jp) {
        String fieldTypeRefName = field.getTypeData().getReferenceName(true);
        String fieldName = field.getName();
        if (field.isGetterNeeded()) {
            methodsBuilder.append(TypeBuilder.getVisibilityString(field.getGetterSetterVisibility()));
            methodsBuilder.append(" ");
            methodsBuilder.append(fieldTypeRefName);
            methodsBuilder.append(" ");
            methodsBuilder.append(field.getGetterMethodName());
            methodsBuilder.append("() ");
            List<TypeData> exceptions = field.getConstructorExceptions();
            if (exceptions != null && exceptions.size() > 0) {
                methodsBuilder.append("throws ");
                Iterator<TypeData> iterator = exceptions.iterator();
                while (iterator.hasNext()) {
                    TypeData type = iterator.next();
                    methodsBuilder.append(type.getReferenceName(false));
                    if (!iterator.hasNext()) continue;
                    methodsBuilder.append(", ");
                }
                methodsBuilder.append(" ");
            }
            methodsBuilder.append("{");
            methodsBuilder.append(IJavaCommand.LINE_SEP);
            GetterMethodData fieldMethod = new GetterMethodData(field);
            fieldMethod.setName(field.getGetterMethodName());
            fieldMethod.setReturnType(field.getTypeData());
            field.setGetterMethod(fieldMethod);
            if (!JavaCodeUtil.isPrimitive((String)field.getTypeData().getQualifiedName(false))) {
                TypeData typeData = field.getTypeData();
                if (!typeData.needsInstantiationValidation() || TypeBuilder.hasValidDefaultConstructor(typeData.getQualifiedName(false), jp)) {
                    methodsBuilder.append("if (");
                    methodsBuilder.append(fieldName);
                    methodsBuilder.append(" == null) {");
                    methodsBuilder.append(IJavaCommand.LINE_SEP);
                    if (field.getHowToHandleNull() == 2) {
                        this.handleInvokeActionStyle(methodsBuilder, field);
                    } else if (field.getHowToHandleNull() == 1) {
                        methodsBuilder.append(fieldName);
                        methodsBuilder.append(" = new ");
                        methodsBuilder.append(typeData.getInstantiationString());
                        if (!typeData.isArray()) {
                            methodsBuilder.append("()");
                        }
                        methodsBuilder.append(";");
                        methodsBuilder.append(IJavaCommand.LINE_SEP);
                        if (this.isStatic() && field.isInitializationTODONeeded()) {
                            methodsBuilder.append("//TODO This object has properties which may not have been initialized.  Add initialization code here if needed.");
                            methodsBuilder.append(IJavaCommand.LINE_SEP);
                        }
                    }
                    methodsBuilder.append("}");
                    methodsBuilder.append(IJavaCommand.LINE_SEP);
                } else {
                    methodsBuilder.append("//TODO This type has no default constructor.  Add initialization code here.");
                    methodsBuilder.append(IJavaCommand.LINE_SEP);
                }
            }
            methodsBuilder.append("return ");
            methodsBuilder.append(fieldName);
            methodsBuilder.append(";");
            methodsBuilder.append(IJavaCommand.LINE_SEP);
            methodsBuilder.append("}");
            methodsBuilder.append(IJavaCommand.LINE_SEP);
            methodsBuilder.append(IJavaCommand.LINE_SEP);
        }
        if (field.isSetterNeeded()) {
            methodsBuilder.append(TypeBuilder.getVisibilityString(field.getGetterSetterVisibility()));
            methodsBuilder.append(" void ");
            methodsBuilder.append(field.getSetterMethodName());
            methodsBuilder.append("(");
            methodsBuilder.append(fieldTypeRefName);
            methodsBuilder.append(" ");
            methodsBuilder.append(fieldName);
            methodsBuilder.append(") {");
            methodsBuilder.append(IJavaCommand.LINE_SEP);
            methodsBuilder.append("this.");
            methodsBuilder.append(fieldName);
            methodsBuilder.append(" = ");
            methodsBuilder.append(fieldName);
            methodsBuilder.append(";");
            methodsBuilder.append(IJavaCommand.LINE_SEP);
            methodsBuilder.append("}");
            methodsBuilder.append(IJavaCommand.LINE_SEP);
            methodsBuilder.append(IJavaCommand.LINE_SEP);
            SetterMethodData fieldMethod = new SetterMethodData(field);
            fieldMethod.setName(field.getSetterMethodName());
            fieldMethod.setReturnType(field.getTypeData());
            field.setSetterMethod(fieldMethod);
        }
    }

    protected void buildClassContents(IJavaProject jp, StringBuilder rawContents) {
        String anno = this.getAnnotation();
        if (anno != null) {
            rawContents.append(anno);
            rawContents.append(IJavaCommand.LINE_SEP);
        }
        rawContents.append(this.getVisibility());
        if (this.fIsStatic) {
            rawContents.append(" static");
        }
        if (this.fIsAbstract) {
            rawContents.append(" abstract");
        }
        rawContents.append(" class ");
        rawContents.append(this.fNewTypeInfo.getReferenceName(false));
        if (this.fSuperclass != null) {
            rawContents.append(" extends ");
            rawContents.append(this.getSuperclass().getReferenceName(false));
        }
        rawContents.append(" {");
        rawContents.append(IJavaCommand.LINE_SEP);
        List<TypeBuilder> innerClasses = this.getInnerClasses();
        if (innerClasses != null && innerClasses.size() > 0) {
            for (TypeBuilder builder : innerClasses) {
                builder.buildClassContents(jp, rawContents);
                rawContents.append(IJavaCommand.LINE_SEP);
            }
        }
        this.processFields(rawContents, this.fFields, jp);
        if (this.fMethods != null && this.fMethods.size() > 0) {
            TypeBuilder.processMethods(rawContents, this.fMethods, jp);
        }
        rawContents.append("}");
        rawContents.append(IJavaCommand.LINE_SEP);
    }

    void collectFieldsForNamespace(List<VariableData> fields, List<List<VariableData>> namespacedFieldCollections) {
        List<FieldData> tempFields = this.getFields();
        if (TypeBuilder.isOk(tempFields)) {
            fields.addAll(tempFields);
            List<TypeBuilder> innerClasses = this.getInnerClasses();
            if (TypeBuilder.isOk(innerClasses)) {
                for (TypeBuilder innerClass : innerClasses) {
                    if (!innerClass.isStatic()) {
                        innerClass.collectFieldsForNamespace(fields, namespacedFieldCollections);
                        continue;
                    }
                    ArrayList<VariableData> domainFields = new ArrayList<VariableData>();
                    namespacedFieldCollections.add(domainFields);
                    innerClass.collectFieldsForNamespace(domainFields, namespacedFieldCollections);
                }
            }
        }
    }

    public void execute() {
        if (!this.fHasBeenExecuted) {
            TypeBuilder topLevel = this.getTopLevelClass();
            if (topLevel != null && topLevel != this) {
                topLevel.execute();
            } else {
                this.initializeImports();
                StringBuilder contentsBuffer = new StringBuilder(1024);
                String packageName = null;
                int index = this.getTypeInfo().getQualifiedName(false).lastIndexOf(".");
                if (index > 0 && (packageName = this.getTypeInfo().getQualifiedName(false).substring(0, index)).length() > 0) {
                    contentsBuffer.append("package ");
                    contentsBuffer.append(packageName);
                    contentsBuffer.append(";");
                    contentsBuffer.append(IJavaCommand.LINE_SEP);
                    contentsBuffer.append(IJavaCommand.LINE_SEP);
                }
                if (this.fImports != null && this.fImports.length > 0) {
                    int i = 0;
                    while (i < this.fImports.length) {
                        contentsBuffer.append("import ");
                        contentsBuffer.append(this.fImports[i]);
                        contentsBuffer.append(";");
                        contentsBuffer.append(IJavaCommand.LINE_SEP);
                        ++i;
                    }
                }
                this.initializeFields();
                this.buildClassContents(this.fJavaProject, contentsBuffer);
                this.fContents = contentsBuffer.toString();
                if (this.fFormat) {
                    this.fContents = JavaCodeUtil.formatString((String)this.fContents);
                    this.fContents = String.valueOf(this.fContents) + IJavaCommand.LINE_SEP;
                }
            }
        }
        this.fHasBeenExecuted = true;
    }

    void gatherTypeData(List<TypeData> allData) {
        Collection<TypeData> types;
        if (this.fTypeDataObjects != null && (types = this.fTypeDataObjects.values()) != null && types.size() > 0) {
            allData.addAll(types);
        }
    }

    public String getAnnotation() {
        return this.fAnnotation;
    }

    public String getContents() {
        return this.fContents;
    }

    public List<FieldData> getFields() {
        return this.fFields;
    }

    public List<TypeData> getImplementedInterfaces() {
        return this.fImplementedInterfaces;
    }

    public List<TypeBuilder> getInnerClasses() {
        return this.fInnerClasses;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public List<MethodData> getMethods() {
        return this.fMethods;
    }

    public TypeBuilder getParent() {
        return this.fParent;
    }

    public TypeData getSuperclass() {
        return this.fSuperclass;
    }

    TypeBuilder getTopLevelClass() {
        TypeBuilder parent;
        TypeBuilder temp = parent = this;
        while (temp != null) {
            parent = temp;
            if (parent == (temp = parent.getParent())) break;
        }
        return parent;
    }

    public TypeData getTypeDataObject(String qName) {
        TypeData data = null;
        TypeBuilder topLevel = this.getTopLevelClass();
        if (topLevel != null && topLevel != this) {
            data = topLevel.getTypeDataObject(qName);
        } else {
            if (this.fTypeDataObjects == null) {
                this.fTypeDataObjects = new HashMap<String, TypeData>();
            }
            if ((data = this.fTypeDataObjects.get(qName)) == null) {
                data = JavaGenericsUtil.buildInitializedModel(qName, this.fJavaProject);
                this.fTypeDataObjects.put(qName, data);
            }
        }
        return data;
    }

    public TypeData getTypeInfo() {
        return this.fNewTypeInfo;
    }

    String getUniqueName(String name, int count, Set<String> fieldNames) {
        String uniqueName = String.valueOf(name) + count++;
        while (fieldNames.contains(uniqueName)) {
            uniqueName = String.valueOf(name) + count++;
        }
        return uniqueName;
    }

    protected String getVisibility() {
        if (this.fVisibility == null) {
            this.fVisibility = "public";
        }
        return this.fVisibility;
    }

    protected void handleInvokeActionStyle(StringBuilder methodBuilder, FieldData field) {
    }

    public boolean hasBeenExecuted() {
        return this.fHasBeenExecuted;
    }

    private void initializeFields() {
        ArrayList<List<VariableData>> namespacedFieldCollections = new ArrayList<List<VariableData>>();
        ArrayList<VariableData> fields = new ArrayList<VariableData>();
        namespacedFieldCollections.add(fields);
        this.collectFieldsForNamespace(fields, namespacedFieldCollections);
        for (List list : namespacedFieldCollections) {
            HashSet<String> fieldNames = new HashSet<String>(list.size());
            for (VariableData field : list) {
                String name = field.getName();
                if (!fieldNames.contains(name)) continue;
                String uniqueName = this.getUniqueName(name, 0, fieldNames);
                field.setName(uniqueName);
                fieldNames.add(uniqueName);
            }
        }
    }

    private void initializeImports() {
        ArrayList<TypeData> allData = new ArrayList<TypeData>();
        this.gatherTypeData(allData);
        if (allData.size() > 0) {
            HashMap<String, TypeData> simpleNameToTypeDataMap = new HashMap<String, TypeData>();
            for (TypeData td : allData) {
                String sName;
                if (td == null || (sName = td.getSimpleName(false)) == null || sName.equals("")) continue;
                if (!simpleNameToTypeDataMap.containsKey(sName)) {
                    simpleNameToTypeDataMap.put(sName, td);
                    continue;
                }
                TypeData existingData = (TypeData)simpleNameToTypeDataMap.get(sName);
                if (td.equals(existingData)) continue;
                td.setUseSimpleName(false);
                existingData.setUseSimpleName(false);
            }
            ArrayList<TypeBuilder> holder = new ArrayList<TypeBuilder>();
            holder.add(this);
            while (!holder.isEmpty()) {
                ArrayList<TypeBuilder> temp = new ArrayList<TypeBuilder>();
                temp.addAll(holder);
                holder.clear();
                for (TypeBuilder builder : temp) {
                    allData.remove(builder.getTypeInfo());
                    List<TypeBuilder> innerClasses = builder.getInnerClasses();
                    if (innerClasses == null || innerClasses.size() <= 0) continue;
                    holder.addAll(innerClasses);
                }
            }
            HashSet<String> imports = new HashSet<String>();
            String packageOfNewClass = "";
            int index = this.getTypeInfo().getQualifiedName(false).lastIndexOf(".");
            if (index > 0 && !this.getTypeInfo().getQualifiedName(false).endsWith(".")) {
                packageOfNewClass = this.getTypeInfo().getQualifiedName(false).substring(0, index + 1);
            }
            for (TypeData td : allData) {
                String qName;
                if (!td.isUseSimpleName() || td.isPrimitive() || td.isVoid() || (qName = td.getQualifiedName(false)) == null || qName.equals("java.lang." + td.getSimpleName(false)) || qName.equals(String.valueOf(packageOfNewClass) + td.getSimpleName(false)) || qName.startsWith(this.getTypeInfo().getQualifiedName(false)) || qName.indexOf(".") < 0) continue;
                imports.add(td.getQualifiedName(false));
            }
            this.fImports = imports.toArray(new String[imports.size()]);
            if (this.fImports.length > 1) {
                Arrays.sort(this.fImports, new Comparator(){

                    public int compare(Object a, Object b) {
                        return ((String)a).compareTo((String)b);
                    }

                    @Override
                    public boolean equals(Object a) {
                        return super.equals(a);
                    }
                });
            }
        }
    }

    public boolean isStatic() {
        return this.fIsStatic;
    }

    private void processFields(StringBuilder buf, List<FieldData> fields, IJavaProject jp) {
        if (fields != null) {
            StringBuilder fieldsBuffer = new StringBuilder(128);
            StringBuilder methodsBuffer = new StringBuilder(512);
            for (FieldData field : fields) {
                field.buildContents(fieldsBuffer);
                this.appendGetterAndSetter(field, methodsBuffer, jp);
            }
            fieldsBuffer.append(IJavaCommand.LINE_SEP);
            methodsBuffer.append(IJavaCommand.LINE_SEP);
            buf.append((CharSequence)fieldsBuffer);
            buf.append((CharSequence)methodsBuffer);
        }
    }

    public void setAnnotation(String annotation) {
        this.fAnnotation = annotation;
    }

    public void setContents(String contents) {
        this.fContents = contents;
    }

    public void setFields(List<FieldData> fields) {
        this.fFields = fields;
    }

    public void setFormat(boolean format) {
        this.fFormat = format;
    }

    public void setImplementedInterfaces(List<TypeData> implementedInterfaces) {
        this.fImplementedInterfaces = implementedInterfaces;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.fIsAbstract = isAbstract;
    }

    public void setIsStatic(boolean isStatic) {
        this.fIsStatic = isStatic;
    }

    public void setMethods(List<MethodData> methods) {
        this.fMethods = methods;
    }

    public void setParent(TypeBuilder parent) {
        this.fParent = parent;
    }

    public void setSuperclass(String qName) {
        if (qName != null) {
            this.setSuperclass(this.getTypeDataObject(qName));
        }
    }

    public void setSuperclass(TypeData superclass) {
        this.fSuperclass = superclass;
    }

    public void setTypeInfo(String qName) {
        if (qName != null) {
            this.setTypeInfo(this.getTypeDataObject(qName));
        }
    }

    public void setTypeInfo(TypeData info) {
        this.fNewTypeInfo = info;
    }

    public void setVisibility(String visibility) {
        this.fVisibility = visibility;
    }

    public static class FieldData
    extends VariableData {
        public static final byte IF_NULL_DO_NOTHING = 0;
        public static final byte IF_NULL_NEW = 1;
        public static final byte IF_NULL_INVOKE_ACTION = 2;
        private byte fNullStyle = 1;
        private MethodData fGetterMethod;
        private MethodData fSetterMethod;
        private boolean fGetterNeeded = true;
        private boolean fSetterNeeded = true;
        private boolean fIsInitializationTODONeeded = false;
        private byte fGetterSetterVisibility = 1;
        private List<TypeData> fExceptions;
        private boolean fIsStatic = false;
        private boolean fIsFinal = false;
        private byte fVisibility = (byte)4;
        private String fInitialValue;
        private String fAnnotation;
        private String fGetterMethodName;
        private String fSetterMethodName;

        public FieldData(TypeData typeData, String name) {
            super(typeData, name);
        }

        void buildContents(StringBuilder buffer) {
            String anno = this.getAnnotation();
            if (anno != null) {
                buffer.append(anno);
                buffer.append(" ");
            }
            buffer.append(TypeBuilder.getVisibilityString(this.getVisibility()));
            buffer.append(" ");
            if (this.isStatic()) {
                buffer.append("static ");
            }
            if (this.isFinal()) {
                buffer.append("final ");
            }
            buffer.append(this.getTypeData().getReferenceName(true));
            buffer.append(" ");
            buffer.append(this.getName());
            if (this.getInitialValue() != null) {
                buffer.append(" = ");
                buffer.append(this.getInitialValue());
            }
            buffer.append(";");
            buffer.append(IJavaCommand.LINE_SEP);
        }

        public String getAnnotation() {
            return this.fAnnotation;
        }

        public List<TypeData> getConstructorExceptions() {
            return this.fExceptions;
        }

        public MethodData getGetterMethod() {
            return this.fGetterMethod;
        }

        public String getGetterMethodName() {
            String suffix;
            if (this.fGetterMethodName == null && (suffix = TypeBuilder.getMethodNameSuffix(this.getName())) != null) {
                this.fGetterMethodName = "get" + suffix;
                if (this.fSetterMethodName == null) {
                    this.fSetterMethodName = "set" + suffix;
                }
            }
            return this.fGetterMethodName;
        }

        public byte getGetterSetterVisibility() {
            return this.fGetterSetterVisibility;
        }

        public byte getHowToHandleNull() {
            return this.fNullStyle;
        }

        public String getInitialValue() {
            return this.fInitialValue;
        }

        public MethodData getSetterMethod() {
            return this.fSetterMethod;
        }

        public String getSetterMethodName() {
            String suffix;
            if (this.fSetterMethodName == null && (suffix = TypeBuilder.getMethodNameSuffix(this.getName())) != null) {
                this.fSetterMethodName = "set" + suffix;
                if (this.fGetterMethodName == null) {
                    this.fGetterMethodName = "get" + suffix;
                }
            }
            return this.fSetterMethodName;
        }

        public byte getVisibility() {
            return this.fVisibility;
        }

        public boolean isFinal() {
            return this.fIsFinal;
        }

        public boolean isGetterNeeded() {
            return this.fGetterNeeded;
        }

        public boolean isInitializationTODONeeded() {
            return this.fIsInitializationTODONeeded;
        }

        public boolean isSetterNeeded() {
            return this.fSetterNeeded;
        }

        public boolean isStatic() {
            return this.fIsStatic;
        }

        public void setAnnotation(String annotation) {
            this.fAnnotation = annotation;
        }

        public void setConstructorExceptions(List<TypeData> exceptions) {
            this.fExceptions = exceptions;
        }

        public void setFinal(boolean isFinal) {
            this.fIsFinal = isFinal;
        }

        public void setGetterMethod(MethodData getterMethod) {
            this.fGetterMethod = getterMethod;
        }

        public void setGetterNeeded(boolean getterNeeded) {
            this.fGetterNeeded = getterNeeded;
        }

        public void setGetterSetterVisibility(byte vis) {
            this.fGetterSetterVisibility = vis;
        }

        public void setHowToHandleNull(byte nullStyle) {
            this.fNullStyle = nullStyle;
        }

        public void setInitializationTODONeeded(boolean isInitializationTODONeeded) {
            this.fIsInitializationTODONeeded = isInitializationTODONeeded;
        }

        public void setInitialValue(String initialValue) {
            this.fInitialValue = initialValue;
        }

        public void setNeedsGetter(boolean needsGetter) {
            this.fGetterNeeded = needsGetter;
        }

        public void setNeedsSetter(boolean needsSetter) {
            this.fSetterNeeded = needsSetter;
        }

        public void setSetterMethod(MethodData setterMethod) {
            this.fSetterMethod = setterMethod;
        }

        public void setSetterNeeded(boolean setterNeeded) {
            this.fSetterNeeded = setterNeeded;
        }

        public void setStatic(boolean isStatic) {
            this.fIsStatic = isStatic;
        }

        public void setVisibility(byte visibility) {
            this.fVisibility = visibility;
        }
    }

    static class GetterMethodData
    extends MethodData {
        private FieldData fUnderlyingField;

        GetterMethodData(FieldData field) {
            this.fUnderlyingField = field;
        }

        @Override
        protected void buildBody(StringBuilder buf) {
        }
    }

    public static class MethodData {
        private byte fVisibility = 1;
        private boolean fIsStatic = false;
        private boolean fIsAbstract = false;
        private TypeData fReturnType;
        private String fName;
        private List<VariableData> fParameters;
        private List<VariableData> fLocalVariables;
        private List<TypeData> fExceptions;
        private String fBody;

        protected void buildBody(StringBuilder buf) {
        }

        public void buildContents(StringBuilder buf) {
            buf.append(TypeBuilder.getVisibilityString(this.getVisibility()));
            buf.append(" ");
            if (this.isStatic()) {
                buf.append("static ");
            }
            buf.append(this.getReturnType().getReferenceName(true));
            buf.append(" ");
            buf.append(this.getName());
            buf.append("(");
            this.buildParameters(buf);
            buf.append(") ");
            buf.append("{");
            buf.append(IJavaCommand.LINE_SEP);
            if (this.fBody != null) {
                buf.append(this.fBody);
            } else {
                this.buildBody(buf);
            }
            buf.append(IJavaCommand.LINE_SEP);
            buf.append("}");
            buf.append(IJavaCommand.LINE_SEP);
            buf.append(IJavaCommand.LINE_SEP);
        }

        protected void buildParameters(StringBuilder buf) {
        }

        public List<TypeData> getExceptions() {
            return this.fExceptions;
        }

        public List<VariableData> getLocalVariables() {
            return this.fLocalVariables;
        }

        public String getName() {
            return this.fName;
        }

        public List<VariableData> getParameters() {
            return this.fParameters;
        }

        public TypeData getReturnType() {
            return this.fReturnType;
        }

        public byte getVisibility() {
            return this.fVisibility;
        }

        public boolean isAbstract() {
            return this.fIsAbstract;
        }

        public boolean isStatic() {
            return this.fIsStatic;
        }

        public void setAbstract(boolean isAbstract) {
            this.fIsAbstract = isAbstract;
        }

        public void setBody(String body) {
            this.fBody = body;
        }

        public void setExceptions(List<TypeData> exceptions) {
            this.fExceptions = exceptions;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public void setParameters(List<VariableData> parameters) {
            this.fParameters = parameters;
        }

        public void setReturnType(TypeData returnType) {
            this.fReturnType = returnType;
        }

        public void setStatic(boolean isStatic) {
            this.fIsStatic = isStatic;
        }

        public void setVisibility(byte visibility) {
            this.fVisibility = visibility;
        }
    }

    static class SetterMethodData
    extends MethodData {
        FieldData fUnderlyingField;

        SetterMethodData(FieldData field) {
            this.fUnderlyingField = field;
        }

        @Override
        protected void buildBody(StringBuilder buf) {
        }

        @Override
        protected void buildParameters(StringBuilder buf) {
        }
    }

    public static class VariableData {
        private TypeData fTypeData;
        private String fName;

        public VariableData(TypeData typeData, String name) {
            this.fTypeData = typeData;
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public TypeData getTypeData() {
            return this.fTypeData;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public void setTypeData(TypeData data) {
            this.fTypeData = data;
        }
    }
}

