/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal;

import com.ibm.etools.jsf.databind.dnd.JSFDropActionMediator;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.codebehind.java.CBModelUtil;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.PublicMonitorWizardDialog;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.TaskIncrementingSubProgressMonitor;
import com.ibm.etools.webtools.javamodel.api.IJavaCommand;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageTypeHelper;
import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.api.objects.ServiceMethodData;
import com.ibm.etools.webtools.services.internal.ServiceBuilder;
import com.ibm.etools.webtools.services.internal.TypeBuilder;
import com.ibm.etools.webtools.services.internal.TypeData;
import com.ibm.etools.webtools.services.internal.generation.FacesConfigCommand;
import com.ibm.etools.webtools.services.internal.servicebean.ServiceInvocationBeanServiceFinder;
import com.ibm.etools.webtools.services.internal.util.RuntimeUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public abstract class AbstractServiceInvocationGenerator
implements IServiceInvocationGenerator {
    private static final String DEFAULT_SUPER_BEAN_NAME = "AbstractServiceBean";
    private static final String DEFAULT_SERVICE_PACKAGE = "services";

    private static String constructNameForServiceBean(ServiceMethodData serviceMethod) {
        ServiceData service = serviceMethod.getService();
        String name = null;
        IType iface = service.getServiceInterface();
        if (iface != null) {
            name = iface.getElementName();
        } else {
            IType sClass = service.getServiceClass();
            if (sClass != null) {
                int index;
                name = sClass.getElementName();
                if (name.endsWith("Proxy") && name.length() > 5) {
                    index = name.lastIndexOf("Proxy");
                    name = name.substring(0, index);
                } else if (name.endsWith("Stub") && name.length() > 4) {
                    index = name.lastIndexOf("Stub");
                    name = name.substring(0, index);
                }
            }
        }
        String serviceMethodName = serviceMethod.getMethodName();
        char firstChar = serviceMethodName.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            char upperFirst = Character.toUpperCase(firstChar);
            serviceMethodName = serviceMethodName.length() > 1 ? String.valueOf(upperFirst) + serviceMethodName.substring(1) : String.valueOf(upperFirst);
        }
        name = String.valueOf(name) + "_" + serviceMethodName;
        return name;
    }

    private static IPackageFragment createServicesPackage(IJavaProject jp, String name, IProgressMonitor monitor) throws JavaModelException {
        IPackageFragmentRoot root = AbstractServiceInvocationGenerator.getRootSourcePackageFragment(jp);
        if (name == null) {
            name = DEFAULT_SERVICE_PACKAGE;
        }
        IPackageFragment servicesPackage = root.createPackageFragment(name, false, monitor);
        return servicesPackage;
    }

    private static ICompilationUnit createSuperClassIfNecessary(IJavaProject jp, String superBeanName, String qName, IPackageFragment servicesPackage, IProgressMonitor monitor) throws JavaModelException {
        String cuName;
        ICompilationUnit cu;
        if (superBeanName == null) {
            superBeanName = DEFAULT_SUPER_BEAN_NAME;
        }
        if (qName == null) {
            qName = "services.AbstractServiceBean";
        }
        if (servicesPackage == null) {
            servicesPackage = AbstractServiceInvocationGenerator.createServicesPackage(jp, null, monitor);
        }
        if (!(cu = servicesPackage.getCompilationUnit(cuName = String.valueOf(superBeanName) + ".java")).exists()) {
            TypeBuilder builder = new TypeBuilder(jp, qName, null);
            builder.setIsAbstract(true);
            if (RuntimeUtilities.isAnnotationCapable(jp.getProject())) {
                builder.setAnnotation("@SuppressWarnings(\"unchecked\")");
            }
            builder.getTypeDataObject("javax.faces.context.FacesContext");
            TypeData returnType = builder.getTypeDataObject("java.util.Map");
            TypeBuilder.MethodData sessionScopeMethod = new TypeBuilder.MethodData();
            sessionScopeMethod.setName("getSessionScope");
            sessionScopeMethod.setReturnType(returnType);
            sessionScopeMethod.setBody("return FacesContext.getCurrentInstance().getExternalContext().getSessionMap();");
            builder.addMethod(sessionScopeMethod);
            builder.execute();
            String contents = builder.getContents();
            cu = null;
            try {
                cu = servicesPackage.createCompilationUnit(cuName, contents, false, monitor);
            }
            catch (JavaModelException javaModelException) {}
            if (cu != null) {
                cu.save(monitor, true);
                builder.getTypeInfo().setType(cu.findPrimaryType());
                AbstractServiceInvocationGenerator.notify(jp.getProject());
            }
        }
        return cu;
    }

    private static void execute(ServiceBuilder builder, IProgressMonitor monitor) throws JavaModelException {
        String cuName;
        ICompilationUnit cu;
        IPackageFragment servicesPackage = builder.getServicePackage();
        String serviceBeanName = builder.getServiceBeanSimpleName();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(cu = servicesPackage.getCompilationUnit(cuName = String.valueOf(serviceBeanName) + ".java")).exists()) {
            if (!builder.hasBeenExecuted()) {
                builder.execute();
            }
            String contents = builder.getContents();
            cu = null;
            try {
                try {
                    cu = servicesPackage.createCompilationUnit(cuName, contents, false, monitor);
                }
                catch (JavaModelException javaModelException) {
                    if (cu != null) {
                        cu.save(monitor, true);
                        builder.getTypeInfo().setType(cu.findPrimaryType());
                    }
                }
            }
            finally {
                if (cu != null) {
                    cu.save(monitor, true);
                    builder.getTypeInfo().setType(cu.findPrimaryType());
                }
            }
        }
    }

    private static IPackageFragmentRoot getRootSourcePackageFragment(IJavaProject jp) throws JavaModelException {
        IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
        IPackageFragmentRoot sRoot = null;
        if (roots != null) {
            int i = 0;
            while (i < roots.length) {
                String p;
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() == 1 && !(p = root.getPath().removeFirstSegments(1).toString()).startsWith(".")) {
                    sRoot = root;
                    break;
                }
                ++i;
            }
        }
        return sRoot;
    }

    protected static ICompilationUnit getServiceBeanSuperType(IProject project, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject jp = JavaCore.create((IProject)project);
        return AbstractServiceInvocationGenerator.createSuperClassIfNecessary(jp, null, null, null, monitor);
    }

    private static void notify(IProject project) {
        ServiceInvocationBeanServiceFinder.handleAbstractServiceBeanAdded(project);
    }

    protected void addToFacesConfig(IServiceInvocationGenerator.GenerationData genData) {
        ServiceMethodData serviceMethod = genData.getServiceMethod();
        ServiceBuilder builder = serviceMethod.getBuilder(genData);
        String instanceName = JavaCodeUtil.lowercaseFirst((String)builder.getServiceBeanSimpleName());
        FacesConfigCommand.FacesManagedBeanModel facesModel = new FacesConfigCommand.FacesManagedBeanModel();
        facesModel.setBeanName(instanceName);
        facesModel.setBeanDescription("");
        String scope = "request";
        IPageDataModel pdm = null;
        if (genData != null && genData.getEditDomain() != null) {
            pdm = PageDataModelUtil.getPageDataModel((org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode)genData.getEditDomain().getModel().getDocument());
            PageTypeHelper helper = new PageTypeHelper(pdm);
            String[] types = helper.getPageTypes((short)1);
            int i = 0;
            while (i < types.length) {
                String type = types[i];
                if (type != null && type.endsWith("PORTLET")) {
                    scope = "session";
                }
                ++i;
            }
        }
        facesModel.setScope(scope);
        facesModel.setBeanClass(builder.getTypeInfo().getQualifiedName(true));
        facesModel.setProject(serviceMethod.getService().getProject().getProject());
        FacesConfigCommand command = new FacesConfigCommand(facesModel);
        command.createNewManagedBean();
    }

    protected void appendNullCheck(StringBuilder buf, String obj, boolean checkIsNull) {
        buf.append("if (");
        buf.append(obj);
        if (checkIsNull) {
            buf.append(" == null) {");
        } else {
            buf.append(" != null) {");
        }
        buf.append(IJavaCommand.LINE_SEP);
    }

    protected void appendReturn(StringBuilder buf, String obj) {
        buf.append(IJavaCommand.LINE_SEP);
        buf.append("return ");
        buf.append(obj);
        buf.append(";");
        buf.append(IJavaCommand.LINE_SEP);
        buf.append("}");
    }

    protected String buildBaseActionBody(IServiceInvocationGenerator.GenerationData genData, ServiceBuilder builder) {
        ServiceBuilder.ParamBeanBuilder paramBeanBuilder = builder.getParamBeanBuilder();
        StringBuilder buf = new StringBuilder(100);
        if (paramBeanBuilder != null) {
            buf.append(builder.getParamField().getGetterMethodName());
            buf.append("();");
            buf.append(IJavaCommand.LINE_SEP);
            this.appendNullCheck(buf, builder.getParamField().getName(), false);
        }
        buf.append("try {");
        if (builder.getResultField() != null) {
            buf.append(builder.getResultField().getName());
            buf.append(" = ");
        }
        buf.append(builder.getServiceField().getGetterMethodName());
        buf.append("().");
        buf.append(genData.getServiceMethod().getMethodName());
        buf.append("(");
        if (paramBeanBuilder != null) {
            List<TypeBuilder.FieldData> paramBeanFields = paramBeanBuilder.getParameterFields();
            String paramBeanFieldName = builder.getParamField().getName();
            Iterator<TypeBuilder.FieldData> iterator = paramBeanFields.iterator();
            while (iterator.hasNext()) {
                TypeBuilder.FieldData param = iterator.next();
                buf.append(paramBeanFieldName);
                buf.append(".");
                buf.append(param.getGetterMethodName());
                buf.append("()");
                if (!iterator.hasNext()) continue;
                buf.append(",");
            }
        }
        buf.append(");");
        buf.append(IJavaCommand.LINE_SEP);
        buf.append("} catch (Exception e) {");
        buf.append(IJavaCommand.LINE_SEP);
        buf.append("e.printStackTrace();");
        buf.append(IJavaCommand.LINE_SEP);
        buf.append("}");
        buf.append(IJavaCommand.LINE_SEP);
        if (paramBeanBuilder != null) {
            buf.append("}");
        }
        return buf.toString();
    }

    protected void buildParamGetterMethodContents(IServiceInvocationGenerator.GenerationData genData, IDOMCompilationUnit domcu, IDOMNode typeNode, ServiceBuilder builder) {
        IDOMMethod paramMethodNode;
        TypeBuilder.FieldData paramField;
        if (genData.isPortalProject() && (paramField = builder.getParamField()) != null && (paramMethodNode = (IDOMMethod)typeNode.getChild(paramField.getGetterMethodName())) != null) {
            StringBuilder buf = new StringBuilder(100);
            buf.append("{");
            buf.append(IJavaCommand.LINE_SEP);
            this.appendNullCheck(buf, paramField.getName(), true);
            buf.append(paramField.getName());
            buf.append(" = (");
            buf.append(paramField.getTypeData().getReferenceName(true));
            buf.append(") getSessionScope().get(this.getClass());");
            buf.append(IJavaCommand.LINE_SEP);
            buf.append("}");
            this.appendReturn(buf, paramField.getName());
            paramMethodNode.setBody(buf.toString());
        }
    }

    protected void buildResultGetterMethodContents(IServiceInvocationGenerator.GenerationData genData, IDOMCompilationUnit domcu, IDOMNode typeNode, ServiceBuilder builder) {
        IDOMMethod resultMethodNode;
        TypeBuilder.FieldData resultField;
        if (genData.isPortalProject() && (resultField = builder.getResultField()) != null && (resultMethodNode = (IDOMMethod)typeNode.getChild(resultField.getGetterMethodName())) != null) {
            StringBuilder buf = new StringBuilder(100);
            buf.append("{");
            buf.append(IJavaCommand.LINE_SEP);
            this.appendNullCheck(buf, resultField.getName(), true);
            buf.append(this.buildBaseActionBody(genData, builder));
            buf.append(IJavaCommand.LINE_SEP);
            buf.append("}");
            this.appendReturn(buf, resultField.getName());
            resultMethodNode.setBody(buf.toString());
        }
    }

    protected void buildServiceGetterMethodContents(IServiceInvocationGenerator.GenerationData genData, IDOMCompilationUnit domcu, IDOMNode typeNode, ServiceBuilder builder) {
    }

    @Override
    public ServiceBuilder createBuilder(IServiceInvocationGenerator.GenerationData genData) throws JavaModelException {
        return this.createServiceBeanBuilder(genData);
    }

    protected void createServiceBean(IServiceInvocationGenerator.GenerationData genData, IProgressMonitor monitor) throws JavaModelException {
        ServiceBuilder builder;
        ServiceMethodData serviceMethod = genData.getServiceMethod();
        if (serviceMethod.getService() != null && serviceMethod.getService().getProject() != null) {
            CBModelUtil.addGetManagedBeanMethodToPageCodeBase((IProject)serviceMethod.getService().getProject().getProject(), (IProgressMonitor)new NullProgressMonitor());
        }
        if ((builder = serviceMethod.getBuilder(genData)) == null) {
            builder = this.createServiceBeanBuilder(genData);
        }
        AbstractServiceInvocationGenerator.execute(builder, monitor);
    }

    protected ServiceBuilder createServiceBeanBuilder(IServiceInvocationGenerator.GenerationData genData) throws JavaModelException {
        IType serviceType;
        ServiceMethodData serviceMethod = genData.getServiceMethod();
        IJavaProject jp = serviceMethod.getService().getProject();
        NullProgressMonitor monitor = new NullProgressMonitor();
        IPackageFragment servicesPackage = AbstractServiceInvocationGenerator.createServicesPackage(jp, null, (IProgressMonitor)monitor);
        String superBeanQName = "services.AbstractServiceBean";
        AbstractServiceInvocationGenerator.createSuperClassIfNecessary(jp, null, superBeanQName, servicesPackage, (IProgressMonitor)monitor);
        String serviceBeanName = AbstractServiceInvocationGenerator.constructNameForServiceBean(serviceMethod);
        String serviceBeanQName = "services." + serviceBeanName;
        ServiceBuilder serviceBeanBuilder = new ServiceBuilder(genData, jp, serviceBeanQName, superBeanQName, serviceBeanName, servicesPackage);
        if (RuntimeUtilities.isAnnotationCapable(jp.getProject())) {
            serviceBeanBuilder.setAnnotation("@SuppressWarnings(\"unchecked\")");
        }
        ServiceMethodData.ParameterType[] parameters = serviceMethod.getParameterTypes();
        TypeBuilder.FieldData paramField = null;
        ServiceBuilder.ParamBeanBuilder paramBeanBuilder = null;
        if (parameters != null && parameters.length > 0) {
            paramBeanBuilder = new ServiceBuilder.ParamBeanBuilder(jp, String.valueOf(serviceBeanQName) + ".ParamBean", serviceBeanBuilder);
            int i = 0;
            while (i < parameters.length) {
                paramBeanBuilder.addParameterField(parameters[i]);
                ++i;
            }
            serviceBeanBuilder.setParamBeanBuilder(paramBeanBuilder);
            paramField = serviceBeanBuilder.addField(paramBeanBuilder.getTypeInfo(), "paramBean");
            paramField.setSetterNeeded(false);
            paramField.getTypeData().setNeedsInstantiationValidation(false);
            serviceBeanBuilder.setParamField(paramField);
        }
        TypeBuilder.FieldData resultField = null;
        if (!"void".equals(serviceMethod.getReturnType().getUntrimmedQName())) {
            resultField = serviceBeanBuilder.addField(serviceMethod.getReturnType().getUntrimmedQName(), "resultBean");
            resultField.setSetterNeeded(false);
            serviceBeanBuilder.setResultField(resultField);
        }
        TypeBuilder.FieldData serviceField = serviceBeanBuilder.addField(serviceMethod.getService().getQualifiedName(), "service");
        serviceField.setAnnotation(serviceMethod.getService().getAnnotation());
        serviceField.setSetterNeeded(false);
        serviceField.setGetterSetterVisibility((byte)4);
        serviceBeanBuilder.setServiceField(serviceField);
        ServiceData service = serviceMethod.getService();
        if (service != null && (serviceType = service.getServiceClass()) != null) {
            String[] exceptionSigs;
            IMethod nullConstructor = serviceType.getMethod(serviceType.getElementName(), null);
            ArrayList<TypeData> exceptions = null;
            if (nullConstructor != null && (exceptionSigs = nullConstructor.getExceptionTypes()) != null && exceptionSigs.length > 0) {
                exceptions = new ArrayList<TypeData>(exceptionSigs.length);
                int i = 0;
                while (i < exceptionSigs.length) {
                    String[] exceptionParts;
                    String exception = null;
                    String sig = exceptionSigs[i];
                    String[][] exceps = serviceType.resolveType(Signature.toString((String)sig));
                    if (exceps != null && exceps.length == 1 && (exceptionParts = exceps[0]) != null && exceptionParts.length == 2 && exceptionParts[0] != null && exceptionParts[1] != null) {
                        exception = exceptionParts[0] != "" ? String.valueOf(exceptionParts[0]) + "." + exceptionParts[1] : exceptionParts[1];
                        TypeData exceptionType = serviceBeanBuilder.getTypeDataObject(exception);
                        exceptions.add(exceptionType);
                    }
                    ++i;
                }
            }
            serviceField.setConstructorExceptions(exceptions);
        }
        TypeData actionReturnType = serviceBeanBuilder.getTypeDataObject("java.lang.String");
        TypeBuilder.MethodData actionMethod = new TypeBuilder.MethodData();
        actionMethod.setName("doAction");
        actionMethod.setReturnType(actionReturnType);
        actionMethod.setVisibility((byte)1);
        if (!genData.isPortalProject()) {
            String body = String.valueOf(this.buildBaseActionBody(genData, serviceBeanBuilder)) + "return \"\";";
            actionMethod.setBody(body);
        } else {
            StringBuilder buf = new StringBuilder(50);
            if (parameters != null && parameters.length > 0) {
                buf.append("getSessionScope().put(this.getClass(), getParamBean());");
                buf.append(IJavaCommand.LINE_SEP);
            }
            buf.append("return \"\";");
            actionMethod.setBody(buf.toString());
        }
        serviceBeanBuilder.addMethod(actionMethod);
        serviceMethod.setServiceBuilder(serviceBeanBuilder);
        return serviceBeanBuilder;
    }

    @Override
    public boolean generate(IServiceInvocationGenerator.GenerationData genData) {
        String contents;
        DOMFactory factory;
        IDOMCompilationUnit domcu;
        IDOMNode typeNode;
        ServiceMethodData serviceMethod = genData.getServiceMethod();
        if (serviceMethod == null) {
            return false;
        }
        ServiceBuilder builder = serviceMethod.getBuilder(genData);
        if (!builder.hasBeenExecuted()) {
            builder.execute();
        }
        if (this.needsCustomCodeGen(genData) && (typeNode = (domcu = (factory = new DOMFactory()).createCompilationUnit(contents = builder.getContents(), builder.getServiceBeanSimpleName())).getChild(builder.getServiceBeanSimpleName())) != null) {
            this.buildServiceGetterMethodContents(genData, domcu, typeNode, builder);
            this.buildParamGetterMethodContents(genData, domcu, typeNode, builder);
            this.buildResultGetterMethodContents(genData, domcu, typeNode, builder);
            String updatedContents = domcu.getContents();
            updatedContents = JavaCodeUtil.formatString((String)updatedContents);
            builder.setContents(updatedContents);
        }
        try {
            this.createServiceBean(genData, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.addToFacesConfig(genData);
        if (genData.isGenerateUI()) {
            this.generateJSFCode(genData);
        }
        return true;
    }

    protected void generateJSFCode(IServiceInvocationGenerator.GenerationData data) {
        try {
            IProgressMonitor mon = null;
            NullProgressMonitor subMonitor = null;
            if (data.getCodeGenModel() instanceof PublicMonitorWizardDialog) {
                PublicMonitorWizardDialog pmDialog = (PublicMonitorWizardDialog)data.getContext();
                pmDialog.setProgressMonitor(null);
                mon = pmDialog.getProgressMonitor();
                subMonitor = new TaskIncrementingSubProgressMonitor(mon, 50);
                pmDialog.setProgressMonitor((IProgressMonitor)subMonitor);
            } else {
                subMonitor = new NullProgressMonitor();
            }
            subMonitor.beginTask(Messages.JSFJavaBeanWizard_generate, 50);
            subMonitor.worked(2);
            HTMLEditDomain htmlEditDomain = data.getEditDomain();
            Node target = null;
            if (htmlEditDomain != null) {
                target = JsfCommandUtil.getTargetNode((Range)htmlEditDomain.getSelectionMediator().getRange());
            }
            subMonitor.worked(2);
            JSFDropActionMediator mediator = new JSFDropActionMediator();
            mediator.handlePaletteDrop(data.getCodeGenModel(), target);
            subMonitor.worked(4);
            subMonitor.done();
            if (mon != null) {
                mon.done();
            }
        }
        catch (Throwable ce) {
            ce.printStackTrace();
        }
    }

    protected boolean needsCustomCodeGen(IServiceInvocationGenerator.GenerationData genData) {
        return genData.isPortalProject();
    }
}

