/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.internal;

import com.ibm.etools.webtools.services.api.objects.IServiceFinder;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.AbstractServiceFinder;
import com.ibm.etools.webtools.services.internal.AbstractServiceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractCompositeServiceFinder
extends AbstractServiceFinder
implements IServiceFinder {
    private AbstractServiceManager fManager;

    protected AbstractCompositeServiceFinder(AbstractServiceManager manager) {
        super(manager.getServiceInvocationGenerator());
        this.fManager = manager;
    }

    protected AbstractServiceManager getManager() {
        return this.fManager;
    }

    @Override
    public List<ServiceData> getServices(IProject project, IProgressMonitor monitor) {
        ArrayList<ServiceData> allServices = new ArrayList<ServiceData>();
        AbstractServiceManager[] childManagers = this.getManager().getChildManagers();
        if (childManagers != null) {
            List<ServiceData> tempList = null;
            int i = 0;
            while (i < childManagers.length) {
                tempList = childManagers[i].getServiceFinder().getServices(project, monitor);
                if (tempList != null) {
                    allServices.addAll(tempList);
                }
                ++i;
            }
        }
        return allServices;
    }

    @Override
    public List<ServiceData> getServices(IProject project, Object id, IProgressMonitor monitor) {
        List<ServiceData> services = null;
        AbstractServiceManager[] childManagers = this.getManager().getChildManagers();
        if (childManagers != null) {
            int i = 0;
            while (i < childManagers.length) {
                if (childManagers[i].getServiceInvocationGenerator().getId() == id) {
                    services = childManagers[i].getServiceFinder().getServices(project, monitor);
                    break;
                }
                ++i;
            }
        }
        return services;
    }
}

