/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.api.servicebean;

import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.internal.util.Util;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class ServiceInvocationBeanData
extends ServiceData {
    private IType fParamType;
    private IType fResultType;

    public ServiceInvocationBeanData(IJavaProject project, IType serviceClass, IServiceInvocationGenerator generator) {
        super(project, serviceClass, null, generator);
    }

    public boolean equals(Object o) {
        boolean equals = super.equals(o);
        if (!equals && o != null && this.getClass().equals(o.getClass())) {
            IType serviceClass = this.getServiceClass();
            equals = serviceClass != null && serviceClass.equals(((ServiceInvocationBeanData)o).getServiceClass());
        }
        return equals;
    }

    private IType getMethodReturnType(String methodName) {
        IType returnType = null;
        IMethod method = this.getServiceClass().getMethod(methodName, null);
        if (method != null && method.exists()) {
            try {
                int flags = method.getFlags();
                if (Flags.isPublic((int)flags)) {
                    String qName = Util.getFullyQualifiedType(method);
                    returnType = this.getProject().findType(qName);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return returnType;
    }

    public IType getParamBeanType() {
        if (this.fParamType == null) {
            this.fParamType = this.getMethodReturnType("getParamBean");
        }
        return this.fParamType;
    }

    public IType getResultBeanType() {
        if (this.fResultType == null) {
            this.fResultType = this.getMethodReturnType("getResultBean");
        }
        return this.fResultType;
    }
}

