/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.api;

import com.ibm.etools.webtools.services.api.objects.IServiceManager;
import com.ibm.etools.webtools.services.internal.servicebean.ServiceInvocationBeanServiceManager;
import com.ibm.etools.webtools.services.internal.sessionbean.SessionBeanServiceManager;
import com.ibm.etools.webtools.services.internal.webservice.WebServiceManager;
import java.util.HashMap;
import java.util.Map;

public class ServicesAPI {
    public static boolean DEBUG = false;
    public static final Object SERVICE_CATEGORY_SERVICE_INVOCATION_BEAN = new Object();
    public static final Object SERVICE_CATEGORY_WEB_SERVICE = new Object();
    public static final Object SERVICE_CATEGORY_SESSION_BEAN = new Object();
    private Map<Object, IServiceManager> fServiceManagerMap = new HashMap<Object, IServiceManager>();
    private static final ServicesAPI INSTANCE = new ServicesAPI();

    private ServicesAPI() {
    }

    public static final IServiceManager getServiceManager(Object serviceCategoryKey) {
        return INSTANCE._getManager(serviceCategoryKey);
    }

    private final IServiceManager _getManager(Object serviceCategoryKey) {
        IServiceManager manager = this.fServiceManagerMap.get(serviceCategoryKey);
        if (manager == null) {
            manager = this.createManager(serviceCategoryKey);
        }
        return manager;
    }

    private synchronized IServiceManager createManager(Object key) {
        IServiceManager manager = this.fServiceManagerMap.get(key);
        if (manager == null) {
            if (key == SERVICE_CATEGORY_SERVICE_INVOCATION_BEAN) {
                manager = new ServiceInvocationBeanServiceManager();
            } else if (key == SERVICE_CATEGORY_WEB_SERVICE) {
                manager = new WebServiceManager();
            } else if (key == SERVICE_CATEGORY_SESSION_BEAN) {
                manager = new SessionBeanServiceManager();
            }
            this.fServiceManagerMap.put(key, manager);
        }
        return manager;
    }
}

