/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.ui.internal.wizard;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.UserCancelledException;
import com.ibm.etools.webtools.services.api.ServicesAPI;
import com.ibm.etools.webtools.services.api.objects.IServiceFinder;
import com.ibm.etools.webtools.services.api.objects.IServiceInvocationGenerator;
import com.ibm.etools.webtools.services.api.objects.IServiceManager;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.api.objects.ServiceMethodData;
import com.ibm.etools.webtools.services.internal.ServiceBuilder;
import com.ibm.etools.webtools.services.internal.util.Util;
import com.ibm.etools.webtools.services.ui.internal.servicebean.pagedata.proxy.ServiceBeanPageDataNodeProxy;
import com.ibm.etools.webtools.services.ui.internal.wizard.WizardData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class Controller {
    private Object fServiceKey;
    private WizardData fData;

    public Controller(Object serviceKey) {
        this.fServiceKey = serviceKey;
    }

    public void createCodeGenModel() {
        if (this.fData.isGenerateUI()) {
            HTMLEditDomain editDomain = this.getEditDomain();
            ICodeGenModel cgModel = null;
            if (editDomain != null && this.fData.getSelectedMethod() != null) {
                try {
                    IDOMDocument doc = editDomain.getActiveModel().getDocument();
                    IPageDataModel pdModel = Util.getPDModel((IDOMDocument)doc);
                    ServiceBeanPageDataNodeProxy serviceBeanMethodPDN = this.createServiceBeanNode(pdModel, this.fData.getSelectedMethod());
                    this.fData.setMethodToInvokePDN(serviceBeanMethodPDN);
                    cgModel = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])new IPageDataNode[]{serviceBeanMethodPDN}, null, (IFile)pdModel.getResource(), (String)"JSF", (boolean)true);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (UserCancelledException userCancelledException) {
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (WebModelCreationException e) {
                    e.printStackTrace();
                }
            }
            if (cgModel != null) {
                cgModel.setCreateSubmitButton(true);
            }
            this.fData.setCgModel(cgModel);
        } else {
            this.fData.setCgModel(null);
        }
    }

    protected ServiceBeanPageDataNodeProxy createServiceBeanNode(IPageDataModel pdModel, ServiceMethodData serviceMethod) {
        ServiceBeanPageDataNodeProxy pdNode = null;
        if (serviceMethod != null) {
            ServiceBuilder builder = this.getServiceBuilder();
            String beanSimpleName = JavaCodeUtil.lowercaseFirst((String)builder.getServiceBeanSimpleName());
            pdNode = new ServiceBeanPageDataNodeProxy(pdModel, builder.getTypeInfo().getQualifiedName(false), beanSimpleName, serviceMethod, builder);
            pdNode.getChildren();
        }
        return pdNode;
    }

    public WizardData getData() {
        if (this.fData == null) {
            this.fData = new WizardData(this);
        }
        return this.fData;
    }

    protected HTMLEditDomain getEditDomain() {
        return this.fData.getEditDomain();
    }

    protected ServiceBuilder getServiceBuilder() {
        ServiceBuilder builder = null;
        if (this.fData.getSelectedMethod() != null && !(builder = this.fData.getSelectedMethod().getBuilder(this.fData.getGenerationData())).hasBeenExecuted()) {
            builder.execute();
        }
        return builder;
    }

    public void performCancel() {
        this.fData.dispose();
    }

    public boolean performFinish(IRunnableContext context) {
        try {
            IServiceInvocationGenerator.GenerationData genData = this.fData.getGenerationData();
            genData.setContext(context);
            genData.getServiceMethod().getService().getGenerator().generate(genData);
        }
        finally {
            this.fData.dispose();
        }
        return true;
    }

    public void populateServices() {
        IProject project = this.getData().getProject();
        List<Object> services = null;
        if (project != null) {
            IServiceManager manager = ServicesAPI.getServiceManager((Object)this.fServiceKey);
            IServiceFinder finder = manager.getServiceFinder();
            services = finder.getServices(project, null);
        } else {
            services = new ArrayList<ServiceData>();
        }
        this.getData().setServices(services);
        ServiceData selectedService = services.size() > 0 ? (ServiceData)services.get(0) : null;
        this.getData().setSelectedService(selectedService);
    }

    public void setData(WizardData data) {
        this.fData = data;
    }

    public void setSelectedMethod(ServiceMethodData method) {
        this.fData.setSelectedMethod(method);
        this.createCodeGenModel();
    }
}

