/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.ui.internal.wizard;

import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.util.ProjectUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.wizards.AbstractData_WizardPage;
import com.ibm.etools.webtools.pagedataview.javabean.codebehind.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JB_List_WizardPage;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JB_Object_WizardPage;
import com.ibm.etools.webtools.services.ui.internal.wizard.AbstractServiceWizardPage;
import com.ibm.etools.webtools.services.ui.internal.wizard.Controller;
import com.ibm.etools.webtools.services.ui.internal.wizard.WizardData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractServiceWizard
extends Wizard {
    protected WizardInfo fWizardInfo;
    protected Controller fController;
    protected AbstractServiceWizardPage fServicePage;
    protected AbstractData_WizardPage fParamPage;
    protected AbstractData_WizardPage fResultObjectPage;
    protected AbstractData_WizardPage fResultListPage;

    public AbstractServiceWizard(boolean generateUI) {
        this(generateUI, null);
    }

    public AbstractServiceWizard(boolean generateUI, boolean allowProjectSelection, JSP jsp) {
        this.setWindowTitle(this.getWizardInfo().fWindowTitle);
        this.setDefaultPageImageDescriptor(this.getWizardInfo().fDefaultImageDescriptor);
        this.setNeedsProgressMonitor(true);
        this.initData(generateUI, allowProjectSelection, jsp);
    }

    public AbstractServiceWizard(boolean generateUI, JSP jsp) {
        this(generateUI, false, jsp);
    }

    public void addPages() {
        this.getWizardInfo();
        ArrayList<IWizardPage> pageHolder = new ArrayList<IWizardPage>();
        this.createLeadingPages(pageHolder);
        this.fServicePage = this.createServicePage();
        pageHolder.add((IWizardPage)this.fServicePage);
        this.createFollowingPages(pageHolder);
        this.createUIPages(pageHolder);
        if (pageHolder.size() > 0) {
            Iterator iter = pageHolder.iterator();
            while (iter.hasNext()) {
                this.addPage((IWizardPage)iter.next());
            }
            this.updatePages();
        }
    }

    protected boolean allowResultPage() {
        ICodeGenModel nextModel;
        ICodeGenModel cgModel;
        boolean allowResultPage = false;
        WizardData wizardData = this.getWizardData();
        if (wizardData != null && (cgModel = wizardData.getCgModel()) != null && (nextModel = cgModel.getNextModel()) != null) {
            allowResultPage = nextModel.getCodeGenNodes() != null || nextModel.getCodeGenNodes().size() > 0;
        }
        return allowResultPage;
    }

    protected void createFollowingPages(List<IWizardPage> pageHolder) {
    }

    protected void createLeadingPages(List<IWizardPage> pageHolder) {
    }

    protected IWizardPage createParamPage() {
        this.fParamPage = new JB_Object_WizardPage(){

            protected void createMiddle(Composite parent) {
            }

            protected void createTop(Composite parent) {
            }
        };
        this.fParamPage.setTitle(this.fWizardInfo.fParamPageTitle);
        this.fParamPage.setDescription(this.fWizardInfo.fParamPageDescription);
        return this.fParamPage;
    }

    protected IWizardPage createResultListPage() {
        this.fResultListPage = new JB_List_WizardPage(){

            protected void createResultsButton(Composite parent) {
            }
        };
        this.fResultListPage.setIsResultsPage(true);
        this.fResultListPage.setTitle(this.fWizardInfo.fResultListPageTitle);
        this.fResultListPage.setDescription(this.fWizardInfo.fResultListPageDescription);
        return this.fResultListPage;
    }

    protected IWizardPage createResultObjectPage() {
        this.fResultObjectPage = new JB_Object_WizardPage(){

            protected void createResultsButton(Composite parent) {
            }
        };
        this.fResultObjectPage.setIsResultsPage(true);
        this.fResultObjectPage.setTitle(this.fWizardInfo.fResultObjectPageTitle);
        this.fResultObjectPage.setDescription(this.fWizardInfo.fResultObjectPageDescription);
        return this.fResultObjectPage;
    }

    protected abstract AbstractServiceWizardPage createServicePage();

    public void createUIPages(List<IWizardPage> pageHolder) {
        if (this.getWizardData().isGenerateUI()) {
            pageHolder.add(this.createParamPage());
            pageHolder.add(this.createResultObjectPage());
            pageHolder.add(this.createResultListPage());
        }
    }

    protected Controller getController() {
        if (this.fController == null) {
            this.fController = new Controller(this.getWizardInfo().fWizardKey);
        }
        return this.fController;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractData_WizardPage nextPage = null;
        WizardData wizardData = this.getWizardData();
        if (page == this.fServicePage && this.getWizardData().isGenerateUI()) {
            nextPage = this.fParamPage;
            ICodeGenModel cgModel = wizardData.getCgModel();
            if (cgModel != null && (cgModel.getCodeGenNodes() == null || cgModel.getCodeGenNodes().size() == 0) && this.allowResultPage()) {
                nextPage = wizardData.getCgModel().getNextModel().isList() ? this.fResultListPage : this.fResultObjectPage;
            }
        } else if (page == this.fParamPage && this.allowResultPage()) {
            nextPage = wizardData.getCgModel().getNextModel().isList() ? this.fResultListPage : this.fResultObjectPage;
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage previousPage = null;
        if (page == this.fResultListPage || page == this.fResultObjectPage) {
            if (this.getWizardData().getCgModel().getCodeGenNodes().size() > 0) {
                previousPage = this.fParamPage;
            } else if (this.fParamPage != null) {
                previousPage = super.getPreviousPage((IWizardPage)this.fParamPage);
            }
        }
        return previousPage != null ? previousPage : super.getPreviousPage(page);
    }

    public WizardData getWizardData() {
        return this.getController().getData();
    }

    public WizardInfo getWizardInfo() {
        if (this.fWizardInfo == null) {
            this.fWizardInfo = new WizardInfo();
            this.fWizardInfo.fParamPageTitle = ResourceHandler.inputForm;
            this.fWizardInfo.fParamPageDescription = ResourceHandler.configureInputForm;
            this.fWizardInfo.fResultObjectPageTitle = ResourceHandler.resultsForm;
            this.fWizardInfo.fResultObjectPageDescription = ResourceHandler.configureResultsForm;
            this.fWizardInfo.fResultListPageTitle = ResourceHandler.resultsForm;
            this.fWizardInfo.fResultListPageDescription = ResourceHandler.configureResultsForm;
        }
        return this.fWizardInfo;
    }

    private void initData(boolean generateUI, boolean allowProjectSelection, JSP jsp) {
        WizardData wizardData = this.getController().getData();
        wizardData.setGenerateUI(generateUI);
        wizardData.setAllowProjectSelection(allowProjectSelection);
        if (jsp != null) {
            wizardData.setComponent(jsp.getWebModel().getComponent());
            wizardData.setJSP(jsp);
        } else if (!allowProjectSelection) {
            IProject proj = JsfProjectUtil.getProject();
            wizardData.setComponent(proj);
        } else if (allowProjectSelection) {
            IResource resource;
            Object item;
            List treeSelections;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            ISelection selection = window.getSelectionService().getSelection();
            IProject project = null;
            if (selection != null && !selection.isEmpty() && selection instanceof TreeSelection && (treeSelections = ((TreeSelection)selection).toList()) != null && treeSelections.size() == 1 && (item = treeSelections.get(0)) instanceof IAdaptable && (resource = (IResource)((IAdaptable)item).getAdapter(IResource.class)) != null && ProjectUtil.isDynamicWebProject((IProject)(project = resource.getProject()))) {
                wizardData.setComponent(project);
            }
        }
    }

    public void initializePages() {
        if (this.fServicePage != null) {
            this.fServicePage.initialize();
        }
    }

    public boolean performCancel() {
        this.getWizardData().getController().performCancel();
        return true;
    }

    public boolean performFinish() {
        return this.getWizardData().getController().performFinish((IRunnableContext)this.getContainer());
    }

    public void updatePages() {
        if (this.fParamPage != null) {
            ICodeGenModel cgModel = this.getWizardData().getCgModel();
            this.fParamPage.setModel(cgModel);
            ICodeGenModel nextModel = cgModel != null ? cgModel.getNextModel() : null;
            this.fResultObjectPage.setModel(nextModel == null || nextModel.isList() ? null : nextModel);
            this.fResultListPage.setModel(nextModel == null || !nextModel.isList() ? null : nextModel);
        }
    }

    public class WizardInfo {
        public Object fWizardKey;
        public String fWindowTitle;
        public String fParamPageTitle;
        public String fParamPageDescription;
        public String fResultObjectPageTitle;
        public String fResultObjectPageDescription;
        public String fResultListPageTitle;
        public String fResultListPageDescription;
        public ImageDescriptor fDefaultImageDescriptor;
    }
}

