/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.ui.internal.webservice;

import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JavaBeanMethodSelection;
import com.ibm.etools.webtools.pagedataview.javabean.util.WebServicesClientUtil;
import com.ibm.etools.webtools.services.internal.webservice.JavaTypeUtil;
import com.ibm.etools.webtools.services.ui.internal.webservice.data.AxisWebServiceLocator;
import com.ibm.etools.webtools.services.ui.internal.webservice.data.WSClientInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WSMethodSelection
extends JavaBeanMethodSelection {
    public WSMethodSelection(Composite base, IJavaBeanPageDataNode bean, boolean showActions) {
        super(base, bean, showActions);
    }

    protected void createInput() {
        this.beanMethodTreeViewer.setLabelProvider((IBaseLabelProvider)new JavaBeanMethodSelection.JavaBeanMethodTreeLabelProvider((JavaBeanMethodSelection)this));
        this.beanMethodTreeViewer.setContentProvider((IContentProvider)new JavaBeanMethodSelection.JavaBeanMethodTreeContentProvider(this){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof JavaBeanMethodSelection.ClassNode) {
                    List wsClients;
                    String realClassName = WSMethodSelection.this.bean.getClassName();
                    IFile resource = WSMethodSelection.this.bean.getPageDataModel().getResource();
                    IProject proj = resource.getProject();
                    ArrayList endPointInterfaces = new ArrayList(1);
                    WebServicesClientUtil.buildEndPointInterfaces((IVirtualComponent)ComponentCore.createComponent((IProject)proj), endPointInterfaces);
                    JavaHelpers beanClass = null;
                    try {
                        beanClass = JavaTypeUtil.introspect((String)realClassName, (IProject)proj);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    JavaClass returnedVal = WebServicesClientUtil.getImplementedEndPointInterface((JavaHelpers)beanClass, endPointInterfaces, (IProject)proj);
                    if (returnedVal == null && (wsClients = AxisWebServiceLocator.instance().getWebServiceClients(null, proj)) != null) {
                        String qualifiedName = beanClass.getQualifiedName();
                        for (WSClientInfo clientInfo : wsClients) {
                            String name = clientInfo.getCls().getFullyQualifiedName();
                            if (!name.equals(qualifiedName)) continue;
                            try {
                                JavaHelpers axisHelper = JavaTypeUtil.introspect((String)clientInfo.getInterface().getFullyQualifiedName(), (IProject)proj);
                                if (axisHelper == null || !axisHelper.isInterface() || !(axisHelper instanceof JavaClass)) continue;
                                returnedVal = (JavaClass)axisHelper;
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                    }
                    if (returnedVal != null) {
                        List classMethods = returnedVal.getPublicMethods();
                        ArrayList<JavaBeanMethodSelection.MethodNode> methodsToShow = new ArrayList<JavaBeanMethodSelection.MethodNode>();
                        int i = 0;
                        while (i < classMethods.size()) {
                            Method m = (Method)classMethods.get(i);
                            if (this.shouldShowMethod(m)) {
                                JavaBeanMethodSelection.MethodNode mn = new JavaBeanMethodSelection.MethodNode((JavaBeanMethodSelection)WSMethodSelection.this);
                                mn.methodType = 1;
                                mn.method = m;
                                methodsToShow.add(mn);
                            }
                            ++i;
                        }
                        return methodsToShow.toArray();
                    }
                }
                return null;
            }
        });
        this.beanMethodTreeViewer.setInput((Object)this.bean);
    }
}

