/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.services.ui.internal.servicebean.pagedata;

import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.ICodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.services.api.ServicesAPI;
import com.ibm.etools.webtools.services.api.objects.IServiceFinder;
import com.ibm.etools.webtools.services.api.objects.IServiceManager;
import com.ibm.etools.webtools.services.api.objects.ServiceData;
import com.ibm.etools.webtools.services.api.servicebean.ServiceInvocationBeanData;
import com.ibm.etools.webtools.services.internal.servicebean.IServiceListener;
import com.ibm.etools.webtools.services.ui.internal.servicebean.pagedata.ServiceBeanCodeGenModelFactory;
import com.ibm.etools.webtools.services.ui.internal.servicebean.pagedata.ServiceBeanPageDataNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;

public class ServiceBeanPDMListener
implements IPageDataModelLifeCycleListener,
IServiceListener {
    private Map<IProject, Set<IPageDataModel>> fProjectToModelsMap = new HashMap<IProject, Set<IPageDataModel>>();

    private void addPageDataNodes(IPageDataModel model, List<ServiceData> services) {
        for (ServiceInvocationBeanData serviceInvocationBeanData : services) {
            String fullyQualifiedTypeName = serviceInvocationBeanData.getServiceClass().getFullyQualifiedName();
            String instanceID = serviceInvocationBeanData.getServiceClass().getElementName();
            if (instanceID != null) {
                instanceID = JavaCodeUtil.lowercaseFirst((String)instanceID);
            }
            ServiceBeanPageDataNode pdn = new ServiceBeanPageDataNode(model, serviceInvocationBeanData, fullyQualifiedTypeName, instanceID);
            pdn.getChildren();
            model.getRoot().addChild((IPageDataNode)pdn);
        }
    }

    private ICodeGenModelFactory getFactory() {
        return ServiceBeanCodeGenModelFactory.getInstance();
    }

    IServiceFinder getServiceFinder() {
        IServiceManager manager = ServicesAPI.getServiceManager((Object)ServicesAPI.SERVICE_CATEGORY_SERVICE_INVOCATION_BEAN);
        IServiceFinder finder = manager.getServiceFinder();
        return finder;
    }

    public void pageDataModelInitialized(final IPageDataModel model) {
        IProject project = model.getResource().getProject();
        Set<IPageDataModel> models = this.fProjectToModelsMap.get(project);
        if (models == null) {
            models = new HashSet<IPageDataModel>();
            this.fProjectToModelsMap.put(project, models);
        }
        models.add(model);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServiceBeanPDMListener.this.refreshServiceBeans(model);
            }
        });
    }

    public void pageDataModelReleased() {
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        Set<IPageDataModel> models;
        IProject project = model.getResource().getProject();
        if (project != null && (models = this.fProjectToModelsMap.get(project)) != null) {
            models.remove(model);
            if (models.size() == 0) {
                this.fProjectToModelsMap.remove(project);
                IServiceFinder finder = this.getServiceFinder();
                finder.removeListener((IServiceListener)this, project);
            }
        }
    }

    private void refreshServiceBeans(IPageDataModel model) {
        this.removeOldServices(model);
        IServiceFinder finder = this.getServiceFinder();
        List services = finder.getServices(model.getResource().getProject(), (IServiceListener)this, null);
        this.addPageDataNodes(model, services);
    }

    private void refreshServiceBeans(List<ServiceData> services, Set<IPageDataModel> models) {
        if (models != null && models.size() > 0) {
            for (IPageDataModel model : models) {
                this.removeOldServices(model);
                this.addPageDataNodes(model, services);
            }
        }
    }

    private void removeOldServices(IPageDataModel model) {
        PageDataNode root = (PageDataNode)model.getRoot();
        EList children = root.getChildren();
        if (children != null && children.size() > 0) {
            ArrayList tempChildren = new ArrayList(children);
            ICodeGenModelFactory factory = this.getFactory();
            for (IPageDataNode child : tempChildren) {
                if (child.getCodeGenModelFactory() != factory) continue;
                root.removeChild(child);
            }
        }
    }

    public void servicesChanged(IProject project, List<ServiceData> services) {
        Set<IPageDataModel> models = this.fProjectToModelsMap.get(project);
        this.refreshServiceBeans(services, models);
    }
}

