/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.wizards.operations;

import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.wizards.http.IHTTPMethodsForResourceCollectionContext;
import com.ibm.etools.webtools.security.web.internal.wizards.roleAssoc.IRoleAssocDataModel;
import com.ibm.etools.webtools.security.web.internal.wizards.url.IURLPatternsWizardDataModel;
import com.ibm.etools.webtools.security.web.internal.wizards.userDataConstraint.IUserDataConstraintDataModel;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IAbstractSecurityWizardsContext;
import com.ibm.etools.webtools.security.wizards.internal.operations.AbstractSecurityWizardOperation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;

public class NewSecurityConstraintOperation
extends AbstractSecurityWizardOperation {
    public NewSecurityConstraintOperation(IAbstractSecurityWizardsContext context) {
        super(context);
    }

    public Object prime() {
        Command userDataConstraintCommand;
        Command roleAssCommand;
        CompoundCommand result = new CompoundCommand(Messages.create_new_constraint_command_label);
        Command newConstraintCommand = ApiClass.addConstraintCommand(this.getModelProvider(), this.getEditDomain(), (String)this.getContext().getPropertyValue("constraint name"));
        Object constraint = ((AddCommand)newConstraintCommand).getCollection().iterator().next();
        result.append(newConstraintCommand);
        List<String> roles = ((IRoleAssocDataModel)this.getContext()).getRoleNames();
        ArrayList<Object> rolesToAdd = new ArrayList<Object>();
        for (String roleName : roles) {
            Object securityRole = ApiClass.getRoleNamed(this.getModelProvider(), roleName);
            boolean selected = ((IRoleAssocDataModel)this.getContext()).getRoleSelection(roleName);
            if (!selected) continue;
            rolesToAdd.add(securityRole);
        }
        if (rolesToAdd.size() > 0 && (roleAssCommand = ApiClass.addRolesToConstraintCommand(this.getModelProvider(), this.getEditDomain(), constraint, rolesToAdd)) != null) {
            result.append(roleAssCommand);
        }
        String userDataConstraint = ((IUserDataConstraintDataModel)this.getContext()).getTransportGuarantee();
        String userDataConstraintDescription = ((IUserDataConstraintDataModel)this.getContext()).getUserDataConstraintDescription();
        if (userDataConstraint != null && userDataConstraint.length() > 0 && (userDataConstraintCommand = ApiClass.addUpdateUserDataConstraintToConstraintCommand(this.getModelProvider(), this.getEditDomain(), constraint, userDataConstraint, userDataConstraintDescription)) != null) {
            result.append(userDataConstraintCommand);
        }
        String collectionName = (String)this.getContext().getPropertyValue("resource collection name");
        String collectionDescription = (String)this.getContext().getPropertyValue("resource collection description");
        Command newCollectionCommand = ApiClass.addResourceCollectionCommand(constraint, this.getModelProvider(), this.getEditDomain(), collectionName, collectionDescription);
        Object webResourceCollection = ((AddCommand)newCollectionCommand).getCollection().iterator().next();
        result.append(newCollectionCommand);
        int i = 0;
        while (i < SecurityConstants.HTTP_METHODS.length) {
            String methodName = SecurityConstants.HTTP_METHODS[i];
            boolean selected = ((IHTTPMethodsForResourceCollectionContext)this.getContext()).getMethodSelection(methodName);
            Command httpMethodCommand = null;
            if (selected) {
                httpMethodCommand = ApiClass.addHTTPMethodCommand(webResourceCollection, this.getEditDomain(), methodName);
            }
            if (httpMethodCommand != null) {
                result.append(httpMethodCommand);
            }
            ++i;
        }
        List<String> hTTPMethods = ((IURLPatternsWizardDataModel)this.getContext()).getURLPatterns();
        for (String method : hTTPMethods) {
            Command command = (Command)ApiClass.addURLPatternCommand(webResourceCollection, this.getEditDomain(), method);
            if (command == null) continue;
            result.append(command);
        }
        return result;
    }
}

