/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.wizards.http;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.wizards.http.IHTTPMethodsForResourceCollectionContext;
import com.ibm.etools.webtools.security.wizards.internal.SecurityWizardPage;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IAbstractSecurityWizardsContext;
import com.ibm.etools.webtools.security.wizards.internal.data.models.IWizardEvent;
import com.ibm.etools.webtools.security.wizards.internal.data.models.WizardPropertyChangedEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class HTTPMethodsForResourceCollectionPage
extends SecurityWizardPage {
    private Group headerGroup = null;
    private CCombo constraintName = null;
    CCombo collectionName = null;
    private HashMap constraints = new HashMap();
    private HashMap collections = new HashMap();
    private HashMap buttonMap = new HashMap();
    List buttons = new ArrayList();
    IPreferenceStore preferenceStore = SecurityBasePlugin.getDefault().getPreferenceStore();

    public HTTPMethodsForResourceCollectionPage(String pageName, IHTTPMethodsForResourceCollectionContext model) {
        super(pageName, (IAbstractSecurityWizardsContext)model);
    }

    public HTTPMethodsForResourceCollectionPage(String pageName, String title, ImageDescriptor titleImage, IHTTPMethodsForResourceCollectionContext model) {
        super(pageName, title, titleImage, (IAbstractSecurityWizardsContext)model);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.webtools.security.web.wtsec0080");
        this.createHeaderArea(composite);
        this.createMethodControl(composite);
        this.setControl((Control)composite);
        this.setPageComplete(true);
        this.setMessage(Messages.http_methods_message, 1);
    }

    private void createHeaderArea(Composite parent) {
        this.headerGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        this.headerGroup.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.headerGroup.setLayoutData((Object)formData);
        this.createConstraintNameArea((Composite)this.headerGroup);
        this.createResourceCollectionNameArea((Composite)this.headerGroup);
    }

    private void createConstraintNameArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.constraint_name);
        this.constraintName = new CCombo(parent, 2048);
        GridData gridData = new GridData(768);
        this.constraintName.setLayoutData((Object)gridData);
        this.setConstraintName();
        this.constraintName.setEnabled(false);
        this.constraintName.addListener(13, (Listener)new ConstraintSelectionListener());
    }

    private void createResourceCollectionNameArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.resource_collection_name);
        this.collectionName = new CCombo(parent, 2048);
        GridData gridData = new GridData(768);
        this.collectionName.setLayoutData((Object)gridData);
        this.setCollectionName();
        this.collectionName.setEnabled(this.getHttpMethodContext().isEnableCollectionName());
        if (this.getHttpMethodContext().isEnableCollectionName()) {
            this.collectionName.setItems(this.getCollectionNames());
        }
        this.collectionName.addListener(13, (Listener)new CollectionSelectionListener());
    }

    private void setConstraintName() {
        String constraintNameValue = (String)this.getHttpMethodContext().getPropertyValue("constraint name");
        if (constraintNameValue != null && !constraintNameValue.equals("") && !constraintNameValue.equals(this.constraintName.getText())) {
            this.constraintName.setText(constraintNameValue);
        }
    }

    private void setCollectionName() {
        String collectionNameValue = (String)this.getHttpMethodContext().getPropertyValue("resource collection name");
        if (collectionNameValue != null && !collectionNameValue.equals("")) {
            this.collectionName.setText(collectionNameValue);
        }
    }

    private void createMethodControl(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.headerGroup, 5);
        formData.right = new FormAttachment(100, 0);
        buttonComposite.setLayoutData((Object)formData);
        int i = 0;
        while (i < SecurityConstants.HTTP_METHODS.length) {
            String methodName = SecurityConstants.HTTP_METHODS[i];
            Button button = new Button(buttonComposite, 32);
            button.setText(methodName);
            button.addListener(13, (Listener)new ButtonSelectionListener());
            this.buttons.add(button);
            this.buttonMap.put(methodName, button);
            ++i;
        }
        this.initMethodSelection(this.collectionName.getText());
    }

    private void handleMethodSelectionChange(Button button) {
        this.getHttpMethodContext().setMethodSelection(button.getText(), button.getSelection());
    }

    private String[] getCollectionNames() {
        String[] result = null;
        if (this.constraints.containsKey(this.constraintName.getText())) {
            List collections = ApiClass.getResourceCollections(this.constraints.get(this.constraintName.getText()));
            result = new String[collections.size()];
            int i = 0;
            for (Object next : collections) {
                if (next instanceof WebResourceCollection) {
                    result[i] = ((WebResourceCollection)next).getWebResourceName();
                    this.collections.put(result[i], next);
                } else {
                    result[i] = ((org.eclipse.jst.javaee.web.WebResourceCollection)next).getWebResourceName();
                    this.collections.put(result[i], next);
                }
                ++i;
            }
        } else {
            return new String[0];
        }
        return result;
    }

    private void handleConstraintSelection() {
        this.collectionName.setText("");
        this.collectionName.setItems(this.getCollectionNames());
        this.getHttpMethodContext().setPropertyValue("constraint name", this.constraintName.getText());
        if (this.collectionName.getItemCount() > 0) {
            this.collectionName.setText(this.collectionName.getItem(0));
            this.getHttpMethodContext().setPropertyValue("resource collection name", this.collectionName.getItem(0));
        }
        this.handleCollectionSelection();
    }

    private void handleCollectionSelection() {
        this.clearMethodButtons();
        if (this.collections.containsKey(this.collectionName.getText())) {
            this.initMethodSelection(this.collectionName.getText());
            this.getHttpMethodContext().setPropertyValue("resource collection name", this.collectionName.getText());
        }
    }

    private void initMethodSelection(String collectionName) {
        String constraintName = this.constraintName.getText();
        Object constraint = ApiClass.getConstraintNamed(constraintName, this.getHttpMethodContext().getModelProvider());
        if (constraint != null) {
            Object collection = ApiClass.getResourceCollectionNamed(collectionName, constraint);
            if (collection != null) {
                List httpMethods = ApiClass.getHTTPMethods(collection);
                for (HTTPMethodTypeEnum httpMethodType : httpMethods) {
                    String name = httpMethodType.getName();
                    this.setButtonSelection((Button)this.buttonMap.get(name), true);
                }
            } else {
                this.setDefaultHTTPAccess();
            }
        } else {
            this.setDefaultHTTPAccess();
        }
    }

    private void setDefaultHTTPAccess() {
        for (Button button : this.buttons) {
            String name = button.getText();
            this.setButtonSelection((Button)this.buttonMap.get(name), this.preferenceStore.getBoolean(name));
        }
    }

    private void clearMethodButtons() {
        for (Button button : this.buttons) {
            this.setButtonSelection(button, false);
        }
    }

    private void setButtonSelection(Button button, boolean selection) {
        button.setSelection(selection);
        this.getHttpMethodContext().setMethodSelection(button.getText(), selection);
    }

    public IHTTPMethodsForResourceCollectionContext getHttpMethodContext() {
        return (IHTTPMethodsForResourceCollectionContext)this.context;
    }

    public void handleWizardEvent(IWizardEvent event) {
        if (event instanceof WizardPropertyChangedEvent) {
            WizardPropertyChangedEvent changeEvent = (WizardPropertyChangedEvent)event;
            if (changeEvent.getPropertyKey().equals("constraint name")) {
                this.setConstraintName();
            } else if (changeEvent.getPropertyKey().equals("resource collection name")) {
                this.setCollectionName();
            }
        }
    }

    public void positionCursor() {
        if (this.constraintName.getEnabled()) {
            this.constraintName.setFocus();
        } else if (this.collectionName.getEnabled()) {
            this.collectionName.setFocus();
        } else {
            ((Button)this.buttons.get(0)).setFocus();
        }
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (page != null) {
            this.constraintName.setEnabled(false);
            this.collectionName.setEnabled(false);
        }
    }

    private class ButtonSelectionListener
    implements Listener {
        private ButtonSelectionListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Widget ew = event.widget;
                    if (ew == null) break;
                    HTTPMethodsForResourceCollectionPage.this.handleMethodSelectionChange((Button)ew);
                }
            }
        }
    }

    private class CollectionSelectionListener
    implements Listener {
        private CollectionSelectionListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Widget ew = event.widget;
                    if (ew == null) break;
                    HTTPMethodsForResourceCollectionPage.this.handleCollectionSelection();
                }
            }
        }
    }

    private class ConstraintSelectionListener
    implements Listener {
        private ConstraintSelectionListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Widget ew = event.widget;
                    if (ew == null) break;
                    HTTPMethodsForResourceCollectionPage.this.handleConstraintSelection();
                }
            }
        }
    }
}

