/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.wizards.http;

import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.web.internal.wizards.http.IHTTPMethodsForResourceCollectionContext;
import com.ibm.etools.webtools.security.web.internal.wizards.newResourceCollection.NewResourceCollectionWizardDataModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class HTTPMethodsForResourceCollectionDataModel
extends NewResourceCollectionWizardDataModel
implements IHTTPMethodsForResourceCollectionContext {
    private boolean enableCollectionName = true;
    private HashMap methods = new HashMap();

    public HTTPMethodsForResourceCollectionDataModel(IProject project) {
        super(project);
        int i = 0;
        while (i < SecurityConstants.HTTP_METHODS.length) {
            String methodName = SecurityConstants.HTTP_METHODS[i];
            this.methods.put(methodName, new Boolean(false));
            ++i;
        }
    }

    @Override
    public boolean isEnableCollectionName() {
        return this.enableCollectionName;
    }

    @Override
    public void setEnableCollectionName(boolean enableCollectionName) {
        this.enableCollectionName = enableCollectionName;
    }

    @Override
    public void setMethodSelection(String methodName, boolean value) {
        if (this.methods.containsKey(methodName)) {
            this.methods.put(methodName, new Boolean(value));
        }
    }

    @Override
    public boolean getMethodSelection(String methodName) {
        boolean result = false;
        if (this.methods.containsKey(methodName)) {
            result = (Boolean)this.methods.get(methodName);
        }
        return result;
    }

    @Override
    public List getMethodsForAccess() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry mapEntry : this.methods.entrySet()) {
            String methodName = (String)mapEntry.getKey();
            Boolean methodAccess = (Boolean)mapEntry.getValue();
            if (!methodAccess.booleanValue()) continue;
            result.add(methodName);
        }
        return result;
    }
}

