/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.util;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.Logger;
import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceRootNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.resource.provider.IFacesURLPatternGenerator;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.internal.impl.ServletMappingImpl;

public class SecurityWebUtilities
extends SecurityUtilities {
    private static IFacesURLPatternGenerator facesURLPatternGenerator = null;

    public static void assignRole(SecurityResourceWrapper resourceWrapper, Object securityRole, IModelProvider webEdit, EditingDomain editingDomain, CompoundCommand undoableCommand) {
        List urlPatterns = ((WebModuleResourceWrapper)resourceWrapper).getEditedURLPatterns();
        if (urlPatterns == null) {
            urlPatterns = resourceWrapper.getURLPatterns();
        }
        for (String urlPattern : urlPatterns) {
            SecurityWebUtilities.processCommand((Object)SecurityWebUtilities.addPatternToDefaultConstraintForRole(securityRole, urlPattern, webEdit, editingDomain), (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
        }
    }

    private static Command addPatternToDefaultConstraintForRole(Object securityRole, String url, IModelProvider webEdit, EditingDomain editingDomain) {
        Command command = null;
        Object targetConstraint = ApiClass.findDefaultConstraintForRole(webEdit, securityRole);
        if (targetConstraint == null) {
            command = (Command)ApiClass.createDefaultConstraintForRoleCommand(webEdit, editingDomain, securityRole, url);
        } else {
            Object webResourceCollection = ApiClass.getResourceCollections(targetConstraint).get(0);
            command = (Command)ApiClass.addURLPatternCommand(webResourceCollection, editingDomain, url);
        }
        return command;
    }

    public static void unassignRole(SecurityResourceWrapper resourceWrapper, Object targetRole, IModelProvider webEdit, EditingDomain editingDomain, ResourceRootNode resourceRootNode, IProject project, CompoundCommand undoableCommand) {
        List constraints = ApiClass.getConstraintsForRole(webEdit, targetRole);
        for (Object constraint : constraints) {
            List allRoles = ApiClass.getRolesFor(constraint);
            HashMap matchedPatterns = SecurityWebUtilities.getPatternsFor(webEdit, constraint, resourceWrapper);
            for (Map.Entry mapEntry : matchedPatterns.entrySet()) {
                Object webResourceCollection = mapEntry.getKey();
                List patterns = (List)mapEntry.getValue();
                SecurityWebUtilities.removeURLPatternsFromCollection(constraint, webResourceCollection, patterns, targetRole, allRoles, resourceWrapper, webEdit, editingDomain, resourceRootNode, project, undoableCommand);
            }
        }
    }

    private static void removeURLPatternsFromCollection(Object constraint, Object webResourceCollection, List patterns, Object targetRole, List allRoles, SecurityResourceWrapper resourceWrapper, IModelProvider webEdit, EditingDomain editingDomain, ResourceRootNode resourceRootNode, IProject project, CompoundCommand undoableCommand) {
        for (String pattern : patterns) {
            if (allRoles.size() > 1) {
                SecurityWebUtilities.processCommand((Object)SecurityWebUtilities.factorOutPatternForRoles(targetRole, allRoles, pattern, webResourceCollection, webEdit, editingDomain), (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
            }
            if (pattern.indexOf("*") > -1 && SecurityWebUtilities.isValidWildCard((String)pattern)) {
                CompoundCommand command = new CompoundCommand();
                List resourceBeingRemovedURLPatterns = resourceWrapper.getURLPatterns();
                SecurityWebUtilities.processCommand((Object)ApiClass.removeURLPatternCommand(webResourceCollection, editingDomain, pattern), (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
                if (!resourceWrapper.isContainer()) {
                    List resources = SecurityWebUtilities.getResourcesFor(project, (ResourceNode)resourceRootNode.getChildren().get(0), pattern);
                    for (ResourceNode resource : resources) {
                        List urlPatterns = resource.getURLPatterns();
                        for (String urlPattern : urlPatterns) {
                            if (resource.getResourceWrapper().isContainer()) {
                                SecurityWebUtilities.processWildcardContainer(resource, resourceBeingRemovedURLPatterns, project, undoableCommand, targetRole, webResourceCollection, webEdit, editingDomain);
                                continue;
                            }
                            if (resourceBeingRemovedURLPatterns.contains(urlPattern) || !resource.getResourceWrapper().canBeConstrained()) continue;
                            Command potentialCommand = SecurityWebUtilities.movePattern(targetRole, urlPattern, webResourceCollection, webEdit, editingDomain);
                            SecurityWebUtilities.processCommand((Object)potentialCommand, (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
                        }
                    }
                }
                SecurityWebUtilities.processCommand((Object)command, (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
                continue;
            }
            SecurityWebUtilities.processCommand((Object)ApiClass.removeURLPatternCommand(webResourceCollection, editingDomain, pattern), (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
        }
        if (ApiClass.getURLPatterns(webResourceCollection).size() == 0) {
            List collections = ApiClass.getResourceCollections(constraint);
            if (collections.size() == 1) {
                SecurityWebUtilities.processCommand((Object)ApiClass.removeConstraintCommand(webEdit, editingDomain, constraint), (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
            } else {
                SecurityWebUtilities.processCommand((Object)ApiClass.removeResourceCollectionCommand(constraint, editingDomain, webResourceCollection), (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
            }
        }
    }

    private static boolean processWildcardContainer(ResourceNode resource, List targetPatterns, IProject project, CompoundCommand undoableCommand, Object targetRole, Object webResourceCollection, IModelProvider webEdit, EditingDomain editingDomain) {
        List resources = resource.getChildren();
        for (ResourceNode element : resources) {
            if (element.getResourceWrapper().isContainer()) {
                SecurityWebUtilities.processWildcardContainer(element, targetPatterns, project, undoableCommand, targetRole, webResourceCollection, webEdit, editingDomain);
                continue;
            }
            List urlPatterns = element.getURLPatterns();
            for (String urlPattern : urlPatterns) {
                if (targetPatterns.contains(urlPattern) || !resource.getResourceWrapper().canBeConstrained()) continue;
                Command potentialCommand = SecurityWebUtilities.movePattern(targetRole, urlPattern, webResourceCollection, webEdit, editingDomain);
                SecurityWebUtilities.processCommand((Object)potentialCommand, (CompoundCommand)undoableCommand, (EditingDomain)editingDomain, (IModelProvider)webEdit);
            }
        }
        return false;
    }

    private static Command factorOutPatternForRoles(Object targetRole, List allRoles, String url, Object webResourceCollection, IModelProvider webEdit, EditingDomain editingDomain) {
        ArrayList otherRoles = new ArrayList(allRoles);
        if (targetRole instanceof SecurityRole) {
            otherRoles.remove(((SecurityRole)targetRole).getRoleName());
        }
        CompoundCommand result = new CompoundCommand();
        for (String otherRole : otherRoles) {
            Object theRole = ApiClass.getRoleNamed(webEdit, otherRole);
            if (theRole == null) continue;
            result.append(SecurityWebUtilities.movePattern(theRole, url, webResourceCollection, webEdit, editingDomain));
        }
        return result;
    }

    private static Command movePattern(Object securityRole, String url, Object webResourceCollection, IModelProvider webEdit, EditingDomain editingDomain) {
        IPreferenceStore preferenceStore = SecurityBasePlugin.getDefault().getPreferenceStore();
        CompoundCommand result = new CompoundCommand();
        List httpMethods = ApiClass.getHTTPMethods(webResourceCollection);
        ArrayList<String> methodNames = new ArrayList<String>();
        for (HTTPMethodTypeEnum httpMethodType : httpMethods) {
            methodNames.add(httpMethodType.getName());
        }
        boolean isDefault = true;
        int i = 0;
        while (i < SecurityConstants.HTTP_METHODS.length && isDefault) {
            boolean defaultSelection = preferenceStore.getBoolean(SecurityConstants.HTTP_METHODS[i]);
            if (defaultSelection && !methodNames.contains(SecurityConstants.HTTP_METHODS[i])) {
                isDefault = false;
            } else if (!defaultSelection && methodNames.contains(SecurityConstants.HTTP_METHODS[i])) {
                isDefault = false;
            }
            ++i;
        }
        if (isDefault) {
            result.append(SecurityWebUtilities.addPatternToDefaultConstraintForRole(securityRole, url, webEdit, editingDomain));
        } else {
            Object newConstraint = null;
            Object theCollection = null;
            List constraints = ApiClass.getConstraintsForSingleRole(webEdit, securityRole);
            if (webResourceCollection instanceof WebResourceCollection) {
                constraints.remove(((WebResourceCollection)webResourceCollection).getSecConstraint());
            }
            boolean foundOne = false;
            Iterator iter = constraints.iterator();
            while (iter.hasNext() && !foundOne) {
                newConstraint = iter.next();
                List collections = null;
                if (newConstraint instanceof SecurityConstraint) {
                    collections = ((SecurityConstraint)newConstraint).getWebResourceCollections();
                }
                Iterator iterator = collections.iterator();
                while (iterator.hasNext() && !foundOne) {
                    theCollection = iterator.next();
                    foundOne = true;
                    List targetsHttpMethods = ApiClass.getHTTPMethods(theCollection);
                    if (targetsHttpMethods.size() != httpMethods.size()) continue;
                    Iterator iterator3 = targetsHttpMethods.iterator();
                    while (iterator3.hasNext() && foundOne) {
                        HTTPMethodTypeEnum httpMethodType = (HTTPMethodTypeEnum)iterator3.next();
                        if (httpMethods.contains(httpMethodType)) continue;
                        foundOne = false;
                    }
                }
            }
            if (!foundOne) {
                AddCommand newConstraintCommand = null;
                int i2 = 0;
                String roleName = null;
                if (securityRole instanceof SecurityRole) {
                    roleName = ((SecurityRole)securityRole).getRoleName();
                }
                while (newConstraintCommand == null && i2 <= 9999) {
                    newConstraintCommand = i2 == 0 ? (AddCommand)ApiClass.addConstraintCommand(webEdit, editingDomain, String.valueOf(roleName) + "_" + Messages.constraint_label) : (AddCommand)ApiClass.addConstraintCommand(webEdit, editingDomain, String.valueOf(roleName) + "_" + Messages.constraint_label + i2);
                    ++i2;
                }
                result.append(newConstraintCommand);
                newConstraint = newConstraintCommand.getCollection().iterator().next();
                result.append((Command)ApiClass.addRoleToConstraintCommand(webEdit, editingDomain, newConstraint, roleName, new Boolean(false)));
                AddCommand newCollectionCommand = (AddCommand)ApiClass.addResourceCollectionCommand(newConstraint, webEdit, editingDomain, String.valueOf(roleName) + "_Collection", "");
                result.append((Command)newCollectionCommand);
                theCollection = newCollectionCommand.getCollection().iterator().next();
                for (String methodName : methodNames) {
                    result.append(ApiClass.addHTTPMethodCommand(theCollection, editingDomain, methodName));
                }
            }
            result.append((Command)ApiClass.addURLPatternCommand(theCollection, editingDomain, url));
        }
        return result;
    }

    public static final List getMatchingPatternsFromCollection(IProject project, Object collection, SecurityResourceWrapper resourceWrapper) {
        ArrayList result = new ArrayList();
        List patterns = ApiClass.getURLPatterns(collection);
        for (Object pattern : patterns) {
            if (!SecurityWebUtilities.patternMatch((IProject)project, pattern, (SecurityResourceWrapper)resourceWrapper)) continue;
            result.add(pattern);
        }
        return result;
    }

    public static final HashMap getPatternsFor(IModelProvider model, Object constraint, SecurityResourceWrapper resourceWrapper) {
        HashMap result = new HashMap();
        List collections = ApiClass.getResourceCollections(constraint);
        if (collections != null) {
            for (Object webResourceCollection : collections) {
                List matchedPatterns = SecurityWebUtilities.getMatchingPatternsFromCollection(JavaEEProjectUtilities.getProject((Object)model.getModelObject()), webResourceCollection, resourceWrapper);
                if (matchedPatterns.size() <= 0) continue;
                result.put(webResourceCollection, matchedPatterns);
            }
        }
        return result;
    }

    public static String getDisplayName(Object constraint, int j2EEVersion) {
        List displayNames;
        String result = "";
        if (constraint instanceof SecurityConstraint) {
            if (j2EEVersion >= 14) {
                EList displayNames2 = ((SecurityConstraint)constraint).getDisplayNames();
                if (displayNames2.size() > 0) {
                    result = ((DisplayName)displayNames2.get(0)).getValue();
                }
            } else {
                result = ((SecurityConstraint)constraint).getDisplayName();
            }
        } else if (constraint instanceof org.eclipse.jst.javaee.web.SecurityConstraint && (displayNames = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getDisplayNames()).size() > 0) {
            result = ((org.eclipse.jst.javaee.core.DisplayName)displayNames.get(0)).getValue();
        }
        return result;
    }

    public static final List getResourcesFor(IProject project, ResourceNode rootNode, String url) {
        ArrayList<ResourceNode> result = new ArrayList<ResourceNode>();
        String matchSoFar = "";
        if (url.indexOf("*") > -1 && !SecurityWebUtilities.isValidWildCard((String)url)) {
            return Collections.EMPTY_LIST;
        }
        String[] split = url.split("/");
        ResourceNode currentNode = rootNode;
        int i = 0;
        i = 1;
        while (i < split.length && split[i].indexOf("*") == -1) {
            String processing = split[i];
            if ((currentNode = SecurityWebUtilities.findTarget(currentNode, "/" + processing, matchSoFar)) == null) {
                return result;
            }
            matchSoFar = String.valueOf(matchSoFar) + "/" + processing;
            ++i;
        }
        if (i < split.length) {
            List children = currentNode.getChildren();
            for (ResourceNode node : children) {
                if (!SecurityWebUtilities.patternMatch((IProject)project, (Object)url, (SecurityResourceWrapper)node.getResourceWrapper())) continue;
                result.add(node);
            }
        } else {
            result.add(currentNode);
        }
        return result;
    }

    private static final ResourceNode findTarget(ResourceNode startNode, String addressableURL, String matchSoFar) {
        ResourceNode result = null;
        List urls = startNode.getURLPatterns();
        Iterator iter = urls.iterator();
        while (iter.hasNext() && result == null) {
            String url = (String)iter.next();
            if (!url.startsWith(String.valueOf(matchSoFar) + addressableURL)) continue;
            result = startNode;
        }
        if (result == null) {
            List children = startNode.getChildren();
            Iterator iter2 = children.iterator();
            while (iter2.hasNext() && result == null) {
                ResourceNode node = (ResourceNode)iter2.next();
                urls = node.getURLPatterns();
                Iterator iterator = urls.iterator();
                while (iterator.hasNext() && result == null) {
                    String url = (String)iterator.next();
                    if (!url.startsWith(String.valueOf(matchSoFar) + addressableURL)) continue;
                    result = node;
                }
            }
        }
        return result;
    }

    public static boolean isFacesProject(IProject project) {
        return SecurityUtilities.isProjectOfType((IProject)project, (String)"jsf.ibm") || SecurityUtilities.isProjectOfType((IProject)project, (String)"jsf.base");
    }

    public static Command newRunAsCommand(ICommonOperationsContext context, Object owner, Object securityRole, String newDescription) {
        Object modelObject = context.getModelProvider().getModelObject();
        if (modelObject instanceof WebApp) {
            WebApp webApp = (WebApp)modelObject;
            RunAsSpecifiedIdentity newRunAs = ((CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi")).getCommonFactory().createRunAsSpecifiedIdentity();
            if (securityRole == null) {
                return null;
            }
            Identity identity = ((CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi")).getCommonFactory().createIdentity();
            identity.setRoleName(((SecurityRole)securityRole).getRoleName());
            if (newDescription != null) {
                if (webApp.getJ2EEVersionID() >= 14) {
                    Description description = CommonFactory.eINSTANCE.createDescription();
                    description.setValue(newDescription);
                    newRunAs.getDescriptions().add((Object)description);
                } else {
                    newRunAs.setDescription(newDescription);
                }
            }
            newRunAs.setIdentity(identity);
            return SetCommand.create((EditingDomain)context.getEditingDomain(), (Object)owner, (Object)WebapplicationPackage.eINSTANCE.getServlet_RunAs(), (Object)newRunAs);
        }
        return null;
    }

    public static Command updateRunAsCommand(ICommonOperationsContext context, Object runAsOwner, Object securityRole, String newDescription) {
        CompoundCommand cc = new CompoundCommand();
        EObject container = null;
        if (runAsOwner instanceof RunAsSpecifiedIdentity) {
            container = ((RunAsSpecifiedIdentity)runAsOwner).eContainer();
        }
        cc.append(SecurityWebUtilities.newRunAsCommand(context, container, securityRole, newDescription));
        return cc;
    }

    public static Object deleteRunAsCommand(ICommonOperationsContext context, Object runas) {
        return ApiClass.removeRunAsCommand(context.getEditingDomain(), runas);
    }

    public static String getRunAsDescription(ICommonOperationsContext context, Object runAs) {
        String result = "";
        Object modelObject = context.getModelProvider().getModelObject();
        if (modelObject instanceof WebApp) {
            WebApp webApp = (WebApp)modelObject;
            if (webApp.getJ2EEVersionID() >= 14) {
                EList descriptions = ((RunAsSpecifiedIdentity)runAs).getDescriptions();
                if (!descriptions.isEmpty()) {
                    result = ((Description)descriptions.get(0)).getValue();
                }
            } else {
                result = ((RunAsSpecifiedIdentity)runAs).getDescription();
            }
        } else {
            List descriptions = ((RunAs)runAs).getDescriptions();
            if (descriptions != null && descriptions.size() > 0) {
                result = ((org.eclipse.jst.javaee.core.Description)descriptions.get(0)).getValue();
            }
        }
        return result;
    }

    public static IFacesURLPatternGenerator getFacesURLPatternGenerator() {
        IExtensionRegistry reg;
        IConfigurationElement[] conf;
        if (facesURLPatternGenerator == null && (conf = (reg = Platform.getExtensionRegistry()).getConfigurationElementsFor("com.ibm.etools.webtools.security.web.facesURLPatternGenerator")).length > 0) {
            IConfigurationElement currentConf = conf[0];
            try {
                facesURLPatternGenerator = (IFacesURLPatternGenerator)currentConf.createExecutableExtension("class");
            }
            catch (Exception exc) {
                Logger.logException((String)"Failed to create an instance of the faces url generator", (Throwable)exc);
            }
        }
        return facesURLPatternGenerator;
    }

    public static boolean patternMatch(Object pattern, SecurityResourceWrapper target) {
        boolean match = false;
        if (!(target.getResource() instanceof IResource || target.getResource() instanceof org.eclipse.jst.j2ee.webapplication.internal.impl.ServletMappingImpl || target.getResource() instanceof ServletMappingImpl)) {
            return false;
        }
        String stringPattern = null;
        if (pattern instanceof String) {
            stringPattern = (String)pattern;
        } else {
            UrlPatternType patternType = (UrlPatternType)pattern;
            stringPattern = patternType.getValue();
        }
        List urlPatterns = target.getURLPatterns();
        Iterator iter = urlPatterns.iterator();
        while (iter.hasNext() && !match) {
            String urlPattern = (String)iter.next();
            if (stringPattern.toUpperCase().equals(urlPattern.toUpperCase())) {
                match = true;
                continue;
            }
            if (!SecurityUtilities.isValidWildCard((String)stringPattern)) continue;
            int index = stringPattern.indexOf("*");
            String pre = null;
            if (index > 0) {
                pre = stringPattern.substring(0, index);
            }
            String post = null;
            if (index + 1 < stringPattern.length()) {
                post = stringPattern.substring(index + 1, stringPattern.length());
            }
            if (pre != null && !urlPattern.startsWith(pre) || post != null && !urlPattern.endsWith(post)) continue;
            match = true;
        }
        return match;
    }
}

