/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.run.as;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.Images;
import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperations;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.common.ops.SecurityCommonOperationsRegistry;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.editor.internal.actions.AddSecurityRoleAction;
import com.ibm.etools.webtools.security.editor.internal.context.SecurityEditorContext;
import com.ibm.etools.webtools.security.editor.internal.nls.Messages;
import com.ibm.etools.webtools.security.editor.internal.roles.viewer.RoleTreeNode;
import com.ibm.etools.webtools.security.editor.internal.util.SecurityEditorUtilities;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SecurityRunAsDialog
extends TitleAreaDialog
implements ISecurityEventListener {
    private SecurityEditorContext context;
    private Composite parent;
    IPreferenceStore preferenceStore = SecurityBasePlugin.getDefault().getPreferenceStore();
    private Combo runAsIdentitySelector = null;
    private Text description;
    private RunAsSpecifiedIdentity runas;
    private ICommonOperations commonOp;

    public SecurityRunAsDialog(Shell parentShell, IProject project, RunAsSpecifiedIdentity runas) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x20);
        this.context = SecurityEditorContext.getContextForProject((IProject)project, (Object)((Object)this));
        this.context.getModelListener().registerListener((ISecurityEventListener)this);
        this.commonOp = SecurityCommonOperationsRegistry.getCommonOperationsForProject((IProject)project);
        this.runas = runas;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.run_as_dialog_title);
        this.setTitle(Messages.edit_run_as_label);
        this.setMessage(Messages.run_as_dialog_description);
        this.setTitleImage(Images.getRunAsDescriptor().createImage());
        this.parent = this.createParent(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent, "com.ibm.etools.webtools.security.web.wtsec0110");
        this.createMainArea(this.parent);
        this.primData();
        this.runAsIdentitySelector.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                SecurityRunAsDialog.this.performValidation();
            }
        });
        SecurityEditorUtilities.checkAndPromptForNewRole((SecurityEditorContext)this.context);
        return this.parent;
    }

    private Composite createParent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 1;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 1;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createMainArea(Composite parent) {
        Label horizontalRule = new Label(parent, 258);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        horizontalRule.setLayoutData((Object)data);
        Label runAsLabel = new Label(parent, 0);
        runAsLabel.setText(SecurityConstants.Run_As_Label);
        this.runAsIdentitySelector = new Combo(parent, 8);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        this.runAsIdentitySelector.setLayoutData((Object)data);
        Button newRole = new Button(parent, 8);
        newRole.setText(Messages.new_role_button_label);
        new AddSecurityRoleAction(null, (Widget)newRole, (ICommonOperationsContext)this.context);
        Label descriptionLabel = new Label(parent, 0);
        descriptionLabel.setText(Messages.description_label);
        this.description = new Text(parent, 2626);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        data.heightHint = 60;
        this.description.setLayoutData((Object)data);
    }

    private void primData() {
        this.context.getSecurityRolesRoot().registerListener((ISecurityEventListener)this);
        this.initRoleSelections();
        this.runAsIdentitySelector.setText(this.runas.getIdentity().getRoleName());
        String description = SecurityWebUtilities.getRunAsDescription((ICommonOperationsContext)this.context, this.runas);
        if (description == null) {
            description = "";
        }
        this.description.setText(description);
    }

    private void initRoleSelections() {
        ArrayList<String> roleNames = new ArrayList<String>();
        List roles = this.context.getSecurityRolesRoot().getChildren();
        for (RoleTreeNode roleNode : roles) {
            if (!roleNode.isAssignable()) continue;
            String roleName = roleNode.getLabel();
            roleNames.add(roleName);
        }
        if (!roleNames.isEmpty()) {
            Collections.sort(roleNames);
            this.runAsIdentitySelector.setItems(roleNames.toArray(new String[roleNames.size()]));
        }
        this.performValidation();
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        this.initRoleSelections();
    }

    protected void okPressed() {
        Command command = null;
        if (!this.runas.getIdentity().getRoleName().equals(this.runAsIdentitySelector.getText()) || !SecurityWebUtilities.getRunAsDescription((ICommonOperationsContext)this.context, this.runas).equals(this.description.getText())) {
            Object role = this.commonOp.getSecurityRoleNamed((ICommonOperationsContext)this.context, this.runAsIdentitySelector.getText());
            command = SecurityWebUtilities.updateRunAsCommand((ICommonOperationsContext)this.context, this.runas, role, this.description.getText());
        }
        if (command != null && command.canExecute()) {
            this.context.getEditingDomain().getCommandStack().execute(command);
        }
        super.okPressed();
    }

    public boolean close() {
        this.context.getModelListener().removeListener((ISecurityEventListener)this);
        this.context.releaseContext((Object)this);
        return super.close();
    }

    private void performValidation() {
        if (this.getButton(0) != null) {
            if (this.runAsIdentitySelector.getSelectionIndex() == -1) {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(Messages.security_role_error);
            } else {
                this.getButton(0).setEnabled(true);
                this.setErrorMessage(null);
                this.setMessage(Messages.run_as_dialog_description);
            }
        }
    }
}

