/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers;

import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRolesChangedEvent;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectWrapper;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.SecurityConstraintDisplayNameChangedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.internal.impl.AuthConstraintImpl;
import org.eclipse.jst.j2ee.webapplication.internal.impl.SecurityConstraintImpl;

public class SecurityConstraintWrapper
extends SecurityObjectWrapper {
    protected AdapterImpl authConstraintAdapter = null;
    private List roles = Collections.EMPTY_LIST;
    private EObject authConstraint = null;

    public SecurityConstraintWrapper(EObject constraint) {
        super(constraint);
        this.updateRolesList();
        this.registerAuthAdapter();
    }

    public void dispose() {
        this.disposeAuthAdapter();
        super.dispose();
    }

    public Object getConstraint() {
        return this.emfObject;
    }

    private void updateRolesList() {
        this.roles = ApiClass.getRolesFor(this.getConstraint());
    }

    public List getRoles() {
        return this.roles;
    }

    public AdapterImpl getAdapter(EObject object) {
        return new SecurityConstraintAdapter(object);
    }

    private void handleAuthConstraintChanged() {
        this.disposeAuthAdapter();
        this.registerAuthAdapter();
    }

    private void registerAuthAdapter() {
        Object securityConstraint = this.getConstraint();
        this.authConstraint = securityConstraint instanceof SecurityConstraint ? ((SecurityConstraint)securityConstraint).getAuthConstraint() : (EObject)((org.eclipse.jst.javaee.web.SecurityConstraint)securityConstraint).getAuthConstraint();
        if (this.authConstraint != null) {
            this.authConstraintAdapter = new AuthConstraintAdapter(this.authConstraint);
        }
    }

    private void disposeAuthAdapter() {
        if (this.authConstraint != null && this.authConstraintAdapter != null) {
            this.authConstraint.eAdapters().remove((Object)this.authConstraintAdapter);
        }
    }

    private class AuthConstraintAdapter
    extends AdapterImpl {
        public AuthConstraintAdapter(EObject model) {
            this.setTarget((Notifier)model);
            model.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object object) {
            return object instanceof AuthConstraint || object instanceof org.eclipse.jst.javaee.web.AuthConstraint;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            Notifier source = (Notifier)notification.getNotifier();
            if (source == this.getTarget() && (feature = (EStructuralFeature)notification.getFeature()) != null) {
                int featureId = -999;
                if (feature instanceof EStructuralFeature) {
                    featureId = ((AuthConstraintImpl)source).eDerivedStructuralFeatureID(feature);
                    switch (featureId) {
                        case 1: {
                            SecurityConstraintWrapper.this.updateRolesList();
                            SecurityConstraintWrapper.this.fire((AbstractSecurityEvent)new SecurityRolesChangedEvent((Object)feature));
                        }
                    }
                }
            }
        }
    }

    private class SecurityConstraintAdapter
    extends AdapterImpl {
        public SecurityConstraintAdapter(EObject model) {
            this.setTarget((Notifier)model);
            model.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object object) {
            return object instanceof SecurityConstraint;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            Notifier source = (Notifier)notification.getNotifier();
            if (source == this.getTarget() && (feature = (EStructuralFeature)notification.getFeature()) != null) {
                int type = notification.getEventType();
                int featureId = -999;
                if (feature instanceof EStructuralFeature && source instanceof SecurityConstraint) {
                    featureId = ((SecurityConstraintImpl)source).eDerivedStructuralFeatureID(feature);
                    switch (featureId) {
                        case 0: {
                            SecurityConstraintWrapper.this.fire(new SecurityConstraintDisplayNameChangedEvent(feature));
                            break;
                        }
                        case 5: {
                            SecurityConstraintWrapper.this.fire(new SecurityConstraintDisplayNameChangedEvent(feature));
                            break;
                        }
                        case 2: {
                            ResourceCollectionAddedEvent event = null;
                            ArrayList<WebResourceCollection> collections = new ArrayList<WebResourceCollection>();
                            switch (type) {
                                case 3: {
                                    WebResourceCollection newCollection = (WebResourceCollection)notification.getNewValue();
                                    collections.add(newCollection);
                                    event = new ResourceCollectionAddedEvent(source, collections);
                                    break;
                                }
                                case 5: {
                                    Iterator iter = ((List)notification.getNewValue()).iterator();
                                    while (iter.hasNext()) {
                                        WebResourceCollection newCollection = (WebResourceCollection)notification.getNewValue();
                                        collections.add(newCollection);
                                    }
                                    event = new ResourceCollectionAddedEvent(source, collections);
                                    break;
                                }
                                case 4: {
                                    WebResourceCollection oldCollection = (WebResourceCollection)notification.getNewValue();
                                    collections.add(oldCollection);
                                    event = new ResourceCollectionAddedEvent(source, collections);
                                    break;
                                }
                                case 6: {
                                    Iterator iter = ((List)notification.getOldValue()).iterator();
                                    while (iter.hasNext()) {
                                        WebResourceCollection oldCollection = (WebResourceCollection)notification.getNewValue();
                                        collections.add(oldCollection);
                                    }
                                    event = new ResourceCollectionAddedEvent(source, collections);
                                }
                            }
                            SecurityConstraintWrapper.this.fire(event);
                            break;
                        }
                        case 3: {
                            SecurityConstraintWrapper.this.handleAuthConstraintChanged();
                        }
                    }
                }
            }
        }
    }
}

