/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu;

import com.ibm.etools.webtools.security.base.internal.actions.AbstractViewerMenuAction;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectWrapper;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.ResourceCollectionWrapper;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.SecurityConstraintWrapper;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import com.ibm.etools.webtools.security.web.internal.wizards.url.URLPatternsWizard;
import com.ibm.etools.webtools.security.web.internal.wizards.url.URLPatternsWizardDataModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class NewURLPatternAction
extends AbstractViewerMenuAction {
    public NewURLPatternAction(TreeViewer constraintsViewer, MenuItem menuItem, ICommonOperationsContext context) {
        super((StructuredViewer)constraintsViewer, (Widget)menuItem, context);
        this.disable();
    }

    public void checkEnablement(ISelection selection) {
        this.enabled = false;
        StructuredSelection ss = (StructuredSelection)selection;
        SecurityObjectTreeNode node = (SecurityObjectTreeNode)ss.getFirstElement();
        if (node != null && this.getCollection(node) != null) {
            this.enabled = true;
        }
        if (this.enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void run() {
        if (this.enabled) {
            if (!this.context.validateState()) {
                return;
            }
            Object constraint = this.getConstraint((SecurityObjectTreeNode)((StructuredSelection)this.viewer.getSelection()).getFirstElement());
            Object webResourceCollection = this.getCollection((SecurityObjectTreeNode)((StructuredSelection)this.viewer.getSelection()).getFirstElement());
            URLPatternsWizardDataModel model = new URLPatternsWizardDataModel(this.context.getProject());
            Object modelObject = this.context.getModelProvider().getModelObject();
            String constraintName = null;
            String webResourceName = null;
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                int j2EEVersion = webApp.getJ2EEVersionID();
                constraintName = SecurityWebUtilities.getDisplayName(constraint, j2EEVersion);
                webResourceName = ((WebResourceCollection)webResourceCollection).getWebResourceName();
                model.setEditingDomain(this.context.getEditingDomain());
            } else if (modelObject instanceof WebApp) {
                constraintName = SecurityWebUtilities.getDisplayName(constraint, -1);
                webResourceName = ((org.eclipse.jst.javaee.web.WebResourceCollection)webResourceCollection).getWebResourceName();
            }
            model.setPropertyValue("constraint name", constraintName);
            model.setPropertyValue("resource collection name", webResourceName);
            model.setEnableCollectionName(false);
            model.setModelProvider(this.context.getModelProvider());
            URLPatternsWizard wizard = new URLPatternsWizard(model);
            WizardDialog dialog = new WizardDialog(SecurityUtilities.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    private Object getCollection(SecurityObjectTreeNode node) {
        SecurityObjectWrapper wrapper = node.getObjectWrapper();
        if (wrapper instanceof ResourceCollectionWrapper) {
            return wrapper.getEmfObject();
        }
        if (wrapper instanceof SecurityConstraintWrapper) {
            return null;
        }
        return this.getCollection((SecurityObjectTreeNode)node.getParent());
    }

    private Object getConstraint(SecurityObjectTreeNode node) {
        SecurityObjectWrapper wrapper = node.getObjectWrapper();
        if (wrapper instanceof SecurityConstraintWrapper) {
            return wrapper.getEmfObject();
        }
        return this.getConstraint((SecurityObjectTreeNode)node.getParent());
    }
}

