/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu;

import com.ibm.etools.webtools.security.base.internal.actions.AbstractViewerMenuAction;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectWrapper;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.SecurityConstraintWrapper;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import com.ibm.etools.webtools.security.web.internal.wizards.newResourceCollection.NewResourceCollectionWizard;
import com.ibm.etools.webtools.security.web.internal.wizards.newResourceCollection.NewResourceCollectionWizardDataModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class NewResourceCollectionAction
extends AbstractViewerMenuAction {
    public NewResourceCollectionAction(TreeViewer constraintsViewer, MenuItem menuItem, ICommonOperationsContext context) {
        super((StructuredViewer)constraintsViewer, (Widget)menuItem, context);
        this.disable();
    }

    public void checkEnablement(ISelection selection) {
        this.enabled = false;
        if (selection instanceof StructuredSelection) {
            this.enabled = true;
        }
        if (this.enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void run() {
        if (this.enabled) {
            if (!this.context.validateState()) {
                return;
            }
            Object constraint = this.getConstraint((SecurityObjectTreeNode)((StructuredSelection)this.viewer.getSelection()).getFirstElement());
            NewResourceCollectionWizardDataModel model = new NewResourceCollectionWizardDataModel(this.context.getProject());
            Object modelObject = this.context.getModelProvider().getModelObject();
            int j2EEVersion = -1;
            if (modelObject instanceof WebApp) {
                WebApp webApp = (WebApp)modelObject;
                j2EEVersion = webApp.getJ2EEVersionID();
                model.setEditingDomain(this.context.getEditingDomain());
            }
            model.setPropertyValue("constraint name", SecurityWebUtilities.getDisplayName(constraint, j2EEVersion));
            model.setModelProvider(this.context.getModelProvider());
            NewResourceCollectionWizard wizard = new NewResourceCollectionWizard(model);
            WizardDialog dialog = new WizardDialog(SecurityUtilities.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    private Object getConstraint(SecurityObjectTreeNode node) {
        SecurityObjectWrapper wrapper = node.getObjectWrapper();
        if (wrapper instanceof SecurityConstraintWrapper) {
            return wrapper.getEmfObject();
        }
        return this.getConstraint((SecurityObjectTreeNode)node.getParent());
    }
}

