/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu;

import com.ibm.etools.webtools.security.base.internal.actions.AbstractViewerMenuAction;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.web.internal.Logger;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.HTTPMethodsTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ResourceCollectionTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.URLPatternTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class DeleteAction
extends AbstractViewerMenuAction {
    List selectedConstraints = new ArrayList();
    List selectedCollections = new ArrayList();
    HashMap constraintToCollection = new HashMap();
    HashMap collectionToURL = new HashMap();

    public DeleteAction(TreeViewer constraintsViewer, MenuItem menuItem, ICommonOperationsContext context) {
        super((StructuredViewer)constraintsViewer, (Widget)menuItem, context);
        this.disable();
    }

    public void checkEnablement(ISelection selection) {
        this.enabled = true;
        StructuredSelection ss = (StructuredSelection)selection;
        this.processSelection(ss);
        Iterator iter = ss.iterator();
        while (iter.hasNext() && this.enabled) {
            ResourceCollectionTreeNode collection;
            ConstraintTreeNode constraint;
            GenericNode treeNode = (GenericNode)iter.next();
            if (treeNode instanceof ResourceCollectionTreeNode) {
                ConstraintTreeNode constraint2 = (ConstraintTreeNode)treeNode.getParent();
                if (this.selectedConstraints.contains((Object)constraint2)) continue;
                List selectedCollections = (List)this.constraintToCollection.get((Object)constraint2);
                if (constraint2.getChildren().size() != selectedCollections.size()) continue;
                this.enabled = false;
                continue;
            }
            if (!(treeNode instanceof URLPatternTreeNode) || this.selectedConstraints.contains((Object)(constraint = (ConstraintTreeNode)(collection = (ResourceCollectionTreeNode)treeNode.getParent()).getParent())) || this.selectedCollections.contains((Object)collection)) continue;
            List selectedURLs = (List)this.collectionToURL.get((Object)collection);
            if (collection.getChildren().size() != selectedURLs.size() + 1) continue;
            this.enabled = false;
        }
        if (this.enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private void processSelection(StructuredSelection ss) {
        this.selectedConstraints.clear();
        this.selectedCollections.clear();
        this.constraintToCollection.clear();
        this.collectionToURL.clear();
        for (GenericNode treeNode : ss) {
            if (treeNode instanceof ConstraintTreeNode) {
                this.selectedConstraints.add(treeNode);
                continue;
            }
            if (treeNode instanceof ResourceCollectionTreeNode) {
                this.selectedCollections.add(treeNode);
                ConstraintTreeNode constraint = (ConstraintTreeNode)treeNode.getParent();
                List<GenericNode> collections = new ArrayList();
                if (this.constraintToCollection.containsKey((Object)constraint)) {
                    collections = (List)this.constraintToCollection.get((Object)constraint);
                } else {
                    this.constraintToCollection.put(constraint, collections);
                }
                collections.add(treeNode);
                continue;
            }
            if (!(treeNode instanceof URLPatternTreeNode)) continue;
            ResourceCollectionTreeNode collection = (ResourceCollectionTreeNode)treeNode.getParent();
            List<GenericNode> urlPatterns = new ArrayList();
            if (this.collectionToURL.containsKey((Object)collection)) {
                urlPatterns = (List)this.collectionToURL.get((Object)collection);
            } else {
                this.collectionToURL.put(collection, urlPatterns);
            }
            urlPatterns.add(treeNode);
        }
    }

    public void run() {
        if (!this.context.validateState()) {
            return;
        }
        if (this.enabled && SecurityUtilities.confirmDelete()) {
            CompoundCommand cc = new CompoundCommand();
            StructuredSelection ss = (StructuredSelection)this.viewer.getSelection();
            for (GenericNode treeNode : ss) {
                Command command = null;
                if (treeNode instanceof ConstraintTreeNode) {
                    command = this.generateDeleteFor((ConstraintTreeNode)treeNode);
                } else if (treeNode instanceof ResourceCollectionTreeNode) {
                    command = this.generateDeleteFor((ResourceCollectionTreeNode)treeNode);
                } else if (treeNode instanceof HTTPMethodsTreeNode) {
                    command = this.generateDeleteFor((HTTPMethodsTreeNode)treeNode);
                } else if (treeNode instanceof URLPatternTreeNode) {
                    command = this.generateDeleteFor((URLPatternTreeNode)treeNode);
                }
                if (command == null) {
                    Logger.log(4, "null delete command generated");
                    return;
                }
                cc.append(command);
            }
            if (!cc.isEmpty()) {
                this.context.getEditingDomain().getCommandStack().execute((Command)cc);
            }
        }
    }

    private Command generateDeleteFor(ResourceCollectionTreeNode node) {
        WebResourceCollection collection = (WebResourceCollection)node.getObjectWrapper().getEmfObject();
        SecurityConstraint constraint = (SecurityConstraint)((SecurityObjectTreeNode)node.getParent()).getObjectWrapper().getEmfObject();
        return ApiClass.removeResourceCollectionCommand(constraint, this.context.getEditingDomain(), collection);
    }

    private Command generateDeleteFor(URLPatternTreeNode node) {
        EObject webResourceCollection = ((SecurityObjectTreeNode)node.getParent()).getObjectWrapper().getEmfObject();
        String urlPattern = node.getLabel();
        return ApiClass.removeURLPatternCommand(webResourceCollection, this.context.getEditingDomain(), urlPattern);
    }

    private Command generateDeleteFor(HTTPMethodsTreeNode node) {
        CompoundCommand cc = new CompoundCommand();
        WebResourceCollection collection = (WebResourceCollection)((SecurityObjectTreeNode)node.getParent()).getObjectWrapper().getEmfObject();
        List methods = ApiClass.getHTTPMethods(collection);
        for (HTTPMethodTypeEnum method : methods) {
            Command command = ApiClass.removeHTTPMethodCommand(collection, this.context.getEditingDomain(), method.getName());
            if (command == null) continue;
            cc.append(command);
        }
        return cc;
    }

    private Command generateDeleteFor(ConstraintTreeNode node) {
        EObject constraint = node.getObjectWrapper().getEmfObject();
        return ApiClass.removeConstraintCommand(this.context.getModelProvider(), this.context.getEditingDomain(), constraint);
    }
}

