/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu;

import com.ibm.etools.webtools.security.base.internal.actions.AbstractViewerMenuAction;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectWrapper;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.ResourceCollectionWrapper;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.SecurityConstraintWrapper;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import com.ibm.etools.webtools.security.web.internal.wizards.http.HTTPMethodsForResourceCollectionDataModel;
import com.ibm.etools.webtools.security.web.internal.wizards.http.HTTPMethodsForResourceCollectionWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ChangeHTTPMethodsAction
extends AbstractViewerMenuAction {
    public ChangeHTTPMethodsAction(TreeViewer constraintsViewer, MenuItem menuItem, ICommonOperationsContext context) {
        super((StructuredViewer)constraintsViewer, (Widget)menuItem, context);
        this.disable();
    }

    public void checkEnablement(ISelection selection) {
        this.enabled = false;
        StructuredSelection ss = (StructuredSelection)selection;
        SecurityObjectTreeNode node = (SecurityObjectTreeNode)ss.getFirstElement();
        if (node != null && this.getCollection(node) != null) {
            this.enabled = true;
        }
        if (this.enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void run() {
        if (this.enabled) {
            Object modelObject;
            if (!this.context.validateState()) {
                return;
            }
            SecurityObjectTreeNode node = (SecurityObjectTreeNode)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            Object webResourceCollection = this.getCollection(node);
            HTTPMethodsForResourceCollectionDataModel model = new HTTPMethodsForResourceCollectionDataModel(this.context.getProject());
            SecurityConstraint constraint = null;
            if (webResourceCollection instanceof WebResourceCollection) {
                constraint = ((WebResourceCollection)webResourceCollection).getSecConstraint();
            }
            if ((modelObject = this.context.getModelProvider().getModelObject()) instanceof WebApp) {
                WebApp webApp = (WebApp)modelObject;
                int j2EEVersion = webApp.getJ2EEVersionID();
                String constraintName = SecurityWebUtilities.getDisplayName(constraint, j2EEVersion);
                model.setPropertyValue("constraint name", constraintName);
                model.setPropertyValue("resource collection name", ((WebResourceCollection)webResourceCollection).getWebResourceName());
                model.setEnableCollectionName(false);
                model.setEditingDomain(this.context.getEditingDomain());
                model.setModelProvider(this.context.getModelProvider());
                HTTPMethodsForResourceCollectionWizard wizard = new HTTPMethodsForResourceCollectionWizard(model);
                WizardDialog dialog = new WizardDialog(SecurityUtilities.getShell(), (IWizard)wizard);
                dialog.open();
            }
        }
    }

    private Object getCollection(SecurityObjectTreeNode node) {
        SecurityObjectWrapper wrapper = node.getObjectWrapper();
        if (wrapper instanceof ResourceCollectionWrapper) {
            return wrapper.getEmfObject();
        }
        if (wrapper instanceof SecurityConstraintWrapper) {
            return null;
        }
        return this.getCollection((SecurityObjectTreeNode)node.getParent());
    }
}

