/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constraint.viewer;

import com.ibm.etools.webtools.security.base.internal.Images;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.base.internal.events.RoleSelectionChangedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRolesChangedEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceContainerNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.util.SecurityWidgetFactory;
import com.ibm.etools.webtools.security.editor.internal.GenericTreeNodeContentProvider;
import com.ibm.etools.webtools.security.editor.internal.SecurityObjectTreeNode;
import com.ibm.etools.webtools.security.editor.internal.context.SecurityEditorContext;
import com.ibm.etools.webtools.security.editor.internal.editorpart.ISecurityViewer;
import com.ibm.etools.webtools.security.editor.internal.resource.viewer.ResourcesViewer;
import com.ibm.etools.webtools.security.editor.internal.roles.viewer.RoleSelectionManager;
import com.ibm.etools.webtools.security.web.internal.api.ApiClass;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintViewerRootTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintViewerSorter;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintsViewerDropTargetAdadpter;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintsViewerLabelProvider;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ResourceCollectionTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.URLPatternTreeNode;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.ChangeConstraintRoleAssociationAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.ChangeHTTPMethodsAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.ChangeUserDataConstraintAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.DeleteAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.NewConstraintAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.NewResourceCollectionAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.NewURLPatternAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.menu.RenameAction;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.wrappers.SecurityConstraintWrapper;
import com.ibm.etools.webtools.security.web.internal.events.HTTPMethodChangedEvent;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionNameChangedEvent;
import com.ibm.etools.webtools.security.web.internal.events.ResourceCollectionRemovedEvent;
import com.ibm.etools.webtools.security.web.internal.events.SecurityConstraintAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.SecurityConstraintDisplayNameChangedEvent;
import com.ibm.etools.webtools.security.web.internal.events.SecurityConstraintRemovedEvent;
import com.ibm.etools.webtools.security.web.internal.events.URLPatternAddedEvent;
import com.ibm.etools.webtools.security.web.internal.events.URLPatternRemovedEvent;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;

public class ConstraintsViewer
implements ISecurityViewer,
ISecurityEventListener {
    private SecurityEditorContext context = null;
    private SecurityWidgetFactory widgetFactory = SecurityWidgetFactory.singleton;
    private TreeViewer constraintsTreeViewer = null;
    Tree tree = null;
    private ConstraintViewerRootTreeNode constraintRootTreeNode = new ConstraintViewerRootTreeNode(null, null);
    private ResourceViewerSelectionChangedListener resourceViewerSelectionChangedListener = new ResourceViewerSelectionChangedListener();
    private EditorActionBarContributor actionBarContributor = null;
    private RoleSelectionManager roleSelectionManager = null;
    private ResourcesViewer resourcesViewer;
    private ToolBar resourceViewerToolBar;
    private MenuItem newConstraint = null;
    private MenuItem changeConstraintRoles = null;
    private MenuItem changeUserDataConstraint = null;
    private MenuItem newResourceCollection = null;
    private MenuItem changeHTTPMethods = null;
    private MenuItem addURLPattern = null;
    private MenuItem delete = null;
    private MenuItem rename = null;
    private Menu constraintsViewerToolBarMenu;
    private int j2EEVersion = -1;
    private int uiFormat = 0;
    final Listener labelListener = new Listener(){

        public void handleEvent(Event event) {
            Label label = (Label)event.widget;
            Shell shell = label.getShell();
            switch (event.type) {
                case 3: {
                    ConstraintsViewer.this.constraintsTreeViewer.setSelection((ISelection)new StructuredSelection(label.getData("_TOOLTIP")));
                }
                case 7: {
                    shell.dispose();
                }
            }
        }
    };
    Listener treeListener = new Listener(){
        Shell tip = null;
        Label label = null;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 5: {
                    Object data;
                    TreeItem item;
                    if (this.tip == null || (item = ConstraintsViewer.this.tree.getItem(new Point(event.x, event.y))) != null && (data = item.getData()) == this.label.getData("_TOOLTIP")) break;
                }
                case 1: 
                case 12: 
                case 16: {
                    if (this.tip == null) break;
                    this.tip.dispose();
                    this.tip = null;
                    this.label = null;
                    break;
                }
                case 32: {
                    String tooltip;
                    Object data;
                    TreeItem item = ConstraintsViewer.this.tree.getItem(new Point(event.x, event.y));
                    if (item == null) break;
                    if (this.tip != null && !this.tip.isDisposed()) {
                        this.tip.dispose();
                    }
                    if ((data = item.getData()) == null || !(data instanceof SecurityObjectTreeNode) || (tooltip = ((SecurityObjectTreeNode)data).getHoverHelp()) == null) break;
                    this.tip = new Shell(ConstraintsViewer.this.tree.getShell(), 16388);
                    FillLayout fillLayout = new FillLayout();
                    fillLayout.marginHeight = 1;
                    fillLayout.marginWidth = 1;
                    this.tip.setLayout((Layout)fillLayout);
                    this.label = new Label((Composite)this.tip, 0);
                    this.label.setForeground(this.tip.getDisplay().getSystemColor(28));
                    this.label.setBackground(this.tip.getDisplay().getSystemColor(29));
                    this.label.setData("_TOOLTIP", data);
                    this.label.setText(tooltip);
                    this.label.addListener(7, ConstraintsViewer.this.labelListener);
                    this.label.addListener(3, ConstraintsViewer.this.labelListener);
                    Point size = this.tip.computeSize(-1, -1);
                    Point pt = ConstraintsViewer.this.tree.toDisplay(event.x, event.y);
                    this.tip.setBounds(pt.x, pt.y + 26, size.x, size.y);
                    this.tip.setVisible(true);
                }
            }
        }
    };

    public Composite createViewerComposite(Composite parent) {
        Composite assignmentPageConstraintsComposite = this.uiFormat == 0 ? this.widgetFactory.createComposite(parent, 0x100000) : new Composite(parent, 0x100000);
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        assignmentPageConstraintsComposite.setLayoutData((Object)formData);
        FormLayout layout = new FormLayout();
        assignmentPageConstraintsComposite.setLayout((Layout)layout);
        Composite title = this.widgetFactory.createHeaderComposite(assignmentPageConstraintsComposite, Messages.constraints_label, Images.getConstraintImage());
        formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        title.setLayoutData((Object)formData);
        Composite composite = new Composite(assignmentPageConstraintsComposite, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)title, 5);
        composite.setLayoutData((Object)formData);
        this.createConstraintViewerToolBar(composite);
        this.createPartControl(composite);
        this.constraintsViewerToolBarMenu = this.createMenu(this.getTree());
        GridData gd = new GridData(1808);
        this.getTree().setLayoutData((Object)gd);
        if (this.uiFormat == 0) {
            this.widgetFactory.paintBordersFor(assignmentPageConstraintsComposite);
        }
        return assignmentPageConstraintsComposite;
    }

    private void createConstraintViewerToolBar(Composite parent) {
        this.resourceViewerToolBar = new ToolBar(parent, 0x800000);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.resourceViewerToolBar.setLayoutData((Object)gd);
        this.resourceViewerToolBar.getAccessible().addAccessibleListener(this.getToolbarAccessibleListener());
        ToolItem expandAll = new ToolItem(this.resourceViewerToolBar, 8);
        expandAll.setImage(Images.getExpandAllImage());
        expandAll.setToolTipText(Messages.expand_all_hover_help);
        expandAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConstraintsViewer.this.constraintsTreeViewer.getTree().setRedraw(false);
                ConstraintsViewer.this.constraintsTreeViewer.expandAll();
                ConstraintsViewer.this.constraintsTreeViewer.getTree().setRedraw(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem collapseAll = new ToolItem(this.resourceViewerToolBar, 8);
        collapseAll.setImage(Images.getCollapseAllImage());
        collapseAll.setToolTipText(Messages.collpase_all_hover_help);
        collapseAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConstraintsViewer.this.constraintsTreeViewer.getTree().setRedraw(false);
                ConstraintsViewer.this.constraintsTreeViewer.collapseAll();
                ConstraintsViewer.this.constraintsTreeViewer.getTree().setRedraw(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final ToolItem resourceToolBarMenuItem = new ToolItem(this.resourceViewerToolBar, 8);
        resourceToolBarMenuItem.setImage(Images.getViewMenuImage());
        resourceToolBarMenuItem.setToolTipText(Messages.menu_tool_tip);
        resourceToolBarMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Point toolbarSize = ConstraintsViewer.this.resourceViewerToolBar.getSize();
                Rectangle itemBounds = resourceToolBarMenuItem.getBounds();
                Point point = ConstraintsViewer.this.resourceViewerToolBar.toDisplay(itemBounds.x, toolbarSize.y);
                ConstraintsViewer.this.constraintsViewerToolBarMenu.setLocation(point);
                ConstraintsViewer.this.constraintsViewerToolBarMenu.setVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private AccessibleListener getToolbarAccessibleListener() {
        return new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String toolTip;
                ToolItem item;
                if (e.childID != -1 && (item = ConstraintsViewer.this.resourceViewerToolBar.getItem(e.childID)) != null && (toolTip = item.getToolTipText()) != null) {
                    e.result = toolTip;
                }
            }
        };
    }

    private void createPartControl(Composite parent) {
        this.tree = this.uiFormat == 0 ? this.widgetFactory.createTree(parent, 770) : new Tree(parent, 2818);
        this.constraintsTreeViewer = new TreeViewer(this.tree);
        this.constraintsTreeViewer.setContentProvider((IContentProvider)new GenericTreeNodeContentProvider());
        this.constraintsTreeViewer.setLabelProvider((IBaseLabelProvider)new ConstraintsViewerLabelProvider(this.roleSelectionManager, this.constraintsTreeViewer));
        this.constraintsTreeViewer.setSorter((ViewerSorter)new ConstraintViewerSorter());
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        this.constraintsTreeViewer.addDropSupport(ops, transfers, (DropTargetListener)new ConstraintsViewerDropTargetAdadpter((Viewer)this.constraintsTreeViewer, this.context));
        Menu menu = this.createMenu(this.tree);
        this.tree.setMenu(menu);
        this.constraintRootTreeNode.registerListener(this);
        this.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ConstraintsViewer.this.actionBarContributor != null) {
                    IActionBars bars = ConstraintsViewer.this.actionBarContributor.getActionBars();
                    bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)ConstraintsViewer.this.context.getAction("constraint viewer delete action"));
                    bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
                    bars.updateActionBars();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.tree.setToolTipText("");
        this.tree.addListener(16, this.treeListener);
        this.tree.addListener(12, this.treeListener);
        this.tree.addListener(1, this.treeListener);
        this.tree.addListener(5, this.treeListener);
        this.tree.addListener(32, this.treeListener);
    }

    public Menu createMenu(Tree tree) {
        Menu menu = new Menu((Control)tree);
        MenuItem newItem = new MenuItem(menu, 64);
        newItem.setText(Messages.new_label);
        Menu newMenu = new Menu(newItem);
        newItem.setMenu(newMenu);
        this.newConstraint = new MenuItem(newMenu, 8);
        this.newConstraint.setText(Messages.newConstraint_menu_label);
        new NewConstraintAction(this.constraintsTreeViewer, this.newConstraint, (ICommonOperationsContext)this.context);
        this.newResourceCollection = new MenuItem(newMenu, 8);
        this.newResourceCollection.setText(Messages.newResourceCollection_menu_label);
        new NewResourceCollectionAction(this.constraintsTreeViewer, this.newResourceCollection, (ICommonOperationsContext)this.context);
        this.addURLPattern = new MenuItem(newMenu, 8);
        this.addURLPattern.setText(Messages.addURLPattern_menu_label);
        new NewURLPatternAction(this.constraintsTreeViewer, this.addURLPattern, (ICommonOperationsContext)this.context);
        this.changeConstraintRoles = new MenuItem(menu, 8);
        this.changeConstraintRoles.setText(Messages.changeConstraintRoles_menu_label);
        new ChangeConstraintRoleAssociationAction(this.constraintsTreeViewer, this.changeConstraintRoles, (ICommonOperationsContext)this.context);
        this.changeUserDataConstraint = new MenuItem(menu, 8);
        this.changeUserDataConstraint.setText(Messages.user_data_menu);
        new ChangeUserDataConstraintAction(this.constraintsTreeViewer, this.changeUserDataConstraint, (ICommonOperationsContext)this.context);
        this.changeHTTPMethods = new MenuItem(menu, 8);
        this.changeHTTPMethods.setText(Messages.changeHTTPMethods_menu_label);
        new ChangeHTTPMethodsAction(this.constraintsTreeViewer, this.changeHTTPMethods, (ICommonOperationsContext)this.context);
        this.rename = new MenuItem(menu, 8);
        this.rename.setText(Messages.rename_label);
        this.context.addAction("constraint viewer rename action", (Action)new RenameAction(this.constraintsTreeViewer, this.rename, (ICommonOperationsContext)this.context));
        new MenuItem(menu, 2);
        this.delete = new MenuItem(menu, 8);
        this.delete.setText(Messages.delete_label);
        this.context.addAction("constraint viewer delete action", (Action)new DeleteAction(this.constraintsTreeViewer, this.delete, (ICommonOperationsContext)this.context));
        return menu;
    }

    public Tree getTree() {
        return (Tree)this.constraintsTreeViewer.getControl();
    }

    public void primData() {
        List securityConstraints = ApiClass.getConstraints(this.context.getModelProvider());
        Iterator iter = securityConstraints.iterator();
        while (iter.hasNext()) {
            ConstraintTreeNode newNode = this.generateTreeNodeFor(iter.next());
            newNode.setParent((GenericNode)this.constraintRootTreeNode);
            this.constraintRootTreeNode.addChild((GenericNode)newNode);
        }
        this.constraintsTreeViewer.setInput((Object)this.constraintRootTreeNode);
    }

    private ConstraintTreeNode generateTreeNodeFor(Object constraint) {
        SecurityConstraintWrapper wrapper = new SecurityConstraintWrapper((EObject)constraint);
        return new ConstraintTreeNode(Images.getConstraintImage(), "", wrapper, this.getJ2EEVersion());
    }

    private int getJ2EEVersion() {
        if (this.j2EEVersion == -1) {
            Object modelObject = this.context.getModelProvider().getModelObject();
            if (modelObject instanceof WebApp) {
                WebApp webApp = (WebApp)modelObject;
                this.j2EEVersion = webApp.getJ2EEVersionID();
            } else {
                this.j2EEVersion = -1;
            }
        }
        return this.j2EEVersion;
    }

    public void refreshConstraintsList() {
        List modelConstraints = ApiClass.getConstraints(this.context.getModelProvider());
        ArrayList copy = new ArrayList(modelConstraints);
        ArrayList<ConstraintTreeNode> toRemove = new ArrayList<ConstraintTreeNode>();
        for (ConstraintTreeNode treeNode : this.constraintRootTreeNode.getChildren()) {
            SecurityConstraintWrapper wrapper = (SecurityConstraintWrapper)treeNode.getObjectWrapper();
            if (modelConstraints.contains(wrapper.getConstraint())) {
                copy.remove(wrapper.getConstraint());
                continue;
            }
            toRemove.add(treeNode);
        }
        for (ConstraintTreeNode treeNode : toRemove) {
            this.constraintRootTreeNode.removeChild((GenericNode)treeNode);
        }
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            ConstraintTreeNode newNode = this.generateTreeNodeFor(iter.next());
            newNode.setParent((GenericNode)this.constraintRootTreeNode);
            this.constraintRootTreeNode.addChild((GenericNode)newNode);
        }
    }

    private void refreshInput(AbstractSecurityEvent event) {
        if (event instanceof SecurityConstraintAddedEvent || event instanceof SecurityConstraintRemovedEvent) {
            this.constraintsTreeViewer.refresh();
        } else if (event instanceof ResourceCollectionNameChangedEvent) {
            String[] properties = new String[]{"label"};
            this.constraintsTreeViewer.update(event.getSource(), properties);
        } else if (event instanceof RoleSelectionChangedEvent) {
            this.constraintsTreeViewer.refresh();
        } else if (event instanceof HTTPMethodChangedEvent) {
            this.constraintsTreeViewer.refresh(event.getSource());
        } else if (event instanceof URLPatternAddedEvent || event instanceof URLPatternRemovedEvent) {
            this.constraintsTreeViewer.refresh(event.getSource());
        } else if (event instanceof ResourceCollectionAddedEvent || event instanceof ResourceCollectionRemovedEvent) {
            this.constraintsTreeViewer.refresh(event.getSource());
        } else if (event instanceof SecurityConstraintDisplayNameChangedEvent) {
            String[] properties = new String[]{"label"};
            this.constraintsTreeViewer.update(event.getSource(), properties);
        } else if (event instanceof SecurityRolesChangedEvent) {
            String[] properties = new String[]{"constraint_roles"};
            this.constraintsTreeViewer.update(event.getSource(), properties);
        }
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        if (event instanceof SecurityConstraintAddedEvent || event instanceof SecurityConstraintRemovedEvent) {
            this.refreshConstraintsList();
        }
        this.refreshInput(event);
    }

    public void dispose() {
        this.constraintRootTreeNode.removeListener(this);
        this.constraintRootTreeNode.dispose();
        this.context.getModelListener().removeListener((ISecurityEventListener)this);
        if (this.roleSelectionManager != null) {
            this.roleSelectionManager.removeListener((ISecurityEventListener)this);
        }
    }

    private HashMap processSelection(StructuredSelection selection) {
        HashMap<SecurityConstraint, HashMap> selectionInfo = new HashMap<SecurityConstraint, HashMap>();
        for (ResourceNode node : selection) {
            if (node instanceof ResourceContainerNode) continue;
            HashMap collectionsToPattern = ((WebModuleResourceWrapper)node.getResourceWrapper()).getCollectionsToPatternsMap();
            for (Map.Entry mapEntry : collectionsToPattern.entrySet()) {
                HashMap collectionInfo;
                Object webResourceCollection = mapEntry.getKey();
                List patterns = (List)mapEntry.getValue();
                Object constraint = null;
                constraint = webResourceCollection instanceof WebResourceCollection ? ((WebResourceCollection)webResourceCollection).getSecConstraint() : ((EObject)webResourceCollection).eContainer();
                if (selectionInfo.containsKey(constraint)) {
                    collectionInfo = (HashMap)selectionInfo.get(constraint);
                    if (collectionInfo.containsKey(webResourceCollection)) {
                        List currentPatterns = (List)collectionInfo.get(webResourceCollection);
                        for (String pattern : patterns) {
                            if (currentPatterns.contains(pattern)) continue;
                            currentPatterns.add(pattern);
                        }
                        continue;
                    }
                    collectionInfo.put(webResourceCollection, patterns);
                    continue;
                }
                collectionInfo = new HashMap();
                collectionInfo.put(webResourceCollection, patterns);
                selectionInfo.put((SecurityConstraint)constraint, collectionInfo);
            }
        }
        return selectionInfo;
    }

    private void doSelections(HashMap selection) {
        ArrayList<GenericNode> selections = new ArrayList<GenericNode>();
        List constraints = this.constraintRootTreeNode.getChildren();
        for (Map.Entry mapEntry : selection.entrySet()) {
            Object selectionSecurityConstraint = mapEntry.getKey();
            HashMap collectionInfo = (HashMap)mapEntry.getValue();
            for (ConstraintTreeNode constraintNode : constraints) {
                EObject treeSecurityConstraint = constraintNode.getObjectWrapper().getEmfObject();
                if (treeSecurityConstraint != selectionSecurityConstraint) continue;
                for (Map.Entry mapEntry2 : collectionInfo.entrySet()) {
                    Object selectionWebResourceCollection = mapEntry2.getKey();
                    List selectionPatterns = (List)mapEntry2.getValue();
                    for (GenericNode constraintChild : constraintNode.getChildren()) {
                        ResourceCollectionTreeNode collectionNode;
                        EObject treeWebResourceCollection;
                        if (!(constraintChild instanceof ResourceCollectionTreeNode) || (treeWebResourceCollection = (collectionNode = (ResourceCollectionTreeNode)constraintChild).getObjectWrapper().getEmfObject()) != selectionWebResourceCollection) continue;
                        for (GenericNode collectionChild : collectionNode.getChildren()) {
                            if (!(collectionChild instanceof URLPatternTreeNode)) continue;
                            URLPatternTreeNode urlPatternChild = (URLPatternTreeNode)collectionChild;
                            for (Object pattern : selectionPatterns) {
                                String selectionPattern = null;
                                if (pattern instanceof String) {
                                    selectionPattern = (String)pattern;
                                } else if (pattern instanceof UrlPatternType) {
                                    selectionPattern = ((UrlPatternType)pattern).getValue();
                                }
                                if (!urlPatternChild.getLabel().equals(selectionPattern)) continue;
                                selections.add(collectionChild);
                            }
                        }
                    }
                }
            }
        }
        StructuredSelection newSelection = new StructuredSelection(selections.toArray());
        this.constraintsTreeViewer.setSelection((ISelection)newSelection, true);
        for (GenericNode node : selections) {
            ArrayList<GenericNode> things = new ArrayList<GenericNode>();
            while (!(node instanceof ConstraintViewerRootTreeNode)) {
                things.add(node);
                node = node.getParent();
            }
            int i = things.size() - 1;
            while (i >= 0) {
                node = (GenericNode)things.get(i);
                this.constraintsTreeViewer.setExpandedState((Object)node, true);
                --i;
            }
        }
    }

    public ISelectionChangedListener getResourceViewerSelectionChangedListener() {
        return this.resourceViewerSelectionChangedListener;
    }

    public void setContext(SecurityEditorContext context) {
        if (this.context != null) {
            this.context.getModelListener().removeListener((ISecurityEventListener)this);
        }
        this.context = context;
        this.context.getModelListener().registerListener((ISecurityEventListener)this);
    }

    public void setRoleSelectionManager(RoleSelectionManager roleSelectionManager) {
        this.roleSelectionManager = roleSelectionManager;
    }

    public void setResourcesViewer(ResourcesViewer resourcesViewer) {
        this.resourcesViewer = resourcesViewer;
    }

    public void hookListeners() {
        this.roleSelectionManager.registerListener((ISecurityEventListener)this);
        this.resourcesViewer.getResourcesTreeViewer().addSelectionChangedListener(this.getResourceViewerSelectionChangedListener());
    }

    public void setActionBarContributor(EditorActionBarContributor actionBarContributor) {
        this.actionBarContributor = actionBarContributor;
    }

    public void setUiFormat(int uiFormat) {
        this.uiFormat = uiFormat;
    }

    public String getHeaderLabel() {
        return Messages.edit_constraints_label;
    }

    public int getDefaultSashWeight() {
        return 0;
    }

    private class ResourceViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private ResourceViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            ConstraintsViewer.this.doSelections(ConstraintsViewer.this.processSelection(selection));
        }
    }
}

