/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constrain.resources;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.common.ops.ICommonOperationsContext;
import com.ibm.etools.webtools.security.base.internal.common.ops.SecurityCommonOperationsRegistry;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRoleAssociationChangedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRoleNameChangedEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityRolesChangedEvent;
import com.ibm.etools.webtools.security.base.internal.resource.providers.GenericNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceRootNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.editor.internal.GenericTreeNodeContentProvider;
import com.ibm.etools.webtools.security.editor.internal.GenericTreeNodeLabelProvider;
import com.ibm.etools.webtools.security.editor.internal.actions.AddSecurityRoleAction;
import com.ibm.etools.webtools.security.editor.internal.actions.CheckAllInCheckboxTableAction;
import com.ibm.etools.webtools.security.editor.internal.actions.UncheckAllInCheckboxTableAction;
import com.ibm.etools.webtools.security.editor.internal.constrain.resource.ConstrainResourceDialog;
import com.ibm.etools.webtools.security.editor.internal.context.SecurityEditorContext;
import com.ibm.etools.webtools.security.editor.internal.editorpart.ISecurityViewer;
import com.ibm.etools.webtools.security.editor.internal.roles.viewer.RoleTreeNode;
import com.ibm.etools.webtools.security.editor.internal.roles.viewer.RoleViewerSorter;
import com.ibm.etools.webtools.security.editor.internal.roles.viewer.menu.DeleteRoleAction;
import com.ibm.etools.webtools.security.editor.internal.roles.viewer.menu.RenameRoleAction;
import com.ibm.etools.webtools.security.editor.internal.util.SecurityEditorUtilities;
import com.ibm.etools.webtools.security.web.internal.constrain.resources.ChangeWildcardPatternAction;
import com.ibm.etools.webtools.security.web.internal.constrain.resources.ConstrainResourceRoleViewerFilter;
import com.ibm.etools.webtools.security.web.internal.constraint.viewer.ConstraintsViewer;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class WebModuleConstrainResourceDialog
extends ConstrainResourceDialog
implements ISecurityEventListener {
    private CheckboxTableViewer rolesViewer;
    private ResourceRootNode selectedResourceRoot = new ResourceRootNode(null, null);
    private ISecurityViewer advancedViewer = new ConstraintsViewer();
    private Composite advancedComposite = null;
    IPreferenceStore preferenceStore = SecurityBasePlugin.getDefault().getPreferenceStore();
    private SecurityEditorContext context;
    private DeleteRoleAction deleteAction = null;
    private Button advancedButton = null;
    private Button editPatternButton = null;
    private boolean advancedShowing = false;
    private String advancedLabel = String.valueOf(Messages.advanced_label) + " >>>";
    private String basicLabel = "<<< " + Messages.basic_label;
    private String basicDialogHeader = Messages.select_roles_label;
    private List resources;
    private Composite rolesComposite;
    private Menu rolesMenu = null;
    private MenuItem newSecurityRole = null;
    private MenuItem selectAll = null;
    private MenuItem selectNone = null;
    private MenuItem delete = null;
    private MenuItem rename = null;
    Composite fill;
    CompoundCommand undoableCommand = new CompoundCommand(Messages.assign_role_command_label);

    public WebModuleConstrainResourceDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.context = SecurityEditorContext.getContextForProject((IProject)project, (Object)((Object)this));
        this.context.getModelListener().registerListener((ISecurityEventListener)this);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.basicDialogHeader);
        this.fill = this.createFillParent(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fill, "com.ibm.etools.webtools.security.web.wtsec0120");
        this.createRolesArea(this.fill);
        if (this.advancedViewer != null) {
            this.advancedComposite = this.advancedViewer.createViewerComposite(this.fill);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(0, 0);
            formData.right = new FormAttachment(0, 0);
            this.advancedComposite.setLayoutData((Object)formData);
        }
        this.primData();
        SecurityEditorUtilities.checkAndPromptForNewRole((SecurityEditorContext)this.context);
        return this.fill;
    }

    private Composite createFillParent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        this.advancedViewer.setUiFormat(1);
        this.advancedViewer.setContext(this.context);
        this.advancedButton = new Button(composite, 8);
        this.advancedButton.setText(this.advancedLabel);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        this.advancedButton.setLayoutData((Object)formData);
        this.advancedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebModuleConstrainResourceDialog.this.handleAdvancedButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private void createRolesArea(Composite parent) {
        this.rolesComposite = new Composite(parent, 0);
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.height = 350;
        formData.width = 350;
        formData.bottom = new FormAttachment((Control)this.advancedButton, -5);
        this.rolesComposite.setLayoutData((Object)formData);
        FormLayout layout = new FormLayout();
        this.rolesComposite.setLayout((Layout)layout);
        Composite buttonBar = new Composite(this.rolesComposite, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, 0);
        buttonBar.setLayoutData((Object)formData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.pack = false;
        buttonBar.setLayout((Layout)rowLayout);
        Button newRoleButton = new Button(buttonBar, 8);
        newRoleButton.setText(Messages.new_role_button_label);
        this.editPatternButton = new Button(buttonBar, 8);
        this.editPatternButton.setText(Messages.edit_patterns_button_text);
        this.rolesViewer = CheckboxTableViewer.newCheckList((Composite)this.rolesComposite, (int)2818);
        this.rolesViewer.setLabelProvider((IBaseLabelProvider)new GenericTreeNodeLabelProvider());
        this.rolesViewer.setContentProvider((IContentProvider)new GenericTreeNodeContentProvider());
        this.rolesViewer.setSorter((ViewerSorter)new RoleViewerSorter());
        this.rolesViewer.addFilter((ViewerFilter)new ConstrainResourceRoleViewerFilter());
        formData = new FormData();
        formData.top = new FormAttachment((Control)buttonBar, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        formData.height = 300;
        formData.width = 100;
        this.rolesViewer.getControl().setLayoutData((Object)formData);
        new AddSecurityRoleAction((StructuredViewer)this.rolesViewer, (Widget)newRoleButton, (ICommonOperationsContext)this.context);
        new ChangeWildcardPatternAction((StructuredViewer)this.rolesViewer, (Widget)this.editPatternButton, (ICommonOperationsContext)this.context, this.resources);
        this.createRolesMenu(this.rolesViewer.getTable());
        this.rolesViewer.getControl().addKeyListener((KeyListener)new MyKeyListener());
        this.rolesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked()) {
                    WebModuleConstrainResourceDialog.this.ungrey(event);
                }
            }
        });
    }

    private void ungrey(CheckStateChangedEvent event) {
        this.rolesViewer.setGrayed(event.getElement(), false);
    }

    private void createRolesMenu(Table table) {
        this.rolesMenu = new Menu((Control)table);
        table.setMenu(this.rolesMenu);
        this.newSecurityRole = new MenuItem(this.rolesMenu, 8);
        this.newSecurityRole.setText(Messages.new_role_button_label);
        new AddSecurityRoleAction((StructuredViewer)this.rolesViewer, (Widget)this.newSecurityRole, (ICommonOperationsContext)this.context);
        new MenuItem(this.rolesMenu, 2);
        this.selectAll = new MenuItem(this.rolesMenu, 8);
        this.selectAll.setText(Messages.select_all_button_label);
        new CheckAllInCheckboxTableAction((StructuredViewer)this.rolesViewer, (Widget)this.selectAll, (ICommonOperationsContext)this.context);
        this.selectNone = new MenuItem(this.rolesMenu, 8);
        this.selectNone.setText(Messages.select_none_button_label);
        new UncheckAllInCheckboxTableAction((StructuredViewer)this.rolesViewer, (Widget)this.selectNone, (ICommonOperationsContext)this.context);
        new MenuItem(this.rolesMenu, 2);
        this.rename = new MenuItem(this.rolesMenu, 8);
        this.rename.setText(Messages.rename_label);
        new RenameRoleAction((StructuredViewer)this.rolesViewer, (Widget)this.rename, (ICommonOperationsContext)this.context);
        this.delete = new MenuItem(this.rolesMenu, 8);
        this.delete.setText(Messages.delete_label);
        this.deleteAction = new DeleteRoleAction((StructuredViewer)this.rolesViewer, (Widget)this.delete, (ICommonOperationsContext)this.context);
    }

    protected void handleAdvancedButtonPressed() {
        if (this.advancedShowing) {
            this.advancedShowing = false;
            this.advancedButton.setText(this.advancedLabel);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 5);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment((Control)this.advancedButton, -5);
            this.rolesComposite.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(0, 0);
            formData.right = new FormAttachment(0, 0);
            this.advancedComposite.setLayoutData((Object)formData);
            this.rolesViewer.getTable().setEnabled(true);
            this.getShell().setText(this.basicDialogHeader);
        } else {
            this.advancedShowing = true;
            this.advancedButton.setText(this.basicLabel);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(0, 0);
            formData.right = new FormAttachment(0, 0);
            this.rolesComposite.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 5);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment((Control)this.advancedButton, -5);
            this.advancedComposite.setLayoutData((Object)formData);
            this.rolesViewer.getTable().setEnabled(false);
            this.getShell().setText(this.advancedViewer.getHeaderLabel());
        }
        this.fill.layout(true);
    }

    private void primData() {
        boolean containerResourceSelected = false;
        for (ResourceNode node : this.resources) {
            if (node.getResourceWrapper().isContainer()) {
                containerResourceSelected = true;
            }
            if (node.getURLPatterns().size() > 1) {
                containerResourceSelected = true;
            }
            node.registerListener((ISecurityEventListener)this);
        }
        if (!containerResourceSelected) {
            this.editPatternButton.setEnabled(false);
        }
        this.refreshResourcesList();
        this.rolesViewer.setInput((Object)this.context.getSecurityRolesRoot());
        this.context.getSecurityRolesRoot().registerListener((ISecurityEventListener)this);
        this.advancedViewer.primData();
        this.initRoleSelections();
    }

    private void initRoleSelections() {
        List roles = this.context.getSecurityRolesRoot().getChildren();
        for (RoleTreeNode roleNode : roles) {
            String roleName = roleNode.getLabel();
            boolean all = true;
            boolean some = false;
            for (ResourceNode resource : this.resources) {
                List assignedRoles = resource.getResourceWrapper().getRoles();
                if (assignedRoles.contains(roleName)) {
                    some = true;
                    continue;
                }
                all = false;
            }
            if (all) {
                this.rolesViewer.setChecked((Object)roleNode, true);
                continue;
            }
            if (some) {
                this.rolesViewer.setGrayed((Object)roleNode, true);
                this.rolesViewer.setChecked((Object)roleNode, true);
                continue;
            }
            this.rolesViewer.setChecked((Object)roleNode, false);
        }
    }

    private void refreshResourcesList() {
        for (ResourceNode resource : this.resources) {
            this.selectedResourceRoot.addChild((GenericNode)resource);
        }
    }

    public boolean close() {
        boolean returnValue = super.close();
        for (ResourceNode node : this.resources) {
            node.removeListener((ISecurityEventListener)this);
        }
        this.context.getSecurityRolesRoot().removeListener((ISecurityEventListener)this);
        this.context.getModelListener().removeListener((ISecurityEventListener)this);
        this.context.releaseContext((Object)this);
        this.advancedViewer.dispose();
        return returnValue;
    }

    public void handleSecurityEvent(AbstractSecurityEvent event) {
        if (event instanceof SecurityRoleAssociationChangedEvent) {
            this.initRoleSelections();
        }
        this.refreshRoleViewerInput(event);
    }

    private void refreshRoleViewerInput(AbstractSecurityEvent event) {
        if (event instanceof SecurityRolesChangedEvent || event instanceof SecurityRoleAssociationChangedEvent) {
            this.rolesViewer.refresh();
        } else if (event instanceof SecurityRoleNameChangedEvent) {
            String[] properties = new String[]{"label"};
            this.rolesViewer.update(event.getSource(), properties);
        }
    }

    private void handleDeleteKeyPressed() {
        if (this.delete.isEnabled()) {
            this.deleteAction.run();
        }
    }

    public void setResources(List resources) {
        this.resources = resources;
        this.resetEditedURLPatterns();
    }

    protected void okPressed() {
        HashMap<SecurityResourceWrapper, List> existingAccesses = new HashMap<SecurityResourceWrapper, List>();
        for (ResourceNode resourceNode : this.selectedResourceRoot.getChildren()) {
            SecurityResourceWrapper resourceWrapper = resourceNode.getResourceWrapper();
            if (!resourceWrapper.canBeConstrained()) continue;
            List existingAccess = SecurityCommonOperationsRegistry.getCommonOperationsForProject((IProject)this.context.getProject()).getRolesHavingAccessToResource((ICommonOperationsContext)this.context, resourceWrapper);
            existingAccesses.put(resourceWrapper, existingAccess);
        }
        List<Object> checkedElements = Arrays.asList(this.rolesViewer.getCheckedElements());
        List<Object> greyElements = Arrays.asList(this.rolesViewer.getGrayedElements());
        for (RoleTreeNode roleTreeNode : this.context.getSecurityRolesRoot().getChildren()) {
            if (!roleTreeNode.isAssignable() || greyElements.contains(roleTreeNode)) continue;
            EObject securityRole = roleTreeNode.getObjectWrapper().getEmfObject();
            boolean selected = checkedElements.contains(roleTreeNode);
            for (Map.Entry mapEntry : existingAccesses.entrySet()) {
                SecurityResourceWrapper resourceWrapper = (SecurityResourceWrapper)mapEntry.getKey();
                List accesses = (List)mapEntry.getValue();
                if (accesses == null) continue;
                if (selected) {
                    if (accesses.contains(securityRole)) continue;
                    SecurityCommonOperationsRegistry.getCommonOperationsForProject((IProject)this.context.getProject()).assignRole((ICommonOperationsContext)this.context, resourceWrapper, (Object)securityRole, this.undoableCommand);
                    continue;
                }
                if (!accesses.contains(securityRole)) continue;
                SecurityCommonOperationsRegistry.getCommonOperationsForProject((IProject)this.context.getProject()).unassignRole((ICommonOperationsContext)this.context, resourceWrapper, (Object)securityRole, this.context.getAllResourcesRoot(), this.undoableCommand);
            }
        }
        this.resetEditedURLPatterns();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.resetEditedURLPatterns();
        super.cancelPressed();
    }

    private void resetEditedURLPatterns() {
        for (ResourceNode resourceNode : this.resources) {
            WebModuleResourceWrapper wrapper = (WebModuleResourceWrapper)resourceNode.getResourceWrapper();
            wrapper.setEditedURLPatterns(null);
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127) {
                WebModuleConstrainResourceDialog.this.handleDeleteKeyPressed();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

