/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.constrain.resources;

import com.ibm.etools.webtools.flatui.SnappyTableViewer;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.web.internal.constrain.resources.PatternCellModifier;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EditWildcardPatternsDialog
extends TrayDialog {
    private Table resourceTable;
    private TableViewer resourcesViewer;
    private Table patternTable;
    private SnappyTableViewer patternsViewer;
    private Button newPatternButton;
    private Button editPatternButton;
    private Button deletePatternButton;
    private List nodeWrappers;
    private HashMap nodeToPatterns = new HashMap();
    private List currentPatterns;

    public EditWildcardPatternsDialog(Shell parentShell, List nodeWrappers) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.nodeWrappers = nodeWrappers;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(Messages.edit_patterns_dialog_title);
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)new GridData(1808));
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        Composite viewerContainer = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        viewerContainer.setLayout((Layout)fillLayout);
        this.resourceTable = new Table(viewerContainer, 2052);
        this.resourcesViewer = new TableViewer(this.resourceTable);
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.resourcesViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.resourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                ResourceNode node = (ResourceNode)ss.getFirstElement();
                if (EditWildcardPatternsDialog.this.nodeToPatterns.containsKey(node)) {
                    EditWildcardPatternsDialog.this.currentPatterns = (List)EditWildcardPatternsDialog.this.nodeToPatterns.get(node);
                } else {
                    EditWildcardPatternsDialog.this.currentPatterns = ((WebModuleResourceWrapper)node.getResourceWrapper()).getEditedURLPatterns();
                    if (EditWildcardPatternsDialog.this.currentPatterns == null) {
                        EditWildcardPatternsDialog.this.currentPatterns = new ArrayList(node.getResourceWrapper().getURLPatterns());
                    }
                    EditWildcardPatternsDialog.this.nodeToPatterns.put(node, EditWildcardPatternsDialog.this.currentPatterns);
                }
                EditWildcardPatternsDialog.this.patternsViewer.setInput((Object)EditWildcardPatternsDialog.this.currentPatterns);
                ((PatternCellModifier)EditWildcardPatternsDialog.this.patternsViewer.getCellModifier()).setValues(EditWildcardPatternsDialog.this.currentPatterns);
                EditWildcardPatternsDialog.this.newPatternButton.setEnabled(true);
            }
        });
        this.patternsViewer = new SnappyTableViewer(viewerContainer);
        this.patternTable = this.patternsViewer.getTable();
        this.patternsViewer.setLabelProvider((IBaseLabelProvider)new PatternsLabelProvider());
        this.patternsViewer.setContentProvider((IContentProvider)new PatternsContentProvider());
        TableColumn column = new TableColumn(this.patternTable, 0x1000000, 0);
        column.setWidth(146);
        this.patternsViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.patternTable)});
        this.patternsViewer.setCellModifier((ICellModifier)new PatternCellModifier(this.patternsViewer));
        this.patternsViewer.setColumnProperties(new String[]{"name"});
        this.patternsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                if (!ss.isEmpty()) {
                    EditWildcardPatternsDialog.this.deletePatternButton.setEnabled(true);
                    EditWildcardPatternsDialog.this.editPatternButton.setEnabled(true);
                } else {
                    EditWildcardPatternsDialog.this.deletePatternButton.setEnabled(false);
                    EditWildcardPatternsDialog.this.editPatternButton.setEnabled(false);
                }
            }
        });
        Composite buttonBar = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.pack = false;
        buttonBar.setLayout((Layout)rowLayout);
        this.newPatternButton = new Button(buttonBar, 8);
        this.newPatternButton.setText(Messages.new_pattern_label);
        this.newPatternButton.setEnabled(false);
        this.newPatternButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditWildcardPatternsDialog.this.currentPatterns.add(Messages.new_pattern_label);
                EditWildcardPatternsDialog.this.patternsViewer.setInput((Object)EditWildcardPatternsDialog.this.currentPatterns);
                ((EditWildcardPatternsDialog)EditWildcardPatternsDialog.this).patternsViewer.fTableViewerImpl.editElement((Object)Messages.new_pattern_label, 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editPatternButton = new Button(buttonBar, 8);
        this.editPatternButton.setText(Messages.edit_pattern_label);
        this.editPatternButton.setEnabled(false);
        this.editPatternButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection ss = (StructuredSelection)EditWildcardPatternsDialog.this.patternsViewer.getSelection();
                String item = (String)ss.getFirstElement();
                ((EditWildcardPatternsDialog)EditWildcardPatternsDialog.this).patternsViewer.fTableViewerImpl.editElement((Object)item, 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deletePatternButton = new Button(buttonBar, 8);
        this.deletePatternButton.setText(Messages.delete_pattern_label);
        this.deletePatternButton.setEnabled(false);
        this.deletePatternButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection ss = (StructuredSelection)EditWildcardPatternsDialog.this.patternsViewer.getSelection();
                for (String element : ss) {
                    EditWildcardPatternsDialog.this.currentPatterns.remove(element);
                }
                EditWildcardPatternsDialog.this.patternsViewer.setInput((Object)EditWildcardPatternsDialog.this.currentPatterns);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment((Control)buttonBar, -5);
        formData.width = 300;
        formData.height = 200;
        viewerContainer.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        buttonBar.setLayoutData((Object)formData);
        this.primData();
        return parent;
    }

    protected void okPressed() {
        for (ResourceNode node : this.nodeWrappers) {
            if (!this.nodeToPatterns.containsKey(node)) continue;
            WebModuleResourceWrapper wrapper = (WebModuleResourceWrapper)node.getResourceWrapper();
            wrapper.setEditedURLPatterns((List)this.nodeToPatterns.get(node));
        }
        super.okPressed();
    }

    private void primData() {
        ArrayList<ResourceNode> theData = new ArrayList<ResourceNode>();
        for (ResourceNode node : this.nodeWrappers) {
            if (node.getResourceWrapper().isContainer()) {
                theData.add(node);
                continue;
            }
            if (node.getURLPatterns().size() <= 1) continue;
            theData.add(node);
        }
        this.resourcesViewer.setInput(theData);
    }

    private class PatternsContentProvider
    implements ITreeContentProvider {
        private PatternsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PatternsLabelProvider
    implements ILabelProvider {
        private PatternsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return (String)element;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return property.equals("label");
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ResourceContentProvider
    implements ITreeContentProvider {
        private ResourceContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ResourceLabelProvider
    implements ILabelProvider {
        private ResourceLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ResourceNode) {
                return ((ResourceNode)element).getLabel();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

