/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.web.internal.api;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.SecurityConstants;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.web.internal.Logger;
import com.ibm.etools.webtools.security.web.internal.nls.Messages;
import com.ibm.etools.webtools.security.web.internal.util.SecurityWebUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.TransportGuaranteeType;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.javaee.web.WebResourceCollection;

public class ApiClass {
    public static final Object addRoleCommand(final IModelProvider model, EditingDomain editDomain, final String roleName, final String desc) {
        Runnable result = null;
        if (ApiClass.isStringParmOK(roleName) && ApiClass.isParmNotNull(model)) {
            boolean found = false;
            Object modelObject = model.getModelObject();
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                EList roles = webApp.getSecurityRoles();
                for (SecurityRole role : roles) {
                    if (!role.getRoleName().equals(roleName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    SecurityRole role = CommonFactory.eINSTANCE.createSecurityRole();
                    role.setRoleName(roleName);
                    if (desc != null) {
                        if (webApp.getJ2EEVersionID() >= 14) {
                            Description description = CommonFactory.eINSTANCE.createDescription();
                            description.setValue(desc);
                            role.getDescriptions().add((Object)description);
                        } else {
                            role.setDescription(desc);
                        }
                    }
                    if (ApiClass.isParmNotNull(editDomain)) {
                        result = AddCommand.create((EditingDomain)editDomain, (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_SecurityRoles(), (Object)role);
                        ((AddCommand)result).setLabel(Messages.create_new_security_role_command_label);
                    }
                }
            } else if (modelObject instanceof WebApp) {
                WebApp webApp = (WebApp)modelObject;
                List roles = webApp.getSecurityRoles();
                for (org.eclipse.jst.javaee.core.SecurityRole role : roles) {
                    if (!role.getRoleName().equals(roleName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    result = new Runnable(){

                        @Override
                        public void run() {
                            WebApp webApp = (WebApp)model.getModelObject();
                            org.eclipse.jst.javaee.core.SecurityRole securityRole = JavaeeFactory.eINSTANCE.createSecurityRole();
                            securityRole.setRoleName(roleName);
                            if (desc != null) {
                                org.eclipse.jst.javaee.core.Description description = JavaeeFactory.eINSTANCE.createDescription();
                                description.setValue(desc);
                                securityRole.getDescriptions().add(description);
                                List roles = webApp.getSecurityRoles();
                                roles.add(securityRole);
                            }
                        }
                    };
                }
            }
        }
        return result;
    }

    public static final boolean renameSecurityRole(IModelProvider modelProvider, EditingDomain editDomain, Object role, String newName) {
        boolean result = false;
        Object action = ApiClass.renameSecurityRoleCommand(modelProvider, editDomain, role, newName);
        if (action != null) {
            if (action instanceof Command && ApiClass.isParmNotNull(editDomain)) {
                editDomain.getCommandStack().execute((Command)action);
                result = true;
            } else if (action instanceof Runnable) {
                modelProvider.modify((Runnable)action, null);
                result = true;
            }
        }
        return result;
    }

    public static final Object renameSecurityRoleCommand(IModelProvider model, EditingDomain editDomain, Object role, String newName) {
        Object modelObject;
        CompoundCommand result = null;
        if (ApiClass.isStringParmOK(newName) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(role) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            String oldRoleName = ((SecurityRole)role).getRoleName();
            result = new CompoundCommand(Messages.rename_role_command_label);
            Command command = SetCommand.create((EditingDomain)editDomain, (Object)role, (Object)CommonPackage.eINSTANCE.getSecurityRole_RoleName(), (Object)newName);
            result.append(command);
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            EList servlets = webApp.getServlets();
            int j = 0;
            while (j < servlets.size()) {
                String roleName;
                Identity identity;
                Servlet servlet = (Servlet)servlets.get(j);
                EList roleRefs = servlet.getSecurityRoleRefs();
                int k = 0;
                while (k < roleRefs.size()) {
                    SecurityRoleRef roleRef = (SecurityRoleRef)roleRefs.get(k);
                    if (oldRoleName.equals(roleRef.getLink())) {
                        command = SetCommand.create((EditingDomain)editDomain, (Object)roleRef, (Object)CommonPackage.eINSTANCE.getSecurityRoleRef_Link(), (Object)newName);
                        result.append(command);
                    }
                    ++k;
                }
                RunAsSpecifiedIdentity runAs = servlet.getRunAs();
                if (runAs != null && (identity = runAs.getIdentity()) != null && oldRoleName.equals(roleName = identity.getRoleName())) {
                    command = SetCommand.create((EditingDomain)editDomain, (Object)identity, (Object)CommonPackage.eINSTANCE.getIdentity_RoleName(), (Object)newName);
                    result.append(command);
                }
                ++j;
            }
            EList constraints = webApp.getConstraints();
            int j2 = 0;
            while (j2 < constraints.size()) {
                SecurityConstraint sc = (SecurityConstraint)constraints.get(j2);
                AuthConstraint ac = sc.getAuthConstraint();
                if (ac != null) {
                    EList roles = ac.getRoles();
                    int k = 0;
                    while (k < roles.size()) {
                        String roleName = (String)roles.get(k);
                        if (oldRoleName.equals(roleName)) {
                            result.append((Command)ApiClass.removeRoleFromConstraintCommand(editDomain, sc, oldRoleName));
                            result.append((Command)ApiClass.addRoleToConstraintCommand(model, editDomain, sc, newName, new Boolean(false)));
                        }
                        ++k;
                    }
                }
                ++j2;
            }
        }
        return result;
    }

    public static final Command addConstraintCommand(IModelProvider model, EditingDomain editDomain, String constraintName) {
        Object modelObject;
        Command result = null;
        if (ApiClass.isStringParmOK(constraintName) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(editDomain) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            boolean found = false;
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            EList constraints = webApp.getConstraints();
            for (SecurityConstraint constraint : constraints) {
                if (webApp.getJ2EEVersionID() >= 14) {
                    DisplayName displayName = (DisplayName)constraint.getDisplayNames().get(0);
                    if (!displayName.getValue().equals(constraintName)) continue;
                    found = true;
                    continue;
                }
                if (!constraint.getDisplayName().equals(constraintName)) continue;
                found = true;
            }
            if (!found) {
                SecurityConstraint constraint = WebapplicationFactory.eINSTANCE.createSecurityConstraint();
                if (webApp.getJ2EEVersionID() >= 14) {
                    DisplayName displayName = CommonFactory.eINSTANCE.createDisplayName();
                    displayName.setValue(constraintName);
                    constraint.getDisplayNames().add((Object)displayName);
                } else {
                    constraint.setDisplayName(constraintName);
                }
                result = AddCommand.create((EditingDomain)editDomain, (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_Constraints(), (Object)constraint);
                ((AddCommand)result).setLabel(Messages.create_new_security_constraint_command_label);
            }
        }
        return result;
    }

    public static final boolean renameConstraint(IModelProvider model, EditingDomain editDomain, Object constraint, String newName) {
        boolean result = false;
        Command command = ApiClass.renameConstraintCommand(model, editDomain, constraint, newName);
        if (command != null) {
            editDomain.getCommandStack().execute(command);
            result = true;
        }
        return result;
    }

    public static final Command renameConstraintCommand(IModelProvider model, EditingDomain editDomain, Object constraint, String newName) {
        CompoundCommand result = null;
        Object modelObject = model.getModelObject();
        if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            if (ApiClass.isStringParmOK(newName) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(editDomain) && ApiClass.isParmNotNull(constraint)) {
                result = new CompoundCommand(Messages.rename_security_constraint_command_label);
                if (webApp.getJ2EEVersionID() >= 14) {
                    EList currentDisplayNames = ((SecurityConstraint)constraint).getDisplayNames();
                    for (DisplayName displayName : currentDisplayNames) {
                        result.append(RemoveCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_DisplayNames(), (Object)displayName));
                    }
                    DisplayName displayName = CommonFactory.eINSTANCE.createDisplayName();
                    displayName.setValue(newName);
                    result.append(AddCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_DisplayNames(), (Object)displayName));
                } else {
                    result.append(SetCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_DisplayName(), (Object)newName));
                }
            }
        }
        return result;
    }

    public static final boolean renameCollection(EditingDomain editDomain, Object collection, String newName) {
        boolean result = false;
        Command command = ApiClass.renameCollectionCommand(editDomain, collection, newName);
        if (command != null) {
            editDomain.getCommandStack().execute(command);
            result = true;
        }
        return result;
    }

    public static final Command renameCollectionCommand(EditingDomain editDomain, Object collection, String newName) {
        CompoundCommand result = null;
        if (ApiClass.isStringParmOK(newName) && ApiClass.isParmNotNull(editDomain) && ApiClass.isParmNotNull(collection)) {
            result = new CompoundCommand(Messages.rename_resource_collection_command_label);
            if (collection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
                result.append(SetCommand.create((EditingDomain)editDomain, (Object)collection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_WebResourceName(), (Object)newName));
            }
        }
        return result;
    }

    public static final Command addAuthConstraintToConstraintCommand(IModelProvider model, EditingDomain editDomain, Object constraint, String desc) {
        Object modelObject;
        Command result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(editDomain) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp && ((SecurityConstraint)constraint).getAuthConstraint() == null) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            AuthConstraint authConstraint = WebapplicationFactory.eINSTANCE.createAuthConstraint();
            if (webApp.getJ2EEVersionID() >= 14) {
                Description description = CommonFactory.eINSTANCE.createDescription();
                description.setValue(desc);
                authConstraint.getDescriptions().add((Object)description);
            } else {
                authConstraint.setDescription(desc);
            }
            result = SetCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_AuthConstraint(), (Object)authConstraint);
            ((SetCommand)result).setLabel(Messages.create_new_auth_constaint_command_label);
        }
        return result;
    }

    public static final Object addRoleToConstraintCommand(IModelProvider model, EditingDomain editDomain, final Object constraint, final String roleName, Boolean roleMustExist) {
        Object result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isStringParmOK(roleName) && ApiClass.isParmNotNull(model)) {
            boolean found = false;
            if (constraint instanceof SecurityConstraint) {
                AuthConstraint authConstraint = ((SecurityConstraint)constraint).getAuthConstraint();
                if (authConstraint != null) {
                    EList roles = authConstraint.getRoles();
                    for (String element : roles) {
                        if (!element.equals(roleName)) continue;
                        found = true;
                    }
                }
                if (!found) {
                    boolean roleFound = true;
                    if (roleMustExist.booleanValue()) {
                        boolean bl = roleFound = ApiClass.getRoleNamed(model, roleName) != null;
                    }
                    if (roleFound) {
                        if (authConstraint == null) {
                            result = new CompoundCommand(Messages.add_role_to_constraint_command_label);
                            Command command = ApiClass.addAuthConstraintToConstraintCommand(model, editDomain, constraint, Messages.auto_generated_auth_constraint_description);
                            result.append(command);
                            authConstraint = (AuthConstraint)((SetCommand)command).getValue();
                        }
                        if (authConstraint != null) {
                            if (result == null) {
                                result = new CompoundCommand(Messages.add_role_to_constraint_command_label);
                            }
                            result.append(AddCommand.create((EditingDomain)editDomain, (Object)authConstraint, (Object)WebapplicationPackage.eINSTANCE.getAuthConstraint_Roles(), (Object)roleName));
                        } else {
                            Logger.log(4, "Auth Constraint expected and null found");
                        }
                    }
                }
            } else if (constraint instanceof org.eclipse.jst.javaee.web.SecurityConstraint) {
                org.eclipse.jst.javaee.web.AuthConstraint authConstraint = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint();
                if (authConstraint != null) {
                    List roles = authConstraint.getRoleNames();
                    for (String element : roles) {
                        if (!element.equals(roleName)) continue;
                        found = true;
                    }
                }
                if (!found) {
                    boolean roleFound = true;
                    if (roleMustExist.booleanValue()) {
                        boolean bl = roleFound = ApiClass.getRoleNamed(model, roleName) != null;
                    }
                    if (roleFound) {
                        result = new Runnable(){

                            @Override
                            public void run() {
                                org.eclipse.jst.javaee.web.AuthConstraint authConstraint = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint();
                                if (authConstraint == null) {
                                    authConstraint = WebFactory.eINSTANCE.createAuthConstraint();
                                    org.eclipse.jst.javaee.core.Description description = JavaeeFactory.eINSTANCE.createDescription();
                                    description.setValue(Messages.auto_generated_auth_constraint_description);
                                    authConstraint.getDescriptions().add(description);
                                    ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).setAuthConstraint(authConstraint);
                                }
                                authConstraint.getRoleNames().add(roleName);
                            }
                        };
                    }
                }
            }
        }
        return result;
    }

    public static final Command addRolesToConstraintCommand(IModelProvider model, EditingDomain editDomain, Object constraint, List roles) {
        Object modelObject;
        CompoundCommand result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isParmNotNull(roles) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(editDomain) && !roles.isEmpty() && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            ArrayList<String> roleNames = new ArrayList<String>();
            for (SecurityRole role : roles) {
                roleNames.add(role.getRoleName());
            }
            AuthConstraint authConstraint = ((SecurityConstraint)constraint).getAuthConstraint();
            if (authConstraint != null) {
                EList existingRoles = authConstraint.getRoles();
                for (String roleName : existingRoles) {
                    if (!roleNames.contains(roleName)) continue;
                    roleNames.remove(roleName);
                }
                if (roleNames.isEmpty()) {
                    return null;
                }
            } else {
                result = new CompoundCommand(Messages.add_role_to_constraint_command_label);
                Command command = ApiClass.addAuthConstraintToConstraintCommand(model, editDomain, constraint, Messages.auto_generated_auth_constraint_description);
                result.append(command);
                authConstraint = (AuthConstraint)((SetCommand)command).getValue();
            }
            if (authConstraint != null) {
                for (String roleName : roleNames) {
                    Command command = AddCommand.create((EditingDomain)editDomain, (Object)authConstraint, (Object)WebapplicationPackage.eINSTANCE.getAuthConstraint_Roles(), (Object)roleName);
                    if (command == null) {
                        Logger.log(4, "Null command generated");
                        return null;
                    }
                    result.append(command);
                }
            } else {
                Logger.log(4, "Auth Constraint expected and null found");
            }
        }
        return result;
    }

    public static final Object removeRoleFromConstraintCommand(EditingDomain editDomain, final Object constraint, final String roleName) {
        Runnable result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isStringParmOK(roleName)) {
            if (constraint instanceof SecurityConstraint) {
                boolean found = false;
                AuthConstraint authConstraint = ((SecurityConstraint)constraint).getAuthConstraint();
                if (authConstraint != null) {
                    EList roles = authConstraint.getRoles();
                    for (String element : roles) {
                        if (!element.equals(roleName)) continue;
                        found = true;
                    }
                }
                if (found && ApiClass.isParmNotNull(editDomain)) {
                    result = RemoveCommand.create((EditingDomain)editDomain, (Object)authConstraint, (Object)WebapplicationPackage.eINSTANCE.getAuthConstraint_Roles(), (Object)roleName);
                    ((RemoveCommand)result).setLabel(Messages.remove_role_from_constraint_command_label);
                }
            } else if (constraint instanceof org.eclipse.jst.javaee.web.SecurityConstraint) {
                boolean found = false;
                org.eclipse.jst.javaee.web.AuthConstraint authConstraint = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint();
                if (authConstraint != null) {
                    List roles = authConstraint.getRoleNames();
                    for (String element : roles) {
                        if (!element.equals(roleName)) continue;
                        found = true;
                    }
                }
                if (found) {
                    result = new Runnable(){

                        @Override
                        public void run() {
                            List roles;
                            org.eclipse.jst.javaee.web.AuthConstraint authConstraint = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint();
                            if (authConstraint != null && (roles = authConstraint.getRoleNames()) != null) {
                                roles.remove(roleName);
                            }
                        }
                    };
                }
            }
        }
        return result;
    }

    public static final Command addUpdateUserDataConstraintToConstraintCommand(IModelProvider model, EditingDomain editDomain, Object constraint, String transport, String desc) {
        Object modelObject;
        CompoundCommand result = new CompoundCommand();
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(editDomain) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            UserDataConstraint userDataConstraint = ((SecurityConstraint)constraint).getUserDataConstraint();
            if (userDataConstraint != null) {
                result.append(ApiClass.removeUserDataConstraintToConstraintCommand(model, editDomain, constraint));
            }
            userDataConstraint = WebapplicationFactory.eINSTANCE.createUserDataConstraint();
            TransportGuaranteeType transportGuarantee = TransportGuaranteeType.getByName((String)transport);
            userDataConstraint.setTransportGuarantee(transportGuarantee);
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            if (webApp.getJ2EEVersionID() >= 14) {
                Description description = CommonFactory.eINSTANCE.createDescription();
                description.setValue(desc);
                userDataConstraint.getDescriptions().add((Object)description);
            } else {
                userDataConstraint.setDescription(desc);
            }
            Command setCommand = SetCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_UserDataConstraint(), (Object)userDataConstraint);
            ((SetCommand)setCommand).setLabel(Messages.user_data_constraint_command_lable);
            result.append(setCommand);
        }
        return result;
    }

    public static final Command removeUserDataConstraintToConstraintCommand(IModelProvider model, EditingDomain editDomain, Object constraint) {
        UserDataConstraint userDataConstraint;
        Object modelObject;
        Command result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(editDomain) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp && (userDataConstraint = ((SecurityConstraint)constraint).getUserDataConstraint()) != null) {
            result = SetCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_UserDataConstraint(), null);
            ((SetCommand)result).setLabel(Messages.user_data_constraint_remove_command_lable);
        }
        return result;
    }

    public static final Command addResourceCollectionCommand(Object constraint, IModelProvider model, EditingDomain editDomain, String resourceCollectionName, String description) {
        Object modelObject;
        Command result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isStringParmOK(resourceCollectionName) && ApiClass.isParmNotNull(editDomain) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            boolean found = false;
            EList collections = ((SecurityConstraint)constraint).getWebResourceCollections();
            for (org.eclipse.jst.j2ee.webapplication.WebResourceCollection collection : collections) {
                if (!collection.getWebResourceName().equals(resourceCollectionName)) continue;
                found = true;
            }
            if (!found) {
                org.eclipse.jst.j2ee.webapplication.WebResourceCollection resourceCollection = WebapplicationFactory.eINSTANCE.createWebResourceCollection();
                resourceCollection.setWebResourceName(resourceCollectionName);
                if (description != null && !description.equals("")) {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                    if (webApp.getJ2EEVersionID() >= 14) {
                        Description descript = CommonFactory.eINSTANCE.createDescription();
                        descript.setValue(description);
                        resourceCollection.getDescriptions().add((Object)descript);
                    } else {
                        resourceCollection.setDescription(description);
                    }
                }
                ArrayList<org.eclipse.jst.j2ee.webapplication.WebResourceCollection> collectionsList = new ArrayList<org.eclipse.jst.j2ee.webapplication.WebResourceCollection>();
                collectionsList.add(resourceCollection);
                result = AddCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_WebResourceCollections(), (Object)resourceCollection);
                ((AddCommand)result).setLabel(Messages.create_new_resource_collection_command_label);
            }
        }
        return result;
    }

    public static final Object addURLPatternCommand(final Object webResourceCollection, EditingDomain editDomain, final String pattern) {
        Runnable result = null;
        if (ApiClass.isParmNotNull(webResourceCollection) && ApiClass.isStringParmOK(pattern)) {
            boolean found = false;
            if (webResourceCollection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
                EList urlMethods = ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)webResourceCollection).getUrlPattern();
                Iterator iter = urlMethods.iterator();
                while (iter.hasNext()) {
                    if (!((String)iter.next()).equals(pattern)) continue;
                    found = true;
                    break;
                }
                if (!found && ApiClass.isParmNotNull(editDomain)) {
                    result = AddCommand.create((EditingDomain)editDomain, (Object)webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_UrlPattern(), (Object)pattern);
                    ((AddCommand)result).setLabel(Messages.add_url_pattern_to_collection_command_label);
                }
            } else if (webResourceCollection instanceof WebResourceCollection) {
                List urlMethods = ((WebResourceCollection)webResourceCollection).getUrlPatterns();
                for (UrlPatternType urlPatternType : urlMethods) {
                    if (!urlPatternType.getValue().equals(pattern)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    result = new Runnable(){

                        @Override
                        public void run() {
                            UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
                            urlPatternType.setValue(pattern);
                            List urlPatterns = ((WebResourceCollection)webResourceCollection).getUrlPatterns();
                            urlPatterns.add(urlPatternType);
                        }
                    };
                }
            }
        }
        return result;
    }

    public static final boolean renameURLPattern(Object webResourceCollection, EditingDomain editDomain, String currentPattern, String newPattern) {
        boolean result = false;
        Command command = ApiClass.renameURLPatternCommand(webResourceCollection, editDomain, currentPattern, newPattern);
        if (command != null) {
            editDomain.getCommandStack().execute(command);
            result = true;
        }
        return result;
    }

    public static final Command renameURLPatternCommand(Object webResourceCollection, EditingDomain editDomain, String currentPattern, String newPattern) {
        CompoundCommand result = new CompoundCommand(Messages.change_url_pattern_command_label);
        if (ApiClass.isParmNotNull(webResourceCollection) && ApiClass.isParmNotNull(editDomain) && ApiClass.isStringParmOK(currentPattern) && ApiClass.isStringParmOK(newPattern) && webResourceCollection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
            boolean found = false;
            EList urlMethods = ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)webResourceCollection).getUrlPattern();
            String resourcePattern = null;
            Iterator iter = urlMethods.iterator();
            while (iter.hasNext() && !found) {
                resourcePattern = (String)iter.next();
                if (!resourcePattern.equals(currentPattern)) continue;
                found = true;
                result.append(RemoveCommand.create((EditingDomain)editDomain, (Object)webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_UrlPattern(), (Object)resourcePattern));
            }
            if (found) {
                result.append(AddCommand.create((EditingDomain)editDomain, (Object)webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_UrlPattern(), (Object)newPattern));
            }
        }
        return result;
    }

    public static final Command addHTTPMethodCommand(Object webResourceCollection, EditingDomain editDomain, String httpMethod) {
        Command result = null;
        List<String> validHttpMethods = Arrays.asList(SecurityConstants.HTTP_METHODS);
        if (validHttpMethods.contains(httpMethod) && ApiClass.isParmNotNull(webResourceCollection) && ApiClass.isParmNotNull(editDomain) && webResourceCollection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
            boolean found = false;
            EList httpMethods = ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)webResourceCollection).getHttpMethod();
            HTTPMethodTypeEnum httpMethodType = null;
            Iterator iter = httpMethods.iterator();
            while (iter.hasNext() && !found) {
                httpMethodType = (HTTPMethodTypeEnum)iter.next();
                if (!httpMethodType.getName().equals(httpMethod)) continue;
                found = true;
            }
            if (!found) {
                EAttribute feature = WebapplicationPackage.eINSTANCE.getWebResourceCollection_HttpMethod();
                EEnum enumerator = (EEnum)feature.getEType();
                Enumerator instance = enumerator.getEEnumLiteral(httpMethod).getInstance();
                result = AddCommand.create((EditingDomain)editDomain, (Object)webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_HttpMethod(), (Object)instance);
                ((AddCommand)result).setLabel(Messages.add_HTTP_method_to_collection_command_label);
            }
        }
        return result;
    }

    public static final Object removeRoleCommand(final IModelProvider model, EditingDomain editDomain, final String roleName) {
        Runnable result = null;
        if (ApiClass.isStringParmOK(roleName) && ApiClass.isParmNotNull(model)) {
            Object modelObject = model.getModelObject();
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                boolean found = false;
                SecurityRole role = null;
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                EList roles = webApp.getSecurityRoles();
                Iterator iter = roles.iterator();
                while (iter.hasNext() && !found) {
                    role = (SecurityRole)iter.next();
                    if (!role.getRoleName().equals(roleName)) continue;
                    found = true;
                }
                if (found && role != null && ApiClass.isParmNotNull(editDomain)) {
                    CompoundCommand cc = new CompoundCommand(Messages.delete_security_role_command_label);
                    cc.append(RemoveCommand.create((EditingDomain)editDomain, (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_SecurityRoles(), (Object)role));
                    EList servlets = webApp.getServlets();
                    int j = 0;
                    while (j < servlets.size()) {
                        String identityRoleName;
                        Identity identity;
                        Servlet servlet = (Servlet)servlets.get(j);
                        EList roleRefs = servlet.getSecurityRoleRefs();
                        int k = 0;
                        while (k < roleRefs.size()) {
                            SecurityRoleRef roleRef = (SecurityRoleRef)roleRefs.get(k);
                            if (roleName.equals(roleRef.getLink())) {
                                cc.append(RemoveCommand.create((EditingDomain)editDomain, (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_SecurityRoleRefs(), (Object)roleRef));
                            }
                            ++k;
                        }
                        RunAsSpecifiedIdentity runAs = servlet.getRunAs();
                        if (runAs != null && (identity = runAs.getIdentity()) != null && roleName.equals(identityRoleName = identity.getRoleName())) {
                            cc.append(SetCommand.create((EditingDomain)editDomain, (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_RunAs(), null));
                        }
                        ++j;
                    }
                    EList constraints = webApp.getConstraints();
                    int j2 = 0;
                    while (j2 < constraints.size()) {
                        SecurityConstraint sc = (SecurityConstraint)constraints.get(j2);
                        AuthConstraint ac = sc.getAuthConstraint();
                        if (ac != null) {
                            EList constraintRoles = ac.getRoles();
                            for (String constraintRolename : constraintRoles) {
                                if (!constraintRolename.equals(roleName)) continue;
                                if (constraintRoles.size() == 1) {
                                    cc.append(ApiClass.removeConstraintCommand(model, editDomain, sc));
                                    continue;
                                }
                                cc.append((Command)ApiClass.removeRoleFromConstraintCommand(editDomain, sc, roleName));
                            }
                        }
                        ++j2;
                    }
                    if (!cc.isEmpty()) {
                        result = cc;
                    }
                }
            } else if (modelObject instanceof WebApp) {
                result = new Runnable(){

                    @Override
                    public void run() {
                        org.eclipse.jst.javaee.core.SecurityRole role = null;
                        WebApp webApp = (WebApp)model.getModelObject();
                        List roles = webApp.getSecurityRoles();
                        Iterator iter = roles.iterator();
                        while (iter.hasNext()) {
                            role = (org.eclipse.jst.javaee.core.SecurityRole)iter.next();
                            if (!role.getRoleName().equals(roleName)) continue;
                            iter.remove();
                            break;
                        }
                        List servlets = webApp.getServlets();
                        int j = 0;
                        while (j < servlets.size()) {
                            String identityRoleName;
                            org.eclipse.jst.javaee.web.Servlet servlet = (org.eclipse.jst.javaee.web.Servlet)servlets.get(j);
                            List roleRefs = servlet.getSecurityRoleRefs();
                            Iterator roleRefIter = roleRefs.iterator();
                            while (roleRefIter.hasNext()) {
                                org.eclipse.jst.javaee.core.SecurityRoleRef roleRef = (org.eclipse.jst.javaee.core.SecurityRoleRef)roleRefIter.next();
                                if (!roleName.equals(roleRef.getRoleLink())) continue;
                                roleRefIter.remove();
                            }
                            RunAs runAs = servlet.getRunAs();
                            if (runAs != null && roleName.equals(identityRoleName = runAs.getRoleName())) {
                                servlet.setRunAs(null);
                            }
                            ++j;
                        }
                        List constraints = webApp.getSecurityConstraints();
                        Iterator constraintIter = constraints.iterator();
                        while (constraintIter.hasNext()) {
                            org.eclipse.jst.javaee.web.SecurityConstraint sc = (org.eclipse.jst.javaee.web.SecurityConstraint)constraintIter.next();
                            org.eclipse.jst.javaee.web.AuthConstraint ac = sc.getAuthConstraint();
                            if (ac == null) continue;
                            List constraintRoles = ac.getRoleNames();
                            Iterator iter2 = constraintRoles.iterator();
                            while (iter2.hasNext()) {
                                String constraintRolename = (String)iter2.next();
                                if (!constraintRolename.equals(roleName)) continue;
                                if (constraintRoles.size() == 1) {
                                    constraintIter.remove();
                                    continue;
                                }
                                iter2.remove();
                            }
                        }
                    }
                };
            }
        }
        return result;
    }

    public static final Command removeConstraintCommand(IModelProvider model, EditingDomain editDomain, Object constraint) {
        org.eclipse.jst.j2ee.webapplication.WebApp webApp;
        EList constraints;
        Object modelObject;
        Command result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(editDomain) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp && (constraints = (webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject).getConstraints()).contains(constraint)) {
            result = RemoveCommand.create((EditingDomain)editDomain, (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_Constraints(), (Object)constraint);
            ((RemoveCommand)result).setLabel(Messages.delete_security_constraint_command_label);
        }
        return result;
    }

    public static final Command removeResourceCollectionCommand(Object constraint, EditingDomain editDomain, Object webResourceCollection) {
        EList collections;
        Command result = null;
        if (ApiClass.isParmNotNull(constraint) && ApiClass.isParmNotNull(webResourceCollection) && ApiClass.isParmNotNull(editDomain) && constraint instanceof SecurityConstraint && (collections = ((SecurityConstraint)constraint).getWebResourceCollections()).contains(webResourceCollection)) {
            result = RemoveCommand.create((EditingDomain)editDomain, (Object)constraint, (Object)WebapplicationPackage.eINSTANCE.getSecurityConstraint_WebResourceCollections(), (Object)webResourceCollection);
            ((RemoveCommand)result).setLabel(Messages.delete_collection_command_label);
        }
        return result;
    }

    public static final Command removeURLPatternCommand(Object webResourceCollection, EditingDomain editDomain, String pattern) {
        Command result = null;
        if (ApiClass.isParmNotNull(webResourceCollection) && ApiClass.isParmNotNull(editDomain) && ApiClass.isStringParmOK(pattern) && webResourceCollection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
            boolean found = false;
            EList httpMethods = ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)webResourceCollection).getUrlPattern();
            String resourcePattern = null;
            Iterator iter = httpMethods.iterator();
            while (iter.hasNext() && !found) {
                resourcePattern = (String)iter.next();
                if (!resourcePattern.equals(pattern)) continue;
                found = true;
            }
            if (found) {
                result = RemoveCommand.create((EditingDomain)editDomain, (Object)webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_UrlPattern(), (Object)pattern);
                ((RemoveCommand)result).setLabel(Messages.delete_URL_pattern_from_collection_command_label);
            }
        }
        return result;
    }

    public static final Command removeHTTPMethodCommand(Object webResourceCollection, EditingDomain editDomain, String httpMethod) {
        Command result = null;
        List<String> validHttpMethods = Arrays.asList(SecurityConstants.HTTP_METHODS);
        if (validHttpMethods.contains(httpMethod) && ApiClass.isParmNotNull(webResourceCollection) && ApiClass.isParmNotNull(editDomain) && webResourceCollection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
            boolean found = false;
            EList httpMethods = ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)webResourceCollection).getHttpMethod();
            HTTPMethodTypeEnum httpMethodType = null;
            Iterator iter = httpMethods.iterator();
            while (iter.hasNext() && !found) {
                httpMethodType = (HTTPMethodTypeEnum)iter.next();
                if (!httpMethodType.getName().equals(httpMethod)) continue;
                found = true;
            }
            if (found) {
                result = RemoveCommand.create((EditingDomain)editDomain, (Object)webResourceCollection, (Object)WebapplicationPackage.eINSTANCE.getWebResourceCollection_HttpMethod(), (Object)httpMethodType);
                ((RemoveCommand)result).setLabel(Messages.delete_HTTP_method_from_collection_command_label);
            }
        }
        return result;
    }

    public static final List getRoles(IModelProvider webModel) {
        List roles = Collections.EMPTY_LIST;
        if (webModel != null) {
            Object modelObject = webModel.getModelObject();
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                roles = webApp.getSecurityRoles();
            } else {
                WebApp webApp = (WebApp)modelObject;
                roles = webApp.getSecurityRoles();
            }
        }
        if (roles == null) {
            roles = Collections.EMPTY_LIST;
        }
        return roles;
    }

    public static final Object getRoleNamed(IModelProvider webModel, String roleName) {
        List roles = ApiClass.getRoles(webModel);
        for (Object next : roles) {
            SecurityRole role;
            if (!(next instanceof SecurityRole ? (role = (SecurityRole)next).getRoleName().equals(roleName) : next instanceof org.eclipse.jst.javaee.core.SecurityRole && (role = (org.eclipse.jst.javaee.core.SecurityRole)next).getRoleName().equals(roleName))) continue;
            return role;
        }
        return null;
    }

    public static final List getRolesFor(Object constraint) {
        org.eclipse.jst.javaee.web.AuthConstraint authConstriant;
        if (constraint instanceof SecurityConstraint) {
            AuthConstraint authConstriant2 = ((SecurityConstraint)constraint).getAuthConstraint();
            if (authConstriant2 != null) {
                return ((SecurityConstraint)constraint).getAuthConstraint().getRoles();
            }
        } else if (constraint instanceof org.eclipse.jst.javaee.web.SecurityConstraint && (authConstriant = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint()) != null) {
            return ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint().getRoleNames();
        }
        return Collections.EMPTY_LIST;
    }

    public static final List getConstraints(IModelProvider webModel) {
        Object constraints = null;
        Object modelObject = webModel.getModelObject();
        if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            constraints = webApp.getConstraints();
        } else {
            WebApp webApp = (WebApp)modelObject;
            constraints = webApp.getSecurityConstraints();
        }
        if (constraints == null) {
            constraints = Collections.EMPTY_LIST;
        }
        return constraints;
    }

    public static final Object getConstraintNamed(String constraintName, IModelProvider webModel) {
        Object modelObject = webModel.getModelObject();
        List constraints = ApiClass.getConstraints(webModel);
        for (Object constraint : constraints) {
            int j2EEVersion;
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                j2EEVersion = webApp.getJ2EEVersionID();
            } else {
                j2EEVersion = -1;
            }
            if (!SecurityWebUtilities.getDisplayName(constraint, j2EEVersion).equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public static final List getResourceCollections(Object constraint) {
        List collections = Collections.EMPTY_LIST;
        if (ApiClass.isParmNotNull(constraint)) {
            collections = constraint instanceof SecurityConstraint ? ((SecurityConstraint)constraint).getWebResourceCollections() : ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getWebResourceCollections();
        }
        if (collections == null) {
            collections = Collections.EMPTY_LIST;
        }
        return collections;
    }

    public static final Object getResourceCollectionNamed(String webResourcecollectionName, Object constraint) {
        List collections = ApiClass.getResourceCollections(constraint);
        for (Object collection : collections) {
            if (!(collection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection ? ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)collection).getWebResourceName().equals(webResourcecollectionName) : collection instanceof WebResourceCollection && ((WebResourceCollection)collection).getWebResourceName().equals(webResourcecollectionName))) continue;
            return collection;
        }
        return null;
    }

    public static final List getHTTPMethods(Object webResourceCollection) {
        List httpMethods = Collections.EMPTY_LIST;
        if (ApiClass.isParmNotNull(webResourceCollection)) {
            if (webResourceCollection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
                httpMethods = ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)webResourceCollection).getHttpMethod();
            } else if (webResourceCollection instanceof WebResourceCollection) {
                httpMethods = ((WebResourceCollection)webResourceCollection).getHttpMethods();
            }
        }
        if (httpMethods == null) {
            httpMethods = Collections.EMPTY_LIST;
        }
        return httpMethods;
    }

    public static final List getURLPatterns(Object webResourceCollection) {
        List urlPatterns = Collections.EMPTY_LIST;
        if (ApiClass.isParmNotNull(webResourceCollection)) {
            if (webResourceCollection instanceof org.eclipse.jst.j2ee.webapplication.WebResourceCollection) {
                urlPatterns = ((org.eclipse.jst.j2ee.webapplication.WebResourceCollection)webResourceCollection).getUrlPattern();
            } else if (webResourceCollection instanceof WebResourceCollection) {
                urlPatterns = ((WebResourceCollection)webResourceCollection).getUrlPatterns();
            }
        }
        if (urlPatterns == null) {
            urlPatterns = Collections.EMPTY_LIST;
        }
        return urlPatterns;
    }

    public static final List getConstraintsForRole(IModelProvider webModel, Object securityRole) {
        ArrayList<Object> result;
        block4: {
            result = new ArrayList<Object>();
            if (!ApiClass.isParmNotNull(webModel) || !ApiClass.isParmNotNull(securityRole)) break block4;
            Object modelObject = webModel.getModelObject();
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                EList constraints = webApp.getConstraints();
                for (SecurityConstraint constraint : constraints) {
                    EList roles;
                    AuthConstraint authConstraint = constraint.getAuthConstraint();
                    if (authConstraint == null || !(roles = authConstraint.getRoles()).contains(((SecurityRole)securityRole).getRoleName())) continue;
                    result.add(constraint);
                }
            } else {
                WebApp webApp = (WebApp)modelObject;
                List constraints = webApp.getSecurityConstraints();
                for (org.eclipse.jst.javaee.web.SecurityConstraint constraint : constraints) {
                    List roles;
                    org.eclipse.jst.javaee.web.AuthConstraint authConstraint = constraint.getAuthConstraint();
                    if (authConstraint == null || !(roles = authConstraint.getRoleNames()).contains(((org.eclipse.jst.javaee.core.SecurityRole)securityRole).getRoleName())) continue;
                    result.add(constraint);
                }
            }
        }
        return result;
    }

    public static final List getConstraintsForSingleRole(IModelProvider webModel, Object securityRole) {
        ArrayList<Object> result;
        block4: {
            result = new ArrayList<Object>();
            if (!ApiClass.isParmNotNull(webModel) || !ApiClass.isParmNotNull(securityRole)) break block4;
            Object modelObject = webModel.getModelObject();
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                EList constraints = webApp.getConstraints();
                for (SecurityConstraint constraint : constraints) {
                    EList roles;
                    AuthConstraint authConstraint = constraint.getAuthConstraint();
                    if (authConstraint == null || (roles = authConstraint.getRoles()).size() != 1 || !roles.contains(((SecurityRole)securityRole).getRoleName())) continue;
                    result.add(constraint);
                }
            } else {
                WebApp webApp = (WebApp)modelObject;
                List constraints = webApp.getSecurityConstraints();
                for (org.eclipse.jst.javaee.web.SecurityConstraint constraint : constraints) {
                    List roles;
                    org.eclipse.jst.javaee.web.AuthConstraint authConstraint = constraint.getAuthConstraint();
                    if (authConstraint == null || (roles = authConstraint.getRoleNames()).size() != 1 || !roles.contains(((org.eclipse.jst.javaee.core.SecurityRole)securityRole).getRoleName())) continue;
                    result.add(constraint);
                }
            }
        }
        return result;
    }

    public static final List getRolesHavingAccessToResource(IModelProvider webModel, SecurityResourceWrapper resourceWrapper) {
        ArrayList validRoles = new ArrayList();
        List roles = ApiClass.getRoles(webModel);
        Iterator roleIter = roles.iterator();
        while (roleIter.hasNext()) {
            boolean roleHasAccess = false;
            Object nextRole = roleIter.next();
            List constraints = ApiClass.getConstraintsForRole(webModel, nextRole);
            Iterator constraintIter = constraints.iterator();
            while (constraintIter.hasNext() && !roleHasAccess) {
                Object nextConstraint = constraintIter.next();
                List collections = ApiClass.getResourceCollections(nextConstraint);
                Iterator collectionsIter = collections.iterator();
                while (collectionsIter.hasNext() && !roleHasAccess) {
                    Object nextCollection = collectionsIter.next();
                    List patterns = ApiClass.getURLPatterns(nextCollection);
                    Iterator patternsIter = patterns.iterator();
                    while (patternsIter.hasNext() && !roleHasAccess) {
                        Object nextPattern = patternsIter.next();
                        roleHasAccess = SecurityUtilities.patternMatch((IProject)JavaEEProjectUtilities.getProject((Object)webModel.getModelObject()), nextPattern, (SecurityResourceWrapper)resourceWrapper);
                        if (!roleHasAccess) continue;
                        validRoles.add(nextRole);
                    }
                }
            }
        }
        return validRoles;
    }

    public static final Object findDefaultConstraintForRole(IModelProvider webModel, Object securityRole) {
        IPreferenceStore preferenceStore = SecurityBasePlugin.getDefault().getPreferenceStore();
        List constraintsForRole = ApiClass.getConstraintsForRole(webModel, securityRole);
        for (Object constraint : constraintsForRole) {
            List collections;
            List currentRoles;
            org.eclipse.jst.javaee.web.AuthConstraint authConstraint;
            List httpMethods;
            org.eclipse.jst.j2ee.webapplication.WebResourceCollection collection;
            ArrayList<String> methodNames = new ArrayList<String>();
            if (constraint instanceof SecurityConstraint) {
                List collections2;
                EList currentRoles2;
                AuthConstraint authConstraint2 = ((SecurityConstraint)constraint).getAuthConstraint();
                if (authConstraint2 != null && (currentRoles2 = authConstraint2.getRoles()).size() == 1 && (collections2 = ApiClass.getResourceCollections(constraint)).size() == 1) {
                    collection = (org.eclipse.jst.j2ee.webapplication.WebResourceCollection)collections2.get(0);
                    httpMethods = ApiClass.getHTTPMethods(collection);
                    for (HTTPMethodTypeEnum httpMethodType : httpMethods) {
                        methodNames.add(httpMethodType.getName());
                    }
                }
            } else if (constraint instanceof org.eclipse.jst.javaee.web.SecurityConstraint && (authConstraint = ((org.eclipse.jst.javaee.web.SecurityConstraint)constraint).getAuthConstraint()) != null && (currentRoles = authConstraint.getRoleNames()).size() == 1 && (collections = ApiClass.getResourceCollections(constraint)).size() == 1) {
                collection = (WebResourceCollection)collections.get(0);
                httpMethods = ApiClass.getHTTPMethods(collection);
                Iterator iter2 = httpMethods.iterator();
                while (iter2.hasNext()) {
                    methodNames.add((String)iter2.next());
                }
            }
            boolean found = true;
            int i = 0;
            while (i < SecurityConstants.HTTP_METHODS.length && found) {
                boolean defaultSelection = preferenceStore.getBoolean(SecurityConstants.HTTP_METHODS[i]);
                if (defaultSelection && !methodNames.contains(SecurityConstants.HTTP_METHODS[i])) {
                    found = false;
                } else if (!defaultSelection && methodNames.contains(SecurityConstants.HTTP_METHODS[i])) {
                    found = false;
                }
                ++i;
            }
            if (!found) continue;
            return constraint;
        }
        return null;
    }

    public static final Object createDefaultConstraintForRoleCommand(IModelProvider model, EditingDomain editDomain, Object role, String urlPattern) {
        IPreferenceStore preferenceStore = SecurityBasePlugin.getDefault().getPreferenceStore();
        CompoundCommand result = new CompoundCommand(Messages.create_default_constraint_command_label);
        Object modelObject = model.getModelObject();
        if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            String roleName = ((SecurityRole)role).getRoleName();
            Command newConstraintCommand = ApiClass.addConstraintCommand(model, editDomain, String.valueOf(roleName) + Messages.constraint_label);
            int counter = 0;
            while (newConstraintCommand == null && counter < 100) {
                String constraintName = String.valueOf(roleName) + Messages.constraint_label + ++counter;
                newConstraintCommand = ApiClass.addConstraintCommand(model, editDomain, constraintName);
            }
            result.append(newConstraintCommand);
            SecurityConstraint constraint = (SecurityConstraint)((AddCommand)newConstraintCommand).getCollection().iterator().next();
            result.append((Command)ApiClass.addRoleToConstraintCommand(model, editDomain, constraint, roleName, new Boolean(false)));
            Command newCollectionCommand = ApiClass.addResourceCollectionCommand(constraint, model, editDomain, String.valueOf(roleName) + "Collection", "");
            result.append(newCollectionCommand);
            org.eclipse.jst.j2ee.webapplication.WebResourceCollection collection = (org.eclipse.jst.j2ee.webapplication.WebResourceCollection)((AddCommand)newCollectionCommand).getCollection().iterator().next();
            int i = 0;
            while (i < SecurityConstants.HTTP_METHODS.length) {
                String methodName = SecurityConstants.HTTP_METHODS[i];
                boolean selected = preferenceStore.getBoolean(methodName);
                if (selected) {
                    result.append(ApiClass.addHTTPMethodCommand(collection, editDomain, methodName));
                }
                ++i;
            }
            result.append((Command)ApiClass.addURLPatternCommand(collection, editDomain, urlPattern));
        }
        return result;
    }

    public static Object removeRoleReferenceCommand(EditingDomain editingDomain, final Object roleRef) {
        if (roleRef instanceof SecurityRoleRef && ApiClass.isParmNotNull(editingDomain)) {
            return RemoveCommand.create((EditingDomain)editingDomain, (Object)((SecurityRoleRef)roleRef).eContainer(), (Object)WebapplicationPackage.eINSTANCE.getServlet_SecurityRoleRefs(), (Object)roleRef);
        }
        if (roleRef instanceof org.eclipse.jst.javaee.core.SecurityRoleRef) {
            return new Runnable(){

                @Override
                public void run() {
                    List roleRefs;
                    org.eclipse.jst.javaee.web.Servlet servlet = (org.eclipse.jst.javaee.web.Servlet)((EObject)roleRef).eContainer();
                    if (servlet != null && (roleRefs = servlet.getSecurityRoleRefs()) != null) {
                        roleRefs.remove(roleRef);
                    }
                }
            };
        }
        return null;
    }

    public static Object removeRunAsCommand(EditingDomain editingDomain, final Object runas) {
        if (runas instanceof RunAsSpecifiedIdentity && ApiClass.isParmNotNull(editingDomain)) {
            return SetCommand.create((EditingDomain)editingDomain, (Object)((RunAsSpecifiedIdentity)runas).eContainer(), (Object)WebapplicationPackage.eINSTANCE.getServlet_RunAs(), null);
        }
        if (runas instanceof RunAs) {
            return new Runnable(){

                @Override
                public void run() {
                    org.eclipse.jst.javaee.web.Servlet servlet = (org.eclipse.jst.javaee.web.Servlet)((EObject)runas).eContainer();
                    if (servlet != null) {
                        servlet.setRunAs(null);
                    }
                }
            };
        }
        return null;
    }

    public static String getUserDataConstraintDescription(IModelProvider model, String constraintName) {
        UserDataConstraint userDataConstraint;
        Object constraint;
        Object modelObject;
        if (ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(constraintName) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp && (constraint = ApiClass.getConstraintNamed(constraintName, model)) != null && (userDataConstraint = ((SecurityConstraint)constraint).getUserDataConstraint()) != null) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            if (webApp.getJ2EEVersionID() >= 14) {
                return ((Description)userDataConstraint.getDescriptions().get(0)).getValue();
            }
            return userDataConstraint.getDescription();
        }
        return null;
    }

    public static String getUserDataConstraintTransportGuarantee(IModelProvider model, String constraintName) {
        UserDataConstraint userDataConstraint;
        Object constraint;
        Object modelObject;
        if (ApiClass.isParmNotNull(model) && ApiClass.isParmNotNull(constraintName) && (modelObject = model.getModelObject()) instanceof org.eclipse.jst.j2ee.webapplication.WebApp && (constraint = ApiClass.getConstraintNamed(constraintName, model)) != null && (userDataConstraint = ((SecurityConstraint)constraint).getUserDataConstraint()) != null) {
            return userDataConstraint.getTransportGuarantee().getLiteral();
        }
        return null;
    }

    private static final boolean isStringParmOK(String parameter) {
        return parameter != null && !parameter.equals("");
    }

    private static final boolean isParmNotNull(Object parm) {
        return parm != null;
    }
}

