/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.resource.providers;

import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import com.ibm.etools.webtools.security.base.internal.resource.providers.IContextListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.model.IModelProvider;

public abstract class ModelListener {
    protected List<ISecurityEventListener> listeners = new ArrayList<ISecurityEventListener>();
    protected List<ISecurityEventListener> weakListeners = new ArrayList<ISecurityEventListener>();
    protected List<IContextListener> contextListeners = new ArrayList<IContextListener>();
    protected IModelProvider modelProvider;
    protected HashMap adapterMap = new HashMap();
    private boolean isDisposed = false;

    public ModelListener(IModelProvider modelProvider) {
        this.modelProvider = modelProvider;
        this.registerAdapters();
    }

    public abstract void registerAdapters();

    protected void unregisterAdapter(EObject eObject) {
        Adapter adapter = (Adapter)this.adapterMap.get(eObject);
        eObject.eAdapters().remove((Object)adapter);
        this.adapterMap.remove(eObject);
    }

    protected void regisiterAdapter(EObject eObject, Adapter adapter) {
        this.adapterMap.put(eObject, adapter);
    }

    public void registerListener(ISecurityEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void registerWeakListener(ISecurityEventListener listener) {
        if (!this.weakListeners.contains(listener)) {
            this.weakListeners.add(listener);
        }
    }

    public void registerListener(IContextListener listener) {
        if (!this.contextListeners.contains(listener)) {
            this.contextListeners.add(listener);
        }
    }

    public void removeListener(ISecurityEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
            this.checkForSelfRemoval();
        }
    }

    public void removeListener(IContextListener listener) {
        if (this.contextListeners.contains(listener)) {
            this.contextListeners.remove(listener);
            this.checkForSelfRemoval();
        }
    }

    private void checkForSelfRemoval() {
        if (this.listeners.isEmpty() && this.contextListeners.isEmpty()) {
            this.dispose();
            this.removeMyself();
        }
    }

    protected abstract void removeMyself();

    public void removeWeakListener(ISecurityEventListener listener) {
        if (this.weakListeners.contains(listener)) {
            this.weakListeners.remove(listener);
        }
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            for (Map.Entry mapEntry : this.adapterMap.entrySet()) {
                EObject eObject = (EObject)mapEntry.getKey();
                Adapter adapter = (Adapter)mapEntry.getValue();
                eObject.eAdapters().remove((Object)adapter);
            }
            this.listeners.clear();
            this.contextListeners.clear();
            this.weakListeners.clear();
            this.adapterMap.clear();
        }
    }

    protected void fire(AbstractSecurityEvent event) {
        ArrayList<ISecurityEventListener> tempToStopConcurencyIssues = new ArrayList<IContextListener>(this.contextListeners);
        for (ISecurityEventListener listener : tempToStopConcurencyIssues) {
            listener.handleSecurityEvent(event);
        }
        tempToStopConcurencyIssues = new ArrayList<ISecurityEventListener>(this.listeners);
        for (ISecurityEventListener listener : tempToStopConcurencyIssues) {
            listener.handleSecurityEvent(event);
        }
        tempToStopConcurencyIssues = new ArrayList<ISecurityEventListener>(this.weakListeners);
        for (ISecurityEventListener listener : tempToStopConcurencyIssues) {
            listener.handleSecurityEvent(event);
        }
    }
}

