/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal.resource.providers;

import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.ISecurityEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public abstract class GenericNode
implements ISecurityEventListener {
    private GenericNode parent = null;
    protected List<GenericNode> children = null;
    private List<ISecurityEventListener> listeners = new ArrayList<ISecurityEventListener>();
    protected Image image = null;
    protected String label = "bad label";

    public GenericNode(Image image, String label) {
        this.image = image;
        if (label != null) {
            this.label = label;
        }
    }

    public GenericNode getParent() {
        return this.parent;
    }

    public void setParent(GenericNode parent) {
        this.parent = parent;
    }

    public List<GenericNode> getChildren() {
        if (this.children == null) {
            this.generateChildren();
        }
        return this.children;
    }

    public void addChild(GenericNode child) {
        if (this.children == null || this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList<GenericNode>();
        }
        this.children.add(child);
        child.registerListener(this);
    }

    public void removeChild(GenericNode child) {
        if (this.children == null || this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList<GenericNode>();
        }
        this.children.remove(child);
        child.removeListener(this);
        child.dispose();
    }

    public void setChildren(List<GenericNode> children) {
        Iterator<GenericNode> iter = this.getGeneratedChildren().iterator();
        while (iter.hasNext()) {
            this.removeChild(iter.next());
        }
        this.children = children;
        for (GenericNode child : children) {
            child.registerListener(this);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void dispose() {
        ArrayList<GenericNode> stopConcurrentModificationProblems = new ArrayList<GenericNode>(this.getGeneratedChildren());
        Iterator iter = stopConcurrentModificationProblems.iterator();
        while (iter.hasNext()) {
            this.removeChild((GenericNode)iter.next());
        }
    }

    public void registerListener(ISecurityEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ISecurityEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void fire(AbstractSecurityEvent event) {
        ArrayList<ISecurityEventListener> listenerCopy = new ArrayList<ISecurityEventListener>(this.listeners);
        for (ISecurityEventListener listener : listenerCopy) {
            listener.handleSecurityEvent(event);
        }
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public abstract void generateChildren();

    public List<GenericNode> getGeneratedChildren() {
        if (this.children == null) {
            return new ArrayList<GenericNode>();
        }
        return this.children;
    }

    public abstract int category();

    public String getHoverHelp() {
        return null;
    }
}

