/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.security.base.internal;

import com.ibm.etools.webtools.security.base.SecurityBasePlugin;
import com.ibm.etools.webtools.security.base.internal.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class Images {
    private static ImageRegistry imageRegistry = SecurityBasePlugin.getDefault().getImageRegistry();
    private static URL installURL = SecurityBasePlugin.getDefault().getBundle().getEntry("/");

    private Images() {
    }

    public static final Image getSpecifiedImage(String imagePath) {
        return Images.getImage(imagePath);
    }

    public static final Image getExpandAllImage() {
        return Images.getImage("expandall");
    }

    public static final Image getViewMenuImage() {
        return Images.getImage("/dlcl16/view_menu");
    }

    public static final Image getCollapseAllImage() {
        return Images.getImage("collapseall");
    }

    public static final Image getSecurityProjectNavigatorImage() {
        return Images.getImage("security_role");
    }

    public static final Image getSecurityRoleReferenceImage() {
        return Images.getImage("security_role_reference");
    }

    public static final Image getSecurityIdentityImage() {
        return Images.getImage("security_identity_obj");
    }

    public static final Image getGroupImage() {
        return Images.getImage("group_obj");
    }

    public static final Image getSpecialGroupImage() {
        return Images.getImage("specialgroup");
    }

    public static final Image getFileImage() {
        return Images.getImage("file");
    }

    public static final Image getUserImage() {
        return Images.getImage("user_obj");
    }

    public static final Image getSecurityRole() {
        return Images.getImage("roles");
    }

    public static final Image getNoAssignedRoleImage() {
        return Images.getImage("rolesnot");
    }

    public static final Image getUncheckedLockImage() {
        return Images.getImage("uncheckedlock");
    }

    public static final Image getConstraintImage() {
        return Images.getImage("constraint");
    }

    public static final Image getResourceCollectionImage() {
        return Images.getImage("resourcecollection");
    }

    public static final Image getURLPatternImage() {
        return Images.getImage("urlpattern");
    }

    public static final Image getHTTPMethodImage() {
        return Images.getImage("httpmethod");
    }

    public static final Image getWebModuleImage() {
        return Images.getImage("webmodule");
    }

    public static final Image getFolderImage() {
        return Images.getImage("folder");
    }

    public static final Image getRole_objImage() {
        return Images.getImage("role_obj");
    }

    public static final Image getWebModuleResourceImage() {
        return Images.getImage("webmoduleresource");
    }

    public static ImageDescriptor getSecurityProjectNavigatorDescriptor() {
        return Images.getImageDescriptor("navigatorsecurity");
    }

    public static final ImageDescriptor getNewRoleDescriptor() {
        return Images.getImageDescriptor("newrole");
    }

    public static final ImageDescriptor getDefaultWizardDescriptor() {
        return Images.getImageDescriptor("/wizard/addwebsecurityconstraint_wiz");
    }

    public static final ImageDescriptor getRunAsDescriptor() {
        return Images.getImageDescriptor("/wizard/security_identity_wiz");
    }

    public static final ImageDescriptor getRoleWizDescriptor() {
        return Images.getImageDescriptor("/wizard/secur_role_wiz");
    }

    public static final ImageDescriptor getRoleRefWizDescriptor() {
        return Images.getImageDescriptor("/wizard/secur_role_ref_wiz");
    }

    public static final ImageDescriptor getRoleDescriptor() {
        return Images.getImageDescriptor("roles");
    }

    public static final ImageDescriptor getLockDescriptor() {
        return Images.getImageDescriptor("lock2");
    }

    public static final ImageDescriptor getCallerOvrDescriptor() {
        return Images.getImageDescriptor("caller_ovr");
    }

    public static final ImageDescriptor getUserOvrDescriptor() {
        return Images.getImageDescriptor("user_ovr");
    }

    public static final ImageDescriptor getExcludedDescriptor() {
        return Images.getImageDescriptor("excluded");
    }

    public static final ImageDescriptor getUncheckedDescriptor() {
        return Images.getImageDescriptor("uncheckedlock");
    }

    public static final ImageDescriptor getAddAuthConstraintWizardBanner() {
        return Images.getImageDescriptor("/wizard/addauthorityconstraints_wiz_");
    }

    public static final ImageDescriptor getAddWebResourceWizardBanner() {
        return Images.getImageDescriptor("/wizard/addwebrescollection_wiz_ban");
    }

    public static Image getWorkbenchImage(IAdaptable object) {
        return Images.getImage(object);
    }

    private static Image getImage(String key) {
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, Images.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    private static Image getImage(IAdaptable adapter) {
        if (adapter == null) {
            return null;
        }
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)adapter.getAdapter(IWorkbenchAdapter.class);
        if (workbenchAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = workbenchAdapter.getImageDescriptor((Object)adapter);
        if (descriptor == null) {
            return null;
        }
        String key = descriptor.toString();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, descriptor);
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = Images.primGetImageDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = Images.primGetImageDescriptor(Images.getNotFoundKeyFor(key));
        }
        return imageDescriptor;
    }

    private static ImageDescriptor primGetImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(installURL, "icons/" + key + ".gif"));
        }
        catch (MalformedURLException exception) {
            Logger.log(4, "Failed to load image for \"" + key + "\"", exception);
        }
        if (imageDescriptor == null) {
            Logger.log(4, "No image found for " + key);
        }
        return imageDescriptor;
    }

    private static String getNotFoundKeyFor(String key) {
        return "notfound_obj";
    }
}

