/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jsf.ui.internal.actions;

import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.sdo.ui.internal.data.ISDOData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.codebehind.java.PageCodeDocletSupport;
import com.ibm.etools.webtools.javamodel.api.IJavaCommand;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocElement;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.CreateImportCommand;
import com.ibm.etools.webtools.javamodel.commands.UpdateMethodCommand;
import com.ibm.etools.webtools.pagedatamodel.wizards.Util;
import com.ibm.etools.webtools.pagedataview.javabean.codebehind.wizard.AbstractJavaJSFDropCommand;
import com.ibm.etools.webtools.relationaltags.ui.wizard.CBSDOUtil;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.data.ISDODataFromService;
import com.ibm.etools.webtools.sdo.jsf.ui.internal.servicesdo.SDOFromServiceWizard;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class NewSDOFromServiceDropCommand
extends AbstractJavaJSFDropCommand {
    protected String fActionId;
    protected HTMLEditDomain fEditDomain;
    public static String ADD_SDO_REF = "Add a SDO reference";

    public NewSDOFromServiceDropCommand(HTMLEditDomain editDomain, String codeGenModelId) {
        super(editDomain, codeGenModelId);
    }

    protected void handleDrop() {
        Util.ensureBuildComplete(null, (boolean)false);
        SDOFromServiceWizard wiz = new SDOFromServiceWizard();
        IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)this.getHTMLEditDomain().getActiveModel().getDocument());
        wiz.setProject(project);
        wiz.setHTMLEditDomain(this.getHTMLEditDomain());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wiz);
        dialog.setTitle(ADD_SDO_REF);
        dialog.updateSize();
        dialog.setPageSize(100, 350);
        int rc = dialog.open();
        if (rc == 0) {
            ISDODataFromService sdoData = wiz.getSDOData();
            JavaModel javaModel = CBSDOUtil.getCBModel(this.getHTMLEditDomain().getActiveModel().getDocument());
            try {
                try {
                    NewSDOFromServiceDropCommand.updateDataGetter(sdoData, javaModel, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (javaModel != null) {
                        javaModel.release();
                    }
                }
            }
            finally {
                if (javaModel != null) {
                    javaModel.release();
                }
            }
        }
    }

    public static void updateDataGetter(ISDOData sdoData, JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        String[] importTypes = new String[]{};
        String returnType = ((ISDODataFromService)sdoData).getReturnTypeName();
        if (returnType == "DataObject") {
            importTypes = new String[]{"commonj.sdo.DataObject"};
        } else if (returnType == "List") {
            importTypes = new String[]{"java.util.List"};
        }
        int i = 0;
        while (i < importTypes.length) {
            CreateImportCommand importCmd = new CreateImportCommand();
            importCmd.setFullyQualifiedType(importTypes[i]);
            importCmd.execute(model, monitor);
            ++i;
        }
        String dataName = sdoData.getId();
        String getterName = "get" + JavaCodeUtil.capitalizeFirst((String)dataName);
        ArrayList<JavaDocElement> docletList = new ArrayList<JavaDocElement>(1);
        docletList.add(new JavaDocElement("mediatorFactory", ((ISDODataFromService)sdoData).getFactoryName()));
        StringBuffer mediatorPropBuffer = new StringBuffer("");
        mediatorPropBuffer.append("metadataFileName=" + sdoData.getTagData().getInputFile());
        String typeName = ((ISDODataFromService)sdoData).getTypeName();
        if (typeName != null) {
            mediatorPropBuffer.append(",typeName=" + typeName);
        }
        docletList.add(new JavaDocElement("mediatorProperties", mediatorPropBuffer.toString()));
        UpdateMethodCommand cmd = new UpdateMethodCommand();
        cmd.setIdentifier(getterName);
        cmd.setModifier("public");
        cmd.setParameters(new String[0]);
        cmd.setParameterNames(new String[0]);
        cmd.setReturnType(returnType);
        cmd.setForce(true);
        StringBuffer buf = new StringBuffer();
        buf.append("//TODO Auto-generated method stub\nreturn null;");
        JavaDocInfo javadoc = new JavaDocInfo(docletList, "");
        cmd.setJavadoc(javadoc);
        cmd.setContents(buf.toString());
        PageCodeDocletSupport.addDataDoclet((IJavaCommand)cmd);
        cmd.execute(model, monitor);
    }
}

