/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.relationaltags.data;

import com.ibm.etools.sdo.jdbc.ui.internal.data.FilterArgumentsManager;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import com.ibm.etools.webtools.relationaltags.ui.wizard.CBRelationalWdoDataTask;
import com.ibm.etools.webtools.relationaltags.ui.wizard.CBSDOUtil;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.FilterArgumentsManagerWeb;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CBFilterArgumentsManager
extends FilterArgumentsManagerWeb {
    public CBFilterArgumentsManager(boolean updateNow) {
        super(updateNow);
    }

    protected void initializeFilterParameters() {
        this.clearFilterParameters();
        IDOMNode tagNode = this.getNode();
        NamedNodeMap map = tagNode.getAttributes();
        Node n = map.getNamedItem("id");
        String id = n.getNodeValue();
        id = JavaTypeUtil.decapitalizePropertyName((String)id);
        JavaModel model = null;
        try {
            IDOMDocument xmldoc = (IDOMDocument)tagNode.getOwnerDocument();
            model = CBSDOUtil.getCBModel(xmldoc);
            ArrayList names = CBSDOUtil.readInitParamNameField(id, model);
            ArrayList values = CBSDOUtil.readInitParamValuesField(id, model);
            int size = names.size();
            if (size != values.size()) {
                return;
            }
            int i = 0;
            while (i < size) {
                String key = (String)names.get(i);
                String value = (String)values.get(i);
                ManagedSetParameterTag param = new ManagedSetParameterTag(id, (Node)tagNode, key, value);
                this.fVariableNameNodeMap.put(key, param);
                this.fVariableNameValueMap.put(key, value);
                ++i;
            }
        }
        finally {
            if (model != null) {
                model.release();
            }
        }
    }

    protected FilterArgumentsManager.IFilterParameter createFilterParameter(String filterVariableName, String filterValue) {
        IDOMNode tagNode = this.getNode();
        NamedNodeMap map = tagNode.getAttributes();
        Node n = map.getNamedItem("id");
        String id = n.getNodeValue();
        id = JavaTypeUtil.decapitalizePropertyName((String)id);
        ManagedSetParameterTag param = new ManagedSetParameterTag(id, (Node)tagNode, filterVariableName, filterValue);
        this.fVariableNameNodeMap.put(filterVariableName, param);
        this.fVariableNameValueMap.put(filterVariableName, filterValue);
        return param;
    }

    public class CreateFilterParametersTask
    extends AbstractJavaModelTask {
        String id;
        String keyName;
        String valueName;

        public CreateFilterParametersTask(String id, String keyName, String valueName) {
            this.id = id;
            this.keyName = keyName;
            this.valueName = valueName;
        }

        public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
            ArrayList names = CBSDOUtil.readInitParamNameField(this.id, model, monitor);
            ArrayList values = CBSDOUtil.readInitParamValuesField(this.id, model, monitor);
            names.add(this.keyName);
            values.add(this.valueName);
            CBRelationalWdoDataTask.replaceInitParamNames(this.id, names, model, monitor);
            CBRelationalWdoDataTask.replaceInitParamValues(this.id, values, model, monitor);
        }
    }

    public class DeleteFilterParametersTask
    extends AbstractJavaModelTask {
        String id;
        String keyName;
        String value;

        public DeleteFilterParametersTask(String id, String keyName, String value) {
            this.id = id;
            this.keyName = keyName;
            this.value = value;
        }

        public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
            ArrayList names = CBSDOUtil.readInitParamNameField(this.id, model, monitor);
            ArrayList values = CBSDOUtil.readInitParamValuesField(this.id, model, monitor);
            names.remove(this.keyName);
            values.remove(this.value);
            CBRelationalWdoDataTask.replaceInitParamNames(this.id, names, model, monitor);
            CBRelationalWdoDataTask.replaceInitParamValues(this.id, values, model, monitor);
        }
    }

    private class ManagedSetParameterTag
    implements FilterArgumentsManager.IFilterParameter {
        String beanID;
        Node tagNode;
        String filterVariableName;
        String filterVariableValue;

        ManagedSetParameterTag(String beanID, Node tagNode, String filterVariableName, String filterVariableValue) {
            this.beanID = beanID;
            this.filterVariableName = filterVariableName;
            this.tagNode = tagNode;
            this.filterVariableValue = filterVariableValue;
        }

        public String getFilterVariableName() {
            return this.filterVariableName;
        }

        public void setFilterVariableName(String name) {
            this.filterVariableName = name;
        }

        public String getFilterVariableValue() {
            return this.filterVariableValue;
        }

        public void setFilterVariableValue(String value) {
            this.filterVariableValue = value;
        }

        public String getId() {
            return this.beanID;
        }

        public void setId(String id) {
            this.beanID = id;
        }

        public void delete() {
        }
    }

    public class UpdateFilterNamesTask
    extends AbstractJavaModelTask {
        String id;
        String oldName;
        String newName;

        public UpdateFilterNamesTask(String id, String oldName, String newName) {
            this.id = id;
            this.oldName = oldName;
            this.newName = newName;
        }

        public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
            ArrayList names = CBSDOUtil.readInitParamNameField(this.id, model, monitor);
            int index = names.indexOf(this.oldName);
            if (index != -1) {
                names.remove(this.oldName);
                names.add(index, this.newName);
            }
            CBRelationalWdoDataTask.replaceInitParamNames(this.id, names, model, monitor);
        }
    }

    public class UpdateFilterValuesTask
    extends AbstractJavaModelTask {
        String id;
        String filterName;
        String newValue;

        public UpdateFilterValuesTask(String id, String filterName, String newValue) {
            this.id = id;
            this.filterName = filterName;
            this.newValue = newValue;
        }

        public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
            ArrayList names = CBSDOUtil.readInitParamNameField(this.id, model, monitor);
            ArrayList values = CBSDOUtil.readInitParamValuesField(this.id, model, monitor);
            int index = names.indexOf(this.filterName);
            if (index != -1) {
                values.remove(index);
                values.add(index, this.newValue);
            }
            CBRelationalWdoDataTask.replaceInitParamValues(this.id, values, model, monitor);
        }
    }
}

