/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.vct;

import com.ibm.etools.common.ui.presentation.FilteredFileSelectionDialog;
import com.ibm.etools.sdo.jdbc.ui.internal.IAttributePage;
import com.ibm.etools.sdo.jdbc.ui.internal.nls.ResourceHandler;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.sdo.ui.internal.data.ISDOData;
import com.ibm.etools.webedit.attributes.IAttributeViewFolder;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.IRelationalWebTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui.JDBCMediatorMetadataViewerFilter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.vct.RelationalFolder;
import com.ibm.etools.webtools.sdo.ui.internal.plugin.SDOWebPlugin;
import com.ibm.etools.webtools.sdo.ui.internal.util.SourceEditorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class PropertiesPage
extends DialogPage
implements IAttributePage,
Listener {
    private static final String DATA_OBJECT_LABEL = ResourceHandler.PropertiesPage_Properties_1;
    private IContributionManager fContributionManager;
    private MenuManager fInputFileMenuMgr;
    private Text fInputFileText;
    private Text fIdText;
    protected IAttributeViewFolder fAttributeViewFolder;
    protected String[] actionStrings;

    public PropertiesPage() {
        this.setActionStrings();
        this.setTitle(DATA_OBJECT_LABEL);
    }

    public PropertiesPage(String title) {
        super(title);
        this.setActionStrings();
    }

    public PropertiesPage(String title, ImageDescriptor image) {
        super(title, image);
        this.setActionStrings();
    }

    public void createControl(Composite composite) {
        Composite base = DialogUtil.createComposite((Composite)composite, (int)3);
        ((GridData)base.getLayoutData()).verticalAlignment = 1;
        DialogUtil.createLabel((Composite)base, (String)ResourceHandler.PropertiesPage_Name__2);
        this.fIdText = DialogUtil.createTextField((Composite)base);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fIdText.setLayoutData((Object)data);
        this.fIdText.setEditable(false);
        DialogUtil.createLabel((Composite)base, (String)ResourceHandler.PropertiesPage_Input_file__3);
        Composite fileComposite = DialogUtil.createComposite((Composite)base, (int)2);
        ((GridLayout)fileComposite.getLayout()).marginWidth = 0;
        data = new GridData(768);
        data.horizontalSpan = 2;
        fileComposite.setLayoutData((Object)data);
        this.fInputFileText = DialogUtil.createTextField((Composite)fileComposite);
        this.fInputFileText.setEditable(false);
        DialogUtil.createMultiMenuButton((Composite)fileComposite, (String)"", (MenuManager)this.getMenuManager());
        this.setControl((Control)base);
    }

    protected IContributionManager getContributions() {
        if (this.fContributionManager == null) {
            this.fContributionManager = new ContributionManager(){

                public void update(boolean arg0) {
                }
            };
            this.fContributionManager.add((IAction)new SelectionListenerAction(ResourceHandler.PropertiesPage_Load____7){

                public void run() {
                    PropertiesPage.this.handleFileButtonPressed(false);
                }
            });
            this.fContributionManager.add((IAction)new SelectionListenerAction(ResourceHandler.PropertiesPage_Save_As____8){

                public void run() {
                    PropertiesPage.this.handleFileButtonPressed(true);
                }
            });
        }
        return this.fContributionManager;
    }

    protected MenuManager getMenuManager() {
        this.fInputFileMenuMgr = new MenuManager("#PopupMenu");
        this.fInputFileMenuMgr.setRemoveAllWhenShown(true);
        this.fInputFileMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int i = 0;
                while (i < PropertiesPage.this.getContributions().getItems().length) {
                    ActionContributionItem contrib = (ActionContributionItem)PropertiesPage.this.getContributions().getItems()[i];
                    PropertiesPage.this.fInputFileMenuMgr.add(contrib.getAction());
                    ++i;
                }
            }
        });
        return this.fInputFileMenuMgr;
    }

    public IRelationalWebTagData getRelationalWebTagData() {
        return ((RelationalFolder)this.fAttributeViewFolder).getRelationalWebTagData();
    }

    public ISDOData getSDOData() {
        return ((RelationalFolder)this.fAttributeViewFolder).getSDOData();
    }

    public void handleEvent(Event event) {
        Widget w = event.widget;
        if (w == this.fIdText) {
            this.getSDOData().setId(this.fIdText.getText());
            this.modifyIdText();
        }
    }

    private void handleFileButtonPressed(boolean isSave) {
        SaveAsDialog dialog;
        if (isSave) {
            dialog = new SaveAsDialog(this.getShell());
            if (dialog.open() == 0) {
                IPath filePath = dialog.getResult();
                filePath = SDOWebPlugin.getWorkspace().getRoot().getFile(filePath).getLocation();
                this.fInputFileText.setText(SourceEditorUtil.getWebAppRelativePath((IPath)filePath).toString());
                this.getRelationalWebTagData().setInputFile(this.fInputFileText.getText(), isSave);
            }
        } else {
            Object[] o;
            dialog = new FilteredFileSelectionDialog(this.getShell(), ResourceHandler.PropertiesPage_ChooseInputFile_1, ResourceHandler.PropertiesPage_Choose_the_Input_File_10, new String[]{"xml"}, false);
            dialog.setInput((Object)SourceEditorUtil.resolveBaseLocationRelativeResource((IPath)Path.EMPTY).getProject());
            JDBCMediatorMetadataViewerFilter viewerFilter = new JDBCMediatorMetadataViewerFilter();
            IProject project = SourceEditorUtil.resolveBaseLocationRelativeResource((IPath)Path.EMPTY).getProject();
            dialog.addFilter((ViewerFilter)viewerFilter);
            dialog.setInput((Object)project);
            this.defaultDialogSelection((FilteredFileSelectionDialog)dialog, project);
            if (dialog.open() == 0 && (o = dialog.getResult()) != null) {
                IFile inputFile = (IFile)o[0];
                this.fInputFileText.setText(SourceEditorUtil.getWebAppRelativePath((IPath)inputFile.getLocation()).toString());
                this.getRelationalWebTagData().removeAllFilters();
                this.getRelationalWebTagData().setInputFile(this.fInputFileText.getText(), isSave);
                this.getRelationalWebTagData().createDefaultFilterValuesForFilterArguments();
            }
        }
        IStatus status = this.getRelationalWebTagData().loadMetadata();
        ((RelationalFolder)this.fAttributeViewFolder).updateStatusLine(status);
        this.getRelationalWebTagData().setFileBrowsed(true);
    }

    private void defaultDialogSelection(FilteredFileSelectionDialog dialog, IProject project) {
        IVirtualComponent comp = ComponentUtilities.findComponent((IResource)project);
        IFolder selection = null;
        IFolder folder = SourceEditorUtil.getSDOFolder((IVirtualComponent)comp);
        if (folder.exists()) {
            selection = folder;
            try {
                if (folder.members().length > 0) {
                    selection = folder.members()[0];
                }
            }
            catch (CoreException coreException) {}
        }
        dialog.setInitialSelection((Object)selection);
    }

    public void modifyIdText() {
        if (!this.getRelationalWebTagData().isFileBrowsed()) {
            String newFileName;
            IResource newResource;
            String xmlFile = this.getRelationalWebTagData().getInputFile();
            IResource resource = null;
            if (xmlFile != null) {
                resource = SourceEditorUtil.resolveWebAppRelativeResource((IPath)new Path(xmlFile));
            }
            if (!(resource != null && resource.exists() || (newResource = SourceEditorUtil.resolveWebAppRelativeResource((IPath)new Path(newFileName = SourceEditorUtil.getUniqueMetaFileFromName((String)this.getSDOData().getId(), (String)".xml")))) != null && newResource.exists())) {
                this.fInputFileText.setText(newFileName);
                this.getRelationalWebTagData().setInputFile(newFileName, true);
            }
        }
    }

    public void setAttributeViewFolder(IAttributeViewFolder attributeViewFolder) {
        this.fAttributeViewFolder = attributeViewFolder;
    }

    public void updateCustomAttributeView() {
        if (this.fIdText != null) {
            if (!this.getSDOData().getId().equals(this.fIdText.getText())) {
                this.fIdText.setText(this.getSDOData().getId());
            }
            this.fInputFileText.setText(this.getRelationalWebTagData().getInputFile());
        }
    }

    protected abstract void setActionStrings();
}

