/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IRelationalTagData;
import com.ibm.etools.sdo.ui.internal.data.ISDOData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui.FilterValuesSelectionPage;
import com.ibm.etools.webtools.sdo.ui.internal.wizards.AbstractSDODataWizard;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.FilterArgument;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

public class WrapFilterValuesPage
extends WizardPage {
    private FilterValuesSelectionPage fFilterValuesPage;

    public WrapFilterValuesPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("NLS4");
        this.fFilterValuesPage = new WrapFilterValuesSelectionPage(this.getContainer());
    }

    public WrapFilterValuesPage(String pageName, String title, String description, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(description);
        this.fFilterValuesPage = new WrapFilterValuesSelectionPage(this.getContainer());
        this.fFilterValuesPage.setCreateFilters(false);
        this.fFilterValuesPage.setCreateOrders(false);
    }

    public void createControl(Composite composite) {
        this.fFilterValuesPage.createControl(composite);
        this.setControl(this.fFilterValuesPage.getControl());
        this.fFilterValuesPage.setContainer(this.getContainer());
    }

    public ISDOData getSDOData() {
        return (ISDOData)((AbstractSDODataWizard)this.getWizard()).getRegionData();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fFilterValuesPage.setVisible(visible);
    }

    public void dispose() {
        super.dispose();
        if (this.fFilterValuesPage != null) {
            this.fFilterValuesPage.dispose();
            this.fFilterValuesPage = null;
        }
    }

    public boolean isPageComplete() {
        Metadata metadata;
        IRelationalTagData relationalTagData = this.fFilterValuesPage.getRelationalTagData();
        if (relationalTagData != null && (metadata = relationalTagData.getMetadata()) != null) {
            EList tablesList = metadata.getTables();
            HashSet<String> nameSet = new HashSet<String>();
            for (Table table : tablesList) {
                if (table.getFilter() == null) continue;
                for (FilterArgument filterArg : table.getFilter().getFilterArguments()) {
                    String argName = filterArg.getName();
                    if (argName == null || nameSet.contains(argName)) continue;
                    String argValue = relationalTagData.getFilterValue(filterArg);
                    if (argValue == null && argName.indexOf("param") == -1 && argName.indexOf("session") == -1) {
                        return false;
                    }
                    nameSet.add(argName);
                }
            }
        }
        return true;
    }

    class WrapFilterValuesSelectionPage
    extends FilterValuesSelectionPage {
        public WrapFilterValuesSelectionPage(IWizardContainer container) {
            super(container);
        }

        @Override
        public ISDOData getSDOData() {
            return WrapFilterValuesPage.this.getSDOData();
        }
    }
}

