/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui;

import com.ibm.etools.sdo.jdbc.ui.internal.ConditionsPage;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IRelationalTagData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.sdo.ui.internal.SDOUiPlugin;
import com.ibm.etools.sdo.ui.internal.data.ISDOData;
import com.ibm.etools.sdo.ui.internal.util.TableResizeListener;
import com.ibm.etools.webtools.customtag.support.common.SourceEditorUtil;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.IRelationalWebTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.nls.Messages;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui.BeanValueCellEditor;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebData;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.FilterArgument;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class FilterValuesSelectionPage
extends ConditionsPage {
    private String SECOND_COLUMN = "2";
    private String FIRST_COLUMN = "1";
    private Text fFilterText;
    private TableViewer fFilterValuesViewer;
    private ICellModifier fFilterValuesCellModifier;
    private IStructuredContentProvider fFilterValuesContentProvider;
    private ITableLabelProvider fFilterValuesLabelProvider;
    private CellEditor fSecondColumnCellEditor;
    private IWizardContainer container;

    public FilterValuesSelectionPage(IWizardContainer container) {
        super(null);
        this.container = container;
    }

    public void createControl(Composite composite) {
        Composite base = DialogUtil.createComposite((Composite)composite, (int)1);
        this.createTableComposite(base);
        this.createFilterValuesMappingComposite(base);
        this.setControl((Control)base);
    }

    private void createFilterValuesMappingComposite(Composite base) {
        DialogUtil.createLabel((Composite)base, (String)Messages.FilterValuesSelectionPage_Filter_statement__1);
        this.fFilterText = DialogUtil.createTextField((Composite)base);
        this.fFilterText.setEditable(false);
        this.fFilterValuesViewer = new TableViewer(base, 67586);
        this.fFilterValuesViewer.setUseHashlookup(true);
        this.fFilterValuesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TableColumn tc1 = new TableColumn(this.fFilterValuesViewer.getTable(), 0);
        TableColumn tc2 = new TableColumn(this.fFilterValuesViewer.getTable(), 0);
        tc1.setText(Messages.FilterValues_FilterKey);
        tc2.setText(Messages.FilterValues_FilterValue);
        TableLayout tlayout = new TableLayout();
        Table table = this.fFilterValuesViewer.getTable();
        table.setLayout((Layout)tlayout);
        table.addControlListener((ControlListener)new TableResizeListener(table, new int[]{20, 80}));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fFilterValuesViewer.setContentProvider(this.getFilterValuesContentProvider());
        this.fFilterValuesViewer.setLabelProvider(this.getFilterValuesLabelProvider());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.getSecondColumnCellEditor();
        this.fFilterValuesViewer.setCellEditors(cellEditorArray);
        this.fFilterValuesViewer.setColumnProperties(new String[]{this.FIRST_COLUMN, this.SECOND_COLUMN});
        this.fFilterValuesViewer.setCellModifier(this.getFilterValuesCellModifier());
        GridData data = new GridData(1810);
        data.heightHint = 100;
        this.fFilterValuesViewer.getTable().setLayoutData((Object)data);
    }

    public void dispose() {
        super.dispose();
        if (this.fSecondColumnCellEditor != null) {
            this.fSecondColumnCellEditor.dispose();
            this.fSecondColumnCellEditor = null;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.fTableViewer) {
            com.ibm.websphere.sdo.mediator.jdbc.metadata.Table table = (com.ibm.websphere.sdo.mediator.jdbc.metadata.Table)((StructuredSelection)event.getSelection()).getFirstElement();
            this.handleTableSelectionChanged(table);
        }
        this.updateWidgetStates();
    }

    protected void handleTableSelectionChanged(com.ibm.websphere.sdo.mediator.jdbc.metadata.Table table) {
        if (this.fFilterValuesViewer != null) {
            this.fFilterValuesViewer.setInput((Object)table);
            String filterText = "";
            if (table != null && table.getFilter() != null) {
                filterText = table.getFilter().getPredicate();
            }
            this.fFilterText.setText(filterText);
            this.fFilterValuesViewer.refresh();
        }
    }

    public IRelationalTagData getRelationalTagData() {
        return (IRelationalTagData)((SDOWebData)this.getSDOData()).getCurrentCodeGenModel().getRegion_data_contrib();
    }

    public ISDOData getSDOData() {
        return null;
    }

    protected ICellModifier getFilterValuesCellModifier() {
        if (this.fFilterValuesCellModifier == null) {
            this.fFilterValuesCellModifier = new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    boolean ret = false;
                    if (property.equals(FilterValuesSelectionPage.this.FIRST_COLUMN)) {
                        ret = false;
                    }
                    if (property.equals(FilterValuesSelectionPage.this.SECOND_COLUMN)) {
                        ret = true;
                    }
                    return ret;
                }

                public Object getValue(Object element, String property) {
                    String ret = "";
                    if (property.equals(FilterValuesSelectionPage.this.SECOND_COLUMN)) {
                        ret = FilterValuesSelectionPage.this.getRelationalTagData().getFilterValue((FilterArgument)element);
                    }
                    return ret;
                }

                public void modify(Object element, String property, Object value) {
                    if (element instanceof Item) {
                        element = ((Item)element).getData();
                    }
                    if (property.equals(FilterValuesSelectionPage.this.SECOND_COLUMN)) {
                        FilterValuesSelectionPage.this.getRelationalTagData().setFilterValue((FilterArgument)element, (String)value);
                        ((BeanValueCellEditor)FilterValuesSelectionPage.this.fSecondColumnCellEditor).setFilterArgument((FilterArgument)element);
                        if (FilterValuesSelectionPage.this.container != null) {
                            FilterValuesSelectionPage.this.container.updateButtons();
                        }
                    }
                    FilterValuesSelectionPage.this.fFilterValuesViewer.refresh();
                }
            };
        }
        return this.fFilterValuesCellModifier;
    }

    private IContentProvider getFilterValuesContentProvider() {
        if (this.fFilterValuesContentProvider == null) {
            this.fFilterValuesContentProvider = new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    com.ibm.websphere.sdo.mediator.jdbc.metadata.Table inputTable;
                    Object[] ret = new Object[]{};
                    if (inputElement instanceof com.ibm.websphere.sdo.mediator.jdbc.metadata.Table && (inputTable = (com.ibm.websphere.sdo.mediator.jdbc.metadata.Table)inputElement).getFilter() != null && inputTable.getFilter().getFilterArguments() != null) {
                        ret = inputTable.getFilter().getFilterArguments().toArray(new Object[inputTable.getFilter().getFilterArguments().size()]);
                    }
                    return ret;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
        }
        return this.fFilterValuesContentProvider;
    }

    private IBaseLabelProvider getFilterValuesLabelProvider() {
        if (this.fFilterValuesLabelProvider == null) {
            this.fFilterValuesLabelProvider = new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    Image ret = null;
                    if (columnIndex == 1) {
                        ret = SDOUiPlugin.getDefault().getImage("condition1");
                    }
                    return ret;
                }

                public String getColumnText(Object element, int columnIndex) {
                    String ret = null;
                    ret = columnIndex == 0 ? ((FilterArgument)element).getName() : FilterValuesSelectionPage.this.getRelationalTagData().getFilterValue((FilterArgument)element);
                    return ret;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }
        return this.fFilterValuesLabelProvider;
    }

    private CellEditor getSecondColumnCellEditor() {
        if (this.fSecondColumnCellEditor == null) {
            BeanValueCellEditor cellEditor = new BeanValueCellEditor((Composite)this.fFilterValuesViewer.getTable(), SourceEditorUtil.getPageDataModel(), this.fFilterValuesViewer, this.getRelationalTagData());
            cellEditor.setELValuePrefix(((IRelationalWebTagData)this.getRelationalTagData()).getELValuePrefix());
            this.fSecondColumnCellEditor = cellEditor;
        }
        return this.fSecondColumnCellEditor;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateCustomAttributeView();
        }
    }

    public void updateCustomAttributeView() {
        super.updateCustomAttributeView();
        if (this.fTableViewer != null) {
            this.handleTableSelectionChanged((com.ibm.websphere.sdo.mediator.jdbc.metadata.Table)((StructuredSelection)this.fTableViewer.getSelection()).getFirstElement());
        }
    }

    public void setContainer(IWizardContainer container2) {
        this.container = container2;
    }
}

