/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.operations;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IDataObjectTagData;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.adapters.ISDONodeAdapter;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetDescription;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters.DataObjectAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters.RelationalWdoNodeAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.DataObjectWebTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.PDDataObjectTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.operations.DataObjectOperation;
import com.ibm.etools.webtools.sdo.ui.internal.actions.HeadElementFilter;
import com.ibm.etools.webtools.sdo.ui.internal.actions.InsertVctAndTaglibCommand;
import com.ibm.etools.webtools.sdo.ui.internal.codegen.WDOCodeGenOperation;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebData;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebDataObjectData;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDDataObjectOperation
extends DataObjectOperation {
    private ISDOPageDataNode fWDOPageDataNode;
    private DataObjectWebTagData fDataObjectTagData;

    public PDDataObjectOperation(ISDOPageDataNode topLevelWdoNode, ICodeGenModel model, DropTargetDescription target, HTMLEditDomain editDomain) {
        super(editDomain);
        this.fWDOPageDataNode = topLevelWdoNode;
        this.fSDOData = this.createSDOData(topLevelWdoNode, model);
    }

    @Override
    protected void doExecutions(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.insertTag((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        this.generateCode((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        monitor.done();
    }

    @Override
    protected int getProcessCount() {
        return 2;
    }

    @Override
    protected void insertTag(IProgressMonitor monitor) {
        InsertVctAndTaglibCommand cmd = this.getCommand();
        cmd.execute();
    }

    @Override
    protected InsertVctAndTaglibCommand getCommand() {
        HeadElementFilter actionFactory = this.createActionHeadElementFilter();
        actionFactory.setDocument((Document)this.getHTMLEditDomain().getActiveModel().getDocument());
        HashMap<String, String> taglibMap = new HashMap<String, String>();
        taglibMap.put("wdo", PDDataObjectOperation.getSDOTaglibURI(this.getSDOData().getProject()));
        InsertVctAndTaglibCommand cmd = new InsertVctAndTaglibCommand("Compound Command", this.getHTMLEditDomain(), taglibMap, null, new CustomTagFactory[]{actionFactory});
        return cmd;
    }

    @Override
    protected void generateCode(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            WDOCodeGenOperation op = new WDOCodeGenOperation(this.getSDOData().getFieldsDataModel());
            op.setInsertionTargetHelper(this.getInsertionTargetHelper());
            try {
                op.run(monitor);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable ce) {
            ce.printStackTrace();
        }
    }

    @Override
    public IDataObjectTagData getDataObjectTagData() {
        if (this.fDataObjectTagData == null) {
            this.fDataObjectTagData = new PDDataObjectTagData(this.getSDOData());
            this.fDataObjectTagData.updateTagRegionData(new RelationalWdoNodeAdapter((Element)this.fWDOPageDataNode.getDOMNode()));
        }
        return this.fDataObjectTagData;
    }

    private SDOWebData createSDOData(ISDOPageDataNode topLevelWdoNode, final ICodeGenModel model) {
        SDOWebDataObjectData ret = new SDOWebDataObjectData(){

            public ICodeGenModel getFieldsDataModel() {
                return model;
            }
        };
        ret.setId(topLevelWdoNode.getName());
        ret.setGenerateDefaultUI(true);
        ret.setDestinationFolder(topLevelWdoNode.getPageDataModel().getResource().getParent());
        model.addCustomProperty((Object)"mediator", (Object)((ISDONodeAdapter)topLevelWdoNode.getAdapter(ISDONodeAdapter.class)).getMediator());
        model.addCustomProperty((Object)"dataObject", (Object)((ISDONodeAdapter)topLevelWdoNode.getAdapter(ISDONodeAdapter.class)).getId());
        return ret;
    }

    @Override
    protected boolean isAutoGenerateKey() {
        DataObjectAdapter adapter = (DataObjectAdapter)this.fWDOPageDataNode.getAdapter(DataObjectAdapter.class);
        return adapter.getUniqueKeyTable() != null;
    }
}

