/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.migration;

import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.sdo.ui.internal.util.SDOFacetUtil;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.feature.JDBCMediatorFacetUtil;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.migration.JDBCMediatorFacetRuntimeChangedDelegate;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.migration.SDOJarMigrator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SDOWebProjectFeaturesMigrator
extends AbstractMigration {
    public static final String FACETS_METADATA_FILE = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    private static final String LIB_PATH = "/WEB-INF/";

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> filesList = new ArrayList<IFile>();
        IFile facetsMetaDataFile = project.getFile(FACETS_METADATA_FILE);
        filesList.add(facetsMetaDataFile);
        IFile classpath = project.getFile(".classpath");
        filesList.add(classpath);
        IFile sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "lib/sdo_access_beans_6.1.0.jar");
        if (sdoJar != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        if ((sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "lib/sdo_web.jar")) != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        if ((sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "lib/sdo_access_beans.jar")) != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        if ((sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "lib/sdo_web_6.1.0.jar")) != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        if ((sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "jdbcmediator.jar")) != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        if ((sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "lib/sdo_access_beans_p5.1.0.jar")) != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        if ((sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "lib/sdo_web_p5.1.0.jar")) != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        if ((sdoJar = SDOWebProjectFeaturesMigrator.getTargetFile(project, "lib/wdo_factories.properties")) != null && sdoJar.exists()) {
            filesList.add(sdoJar);
        }
        return filesList;
    }

    public static IFile getTargetFile(IProject project, String jarName) {
        IVirtualComponent module = ComponentCore.createComponent((IProject)project);
        Object rootFolder = null;
        rootFolder = module != null ? module.getRootFolder().getUnderlyingFolder() : project.getFolder("WebContent");
        if (rootFolder != null && rootFolder.exists()) {
            IFolder libFolder = rootFolder.getFolder((IPath)new Path(LIB_PATH));
            return libFolder.getFile(jarName);
        }
        return null;
    }

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            if (!SDOFacetUtil.isFacetDefinedOnProject((IProject)project, (String)"web.sdo.jdbc")) {
                SDOJarMigrator migrator = new SDOJarMigrator();
                migrator.migrate(project);
            } else {
                com.ibm.etools.sdo.jdbc.ui.internal.util.JDBCMediatorFacetUtil.uninstallJDBCMediatorFacet((IProgressMonitor)new NullProgressMonitor(), (IProject)project);
            }
            JDBCMediatorFacetUtil.installJDBCMediatorFacet(project, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            JDBCMediatorFacetRuntimeChangedDelegate.migrate(project, null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new MigrationStatus(Status.OK_STATUS);
    }
}

