/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.migration;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.JDBCUiUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DatasourceConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.feature.RelationalDataFeature;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.migration.JDBCMediatorRuntimeChangedJob;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.nls.Messages;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.plugin.JDBCMediatorUIPlugin;
import com.ibm.etools.webtools.webproject.features.taglibs.internal.util.RuntimeUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.frameworks.internal.ui.UIOperationHandler;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JDBCMediatorFacetRuntimeChangedDelegate
implements IDelegate {
    private static final String[] v5Imports = new String[]{"com.ibm.websphere.wdo.access.connections.ConnectionManager", "com.ibm.websphere.wdo.mediator.rdb.ConnectionWrapper"};
    private static final String[] v6Imports = new String[]{"com.ibm.websphere.sdo.access.connections.ConnectionManager", "com.ibm.websphere.sdo.mediator.jdbc.ConnectionWrapper"};
    IRuntime runtimeToBeRemoved;
    private static boolean canceled;

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IRuntime runtime = RuntimeUtil.getRuntime((IProject)project);
        String needToMigrateToVersion = null;
        if (RuntimeUtil.isTargetedAtWASV60((IRuntime)runtime)) {
            if (!fv.getVersionString().equals("6.0")) {
                needToMigrateToVersion = "6.0";
            }
        } else if (RuntimeUtil.isTargetedAtWASV61((IRuntime)runtime) || RuntimeUtil.isTargetedAtWASV70((IRuntime)runtime) || RuntimeUtil.isTargetedAtPortalV61((IRuntime)runtime) || RuntimeUtil.isTargetedAtPortalV61OnWAS70((IRuntime)runtime)) {
            if (!fv.getVersionString().equals("6.1")) {
                needToMigrateToVersion = "6.1";
            }
        } else if (RuntimeUtil.isTargetedAtPortalV51((IRuntime)runtime)) {
            if (!fv.getVersionString().equals("6.0")) {
                needToMigrateToVersion = "6.0";
            }
        } else if (RuntimeUtil.isTargetedAtPortalV60((IRuntime)runtime)) {
            if (!fv.getVersionString().equals("6.0")) {
                needToMigrateToVersion = "6.0";
            }
        } else {
            needToMigrateToVersion = "6.1";
        }
        if (needToMigrateToVersion != null) {
            JDBCMediatorRuntimeChangedJob job = new JDBCMediatorRuntimeChangedJob(project, fv.getVersionString(), needToMigrateToVersion);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
            JDBCMediatorFacetRuntimeChangedDelegate.migrate(project, runtime, monitor);
        } else if (RuntimeUtil.isTargetedAtWASV61((IRuntime)runtime)) {
            if (fv.getVersionString().equals("6.1")) {
                this.manuallyHandleFacetChange(project, monitor, fv, "6.1");
                JDBCMediatorFacetRuntimeChangedDelegate.migrate(project, runtime, monitor);
            }
        } else if (RuntimeUtil.isTargetedAtPortalV60((IRuntime)runtime) && fv.getVersionString().equals("6.0")) {
            this.manuallyHandleFacetChange(project, monitor, fv, "6.0");
            JDBCMediatorFacetRuntimeChangedDelegate.migrate(project, runtime, monitor);
        }
    }

    private void manuallyHandleFacetChange(IProject project, IProgressMonitor monitor, IProjectFacetVersion fv, String needToMigrateToVersion) throws CoreException {
        RelationalDataFeature feature = new RelationalDataFeature();
        feature.setVersion(fv.getVersionString());
        WTPOperation op = feature.removeOperation(project);
        try {
            op.run(monitor);
        }
        catch (InvocationTargetException x) {
            Throwable e = x.getTargetException();
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            String message = e.getMessage() != null ? e.getMessage() : "";
            throw new CoreException((IStatus)new Status(4, JDBCMediatorUIPlugin.PLUGIN_ID, 4, message, e));
        }
        catch (InterruptedException x) {
            String message = x.getMessage() != null ? x.getMessage() : "";
            throw new CoreException((IStatus)new Status(8, JDBCMediatorUIPlugin.PLUGIN_ID, 0, message, (Throwable)x));
        }
        feature = new RelationalDataFeature();
        feature.setVersion(needToMigrateToVersion);
        op = feature.createOperation(project);
        try {
            op.run(monitor);
        }
        catch (InvocationTargetException x) {
            Throwable e = x.getTargetException();
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            String message = e.getMessage() != null ? e.getMessage() : "";
            throw new CoreException((IStatus)new Status(4, JDBCMediatorUIPlugin.PLUGIN_ID, 4, message, e));
        }
        catch (InterruptedException x) {
            String message = x.getMessage() != null ? x.getMessage() : "";
            throw new CoreException((IStatus)new Status(8, JDBCMediatorUIPlugin.PLUGIN_ID, 0, message, (Throwable)x));
        }
    }

    public static void migrate(IProject project, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        JDBCMediatorFacetRuntimeChangedDelegate.updateImports(project, monitor, v5Imports, v6Imports);
        JDBCMediatorFacetRuntimeChangedDelegate.migrateWDOResourceReferences(project, runtime, monitor);
    }

    private static boolean saveAllDirtyEditors(IProject project) {
        IWorkbenchWindow[] windows;
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
        ArrayList<IEditorInput> dirtyEditorsInput = new ArrayList<IEditorInput>();
        IWorkbench workbench = JDBCMediatorUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow element = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = element.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] editorReferences;
                IWorkbenchPage element2 = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = editorReferences = element2.getEditorReferences();
                int n5 = editorReferences.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorInput edInput;
                    IEditorReference element3 = iEditorReferenceArray[n6];
                    IEditorPart editor = element3.getEditor(false);
                    if (editor != null && editor.isDirty() && !dirtyEditorsInput.contains(editor.getEditorInput()) && (edInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                        dirtyEditors.add(editor);
                        dirtyEditorsInput.add(editor.getEditorInput());
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        if (dirtyEditors.size() > 0) {
            IWorkbenchWindow w = JDBCMediatorFacetRuntimeChangedDelegate.getActiveWorkbenchWindow();
            if (w == null) {
                w = windows[0];
            }
            final IWorkbenchWindow w2 = w;
            final ArrayList<IEditorPart> dirtyEditors2 = dirtyEditors;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean result = JDBCMediatorFacetRuntimeChangedDelegate.saveAll(dirtyEditors2, true, w2);
                    canceled = !result;
                }
            });
        }
        return !canceled;
    }

    private static boolean saveAll(List dirtyEditors, boolean confirm, IWorkbenchWindow window) {
        String SAVE_RESOURCES_TITLE = Messages.JDBCMediatorFacetRuntimeChangedDelegate_0;
        String RESOURCES_TO_SAVE_MESSAGE = Messages.JDBCMediatorFacetRuntimeChangedDelegate_1;
        if (confirm) {
            AdaptableList input = new AdaptableList((Collection)dirtyEditors);
            ListSelectionDialog dlg = new ListSelectionDialog(window.getShell(), (Object)input, (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), RESOURCES_TO_SAVE_MESSAGE);
            dlg.setInitialSelections(dirtyEditors.toArray(new Object[dirtyEditors.size()]));
            dlg.setTitle(SAVE_RESOURCES_TITLE);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            dirtyEditors = Arrays.asList(dlg.getResult());
            if (dirtyEditors == null) {
                return false;
            }
            if (dirtyEditors.size() == 0) {
                return true;
            }
        }
        final List<Object> finalEditors = dirtyEditors;
        final IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("", finalEditors.size());
                int i = 0;
                while (i < finalEditors.size()) {
                    IEditorPart part = (IEditorPart)finalEditors.get(i);
                    part.doSave((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (monitor.isCanceled()) break;
                    ++i;
                }
            }
        };
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(workspaceOp, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        return JDBCMediatorFacetRuntimeChangedDelegate.runProgressMonitorOperation(Messages.JDBCMediatorFacetRuntimeChangedDelegate_2, progressOp, window);
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        Shell[] shells;
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)data;
            }
            shell = shell.getParent();
        }
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell element = shellArray[n2];
            Object data = element.getData();
            if (data instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)data;
            }
            ++n2;
        }
        return null;
    }

    private static boolean runProgressMonitorOperation(String opName, IRunnableWithProgress progressOp, IWorkbenchWindow window) {
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(window.getShell());
        try {
            dlg.run(false, true, progressOp);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
        return !dlg.getProgressMonitor().isCanceled();
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IProject project) {
        IPackageFragmentRoot[] sourceFolders;
        IPackageFragmentRoot packageFragmentRoot = null;
        if (project != null && (sourceFolders = J2EEProjectUtilities.getSourceContainers((IProject)project)).length > 0) {
            packageFragmentRoot = sourceFolders[0];
        }
        return packageFragmentRoot;
    }

    public void removeRuntimeTarget(IProject project, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        this.runtimeToBeRemoved = runtime;
    }

    private static void updateImports(IProject project, IProgressMonitor monitor, String[] existingImports, String[] newImports) {
        try {
            IPackageFragmentRoot root;
            boolean okay = true;
            try {
                okay = JDBCMediatorFacetRuntimeChangedDelegate.saveAllDirtyEditors(project);
            }
            catch (RuntimeException runtimeException) {}
            if (okay && (root = JDBCMediatorFacetRuntimeChangedDelegate.getPackageFragmentRoot(project)) != null) {
                IJavaElement[] javaElements;
                IJavaElement[] iJavaElementArray = javaElements = root.getChildren();
                int n = javaElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement element = iJavaElementArray[n2];
                    if (element instanceof IPackageFragment) {
                        ICompilationUnit[] compUnits;
                        IPackageFragment packFrag = (IPackageFragment)element;
                        ICompilationUnit[] iCompilationUnitArray = compUnits = packFrag.getCompilationUnits();
                        int n3 = compUnits.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IImportDeclaration[] imports;
                            ICompilationUnit unit = iCompilationUnitArray[n4];
                            boolean importsModified = false;
                            IImportDeclaration[] iImportDeclarationArray = imports = unit.getImports();
                            int n5 = imports.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IImportDeclaration element2 = iImportDeclarationArray[n6];
                                String name = element2.getElementName();
                                int y = 0;
                                while (y < existingImports.length) {
                                    if (name.equals(existingImports[y])) {
                                        element2.delete(false, monitor);
                                        unit.createImport(newImports[y], null, null);
                                        importsModified = true;
                                    }
                                    ++y;
                                }
                                ++n6;
                            }
                            if (importsModified) {
                                if (unit.isWorkingCopy()) {
                                    unit.commitWorkingCopy(false, monitor);
                                } else {
                                    unit.save(monitor, false);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private static void migrateWDOResourceReferences(IProject project, IRuntime newRuntime, IProgressMonitor monitor) {
        block16: {
            HashMap<String, DatasourceConnectionWrapper> dataSourceConnections = new HashMap<String, DatasourceConnectionWrapper>();
            if (JDBCMediatorFacetRuntimeChangedDelegate.isDynamicWeb(project)) {
                IResource resource = project.findMember(".wdo-connections");
                if (resource != null && resource.exists() && resource.getType() == 1) {
                    try {
                        EList connections = ConnectionsHelper.getConnections((IProject)project);
                        for (Connection connection : connections) {
                            DatasourceConnectionWrapper wrapper;
                            if (!(connection.getRuntime() instanceof DatasourceConnection) || !(wrapper = new DatasourceConnectionWrapper((DatasourceConnection)connection.getRuntime())).isAutoDeploy()) continue;
                            dataSourceConnections.put(wrapper.getResourceReferenceName(), wrapper);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!dataSourceConnections.isEmpty()) {
                    IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                    WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)component);
                    boolean edited = false;
                    try {
                        try {
                            WebApp app = webEdit.getWebApp();
                            EList resourceRefs = app.getResourceRefs();
                            int i = 0;
                            while (i < resourceRefs.size()) {
                                ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
                                if (dataSourceConnections.containsKey(resourceRef.getName()) && JDBCUiUtil.canHaveResourceRef((IProject)project)) {
                                    edited = JDBCUiUtil.modifyWASResourceRefExtension((IProject)project, (WebApp)app, (ResourceRef)resourceRef, (IRuntime)newRuntime, dataSourceConnections, (boolean)edited, (boolean)false);
                                }
                                ++i;
                            }
                            if (!edited) break block16;
                            if (Display.getCurrent() != null) {
                                webEdit.saveIfNecessaryWithPrompt((IProgressMonitor)new NullProgressMonitor(), (IOperationHandler)new UIOperationHandler(new Shell()), edited);
                                break block16;
                            }
                            webEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (webEdit != null) {
                                webEdit.dispose();
                            }
                        }
                    }
                    finally {
                        if (webEdit != null) {
                            webEdit.dispose();
                        }
                    }
                }
            }
        }
    }

    public static boolean isDynamicWeb(IProject project) {
        boolean isDynamicWeb = false;
        try {
            isDynamicWeb = JDBCMediatorFacetRuntimeChangedDelegate.projectHasFacet(project, "jst.web", null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isDynamicWeb;
    }

    public static boolean projectHasFacet(IProject project, String facetID, String facetVersion) throws CoreException {
        IProjectFacet requiredFacet;
        IFacetedProject facetedProject;
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID) && (facetedProject = ProjectFacetsManager.create((IProject)project)) != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
            if (facetVersion != null) {
                IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                if (requiredFacetVersion != null) {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                }
            } else {
                hasFacet = facetedProject.hasProjectFacet(requiredFacet);
            }
        }
        return hasFacet;
    }
}

