/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.data;

import com.ibm.etools.sdo.jdbc.ui.internal.data.FilterArgumentsManager;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.data.RelationalTagData;
import com.ibm.etools.sdo.ui.internal.Status;
import com.ibm.etools.sdo.ui.internal.data.ISDOData;
import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.sdo.ui.provisional.datahandlers.SDOToolsFactory;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.adapters.ISDONodeAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters.IRelationalWdoNodeAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.IRelationalWebTagData;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebData;
import com.ibm.etools.webtools.wizards.cgen.impl.WebRegionDataContrib;
import com.ibm.etools.webtools.wizards.regiondata.IWTFileData;
import com.ibm.etools.webtools.wizards.regiondata.IWTRegionData;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.FilterArgument;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;

public abstract class RelationalWebTagData
extends RelationalTagData
implements IRelationalWebTagData {
    private IRelationalWdoNodeAdapter fWDONodeAdapter;
    private WebRegionDataContrib fWebRegionDataContrib = new WebRegionDataContrib();

    public RelationalWebTagData(SDOWebData parent) {
        super((ISDOData)parent);
    }

    @Override
    public IStatus updateTagRegionData(ISDONodeAdapter sdoNodeAdapter) {
        return this.updateTagRegionData((IRelationalWdoNodeAdapter)sdoNodeAdapter);
    }

    @Override
    public SDOWebData getSDOWebData() {
        return (SDOWebData)this.getSDOData();
    }

    public IStatus updateTagRegionData(IRelationalWdoNodeAdapter wdoNodeAdapter) {
        Status status = null;
        this.setWDONodeAdapter(wdoNodeAdapter);
        String action = wdoNodeAdapter.getAction();
        if (action.equals("CREATE")) {
            this.getSDOData().setAction(1);
        } else {
            this.getSDOData().setAction(0);
        }
        this.getSDOData().setId(wdoNodeAdapter.getId());
        try {
            this.setConnectionId(wdoNodeAdapter.getConnectionId());
            this.setInputFile(wdoNodeAdapter.getInputFile(), false);
            this.getFilterArgumentsManager().setupFilterVariablesMap();
            status = this.loadMetadata();
        }
        catch (Throwable e) {
            status = new Status(4, e.getMessage(), e);
        }
        return status;
    }

    protected void setWDONodeAdapter(IRelationalWdoNodeAdapter wdoNodeAdapter) {
        this.fWDONodeAdapter = wdoNodeAdapter;
    }

    protected FilterArgumentsManager getFilterArgumentsManager() {
        if (this.fWDONodeAdapter == null) {
            return super.getFilterArgumentsManager();
        }
        FilterArgumentsManager mgr = this.fWDONodeAdapter.getFilterArgumentsManager();
        mgr.setMetadata(this.getMetadata());
        return mgr;
    }

    public String getInputFile() {
        return this.fInputFile;
    }

    public void setInputFile(String inputFile, boolean isSave) {
        this.fInputFile = inputFile;
        String oldInput = null;
        if (this.getWDONodeAdapter() != null) {
            SDOToolsFactory factory;
            oldInput = this.getWDONodeAdapter().getInputFile();
            Metadata oldMetadata = this.getMetadata();
            if (this.getInputFile() != null && !this.getInputFile().equals(oldInput)) {
                this.getWDONodeAdapter().setInputFile(this.getInputFile());
            }
            if (isSave) {
                SDOToolsFactory factory2;
                this.updateMetadata(oldMetadata);
                if (!this.getInputFile().equals(oldInput) && (factory2 = this.getWDONodeAdapter().getSDOPageDataNode().getSDODataFactory()) != null) {
                    factory2.setMetadataFileName(inputFile);
                    try {
                        this.getWDONodeAdapter().getSDOPageDataNode().saveMetaDataModel();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.getInputFile() != null && !this.getInputFile().equals(oldInput) && (factory = this.getWDONodeAdapter().getSDOPageDataNode().getSDODataFactory()) != null) {
                factory.setMetaDataModel(null);
                factory.setMetadataFileName(inputFile);
            }
        } else {
            this.getSDOToolsFactory().setMetadataFileName(inputFile);
        }
        if (this.getInputFile() != null && (!this.getInputFile().equals(oldInput) || isSave)) {
            try {
                this.notifyWDOPageDataNodeChanged();
            }
            catch (MediatorException mediatorException) {}
        }
    }

    public void setConnectionData(IConnectionData data) {
        if (this.fConnectionData != null) {
            this.fConnectionData.release();
        }
        this.fConnectionData = data;
        String oldConnection = null;
        if (this.getWDONodeAdapter() != null) {
            oldConnection = this.getWDONodeAdapter().getConnectionId();
        }
        boolean isSetAttr = false;
        boolean isNotifyChange = false;
        if (this.getConnectionData().getConnectionId() != null && !this.getConnectionData().getConnectionId().equals(oldConnection)) {
            isSetAttr = true;
            isNotifyChange = true;
        }
        if (isSetAttr && this.getWDONodeAdapter() != null) {
            this.getWDONodeAdapter().setConnectionId(this.getConnectionData().getConnectionString());
        }
        try {
            if (isNotifyChange) {
                this.notifyWDOPageDataNodeChanged();
            }
        }
        catch (MediatorException mediatorException) {}
    }

    public Metadata getMetadata() {
        Metadata ret = null;
        if (this.getWDONodeAdapter() != null) {
            ret = this.getWDONodeAdapter().getMetadata();
        }
        if (ret == null) {
            ret = super.getMetadata();
        }
        return ret;
    }

    protected void updateMetadata(Metadata metadata) {
        ((SDOPageDataNode)this.getWDONodeAdapter().getSDOPageDataNode()).setMetaDataModel((Object)metadata);
    }

    public void notifyWDOPageDataNodeChanged() throws MediatorException {
        this.updateDataModel();
    }

    void updateDataModel() {
        block6: {
            try {
                SDOWebData sdoWebData = (SDOWebData)this.getSDOData();
                if (sdoWebData.getFieldsDataModel().getRoot() == null || !(sdoWebData.getFieldsDataModel().getRoot().getEnclosedNode() instanceof SDOPageDataNode)) {
                    SDOPageDataNode thisNode = (SDOPageDataNode)this.createSDOPageDataNode();
                    sdoWebData.updateFieldsDataModel(thisNode);
                    break block6;
                }
                try {
                    ((ISDOPageDataNode)sdoWebData.getFieldsDataModel().getRoot().getEnclosedNode()).changedMetaDataModel();
                }
                catch (MediatorException mediatorException) {}
                sdoWebData.updateFieldsDataModel((SDOPageDataNode)sdoWebData.getFieldsDataModel().getRoot().getEnclosedNode());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    ISDOPageDataNode createSDOPageDataNode() {
        return null;
    }

    public IRelationalWdoNodeAdapter getWDONodeAdapter() {
        return this.fWDONodeAdapter;
    }

    @Override
    public String getELValuePrefix() {
        String ret = "${";
        ret = this.getWDONodeAdapter() != null ? this.getWDONodeAdapter().getELValuePrefix() : ((SDOWebData)this.getSDOData()).getELValuePrefix();
        return ret;
    }

    @Override
    public void createDefaultFilterValuesForFilterArguments() {
        EList tablesList = this.getMetadata().getTables();
        HashSet<String> nameSet = new HashSet<String>();
        for (Table table : tablesList) {
            if (table.getFilter() == null) continue;
            for (FilterArgument filterArg : table.getFilter().getFilterArguments()) {
                String argName = filterArg.getName();
                if (nameSet.contains(argName)) continue;
                String argValue = this.getFilterValue(filterArg);
                if (argValue == null) {
                    if (argName.indexOf("param") != -1) {
                        argValue = argName.substring(argName.indexOf("param") + "param".length());
                        argValue = String.valueOf(this.getELValuePrefix()) + "param" + "." + argValue + "}";
                    } else if (argName.indexOf("session") != -1) {
                        argValue = argName.substring(argName.indexOf("sessionScope") + "sessionScope".length());
                        argValue = String.valueOf(this.getELValuePrefix()) + "sessionScope" + "." + argValue + "}";
                    }
                }
                this.setFilterValue(filterArg, argValue);
                nameSet.add(argName);
            }
        }
    }

    public IWTFileData[] getFiles() {
        return this.fWebRegionDataContrib.getFiles();
    }

    public void setRegionData(IWTRegionData rData) {
        this.fWebRegionDataContrib.setRegionData(rData);
        if (rData instanceof ISDOData) {
            super.setSDOData((ISDOData)rData);
        }
    }

    public void setSDOoData(ISDOData rData) {
        super.setSDOData(rData);
        if (rData instanceof IWTRegionData) {
            this.fWebRegionDataContrib.setRegionData((IWTRegionData)rData);
        }
    }
}

