/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.deploy.internal;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.ServerSetup;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DatasourceConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DriverManagerConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCSQLVendorType;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RuntimeConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.webtools.sdo.deploy.internal.ISDODeployConstants;
import com.ibm.etools.webtools.sdo.deploy.internal.common.DataSourceProperty;
import com.ibm.etools.webtools.sdo.deploy.internal.common.SDODatabaseDeployUtil;
import com.ibm.etools.webtools.sdo.deploy.internal.nls.ResourceHandler;
import com.ibm.etools.webtools.sdo.deploy.internal.util.DataAccessHelper;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.models.config.libraries.impl.LibrariesFactoryImpl;
import com.ibm.ws.ast.st.enhanced.ear.internal.command.SharedLibraryConfiguratorCommand;
import com.ibm.ws.ast.st.enhanced.ear.internal.config.ApplicationConfiguratorModel;
import com.ibm.ws.ast.st.enhanced.ear.internal.config.SharedLibraryConfigurationModel;
import com.ibm.ws.ast.st.enhanced.ear.model.IApplicationConfiguratorModel;
import com.ibm.ws.ast.st.enhanced.ear.util.ApplicationConfiguratorModelFactory;
import com.ibm.ws.ast.st.enhanced.ear.util.DataSourceInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class WAS6ServerSetup
implements ServerSetup {
    private IProject fProject;

    public void doIt(IRuntime runtime, IProject project) throws IOException {
        this.fProject = project;
        this.deployRBDDatabaseConfigToWASV6Server(runtime);
    }

    private IProject getProject() {
        return this.fProject;
    }

    private void deployRBDDatabaseConfigToWASV6Server(IRuntime runtime) throws IOException {
        int connection_count;
        IVirtualComponent component = this.getAppComponet(this.getProject());
        if (component != null && (connection_count = ConnectionsHelper.getConnectionCount((IProject)this.getProject())) > 0) {
            IApplicationConfiguratorModel appConfigModel = null;
            try {
                try {
                    appConfigModel = ApplicationConfiguratorModelFactory.createModel((IVirtualComponent)component);
                    if (appConfigModel != null) {
                        int i = 0;
                        while (i < connection_count) {
                            if (ConnectionsHelper.isDatasourceConnection((IProject)this.getProject(), (int)i)) {
                                this.setUpDatasourceConnection(appConfigModel, i, this.getProject());
                            } else if (ConnectionsHelper.isDriverManagerConnection((IProject)this.getProject(), (int)i)) {
                                this.setUpDriverManagedConnection(appConfigModel, i);
                            }
                            ++i;
                        }
                        appConfigModel.save();
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    if (appConfigModel != null) {
                        appConfigModel.cleanup();
                    }
                }
            }
            finally {
                if (appConfigModel != null) {
                    appConfigModel.cleanup();
                }
            }
        }
    }

    private void setUpDriverManagedConnection(IApplicationConfiguratorModel appConfigModel, int connection_index) throws IOException {
        DriverManagerConnectionWrapper dmc = ConnectionsHelper.getDriverManagerConnectionWrapper((IProject)this.getProject(), (int)connection_index);
        if (appConfigModel instanceof ApplicationConfiguratorModel) {
            SharedLibraryConfigurationModel sharedLibConfigModel;
            ApplicationConfiguratorModel appConfigImpl = (ApplicationConfiguratorModel)appConfigModel;
            String className = dmc.getClassName();
            if (className.indexOf(".") != -1) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            String id = String.valueOf(className) + " Driver Jars";
            String pathsAsString = dmc.getClassLocation();
            ArrayList<String> paths = new ArrayList<String>();
            if (pathsAsString != null) {
                StringTokenizer toker = new StringTokenizer(pathsAsString, ";");
                while (toker.hasMoreTokens()) {
                    paths.add(toker.nextToken());
                }
            }
            if ((sharedLibConfigModel = appConfigImpl.getSharedLibraryConfigModel()) != null) {
                List libs = sharedLibConfigModel.getLibraryLst();
                boolean match = false;
                Library library = null;
                for (Library lib : libs) {
                    if (!id.equals(lib.getName())) continue;
                    match = true;
                    library = lib;
                }
                if (match) {
                    EList list = library.getClassPath();
                    list.clear();
                    list.addAll(paths);
                } else {
                    LibrariesFactoryImpl factory = new LibrariesFactoryImpl();
                    library = factory.createLibrary();
                    library.setName(id);
                    library.setDescription(ResourceHandler.ISDODeployConstants_Auto_generated_by_WDO_tooling_11);
                    library.getClassPath().addAll(paths);
                    SharedLibraryConfiguratorCommand command = new SharedLibraryConfiguratorCommand();
                    command.setLibraryConfigModel(sharedLibConfigModel);
                    command.addLibraryEntry(library, appConfigImpl.getApplDeploymentConfigurationModel());
                }
            }
        }
    }

    private void setUpDatasourceConnection(IApplicationConfiguratorModel appConfigModel, int connection_index, IProject project) throws IOException {
        DatasourceConnectionWrapper dsc = ConnectionsHelper.getDatasourceConnectionWrapper((IProject)this.getProject(), (int)connection_index);
        if (!dsc.isAutoDeploy()) {
            return;
        }
        List serverDataList = appConfigModel.getJDBCProviders();
        RSCSQLVendorType vendorType = RSCSQLVendorType.get((int)dsc.getSqlVendorType());
        if (vendorType != null) {
            if (RSCConnectionsHelper.isDB2DatabaseForAS400((String)vendorType.getProductName())) {
                this.createWDODB2ForAS400Provider(appConfigModel, dsc, serverDataList, project);
            } else if (RSCConnectionsHelper.isDB2Database((String)vendorType.getProductName())) {
                this.createWDODB2Provider(appConfigModel, dsc, serverDataList, project);
            } else if (RSCConnectionsHelper.isCloudDatabase((String)vendorType.getProductName())) {
                this.createWDOCloudscapeProvider(appConfigModel, dsc, serverDataList, project);
            } else if (RSCConnectionsHelper.isDerbyDatabase((String)vendorType.getProductName())) {
                if (RSCConnectionsHelper.hasJ2CCJar((String)dsc.getClassLocation())) {
                    this.createWDODerbyDB2UniversalProvider(appConfigModel, dsc, serverDataList, project);
                } else if (RSCConnectionsHelper.isDebryClientDriver((String)dsc.getClassname())) {
                    this.createSDODerbyClientDriverProvider(appConfigModel, dsc, serverDataList, project);
                } else {
                    this.createWDODerbyProvider(appConfigModel, dsc, serverDataList, project);
                }
            } else if (RSCConnectionsHelper.isOracleDatabase((String)vendorType.getProductName())) {
                this.createWDOOracleProvider(appConfigModel, dsc, serverDataList, project);
            } else if (RSCConnectionsHelper.isMSSQLDatabase((String)vendorType.getProductName())) {
                this.createWDOMSSQLProvider(appConfigModel, dsc, serverDataList, project);
            } else if (RSCConnectionsHelper.isInformixDatabase((String)vendorType.getProductName())) {
                this.createWDOInformixProvider(appConfigModel, dsc, serverDataList, project);
            } else if (RSCConnectionsHelper.isSybaseDatabase((String)vendorType.getProductName())) {
                this.createWDOSybaseProvider(appConfigModel, dsc, serverDataList, project);
            }
        }
    }

    private IVirtualComponent getAppComponet(IProject project) {
        IVirtualComponent ret = null;
        if (J2EEProjectUtilities.isEARProject((IProject)project)) {
            ret = ComponentCore.createComponent((IProject)project);
        } else {
            IVirtualComponent child = ComponentCore.createComponent((IProject)project);
            if (child != null) {
                IVirtualComponent[] earComponentHandles;
                IVirtualComponent[] iVirtualComponentArray = earComponentHandles = child.getReferencingComponents();
                int n = earComponentHandles.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualComponent element = iVirtualComponentArray[n2];
                    if (J2EEProjectUtilities.isEARProject((IProject)element.getProject())) {
                        ret = element;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return ret;
    }

    protected void createWDOCloudscapeProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_CLOUDSCAPE_JDBC_PROVIDER_NAME, "Auto Generated - Cloudscape JDBC Driver", "com.ibm.websphere.rsadapter.CloudscapeDataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_CLOUDSCAPE_JDBC_PROVIDER_NAME), project);
    }

    protected void createSDODerbyClientDriverProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_DERBY_NETWORKED_JDBC_PROVIDER_NAME, "Auto Generated - Derby Networked JDBC Driver", "com.ibm.websphere.rsadapter.DerbyDataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_DERBY_NETWORKED_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDODerbyDB2UniversalProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_DERBY_JDBC_PROVIDER_NAME, "Auto Generated - Derby JDBC Driver", "com.ibm.websphere.rsadapter.DB2DataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_DB2_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDODerbyProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_DERBY_JDBC_PROVIDER_NAME, "Auto Generated - Derby JDBC Driver", "com.ibm.websphere.rsadapter.DerbyDataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_DERBY_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDODB2ForAS400Provider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_DB2_FOR_AS400_JDBC_PROVIDER_NAME, "Auto Generated - DB2 JDBC Driver", "com.ibm.websphere.rsadapter.DB2AS400DataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_DB2_FOR_AS400_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDODB2Provider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_DB2_JDBC_PROVIDER_NAME, "Auto Generated - DB2 JDBC Driver", "com.ibm.websphere.rsadapter.DB2DataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_DB2_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDOInformixProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_INFORMIX_JDBC_PROVIDER_NAME, "Auto Generated - Informix JDBC Driver", "com.ibm.websphere.rsadapter.InformixDataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_INFORMIX_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDOJDBCProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, String jdbcProviderName, String jdbcProviderDescription, String dataSourceHelperClassName, SDODatabaseDeployUtil wdoDatabaseDeployUtil, IProject project) {
        int isSameImplClass;
        JDBCProvider defaultProvider = null;
        int nextIndex = 0;
        int i = 0;
        while (i < serverDataList.size()) {
            if (serverDataList.get(i) instanceof JDBCProvider) {
                DataSource found;
                JDBCProvider provider = (JDBCProvider)serverDataList.get(i);
                String providerName = provider.getName();
                if (providerName.startsWith(jdbcProviderName)) {
                    boolean match = this.containsClassPaths(dsc, (List)provider.getClasspath());
                    int index = 0;
                    try {
                        index = Integer.parseInt(providerName.substring(jdbcProviderName.length()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (index >= nextIndex) {
                        nextIndex = index + 1;
                    }
                    if (match && (isSameImplClass = this.doesImplClassMatch(dsc, provider)) != 0) {
                        defaultProvider = provider;
                    }
                }
                if (defaultProvider == null && (found = this.findDataSource(appConfigModel, dsc, provider)) != null) {
                    this.removeDataSource(appConfigModel, dsc, provider, found);
                }
            }
            ++i;
        }
        DataSource found = null;
        boolean isDefaultProvider = false;
        if (defaultProvider != null) {
            isDefaultProvider = true;
            found = this.findDataSource(appConfigModel, dsc, defaultProvider);
        } else {
            int index = appConfigModel.addDatabase(String.valueOf(jdbcProviderName) + (nextIndex > 0 ? "" + nextIndex : ""), jdbcProviderDescription, dsc.getClassname(), this.getClassPathEntries(dsc), new String[0]);
            if (index != -1) {
                defaultProvider = (JDBCProvider)appConfigModel.getJDBCProviders().get(index);
            }
        }
        wdoDatabaseDeployUtil.addProperty("isDefaultProvider", Boolean.toString(isDefaultProvider));
        if (found == null) {
            DataSourceProperty[] properties;
            DataSource myDataSource = this.createNewDataSource(dsc, defaultProvider, appConfigModel, ISDODeployConstants.WDO_DEFAULT_DATASOURCE_DESCRIPTION, dataSourceHelperClassName, project);
            DataSourceProperty[] dataSourcePropertyArray = properties = wdoDatabaseDeployUtil.setDataSourceProperties(dsc);
            int n = properties.length;
            isSameImplClass = 0;
            while (isSameImplClass < n) {
                DataSourceProperty element = dataSourcePropertyArray[isSameImplClass];
                appConfigModel.addResourceProperty((J2EEResourceFactory)myDataSource, element.getName(), element.getType(), element.getValue(), element.getDescription(), element.isRequired());
                ++isSameImplClass;
            }
        } else {
            this.editExistingDataSource(project, dsc, defaultProvider, found, appConfigModel);
            J2EEResourcePropertySet propSet = found.getPropertySet();
            EList props = propSet.getResourceProperties();
            ArrayList<DataSourceProperty> propertyList = new ArrayList<DataSourceProperty>();
            int i2 = 0;
            while (i2 < props.size()) {
                J2EEResourceProperty info = (J2EEResourceProperty)props.get(i2);
                propertyList.add(DataSourceProperty.addResourceProperty((String)info.getName(), (String)info.getType(), (String)info.getValue(), (String)info.getDescription(), (boolean)info.isRequired()));
                ++i2;
            }
            DataSourceProperty[] modifiedProperties = wdoDatabaseDeployUtil.editDataSourceProperties(propertyList.toArray(new DataSourceProperty[propertyList.size()]), dsc);
            HashMap<String, DataSourceProperty> modifiedPropertiesMap = new HashMap<String, DataSourceProperty>();
            DataSourceProperty[] dataSourcePropertyArray = modifiedProperties;
            int n = modifiedProperties.length;
            int n2 = 0;
            while (n2 < n) {
                DataSourceProperty element = dataSourcePropertyArray[n2];
                modifiedPropertiesMap.put(element.getName(), element);
                ++n2;
            }
            Iterator<Object> iter = props.iterator();
            while (iter.hasNext()) {
                J2EEResourceProperty info = (J2EEResourceProperty)iter.next();
                if (modifiedPropertiesMap.containsKey(info.getName())) {
                    DataSourceProperty property = (DataSourceProperty)modifiedPropertiesMap.get(info.getName());
                    info.setValue(property.getValue());
                    info.setType(property.getType());
                    info.setDescription(property.getDescription());
                    info.setRequired(property.isRequired());
                    modifiedPropertiesMap.remove(info.getName());
                    continue;
                }
                iter.remove();
            }
            iter = modifiedPropertiesMap.keySet().iterator();
            while (iter.hasNext()) {
                DataSourceProperty property = (DataSourceProperty)modifiedPropertiesMap.get(iter.next());
                appConfigModel.addResourceProperty((J2EEResourceFactory)found, property.getName(), property.getType(), property.getValue(), property.getDescription(), property.isRequired());
            }
        }
    }

    protected void createWDOMSSQLProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_MSSQL_JDBC_PROVIDER_NAME, "Auto Generated - MS-SQL JDBC Driver", RSCConnectionsHelper.getDataSourceHelperClassForMSSQLDataSource((String)dsc.getClassname()), new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_MSSQL_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDOOracleProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_ORACLE_JDBC_PROVIDER_NAME, "Auto Generated - Oracle JDBC Driver", "com.ibm.websphere.rsadapter.OracleDataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_ORACLE_JDBC_PROVIDER_NAME), project);
    }

    protected void createWDOSybaseProvider(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, List serverDataList, IProject project) {
        this.createWDOJDBCProvider(appConfigModel, dsc, serverDataList, ISDODeployConstants.DEFAULT_SYBASE_JDBC_PROVIDER_NAME, "Auto Generated - Sybase JDBC Driver", "com.ibm.websphere.rsadapter.SybaseDataStoreHelper", new SDODatabaseDeployUtil(ISDODeployConstants.DEFAULT_SYBASE_JDBC_PROVIDER_NAME), project);
    }

    protected boolean containsClassPaths(DatasourceConnectionWrapper dsc, List classPaths) {
        boolean match = true;
        StringTokenizer toker = new StringTokenizer(dsc.getClassLocation(), ";");
        while (toker.hasMoreElements()) {
            String path = toker.nextToken();
            if (classPaths.contains(path)) continue;
            match = false;
        }
        return match;
    }

    protected boolean doesImplClassMatch(DatasourceConnectionWrapper dsc, JDBCProvider provider) {
        boolean isSameImplClass = provider != null ? (provider.getImplementationClassName() != null ? (dsc != null ? provider.getImplementationClassName().equals(dsc.getClassname()) : false) : false) : false;
        return isSameImplClass;
    }

    private DataSource findDataSource(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, JDBCProvider defaultProvider) {
        DataSource myDataSource = null;
        Vector dataSources = appConfigModel.getDataSourceList(defaultProvider);
        int i = 0;
        while (i < dataSources.size()) {
            if (dataSources.get(i) instanceof DataSource) {
                DataSource ds = (DataSource)dataSources.get(i);
                if (dsc.getJndiName().equals(ds.getJndiName())) {
                    myDataSource = ds;
                }
            }
            ++i;
        }
        return myDataSource;
    }

    private void removeDataSource(IApplicationConfiguratorModel appConfigModel, DatasourceConnectionWrapper dsc, JDBCProvider provider, DataSource found) {
        Vector dataSources = appConfigModel.getDataSourceList(provider);
        ((ApplicationConfiguratorModel)appConfigModel).getDataSourceConfigModel().removeDataSource(provider, dataSources.indexOf(found));
    }

    protected String[] getClassPathEntries(DatasourceConnectionWrapper dsc) {
        Vector<String> ret = new Vector<String>();
        StringTokenizer toker = new StringTokenizer(dsc.getClassLocation(), ";");
        while (toker.hasMoreElements()) {
            String path = toker.nextToken();
            ret.add(path);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private boolean isOlderEJBProject(IProject project) {
        return WAS6ServerSetup.isMinimumFacetDefinedOnProject(project, "jst.ejb", "2.1]");
    }

    private static boolean isMinimumFacetDefinedOnProject(IProject project, String facetName, String versionExpression) {
        boolean isDefined;
        block5: {
            isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
            if (isDefined) {
                isDefined = false;
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                    if (facetedProject == null || facet == null) break block5;
                    Set versions = facet.getVersions(versionExpression);
                    for (IProjectFacetVersion projectFacetVersion : versions) {
                        isDefined = facetedProject.hasProjectFacet(projectFacetVersion);
                        if (!isDefined) {
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    isDefined = false;
                }
            }
        }
        return isDefined;
    }

    private String getUniqueDataSourceName(JDBCProvider defaultProvider, IApplicationConfiguratorModel appConfigModel, String suggestedName) {
        Vector dataSources = appConfigModel.getDataSourceList(defaultProvider);
        int i = 0;
        int suggestedNameIndex = 1;
        while (i < dataSources.size()) {
            DataSource ds;
            if (dataSources.get(i) instanceof DataSource && (ds = (DataSource)dataSources.get(i)).getName().equals(suggestedName)) {
                suggestedName = String.valueOf(suggestedName) + suggestedNameIndex;
                ++suggestedNameIndex;
                i = 0;
                continue;
            }
            ++i;
        }
        return suggestedName;
    }

    private DataSource createNewDataSource(DatasourceConnectionWrapper dsc, JDBCProvider defaultProvider, IApplicationConfiguratorModel appConfigModel, String datasourceDescription, String dataSourceHelper, IProject project) {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setDsDescription(datasourceDescription);
        dsInfo.setDsName(this.getUniqueDataSourceName(defaultProvider, appConfigModel, dsc.getResourceReferenceName()));
        dsInfo.setDsJndiName(dsc.getJndiName());
        dsInfo.setDsIsUseInCmp(false);
        String authAlias = this.editJAASEntry(project, dsc, appConfigModel);
        boolean resourceRefFound = this.isResourceRefDefinedForConnection(dsc, project);
        if (!resourceRefFound && authAlias != null && authAlias.length() > 0) {
            dsInfo.setDsComponentManagedAuthenticationAlias(authAlias);
            dsInfo.setDsContainerManagedAuthenticationAlias(authAlias);
        }
        if (this.isOlderEJBProject(project)) {
            dsInfo.setDsIsUseInCmp(true);
        }
        int index = appConfigModel.addDataSource(defaultProvider, dsInfo);
        DataSource myDataSource = null;
        if (index > -1) {
            myDataSource = (DataSource)appConfigModel.getDataSourceList(defaultProvider).get(index);
            myDataSource.setDatasourceHelperClassname(dataSourceHelper);
        }
        return myDataSource;
    }

    private boolean isResourceRefDefinedForConnection(DatasourceConnectionWrapper dsc, IProject project) {
        boolean resourceRefFound;
        block10: {
            resourceRefFound = false;
            WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
            if (webEdit != null) {
                try {
                    try {
                        WebApp app = webEdit.getWebApp();
                        if (app == null) break block10;
                        EList resourceRefs = app.getResourceRefs();
                        int resourceRefsLength = resourceRefs.size();
                        int i = resourceRefsLength - 1;
                        while (i >= 0) {
                            ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
                            String resourceRefName = dsc.getResourceReferenceName();
                            if (resourceRef.getName().equals(resourceRefName)) {
                                resourceRefFound = true;
                                break;
                            }
                            --i;
                        }
                    }
                    catch (Exception exception) {
                        if (webEdit != null) {
                            webEdit.dispose();
                        }
                    }
                }
                finally {
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                }
            }
        }
        return resourceRefFound;
    }

    private String editJAASEntry(IProject project, DatasourceConnectionWrapper dsc, IApplicationConfiguratorModel appConfigModel) {
        String alias = null;
        String id = dsc.getId();
        boolean isWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
        String projectVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        if (isWebProject && projectVersion.equals("2.5")) {
            if (id != null && id.endsWith("_runtime")) {
                alias = id.substring(0, id.length() - "_runtime".length());
            }
            if (alias == null) {
                alias = dsc.getConnectionString();
            }
        } else {
            if (id != null && id.endsWith("_runtime")) {
                alias = "wdo_" + id.substring(0, id.length() - "_runtime".length());
            }
            if (alias == null) {
                alias = "wdo_" + dsc.getConnectionString();
            }
        }
        boolean isJAASAuthAliasExists = appConfigModel.isJAASAuthAliasExists(alias);
        boolean userJAASExists = appConfigModel.isJAASAuthUserIdExists(alias, dsc.getUserid());
        String password = com.ibm.etools.sdo.jdbc.ui.internal.util.DataAccessHelper.recvData((String)RSCConnectionsHelper.getRealm((RuntimeConnectionWrapper)dsc), (String)dsc.getUserid());
        boolean shouldAdd = true;
        if (isJAASAuthAliasExists && userJAASExists && password == null) {
            shouldAdd = false;
        }
        if (shouldAdd) {
            if (isJAASAuthAliasExists) {
                appConfigModel.removeJAASAuthData(alias);
            }
            if (dsc.getUserid() != null && dsc.getUserid().length() > 0) {
                appConfigModel.addJAASAuthData(alias, dsc.getUserid(), password, ResourceHandler.ISDODeployConstants_Auto_generated_by_WDO_tooling_11);
            } else {
                alias = null;
            }
        } else {
            alias = null;
        }
        return alias;
    }

    private void editExistingDataSource(IProject project, DatasourceConnectionWrapper dsc, JDBCProvider defaultProvider, DataSource found, IApplicationConfiguratorModel appConfigModel) {
        if (dsc.getResourceReferenceName() != null && !dsc.getResourceReferenceName().equals(found.getName())) {
            String datasourceName = this.getUniqueDataSourceName(defaultProvider, appConfigModel, dsc.getResourceReferenceName());
            found.setName(datasourceName);
        }
        if (dsc.getJndiName() != null && !dsc.getJndiName().equals(found.getJndiName())) {
            found.setJndiName(dsc.getJndiName());
        }
        this.editJAASEntry(project, dsc, appConfigModel);
    }

    public String recvData(String input) {
        return DataAccessHelper.recvData(input);
    }

    public String sendData(String input) {
        return DataAccessHelper.sendData(input);
    }

    public boolean deleteDataSource(Connection connection, IProject project) {
        this.fProject = project;
        IVirtualComponent component = this.getAppComponet(this.getProject());
        boolean deleted = false;
        if (component != null) {
            IApplicationConfiguratorModel appConfigModel = ApplicationConfiguratorModelFactory.createModel((IVirtualComponent)component);
            try {
                try {
                    DatasourceConnectionWrapper dsc = new DatasourceConnectionWrapper((DatasourceConnection)connection.getRuntime());
                    List serverDataList = appConfigModel.getJDBCProviders();
                    int i = 0;
                    while (i < serverDataList.size()) {
                        JDBCProvider provider;
                        DataSource found;
                        if (serverDataList.get(i) instanceof JDBCProvider && (found = this.findDataSource(appConfigModel, dsc, provider = (JDBCProvider)serverDataList.get(i))) != null && (found.getDescription().indexOf("SDO") != -1 || found.getDescription().indexOf("WDO") != -1 || found.getDescription().indexOf("Web Tools") != -1)) {
                            boolean isJAASAuthAliasExists;
                            this.removeDataSource(appConfigModel, dsc, provider, found);
                            String alias = null;
                            String id = dsc.getId();
                            boolean isWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
                            String projectVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
                            if (isWebProject && projectVersion.equals("2.5")) {
                                if (id != null && id.endsWith("_runtime") && !appConfigModel.isJAASAuthAliasExists(alias = id.substring(0, id.length() - "_runtime".length()))) {
                                    alias = null;
                                }
                                if (alias == null) {
                                    alias = dsc.getConnectionString();
                                }
                            } else {
                                if (id != null && id.endsWith("_runtime") && !appConfigModel.isJAASAuthAliasExists(alias = "wdo_" + id.substring(0, id.length() - "_runtime".length()))) {
                                    alias = null;
                                }
                                if (alias == null) {
                                    alias = "wdo_" + dsc.getConnectionString();
                                }
                            }
                            if (isJAASAuthAliasExists = appConfigModel.isJAASAuthAliasExists(alias)) {
                                appConfigModel.removeJAASAuthData(alias);
                            }
                            deleted = true;
                        }
                        ++i;
                    }
                    if (deleted) {
                        appConfigModel.save();
                    }
                }
                catch (Exception exception) {
                    if (appConfigModel != null) {
                        appConfigModel.cleanup();
                    }
                }
            }
            finally {
                if (appConfigModel != null) {
                    appConfigModel.cleanup();
                }
            }
        }
        return deleted;
    }
}

