/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.scriptgrammar.dojo.internal;

import com.ibm.etools.webtools.dojo.core.DojoSettings;
import com.ibm.etools.webtools.dojo.core.DojoVersion;
import com.ibm.etools.webtools.scriptgrammar.core.provider.AbstractWidgetProvider;
import com.ibm.etools.webtools.scriptgrammar.core.provider.WidgetDescription;
import com.ibm.etools.webtools.scriptgrammar.core.widget.IWidgetDescription;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.Activator;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.DojoMetadataRegistry;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.Logger;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.VersionDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class WidgetFactory
extends AbstractWidgetProvider {
    private static Map EMPTY_MAP = new HashMap(0);
    private static final boolean TRACE = Boolean.valueOf(Platform.getDebugOption((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + "/dojo-widgetFactory")));
    public static final String DEFAULT_BUNDLE_ENTRYROOT = "resources/";
    private static final String OPENAJAX_METADATA = "/openajax.metadata/";
    private static final String OPENAJAX_NAMESPACE = "http://ns.openajax.org/widgets";
    private static final String XML = "xml";
    private static long time0 = 0L;
    private static long time1 = 0L;
    private static final String ATTRIBUTE_ICON_PATH = "/resources/images/dojo_attribute.gif";
    private static URL dojoAttributeIconUrl = null;

    public IWidgetDescription createDescriptionFrom(URL widgetLocation) {
        WidgetDescription description = (WidgetDescription)super.createDescriptionFrom(widgetLocation);
        WidgetDescription.PropertyDescription[] properties = description.getPropertyDescriptions();
        int i = 0;
        while (i < properties.length) {
            WidgetDescription.PropertyDescription property = properties[i];
            property.put((Object)"small-icon", (Object)WidgetFactory.getDojoAttributeIconURL().toString());
            ++i;
        }
        return description;
    }

    private static URL getDojoAttributeIconURL() {
        if (dojoAttributeIconUrl == null) {
            dojoAttributeIconUrl = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(ATTRIBUTE_ICON_PATH), null);
        }
        return dojoAttributeIconUrl;
    }

    public String[] getPossibleUserWidgetNames(IPath path) {
        Map userWidgetMap = this.getUserWidgetMap(path);
        String[] names = userWidgetMap.keySet().toArray(new String[userWidgetMap.size()]);
        return names;
    }

    private Map getSystemWidgetMap(IPath path) {
        final HashMap systemWidgets = new HashMap();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IProject project = null;
            DojoVersion version = null;
            Object dojoRootPath = null;
            if (path != null) {
                project = workspaceRoot.getProject(path.segment(0));
                version = DojoSettings.getDojoVersion((IProject)project);
                dojoRootPath = DojoSettings.getDojoRoot((IProject)project);
            }
            VersionDescriptor[] versionDescriptors = DojoMetadataRegistry.getInstance().getVersionDescriptions(version, path);
            int i = 0;
            while (i < versionDescriptors.length) {
                systemWidgets.putAll(versionDescriptors[i].getResolvedWidgets(this));
                ++i;
            }
            if (path != null && dojoRootPath instanceof IPath) {
                IFolder dojoRoot = null;
                dojoRoot = ((IPath)dojoRootPath).isAbsolute() ? workspaceRoot.getFolder((IPath)dojoRootPath) : project.getFolder((IPath)dojoRootPath);
                if (dojoRoot.exists()) {
                    dojoRoot.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            IWidgetDescription newDescription;
                            if (WidgetFactory.XML.equals(resource.getFileExtension()) && WidgetFactory.OPENAJAX_NAMESPACE.equals((newDescription = WidgetFactory.this.createDescriptionFrom(resource.getFullPath())).getAttribute("xmlns")) && newDescription.getAttribute("name") != null) {
                                IWidgetDescription existingDescription = (IWidgetDescription)systemWidgets.get(newDescription.getName());
                                if (existingDescription == null) {
                                    systemWidgets.put(newDescription.getName(), newDescription);
                                } else {
                                    String existingVersion = existingDescription.getAttribute("version");
                                    String newVersion = newDescription.getAttribute("version");
                                    try {
                                        if (Long.parseLong(existingVersion) < Long.parseLong(newVersion)) {
                                            systemWidgets.put(newDescription.getName(), newDescription);
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        systemWidgets.put(newDescription.getName(), newDescription);
                                        Logger.logException(systemWidgets.toString(), e);
                                    }
                                }
                            }
                            return true;
                        }
                    }, 2, false);
                }
            }
        }
        catch (MalformedURLException e) {
            Logger.logException(e);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return systemWidgets;
    }

    private Map getSystemWidgetMap(DojoVersion version, IPath path) {
        HashMap systemWidgets = new HashMap();
        VersionDescriptor[] versionDescriptors = DojoMetadataRegistry.getInstance().getVersionDescriptions(version, path);
        int i = 0;
        while (i < versionDescriptors.length) {
            systemWidgets.putAll(versionDescriptors[i].getResolvedWidgets(this));
            ++i;
        }
        return systemWidgets;
    }

    public IWidgetDescription[] getSystemWidgets(IPath path) {
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        Map systemWidgets = this.getSystemWidgetMap(path);
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DOJO WidgetFactory.getSystemWidgets(");
            stringBuffer.append(path);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms (");
            stringBuffer.append(systemWidgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return systemWidgets.values().toArray(new IWidgetDescription[0]);
    }

    public IWidgetDescription[] getSystemWidgets(DojoVersion version) {
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        Map systemWidgets = this.getSystemWidgetMap(version, null);
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DOJO WidgetFactory.getSystemWidgets(");
            stringBuffer.append(version);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms (");
            stringBuffer.append(systemWidgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return systemWidgets.values().toArray(new IWidgetDescription[0]);
    }

    public IWidgetDescription[] getUserDefinedWidgets(IPath path) {
        if (path == null || path.isEmpty()) {
            return new IWidgetDescription[0];
        }
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        Map userWidgets = this.getUserWidgetMap(path);
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DOJO WidgetFactory.getUserDefinedWidgets(");
            stringBuffer.append(path);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms (");
            stringBuffer.append(userWidgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return userWidgets.values().toArray(new IWidgetDescription[0]);
    }

    private Map getUserWidgetMap(IPath basePath) {
        if (basePath == null || basePath.isEmpty()) {
            return EMPTY_MAP;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(basePath.segment(0));
        final HashMap userWidgets = new HashMap();
        IFolder openAjaxMetaRoot = project.getFolder(OPENAJAX_METADATA);
        if (openAjaxMetaRoot.isAccessible()) {
            try {
                openAjaxMetaRoot.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        IWidgetDescription newDescription;
                        if (WidgetFactory.XML.equals(resource.getFileExtension()) && WidgetFactory.OPENAJAX_NAMESPACE.equals((newDescription = WidgetFactory.this.createDescriptionFrom(resource.getFullPath())).getAttribute("xmlns")) && newDescription.getAttribute("name") != null) {
                            IWidgetDescription existingDescription = (IWidgetDescription)userWidgets.get(newDescription.getName());
                            if (existingDescription == null) {
                                userWidgets.put(newDescription.getName(), newDescription);
                            } else {
                                String existingVersion = existingDescription.getAttribute("version");
                                String newVersion = newDescription.getAttribute("version");
                                try {
                                    if (Long.parseLong(existingVersion) < Long.parseLong(newVersion)) {
                                        userWidgets.put(newDescription.getName(), newDescription);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    userWidgets.put(newDescription.getName(), newDescription);
                                    Logger.logException(userWidgets.toString(), e);
                                }
                            }
                        }
                        return true;
                    }
                }, 2, false);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return userWidgets;
    }

    public IWidgetDescription getWidgetDescription(IPath widgetLocation) {
        return super.createDescriptionFrom(widgetLocation);
    }

    public IWidgetDescription getWidgetDescription(String widgetName, IPath basePath) {
        IWidgetDescription description;
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        if ((description = (IWidgetDescription)this.getUserWidgetMap(basePath).get(widgetName)) == null) {
            description = (IWidgetDescription)this.getSystemWidgetMap(basePath).get(widgetName);
        }
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DOJO WidgetFactory.getWidgetDescription(");
            stringBuffer.append(widgetName);
            stringBuffer.append(",");
            stringBuffer.append(basePath);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms");
            System.out.println(stringBuffer.toString());
        }
        return description;
    }

    public IWidgetDescription[] getVisibleWidgets(IPath path) {
        if (TRACE) {
            time1 = System.currentTimeMillis();
        }
        HashMap widgets = new HashMap(this.getSystemWidgetMap(path));
        widgets.putAll(this.getUserWidgetMap(path));
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DOJO WidgetFactory.getVisibleWidgets(");
            stringBuffer.append(path);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time1);
            stringBuffer.append("ms (");
            stringBuffer.append(widgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return widgets.values().toArray(new IWidgetDescription[0]);
    }
}

