/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.scriptgrammar.dojo.internal;

import com.ibm.etools.webtools.dojo.core.DojoVersion;
import com.ibm.etools.webtools.scriptgrammar.core.widget.IWidgetDescription;
import com.ibm.etools.webtools.scriptgrammar.core.widget.IWidgetRequirements;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.Logger;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.WidgetFactory;
import com.ibm.icu.util.StringTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.osgi.framework.Bundle;

public class VersionDescriptor {
    static final int INCLUSIVE = 2;
    static final int EXCLUSIVE = 4;
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_GRAMMAR = "grammar";
    private static final String ELEMENT_WIDGET = "widget";
    private static final String ATTR_FOLDER = "folder";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_EXCLUDE_FACETS = "exclude-facets";
    static final String ID = "id";
    private String id = null;
    private int fLowerBoundRule;
    private int fUpperBoundRule;
    private DojoVersion fLowerVersion;
    private DojoVersion fUpperVersion;
    private boolean isDefault;
    private final HashSet<String> excludeFacetIds = new HashSet();
    private final String fVersionRange;
    private final String[] fFolders;
    private final String fGrammarPath;
    private Map fWidgets;
    private final String fBundleID;

    public VersionDescriptor(IConfigurationElement element) {
        String excludeListString;
        this.id = element.getAttribute(ID);
        if (this.id == null) {
            this.id = element.getDeclaringExtension().getUniqueIdentifier();
        }
        this.fVersionRange = element.getAttribute(ATTR_VERSION);
        this.fGrammarPath = element.getAttribute(ATTR_GRAMMAR);
        this.fBundleID = element.getContributor().getName();
        String defaultAttribute = element.getAttribute(ATTR_DEFAULT);
        if (defaultAttribute != null) {
            boolean bl = this.isDefault = Boolean.valueOf(defaultAttribute) != false || this.fVersionRange != null && this.fVersionRange.equals("*");
        }
        if ((excludeListString = element.getAttribute(ATTR_EXCLUDE_FACETS)) != null && !excludeListString.isEmpty()) {
            String[] excludeFacetArray;
            String[] stringArray = excludeFacetArray = excludeListString.split(",");
            int n = excludeFacetArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.excludeFacetIds.add(string);
                ++n2;
            }
        }
        if (this.fVersionRange == null || this.fVersionRange.length() == 0 || this.fVersionRange.indexOf(44) < 0 && !this.fVersionRange.equals("*")) {
            Logger.log(4, "Version range missing in " + element.getDeclaringExtension().getExtensionPointUniqueIdentifier() + " " + element.getNamespaceIdentifier());
        }
        IConfigurationElement[] widgetSpecifiers = element.getChildren(ELEMENT_WIDGET);
        ArrayList<String> folders = new ArrayList<String>();
        int i = 0;
        while (i < widgetSpecifiers.length) {
            String folder = widgetSpecifiers[i].getAttribute(ATTR_FOLDER);
            if (folder != null && folder.length() != 0) {
                folders.add(folder);
            } else {
                Logger.log(4, "Missing required attribute: folder");
            }
            ++i;
        }
        this.fFolders = folders.toArray(new String[0]);
        this.parseVersions();
    }

    public int compare(DojoVersion v1, DojoVersion v2) {
        if (v1.getMajor() != v2.getMajor()) {
            return v1.getMajor() - v2.getMajor();
        }
        if (v1.getMinor() != v2.getMinor()) {
            return v1.getMinor() - v2.getMinor();
        }
        if (v1.getService() != v2.getService()) {
            return v1.getService() - v2.getService();
        }
        if (v1.getQualifier() != v2.getQualifier() && (v1.getQualifier() != null || v2.getQualifier() != null)) {
            if (v1.getQualifier() == null) {
                return -1;
            }
            if (v2.getQualifier() == null) {
                return 1;
            }
            return v1.getQualifier().compareTo(v2.getQualifier());
        }
        if (v1.getBuildID() != v2.getBuildID() && (v1.getBuildID() != null || v2.getBuildID() != null)) {
            if (v1.getBuildID() == null) {
                return -1;
            }
            if (v2.getBuildID() == null) {
                return 1;
            }
            return v1.getBuildID().compareTo(v2.getBuildID());
        }
        return 0;
    }

    String[] getFolders() {
        return this.fFolders;
    }

    public URL getGrammarURL() {
        return Platform.getBundle((String)this.fBundleID).getEntry(this.fGrammarPath);
    }

    Map getResolvedWidgets(WidgetFactory provider) {
        if (this.fWidgets == null) {
            Bundle bundle = Platform.getBundle((String)this.fBundleID);
            HashMap<String, IWidgetDescription> widgets = new HashMap<String, IWidgetDescription>();
            int i = 0;
            while (i < this.fFolders.length) {
                String folder = this.fFolders[i];
                Enumeration entryPaths = bundle.findEntries(folder, "*.xml", true);
                while (entryPaths.hasMoreElements()) {
                    URL entryURL = (URL)entryPaths.nextElement();
                    IWidgetDescription newDescription = provider.createDescriptionFrom(entryURL);
                    IWidgetDescription existingDescription = (IWidgetDescription)widgets.get(newDescription.getName());
                    if (existingDescription == null) {
                        widgets.put(newDescription.getName(), newDescription);
                        continue;
                    }
                    try {
                        String existingVersion = existingDescription.getAttribute(ATTR_VERSION);
                        String newVersion = newDescription.getAttribute(ATTR_VERSION);
                        if (Float.parseFloat(existingVersion) < Float.parseFloat(newVersion)) {
                            widgets.put(newDescription.getName(), newDescription);
                        }
                        if (Float.parseFloat(existingVersion) != Float.parseFloat(newVersion)) continue;
                        HashMap<String, String> existingRequirements = new HashMap<String, String>();
                        HashMap<String, String> newRequirements = new HashMap<String, String>();
                        IWidgetRequirements[] requirements = existingDescription.getRequirements();
                        int j = 0;
                        while (j < requirements.length) {
                            existingRequirements.put(requirements[j].getName(), requirements[j].getMinVersion());
                            ++j;
                        }
                        requirements = newDescription.getRequirements();
                        j = 0;
                        while (j < requirements.length) {
                            widgets.remove(existingDescription.getName());
                            newRequirements.put(requirements[j].getName(), requirements[j].getMinVersion());
                            ++j;
                        }
                        Iterator k = existingRequirements.keySet().iterator();
                        while (k.hasNext()) {
                            String name = k.next().toString();
                            Object newMinVersion = newRequirements.get(name);
                            if (newMinVersion == null || ((String)existingRequirements.get(name)).compareTo((String)newMinVersion) >= 0) continue;
                            widgets.remove(existingDescription.getName());
                            widgets.put(newDescription.getName(), newDescription);
                        }
                    }
                    catch (NumberFormatException e) {
                        widgets.put(newDescription.getName(), newDescription);
                        Logger.logException(entryURL.toString(), e);
                    }
                }
                ++i;
            }
            this.fWidgets = widgets;
        }
        return this.fWidgets;
    }

    boolean isDefault() {
        return this.isDefault;
    }

    @Deprecated
    public boolean matches(DojoVersion version) {
        return this.matches(version, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(DojoVersion version, IPath path) {
        boolean upperValid;
        boolean lowerValid;
        block7: {
            if (path != null && path.segmentCount() > 0 && !this.excludeFacetIds.isEmpty()) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)));
                    if (facetedProject == null) break block7;
                    Set fvSet = facetedProject.getProjectFacets();
                    HashSet<String> projectFacetIds = new HashSet<String>();
                    for (IProjectFacetVersion projectFacetVersion : fvSet) {
                        projectFacetIds.add(projectFacetVersion.getProjectFacet().getId());
                    }
                    if (!projectFacetIds.contains("rad.dojo")) {
                        for (String facet_id : this.excludeFacetIds) {
                            if (!ProjectFacetsManager.isProjectFacetDefined((String)facet_id) || !projectFacetIds.contains(facet_id)) continue;
                            return false;
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        if (version == null) {
            return this.isDefault();
        }
        this.parseVersions();
        DojoVersion testVersion = new DojoVersion();
        testVersion.setMajor(version.getMajor() == -1 ? (short)0 : version.getMajor());
        testVersion.setMinor(version.getMinor() == -1 ? (short)0 : version.getMinor());
        testVersion.setService(version.getService() == -1 ? (short)0 : version.getService());
        testVersion.setBuildID(version.getBuildID());
        testVersion.setQualifier(version.getQualifier());
        boolean bl = this.fLowerBoundRule == 4 ? this.compare(testVersion, this.fLowerVersion) > 0 : (lowerValid = this.compare(testVersion, this.fLowerVersion) >= 0);
        boolean bl2 = this.fUpperBoundRule == 4 ? this.compare(testVersion, this.fUpperVersion) < 0 : (upperValid = this.compare(testVersion, this.fUpperVersion) <= 0);
        return lowerValid && upperValid;
    }

    void parseVersions() {
        if (this.fLowerVersion == null && this.fUpperVersion == null) {
            String versionRange = this.fVersionRange.trim();
            StringTokenizer toker = new StringTokenizer(versionRange, ",", false);
            String lower = toker.nextToken().trim();
            String upper = toker.nextToken().trim();
            this.fLowerBoundRule = lower.charAt(0) == '[' ? 2 : 4;
            this.fUpperBoundRule = upper.charAt(upper.length() - 1) == ']' ? 2 : 4;
            this.fLowerVersion = new DojoVersion(lower.substring(1).trim());
            this.fUpperVersion = new DojoVersion(upper.substring(0, upper.length() - 1).trim());
            if (this.fLowerVersion.getMajor() == -1) {
                this.fLowerVersion.setMajor((short)0);
            }
            if (this.fLowerVersion.getMinor() == -1) {
                this.fLowerVersion.setMinor((short)0);
            }
            if (this.fLowerVersion.getService() == -1) {
                this.fLowerVersion.setService((short)0);
            }
            if (this.fUpperVersion.getMajor() == -1) {
                this.fUpperVersion.setMajor((short)0);
            }
            if (this.fUpperVersion.getMinor() == -1) {
                this.fUpperVersion.setMinor((short)0);
            }
            if (this.fUpperVersion.getService() == -1) {
                this.fUpperVersion.setService((short)0);
            }
        }
    }

    static String[] unpack(String s) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer toker = new StringTokenizer(s, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (toker.hasMoreTokens()) {
            list.add(StringUtils.replace((String)toker.nextToken(), (String)"&comma;", (String)",").trim());
        }
        return list.toArray(new String[0]);
    }

    public String toString() {
        return String.valueOf(this.id) + ":" + this.fVersionRange;
    }
}

