/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.scriptgrammar.dojo.internal;

import com.ibm.etools.webtools.dojo.core.DojoVersion;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.Activator;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.VersionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class DojoMetadataRegistry {
    private static final String EXTENSION_ID = "toolkit";
    private static final Object ELEMENT_DOJO = "dojo";
    private static Collection fVersionDescriptors = null;
    private static DojoMetadataRegistry _instance = new DojoMetadataRegistry();

    public static DojoMetadataRegistry getInstance() {
        return _instance;
    }

    synchronized void loadVersions() {
        if (fVersionDescriptors == null) {
            fVersionDescriptors = new ArrayList();
            this.readRegistry(Platform.getExtensionRegistry(), Activator.getDefault().getBundle().getSymbolicName(), EXTENSION_ID);
        }
    }

    private boolean readElement(IConfigurationElement element) {
        if (ELEMENT_DOJO.equals(element.getName())) {
            fVersionDescriptors.add(new VersionDescriptor(element));
        }
        return true;
    }

    private void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
    }

    private void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    private void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }

    public VersionDescriptor[] getVersionDescriptions(DojoVersion version, IPath path) {
        ArrayList<VersionDescriptor> matches = new ArrayList<VersionDescriptor>(1);
        VersionDescriptor[] descriptors = this.getVersionDescriptions();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].matches(version, path)) {
                matches.add(descriptors[i]);
            }
            ++i;
        }
        return matches.toArray(new VersionDescriptor[matches.size()]);
    }

    public VersionDescriptor[] getVersionDescriptions() {
        this.loadVersions();
        return fVersionDescriptors.toArray(new VersionDescriptor[fVersionDescriptors.size()]);
    }
}

