/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.scriptgrammar.dojo.internal;

import com.ibm.etools.webtools.dojo.core.DojoVersion;
import com.ibm.etools.webtools.scriptgrammar.core.IContentModelHandler;
import com.ibm.etools.webtools.scriptgrammar.core.IScriptGrammarProvider;
import com.ibm.etools.webtools.scriptgrammar.core.IWidgetProvider;
import com.ibm.etools.webtools.scriptgrammar.core.provider.AbstractContentModelHandler;
import com.ibm.etools.webtools.scriptgrammar.core.provider.WidgetDescription;
import com.ibm.etools.webtools.scriptgrammar.core.widget.IWidgetDescription;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.DojoMetadataRegistry;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.Logger;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.VersionDescriptor;
import com.ibm.etools.webtools.scriptgrammar.dojo.internal.WidgetFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DojoGrammarProvider
implements IScriptGrammarProvider,
IExecutableExtension {
    private DojoVersion fVersion = new DojoVersion("1.1");
    private static final String DOJO_TYPE = "dojotype";
    private static final String ROOT_PATH_STRING = Path.ROOT.toString();
    private final WidgetFactory fWidgetFactory = new WidgetFactory();
    private final IContentModelHandler fContentModelProvider = new ContentModelProvider();

    public IContentModelHandler getContentModelHandler() {
        return this.fContentModelProvider;
    }

    public IWidgetProvider getWidgetProvider() {
        return this.fWidgetFactory;
    }

    public String getId() {
        return this.getClass().getName();
    }

    IPath getDocumentPath(Node element) {
        if (element instanceof IDOMNode) {
            String pathString;
            IDOMModel domModel = ((IDOMNode)element).getModel();
            String string = pathString = domModel != null ? domModel.getBaseLocation() : null;
            if (pathString != null && pathString.startsWith(ROOT_PATH_STRING)) {
                return new Path(pathString);
            }
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Map) {
            String versionString = (String)((Map)data).get("defaultVersion");
            if (versionString != null) {
                this.fVersion = new DojoVersion(versionString);
            }
        } else if (data != null) {
            this.fVersion = new DojoVersion(data.toString());
        }
    }

    private class ContentModelProvider
    extends AbstractContentModelHandler {
        private ContentModelProvider() {
        }

        public String[] getAttributeValues(Element element, String namespace, String name) {
            String[] values = null;
            if (this.isDojoElement(element)) {
                IPath documentPath = DojoGrammarProvider.this.getDocumentPath(element);
                if (name.toLowerCase(Locale.US).equals(DojoGrammarProvider.DOJO_TYPE)) {
                    if (documentPath != null) {
                        IWidgetDescription[] widgets = DojoGrammarProvider.this.fWidgetFactory.getUserDefinedWidgets(documentPath);
                        values = new String[widgets.length];
                        int i = 0;
                        while (i < widgets.length) {
                            values[i] = widgets[i].getName();
                            ++i;
                        }
                    }
                } else {
                    CMNode attrDecl;
                    IWidgetDescription widget;
                    String dojoType = element.getAttribute(DojoGrammarProvider.DOJO_TYPE);
                    if (dojoType != null && (widget = DojoGrammarProvider.this.fWidgetFactory.getWidgetDescription(dojoType, documentPath)) != null && (attrDecl = widget.getAttributeDeclaration(name)) != null) {
                        values = this.getBasicModelQuery().getPossibleDataTypeValues(element, attrDecl);
                    }
                }
            }
            if (values == null) {
                values = super.getAttributeValues(element, namespace, name);
            }
            return values;
        }

        public CMNode[] getAvailableElementContent(Element element, String namespace, int includeOptions) {
            CMNode[] nodes = null;
            String dojoType = null;
            if ((1 & includeOptions) != 0 && this.isDojoElement(element) && (dojoType = element.getAttribute(DojoGrammarProvider.DOJO_TYPE)) != null) {
                IPath fullPath = DojoGrammarProvider.this.getDocumentPath(element);
                WidgetDescription widget = (WidgetDescription)DojoGrammarProvider.this.fWidgetFactory.getWidgetDescription(StringUtils.strip((String)dojoType), fullPath);
                if (widget != null) {
                    nodes = widget.getAttributeDeclarations();
                    Node parent = element.getParentNode();
                    if (parent != null && parent.getNodeType() == 1) {
                        CMNode[] parentAttributes;
                        WidgetDescription parentWidget;
                        Element parentElement = (Element)parent;
                        String parentDojoType = null;
                        if (this.isDojoElement(parentElement) && (parentDojoType = parentElement.getAttribute(DojoGrammarProvider.DOJO_TYPE)) != null && (parentWidget = (WidgetDescription)DojoGrammarProvider.this.fWidgetFactory.getWidgetDescription(StringUtils.strip((String)parentDojoType), fullPath)) != null && (parentAttributes = parentWidget.getExtendedAttributeDeclarations()) != null) {
                            nodes = this.mergeArrays(nodes, parentAttributes);
                        }
                    }
                }
            }
            if ((2 & includeOptions) != 0 && this.isDojoElement(element)) {
                dojoType = element.getAttribute(DojoGrammarProvider.DOJO_TYPE);
            }
            if (nodes == null) {
                nodes = super.getAvailableElementContent(element, namespace, includeOptions);
            }
            return nodes;
        }

        private CMNode[] mergeArrays(CMNode[] nodes, CMNode[] parentAttributes) {
            CMNode[] mergedArray = new CMNode[nodes.length + parentAttributes.length];
            System.arraycopy(nodes, 0, mergedArray, 0, nodes.length);
            System.arraycopy(parentAttributes, 0, mergedArray, nodes.length, parentAttributes.length);
            return mergedArray;
        }

        public CMDocument getCMDocument(Element element) {
            CMDocument document = null;
            document = this.loadCMDocument(element);
            return document;
        }

        private boolean isDojoElement(Element element) {
            CMDocument document = this.getCMDocument(element);
            if (document == null) {
                return true;
            }
            boolean isDojoElement = false;
            CMNode elementDecl = null;
            Iterator i = document.getElements().iterator();
            while (i.hasNext() && !isDojoElement) {
                elementDecl = (CMNode)i.next();
                if (!elementDecl.getNodeName().toLowerCase(Locale.US).equals(element.getNodeName().toLowerCase(Locale.US))) continue;
                isDojoElement = true;
            }
            return isDojoElement;
        }

        private CMDocument loadCMDocument(Element element) {
            DojoDocumentAdapter adapter = (DojoDocumentAdapter)((IDOMDocument)element.getOwnerDocument()).getAdapterFor(DojoDocumentAdapter.class);
            if (adapter == null) {
                adapter = new DojoDocumentAdapter(element.getOwnerDocument());
                ((IDOMDocument)element.getOwnerDocument()).addAdapter((INodeAdapter)adapter);
            }
            return adapter.getCMDocument();
        }
    }

    class DojoDocumentAdapter
    implements INodeAdapter {
        private CMDocument cmDoc;
        private final Document doc;

        public DojoDocumentAdapter(Document doc) {
            this.doc = doc;
        }

        public CMDocument getCMDocument() {
            if (this.cmDoc == null) {
                VersionDescriptor[] versionDescriptors = DojoMetadataRegistry.getInstance().getVersionDescriptions(DojoGrammarProvider.this.fVersion, DojoGrammarProvider.this.getDocumentPath(this.doc));
                int i = 0;
                while (i < versionDescriptors.length && this.cmDoc == null) {
                    URL entry = versionDescriptors[i].getGrammarURL();
                    if (entry != null) {
                        try {
                            String filepath = FileLocator.toFileURL((URL)entry).getFile();
                            this.cmDoc = ContentModelManager.getInstance().createCMDocument("file:" + filepath, null);
                        }
                        catch (IOException e) {
                            Logger.logException(e);
                        }
                        if (this.cmDoc == null || this.cmDoc.getElements().getLength() == 0) {
                            Logger.log(2, "No elements defined in grammar file " + entry + ", a SAXParseException may have been thrown.");
                        }
                    }
                    ++i;
                }
            }
            return this.cmDoc;
        }

        public boolean isAdapterForType(Object arg0) {
            return DojoDocumentAdapter.class.equals(arg0);
        }

        public void notifyChanged(INodeNotifier arg0, int arg1, Object arg2, Object arg3, Object arg4, int arg5) {
        }
    }
}

