/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.scriptgrammar.cea.internal.version;

import com.ibm.etools.webtools.cea.version.CeaWidgetVersion;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.CeaWidgetScriptgrammarPlugin;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.version.CeaWidgetVersionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class CeaWidgetMetadataRegistry {
    private static final String EXTENSION_ID = "ceawidget_library";
    private static final Object ELEMENT_CEA_WIDGET = "ceawidget";
    private static Collection<CeaWidgetVersionDescriptor> fVersionDescriptors = null;
    private static CeaWidgetMetadataRegistry _instance = new CeaWidgetMetadataRegistry();

    public static CeaWidgetMetadataRegistry getInstance() {
        return _instance;
    }

    public CeaWidgetVersionDescriptor[] getCeaWidgetVersionDescriptions() {
        this.loadVersions();
        return fVersionDescriptors.toArray(new CeaWidgetVersionDescriptor[fVersionDescriptors.size()]);
    }

    public CeaWidgetVersionDescriptor[] getCeaWidgetVersionDescriptions(CeaWidgetVersion version, IPath path) {
        ArrayList<CeaWidgetVersionDescriptor> matches = new ArrayList<CeaWidgetVersionDescriptor>(1);
        CeaWidgetVersionDescriptor[] descriptors = this.getCeaWidgetVersionDescriptions();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].matches(version, path)) {
                matches.add(descriptors[i]);
            }
            ++i;
        }
        return matches.toArray(new CeaWidgetVersionDescriptor[matches.size()]);
    }

    synchronized void loadVersions() {
        if (fVersionDescriptors == null) {
            fVersionDescriptors = new ArrayList<CeaWidgetVersionDescriptor>();
            this.readRegistry(Platform.getExtensionRegistry(), CeaWidgetScriptgrammarPlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_ID);
        }
    }

    private boolean readElement(IConfigurationElement element) {
        if (ELEMENT_CEA_WIDGET.equals(element.getName())) {
            fVersionDescriptors.add(new CeaWidgetVersionDescriptor(element));
        }
        return true;
    }

    private void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
    }

    private void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    private void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }
}

