/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.scriptgrammar.cea.internal.provider;

import com.ibm.etools.webtools.cea.scriptgrammar.core.IContentModelHandler;
import com.ibm.etools.webtools.cea.scriptgrammar.core.IScriptGrammarProvider;
import com.ibm.etools.webtools.cea.scriptgrammar.core.IWidgetProvider;
import com.ibm.etools.webtools.cea.scriptgrammar.core.provider.AbstractContentModelHandler;
import com.ibm.etools.webtools.cea.scriptgrammar.core.provider.WidgetDescription;
import com.ibm.etools.webtools.cea.scriptgrammar.core.widget.IWidgetDescription;
import com.ibm.etools.webtools.cea.version.CeaWidgetVersion;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.model.CeaWidgetPropertyCMDocument;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.provider.CeaWidgetFactory;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.util.Logger;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.version.CeaWidgetMetadataRegistry;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.version.CeaWidgetVersionDescriptor;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CeaWidgetScriptGrammarProvider
implements IScriptGrammarProvider,
IExecutableExtension {
    private final CeaWidgetFactory fWidgetFactory = new CeaWidgetFactory();
    private final IContentModelHandler fContentModelProvider = new ContentModelProvider();
    private static final String DOJO_TYPE = "ceadojotype";
    private final Reference<CeaWidgetPropertyCMDocument> fDocument = null;
    private static final String ROOT_PATH_STRING = Path.ROOT.toString();
    private CeaWidgetVersion fVersion = new CeaWidgetVersion("1.0.0.1");

    public IContentModelHandler getContentModelHandler() {
        return this.fContentModelProvider;
    }

    private IPath getDocumentPath(Node element) {
        String pathString;
        if (element instanceof IDOMNode && (pathString = ((IDOMNode)element).getModel().getBaseLocation()).startsWith(ROOT_PATH_STRING)) {
            return new Path(pathString);
        }
        return null;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public IWidgetProvider getWidgetProvider() {
        return this.fWidgetFactory;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Map) {
            String versionString = (String)((Map)data).get("defaultVersion");
            if (versionString != null) {
                this.fVersion = new CeaWidgetVersion(versionString);
            }
        } else if (data != null) {
            this.fVersion = new CeaWidgetVersion(data.toString());
        }
    }

    class CeaWidgetDocumentAdapter
    implements INodeAdapter {
        private CMDocument cmDoc;
        private final Document doc;

        public CeaWidgetDocumentAdapter(Document doc) {
            this.doc = doc;
        }

        public CMDocument getCMDocument() {
            if (this.cmDoc == null) {
                CeaWidgetVersionDescriptor[] versionDescriptors = CeaWidgetMetadataRegistry.getInstance().getCeaWidgetVersionDescriptions(CeaWidgetScriptGrammarProvider.this.fVersion, CeaWidgetScriptGrammarProvider.this.getDocumentPath(this.doc));
                int i = 0;
                while (i < versionDescriptors.length && this.cmDoc == null) {
                    URL entry = versionDescriptors[i].getGrammarURL();
                    if (entry != null) {
                        try {
                            String filepath = FileLocator.toFileURL((URL)entry).getFile();
                            this.cmDoc = ContentModelManager.getInstance().createCMDocument("file:" + filepath, null);
                        }
                        catch (IOException e) {
                            Logger.logException(e);
                        }
                        if (this.cmDoc == null || this.cmDoc.getElements().getLength() == 0) {
                            Logger.log(2, "No elements defined in grammar file " + entry + ", a SAXParseException may have been thrown.");
                        }
                    }
                    ++i;
                }
            }
            return this.cmDoc;
        }

        public boolean isAdapterForType(Object arg0) {
            return CeaWidgetDocumentAdapter.class.equals(arg0);
        }

        public void notifyChanged(INodeNotifier arg0, int arg1, Object arg2, Object arg3, Object arg4, int arg5) {
        }
    }

    private class ContentModelProvider
    extends AbstractContentModelHandler {
        private ContentModelProvider() {
        }

        public String[] getAttributeValues(Element element, String namespace, String name) {
            String[] values = null;
            if (this.isDojoElement(element)) {
                IPath documentPath = CeaWidgetScriptGrammarProvider.this.getDocumentPath(element);
                if (name.toLowerCase(Locale.US).equals(CeaWidgetScriptGrammarProvider.DOJO_TYPE)) {
                    if (documentPath != null) {
                        IWidgetDescription[] widgets = CeaWidgetScriptGrammarProvider.this.fWidgetFactory.getUserDefinedWidgets(documentPath);
                        values = new String[widgets.length];
                        int i = 0;
                        while (i < widgets.length) {
                            values[i] = widgets[i].getName();
                            ++i;
                        }
                    }
                } else {
                    CMNode attrDecl;
                    IWidgetDescription widget;
                    String dojoType = element.getAttribute(CeaWidgetScriptGrammarProvider.DOJO_TYPE);
                    if (dojoType != null && (widget = CeaWidgetScriptGrammarProvider.this.fWidgetFactory.getWidgetDescription(dojoType, documentPath)) != null && (attrDecl = widget.getAttributeDeclaration(name)) != null) {
                        values = this.getBasicModelQuery().getPossibleDataTypeValues(element, attrDecl);
                    }
                }
            }
            if (values == null) {
                values = super.getAttributeValues(element, namespace, name);
            }
            return values;
        }

        public CMNode[] getAvailableElementContent(Element element, String namespace, int includeOptions) {
            CMNode[] nodes = null;
            String dojoType = null;
            if ((1 & includeOptions) != 0 && this.isDojoElement(element) && (dojoType = element.getAttribute(CeaWidgetScriptGrammarProvider.DOJO_TYPE)) != null) {
                IPath fullPath = CeaWidgetScriptGrammarProvider.this.getDocumentPath(element);
                WidgetDescription widget = (WidgetDescription)CeaWidgetScriptGrammarProvider.this.fWidgetFactory.getWidgetDescription(StringUtils.strip((String)dojoType), fullPath);
                if (widget != null) {
                    nodes = widget.getAttributeDeclarations();
                    Node parent = element.getParentNode();
                    if (parent != null && parent.getNodeType() == 1) {
                        CMNode[] parentAttributes;
                        WidgetDescription parentWidget;
                        Element parentElement = (Element)parent;
                        String parentDojoType = null;
                        if (this.isDojoElement(parentElement) && (parentDojoType = parentElement.getAttribute(CeaWidgetScriptGrammarProvider.DOJO_TYPE)) != null && (parentWidget = (WidgetDescription)CeaWidgetScriptGrammarProvider.this.fWidgetFactory.getWidgetDescription(StringUtils.strip((String)parentDojoType), fullPath)) != null && (parentAttributes = parentWidget.getExtendedAttributeDeclarations()) != null) {
                            nodes = this.mergeArrays(nodes, parentAttributes);
                        }
                    }
                }
            }
            if ((2 & includeOptions) != 0 && this.isDojoElement(element)) {
                dojoType = element.getAttribute(CeaWidgetScriptGrammarProvider.DOJO_TYPE);
            }
            if (nodes == null) {
                nodes = super.getAvailableElementContent(element, namespace, includeOptions);
            }
            return nodes;
        }

        public CMDocument getCMDocument(Element element) {
            CMDocument document = null;
            document = this.loadCMDocument(element);
            return document;
        }

        private boolean isDojoElement(Element element) {
            CMDocument document = this.getCMDocument(element);
            if (document == null) {
                return true;
            }
            boolean isDojoElement = false;
            CMNode elementDecl = null;
            Iterator i = document.getElements().iterator();
            while (i.hasNext() && !isDojoElement) {
                elementDecl = (CMNode)i.next();
                if (!elementDecl.getNodeName().toLowerCase(Locale.US).equals(element.getNodeName().toLowerCase(Locale.US))) continue;
                isDojoElement = true;
            }
            return isDojoElement;
        }

        private CMDocument loadCMDocument(Element element) {
            CeaWidgetDocumentAdapter adapter = (CeaWidgetDocumentAdapter)((IDOMDocument)element.getOwnerDocument()).getAdapterFor(CeaWidgetDocumentAdapter.class);
            if (adapter == null) {
                adapter = new CeaWidgetDocumentAdapter(element.getOwnerDocument());
                ((IDOMDocument)element.getOwnerDocument()).addAdapter((INodeAdapter)adapter);
            }
            return adapter.getCMDocument();
        }

        private CMNode[] mergeArrays(CMNode[] nodes, CMNode[] parentAttributes) {
            CMNode[] mergedArray = new CMNode[nodes.length + parentAttributes.length];
            System.arraycopy(nodes, 0, mergedArray, 0, nodes.length);
            System.arraycopy(parentAttributes, 0, mergedArray, nodes.length, parentAttributes.length);
            return mergedArray;
        }
    }
}

