/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.scriptgrammar.cea.internal.provider;

import com.ibm.etools.webtools.cea.scriptgrammar.core.provider.AbstractWidgetProvider;
import com.ibm.etools.webtools.cea.scriptgrammar.core.provider.WidgetDescription;
import com.ibm.etools.webtools.cea.scriptgrammar.core.widget.IWidgetDescription;
import com.ibm.etools.webtools.cea.settings.CeaWidgetSettings;
import com.ibm.etools.webtools.cea.version.CeaWidgetVersion;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.CeaWidgetScriptgrammarPlugin;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.util.Logger;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.version.CeaWidgetMetadataRegistry;
import com.ibm.etools.webtools.scriptgrammar.cea.internal.version.CeaWidgetVersionDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class CeaWidgetFactory
extends AbstractWidgetProvider {
    private static Map<String, IWidgetDescription> EMPTY_MAP = new HashMap<String, IWidgetDescription>(0);
    private static final boolean TRACE = Boolean.valueOf(Platform.getDebugOption((String)(String.valueOf(CeaWidgetScriptgrammarPlugin.getDefault().getBundle().getSymbolicName()) + "/cea-widgetFactory")));
    public static final String DEFAULT_BUNDLE_ENTRYROOT = "resources/";
    private static final String OPENAJAX_METADATA = "/openajax.metadata/";
    private static final String OPENAJAX_NAMESPACE = "http://ns.openajax.org/widgets";
    private static final String XML = "xml";
    private IProjectFacet fCeaWidgetFacet;
    private static long time0 = 0L;
    private static long time1 = 0L;
    private static final String ATTRIBUTE_ICON_PATH = "/resources/images/cea_attribute.gif";
    private static URL ceaWidgetAttributeIconUrl = null;

    public CeaWidgetFactory() {
        if (ProjectFacetsManager.isProjectFacetDefined((String)"rad.cea.widgets")) {
            this.fCeaWidgetFacet = ProjectFacetsManager.getProjectFacet((String)"rad.cea.widgets");
        }
    }

    private static URL getCeaWidgetAttributeIconURL() {
        if (ceaWidgetAttributeIconUrl == null) {
            ceaWidgetAttributeIconUrl = FileLocator.find((Bundle)CeaWidgetScriptgrammarPlugin.getDefault().getBundle(), (IPath)new Path(ATTRIBUTE_ICON_PATH), null);
        }
        return ceaWidgetAttributeIconUrl;
    }

    public IWidgetDescription createDescriptionFrom(URL widgetLocation) {
        WidgetDescription description = (WidgetDescription)super.createDescriptionFrom(widgetLocation);
        WidgetDescription.PropertyDescription[] properties = description.getPropertyDescriptions();
        int i = 0;
        while (i < properties.length) {
            WidgetDescription.PropertyDescription property = properties[i];
            property.put((Object)"small-icon", (Object)CeaWidgetFactory.getCeaWidgetAttributeIconURL().toString());
            ++i;
        }
        return description;
    }

    public String[] getPossibleUserWidgetNames(IPath path) {
        Map<String, IWidgetDescription> userWidgetMap = this.getUserWidgetMap(path);
        String[] names = userWidgetMap.keySet().toArray(new String[userWidgetMap.size()]);
        return names;
    }

    private Map<String, IWidgetDescription> getSystemWidgetMap(CeaWidgetVersion version, IPath path) {
        HashMap<String, IWidgetDescription> systemWidgets = new HashMap<String, IWidgetDescription>();
        CeaWidgetVersionDescriptor[] versionDescriptors = CeaWidgetMetadataRegistry.getInstance().getCeaWidgetVersionDescriptions(version, path);
        int i = 0;
        while (i < versionDescriptors.length) {
            systemWidgets.putAll(versionDescriptors[i].getResolvedWidgets(this));
            ++i;
        }
        return systemWidgets;
    }

    private Map<String, IWidgetDescription> getSystemWidgetMap(IPath path) {
        final HashMap<String, IWidgetDescription> systemWidgets = new HashMap<String, IWidgetDescription>();
        try {
            IWorkspaceRoot workspaceRoot = null;
            IProject project = null;
            CeaWidgetVersion version = null;
            IPath ceaWidgetRootPath = null;
            if (path != null) {
                IFacetedProject facetedProject;
                workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                project = workspaceRoot.getProject(path.segment(0));
                if (this.fCeaWidgetFacet != null && (facetedProject = ProjectFacetsManager.create((IProject)project)) != null && facetedProject.hasProjectFacet(this.fCeaWidgetFacet)) {
                    version = CeaWidgetSettings.getCeaWidgetVersion((IProject)project);
                    ceaWidgetRootPath = CeaWidgetSettings.getCeaWidgetRoot((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)));
                }
            }
            CeaWidgetVersionDescriptor[] versionDescriptors = CeaWidgetMetadataRegistry.getInstance().getCeaWidgetVersionDescriptions(version, path);
            int i = 0;
            while (i < versionDescriptors.length) {
                systemWidgets.putAll(versionDescriptors[i].getResolvedWidgets(this));
                ++i;
            }
            if (path != null) {
                IFolder ceaWidgetRoot = null;
                if (ceaWidgetRootPath != null && (ceaWidgetRoot = ceaWidgetRootPath.isAbsolute() ? workspaceRoot.getFolder(ceaWidgetRootPath) : project.getFolder(ceaWidgetRootPath)).exists()) {
                    ceaWidgetRoot.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            IWidgetDescription newDescription;
                            if (CeaWidgetFactory.XML.equals(resource.getFileExtension()) && CeaWidgetFactory.OPENAJAX_NAMESPACE.equals((newDescription = CeaWidgetFactory.this.createDescriptionFrom(resource.getFullPath())).getAttribute("xmlns")) && newDescription.getAttribute("name") != null) {
                                IWidgetDescription existingDescription = (IWidgetDescription)systemWidgets.get(newDescription.getName());
                                if (existingDescription == null) {
                                    systemWidgets.put(newDescription.getName(), newDescription);
                                } else {
                                    String existingVersion = existingDescription.getAttribute("version");
                                    String newVersion = newDescription.getAttribute("version");
                                    try {
                                        if (Long.parseLong(existingVersion) < Long.parseLong(newVersion)) {
                                            systemWidgets.put(newDescription.getName(), newDescription);
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        systemWidgets.put(newDescription.getName(), newDescription);
                                        Logger.logException(systemWidgets.toString(), e);
                                    }
                                }
                            }
                            return true;
                        }
                    }, 2, false);
                }
            }
        }
        catch (MalformedURLException e) {
            Logger.logException(e);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return systemWidgets;
    }

    @Deprecated
    public IWidgetDescription[] getSystemWidgets(CeaWidgetVersion version) {
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        Map<String, IWidgetDescription> systemWidgets = this.getSystemWidgetMap(version, null);
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CEA WidgetFactory.getSystemWidgets(");
            stringBuffer.append(version);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms (");
            stringBuffer.append(systemWidgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return systemWidgets.values().toArray(new IWidgetDescription[0]);
    }

    public IWidgetDescription[] getSystemWidgets(IPath path) {
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        Map<String, IWidgetDescription> systemWidgets = this.getSystemWidgetMap(path);
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CEA WidgetFactory.getSystemWidgets(");
            stringBuffer.append(path);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms (");
            stringBuffer.append(systemWidgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return systemWidgets.values().toArray(new IWidgetDescription[0]);
    }

    public IWidgetDescription[] getUserDefinedWidgets(IPath path) {
        if (path == null || path.isEmpty()) {
            return new IWidgetDescription[0];
        }
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        Map<String, IWidgetDescription> userWidgets = this.getUserWidgetMap(path);
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CEA WidgetFactory.getUserDefinedWidgets(");
            stringBuffer.append(path);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms (");
            stringBuffer.append(userWidgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return userWidgets.values().toArray(new IWidgetDescription[0]);
    }

    private Map<String, IWidgetDescription> getUserWidgetMap(IPath basePath) {
        if (basePath == null || basePath.isEmpty()) {
            return EMPTY_MAP;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(basePath.segment(0));
        final HashMap<String, IWidgetDescription> userWidgets = new HashMap<String, IWidgetDescription>();
        IFolder openAjaxMetaRoot = project.getFolder(OPENAJAX_METADATA);
        if (openAjaxMetaRoot.isAccessible()) {
            try {
                openAjaxMetaRoot.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        IWidgetDescription newDescription;
                        if (CeaWidgetFactory.XML.equals(resource.getFileExtension()) && CeaWidgetFactory.OPENAJAX_NAMESPACE.equals((newDescription = CeaWidgetFactory.this.createDescriptionFrom(resource.getFullPath())).getAttribute("xmlns")) && newDescription.getAttribute("name") != null) {
                            IWidgetDescription existingDescription = (IWidgetDescription)userWidgets.get(newDescription.getName());
                            if (existingDescription == null) {
                                userWidgets.put(newDescription.getName(), newDescription);
                            } else {
                                String existingVersion = existingDescription.getAttribute("version");
                                String newVersion = newDescription.getAttribute("version");
                                try {
                                    if (Long.parseLong(existingVersion) < Long.parseLong(newVersion)) {
                                        userWidgets.put(newDescription.getName(), newDescription);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    userWidgets.put(newDescription.getName(), newDescription);
                                    Logger.logException(userWidgets.toString(), e);
                                }
                            }
                        }
                        return true;
                    }
                }, 2, false);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return userWidgets;
    }

    public IWidgetDescription[] getVisibleWidgets(IPath path) {
        if (TRACE) {
            time1 = System.currentTimeMillis();
        }
        HashMap<String, IWidgetDescription> widgets = new HashMap<String, IWidgetDescription>(this.getSystemWidgetMap(path));
        widgets.putAll(this.getUserWidgetMap(path));
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CEA WidgetFactory.getVisibleWidgets(");
            stringBuffer.append(path);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time1);
            stringBuffer.append("ms (");
            stringBuffer.append(widgets.size());
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
        return widgets.values().toArray(new IWidgetDescription[0]);
    }

    public IWidgetDescription getWidgetDescription(IPath widgetLocation) {
        return super.createDescriptionFrom(widgetLocation);
    }

    public IWidgetDescription getWidgetDescription(String widgetName, IPath basePath) {
        IWidgetDescription description;
        if (TRACE) {
            time0 = System.currentTimeMillis();
        }
        if ((description = this.getUserWidgetMap(basePath).get(widgetName)) == null) {
            description = this.getSystemWidgetMap(basePath).get(widgetName);
        }
        if (TRACE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CEA WidgetFactory.getWidgetDescription(");
            stringBuffer.append(widgetName);
            stringBuffer.append(",");
            stringBuffer.append(basePath);
            stringBuffer.append(") took ");
            stringBuffer.append(System.currentTimeMillis() - time0);
            stringBuffer.append("ms");
            System.out.println(stringBuffer.toString());
        }
        return description;
    }
}

